pro plot_page, pdef, arg1, arg2, nh=nh, nv=nv, nplots=nplots, title=title, $
               init=init, reset=reset, send=send, next=next, restore=restore, $
               $
               set_plot=set_plot, landscape=landscape, filename=filename, $
               printer_name=printer_name, print2file=print2file, $
               $
               position=position, region=region, $
               xspace=xspace, yspace=yspace, $
               xtitle=xtitle, ytitle=ytitle, $
               xtickname=xtickname, ytickname=ytickname, $
               charsize=charsize, $
               _extra=plotParm

  common plot_page_common, device_spec

  init=keyword_set(init)        ; define pdef, etc...
  reset=keyword_set(reset)      ; resets 
  send=keyword_set(send)        ; sends plot to printer and reset
  next=keyword_set(next)        ; sets position 
  restore=keyword_set(restore)  ; restores old x, y, z, p variables

;  nplots can be used to automatically set nh and nv.
  if keyword_set(nplots) and $
    not keyword_set(nh) and not keyword_set(nv) then begin
      nv= fix( sqrt( nplots) )
      nh= ceil( nplots/float(nv) )
  endif

  if not keyword_set(nh) then nh=1
  if not keyword_set(nv) then nv=1
  if n_elements(nplots) eq 0 then nplots=nh*nv

  landscape=keyword_set(landscape)
  print2file= keyword_set(print2file)
  if not keyword_set(filename) then filename='page'

  if n_elements(region) ne 4 and n_elements(position) ne 4 then $
    region=[0,0,1,1]
  if n_elements(region) eq 4 then begin
      ll=[ (region(2)-region(0))*0.075 + region(0), $
           (region(3)-region(1))*0.050 + region(1) ]
      ur=[ (region(2)-region(0))*0.975 + region(0), $
           (region(3)-region(1))*0.950 + region(1) ]
      position=[ll,ur]
  endif
  if not keyword_set(xspace) then xspace=0.15
  if not keyword_set(yspace) then yspace=0.15
  if not keyword_set(title) then title=' '
  if not keyword_set(xtitle) then xtitle=' '
  if not keyword_set(ytitle) then ytitle=' '

  if init then begin
      if keyword_set(set_plot) then begin
          set_plot= strlowcase(set_plot)
          spawn, "echo $$", uniqueid &  uniqueid=strtrim(uniqueid(0),2)
          if landscape then begin
              xs=10.0 & ys=7.5
              xoffset=0.5 & yoffset=10.5
          endif else begin
              xs=7.5 & ys=10.0
              xoffset=0.5 & yoffset=0.5
          endelse
          print2file= keyword_set(print2file)
          case set_plot of
              'ps': begin
                  set_plot, set_plot
                  device, xsize=xs, ysize=ys, /inches, landscape=landscape,$
                    filename=filename+uniqueid+'.'+set_plot, $
                    xoffset=xoffset, yoffset=yoffset
                  default_printer_name='ggs_laser'
                  device_type='printer'
              end
              'pcl': begin
                  set_plot, set_plot
                  device, xsize=xs, ysize=ys, /inches, landscape=landscape,$
                    filename=filename+uniqueid+'.'+set_plot
                  default_printer_name='cis_color'
                  device_type='printer'
              end
              'x': begin
                  set_plot, set_plot
                  device_type='display'
                  default_printer_name=' '
              endif
          endcase
          if not keyword_set(printer_name) then $
            printer_name=default_printer_name
          device_spec= { device_spec_struct, $
                         name:set_plot, $
                         device_type:device_type, $
                         filename_pre:filename, $
                         filename:filename+uniqueid+'.'+set_plot, $
                         send_page:0, $ ; flag that a printable page needs sending
                         autoclear:1, $ ; send at page completion
                         printer_name:printer_name, $
                         print2file:print2file, $
                         oldX:!X, $
                         oldY:!Y, $
                         oldZ:!Z, $
                         oldP:!P $
                       } 
      endif
      
      if n_elements( device_spec ) eq 0 then begin
          set_plot, 'x'
          device_spec= { device_spec_struct, $
                         name:'x', $
                         device_type:'display', $
                         filename_pre:' ', $
                         filename:' ', $
                         send_page:0, $
                         autoclear:1, $ ; clear at page completion
                         printer_name:' ', $
                         print2file:print2file, $
                         oldX:!X, $
                         oldY:!Y, $
                         oldZ:!Z, $
                         oldP:!P $
                       } 
      endif
  endif

  if init then begin
;     calculate origin and deltaplot
      xorigin= position(0)      
      yorigin= position(1)

      plotwidth= (position(2)-position(0)) / ( nh + nh*xspace - xspace )
      plotheight= (position(3)-position(1)) / ( nv + nv*yspace - yspace )

      xdeltaplot= plotwidth * ( 1+xspace )
      ydeltaplot= plotheight * ( 1+yspace )      

      pdef= { pdef_struct, $
              next_plot_number:0, $
              number_of_plots:nplots, $
              horizontal_panels:nh, $
              vertical_panels:nv, $
              xorigin:xorigin, $
              yorigin:yorigin, $
              xdeltaplot:xdeltaplot, $
              ydeltaplot:ydeltaplot, $
              plotwidth:plotwidth, $
              plotheight:plotheight, $
              title:title $
            }

      titlepos= ( position(3)-position(1) ) * 1.03 + position(1)
      xyouts, position(0), titlepos, title, /normal, charsize=1.0

  endif else if restore then begin
      !x=device_spec.oldx
      !y=device_spec.oldy
      !z=device_spec.oldz
      !p=device_spec.oldp
  endif else if reset then begin
      pdef.next_plot_number=0
  endif else if send then begin
      if device_spec.send_page eq 1 then begin
          if device_spec.device_type eq 'printer' then begin
              device, /close
              if not device_spec.print2file then begin
                  printstr= 'lp -cd'+device_spec.printer_name+' '
                  spawn, printstr+device_spec.filename
                  spawn, 'rm '+device_spec.filename
              endif
              spawn, "echo $$", uniqueid 
              uniqueid=strtrim(uniqueid(0),2)
              device, filename=device_spec.filename_pre+uniqueid+'.'+ $
                device_spec.name
              device_spec.filename=device_spec.filename_pre+uniqueid+'.'+$
                device_spec.name
          endif else begin
              erase
          endelse
          titlepos= ( position(3)-position(1) ) * 1.03 + position(1)
          xyouts, position(0), titlepos, title, /normal, charsize=1.0
          device_spec.send_page=0              
      endif      
  endif else if next then begin
      if pdef.next_plot_number eq 0 and $
        device_spec.autoclear then begin
          if device_spec.send_page eq 1 then begin
              if device_spec.device_type eq 'printer' then begin
                  device, /close
                  if not device_spec.print2file then begin
                      printstr= 'lp -cd'+device_spec.printer_name+' '
                      spawn, printstr+device_spec.filename
                      spawn, 'rm '+device_spec.filename
                  endif
                  spawn, "echo $$", uniqueid 
                  uniqueid=strtrim(uniqueid(0),2)
                  device, filename=device_spec.filename_pre+uniqueid+'.'+ $
                    device_spec.name
                  device_spec.filename=device_spec.filename_pre+uniqueid+'.'+$
                    device_spec.name
              endif else begin
                  erase
              endelse
              titlepos= ( position(3)-position(1) ) * 1.03 + position(1)
              xyouts, position(0), titlepos, title, /normal, charsize=1.0
          endif
      endif

      device_spec.send_page=1    
                   this_h= pdef.next_plot_number mod pdef.horizontal_panels
      this_v= pdef.vertical_panels - 1 - $
        pdef.next_plot_number / pdef.horizontal_panels

      ll= [ pdef.xorigin + pdef.xdeltaplot * this_h, $
            pdef.yorigin + pdef.ydeltaplot * this_v ]
      ur= [ ll(0)+pdef.plotwidth, ll(1)+pdef.plotheight ]
      
      !p.position=[ll,ur]
      
      blankticks= replicate(' ',30)
      nullticks= replicate('',30)
      case ((this_h) eq 0)*1 + ((this_v) eq 0)*2 of    
          0: begin              ; interior
              !x.title=' '
              !x.tickname=blankticks
              !y.title=' '              
              !y.tickname=blankticks
          end
          1: begin              ; leftside
              !x.title=' '
              !x.tickname=blankticks
              !y.title=ytitle
              !y.tickname=nullticks
          end
          2: begin              ; bottom
              !x.title=xtitle
              !x.tickname=nullticks
              !y.title=' '
              !y.tickname=blankticks              
          end
          3: begin              ; bottom-left corner
              !x.title=xtitle
              !x.tickname=nullticks              
              !y.title=ytitle
              !y.tickname=nullticks              
          end
      endcase
      pdef.next_plot_number= pdef.next_plot_number+1
      if pdef.next_plot_number eq pdef.number_of_plots then begin
          pdef.next_plot_number=0
      endif

  endif else begin
      
      if keyword_set(charsize) then begin
          charsize= pdef.plotwidth*charsize*5
      endif else begin
          charsize= pdef.plotwidth*5
      endelse
      
      if n_params() eq 2 then begin
          arg2=arg1
          arg1=lindgen(n_elements(arg2))
      endif

      if pdef.next_plot_number eq 0 and $
        device_spec.autoclear then begin
          if device_spec.send_page eq 1 then begin
              if device_spec.device_type eq 'printer' then begin
                  stop
                  device, /close
                  if not device_spec.print2file then begin
                      printstr= 'lp -cd'+device_spec.printer_name+' '
                      spawn, printstr+device_spec.filename
                      spawn, 'rm '+device_spec.filename
                  endif
                  spawn, "echo $$", uniqueid 
                  uniqueid=strtrim(uniqueid(0),2)
                  device, filename=device_spec.filename_pre+uniqueid+'.'+ $
                    device_spec.name
                  device_spec.filename=device_spec.filename_pre+uniqueid+'.'+$
                    device_spec.name
              endif else begin
                  erase
              endelse
              titlepos= ( position(3)-position(1) ) * 1.03 + position(1)
              xyouts, position(0), titlepos, title, /normal, charsize=1.0
          endif
      endif

      device_spec.send_page=1
      
      this_h= pdef.next_plot_number mod pdef.horizontal_panels
      this_v= pdef.vertical_panels - 1 - $
        pdef.next_plot_number / pdef.horizontal_panels

      ll= [ pdef.xorigin + pdef.xdeltaplot * this_h, $
            pdef.yorigin + pdef.ydeltaplot * this_v ]
      ur= [ ll(0)+pdef.plotwidth, ll(1)+pdef.plotheight ]
      
      blankticks= replicate(' ',30)
      case ((this_h) eq 0)*1 + ((this_v) eq 0)*2 of    
          0: $                  ; interior
            plot, arg1, arg2, _extra=plotParm, $
            xtickname=blankticks, ytickname=blankticks, $            
            title=title, charsize=charsize, $
            position= [ ll, ur ], /noerase
          1: $                  ; leftside
            plot, arg1, arg2, _extra=plotParm, $
            xtickname=blankticks, $
            ytitle=ytitle, charsize=charsize, $
            title=title, $
            position= [ ll, ur ], /noerase
          2: $                  ; bottom
            plot, arg1, arg2, _extra=plotParm, $
            ytickname=blankticks, $
            xtitle=xtitle, charsize=charsize, $
            title=title, $
            position= [ ll, ur ], /noerase
          3: $                  ; bottom-left corner
            plot, arg1, arg2, _extra=plotParm, $
            xtitle=xtitle, $
            ytitle=ytitle, $
            title=title, charsize=charsize, $
            position= [ ll, ur ], /noerase
      endcase
      pdef.next_plot_number= pdef.next_plot_number+1
      if pdef.next_plot_number eq pdef.number_of_plots then begin
          pdef.next_plot_number=0
      endif
  endelse
  return
end
      

