pro poor_contour, x_in, y_in, $
                  contours=contour, $
                  xbins=xbins, $
                  ybins=ybins, $
                  _extra=plot_Par, min_value=min_value, $
                  overplot=overplot

if n_elements(min_value) gt 0 then begin
    r= where( y_in ge min_value )
    if r(0) ne -1 then begin
        y_in=y_in(r)
        x_in=x_in(r)
    endif
endif

; poor mans contour
;
; Input coordinate pairs of points x(n),y(n)
;  Input interval [xl,xu],[yl,yu], increments:[dx,dy]
; Input three levels of significance a> b> c < 1.000
; Output three vectors of indices for x and y that
;   correspond to meeting the conditions
;  nra =>>>> indices where # of times in buckets
;      places all x(nra),y(nra) as containing 
;            1-a of the particles:
;     example a =.9999; nra find all buckets such that

if n_elements(xbins) eq 0 then xbins=30
if n_elements(ybins) eq 0 then ybins=30

if n_elements( contour ) eq 0 then begin
    a=.8
    b=.3
    c=.001
endif else begin
    a=contour(0)
    b=contour(1)
    c=contour(2)
endelse

if not keyword_set( overplot ) then $
  plot, x_in, y_in, _extra=plot_par, /nodata

xlog=!x.type
ylog=!y.type

if xlog then x=alog10(x_in) else x=x_in
if ylog then y=alog10(y_in) else y=y_in

xl=!x.crange(0)
xu=!x.crange(1)
yl=!y.crange(0)
yu=!y.crange(1)

dx= (xu-xl)/xbins
dy= (yu-yl)/ybins

npoints=n_elements(x)
ixsize=fix((xu-xl)/dx + 1)  ; fix = in*2; long in*4
iysize=fix((yu-yl)/dy + 1)

counter=0.0*findgen(ixsize(0),iysize(0))
xcounter=counter
ycounter=counter
;caculate indices for incoming points
ix=fix( (x-xl)/dx ) > 0 < (ixsize-1)
iy=fix( (y-yl)/dy) > 0 < (iysize-1)

for jkl=0L,npoints-1 do begin
    counter(ix(jkl),iy(jkl))=counter(ix(jkl),iy(jkl))+1
    xcounter(ix(jkl),iy(jkl))=ix(jkl)
    ycounter(ix(jkl),iy(jkl))=iy(jkl)
endfor

; sort output
order= counter(sort(counter))
; now things in order are  0,0,0,0,,1,,,,2,,,3,,4,,,5,,6,,7
; form runing sum
nsort=n_elements(order)
cumsum=0*order
cumsum(0)=order(0)
for jkl=1L,nsort-1 do begin
    cumsum(jkl)=cumsum(jkl-1)+order(jkl)
endfor

; find breaks in cumulative sum
aggregate=total(counter)
cumsum=cumsum/(aggregate*1.0)
isortga=where(cumsum ge a)   ;peak/ridge
nmina=-1
nmaxa=-1
if(isortga(0) ne -1) then nmina=min(order(isortga))
if(isortga(0) ne -1) then nmaxa=max(order(isortga))
iraxy=where(counter ge nmina and counter le nmaxa)
isortgb=where(cumsum ge b and cumsum le a)   ;less of all near peak
nminb=-1
nmaxb=-1
if(isortgb(0) ne -1)  then nminb=min(order(isortgb))
if(isortgb(0) ne -1)  then nmaxb=max(order(isortgb))
irbxy=where(counter ge nminb and counter le nmaxb )
isortgc=where(cumsum ge c and cumsum le b)  ; peak/ridge
nminc=-1
nmaxc=-1
if(isortgc(0) ne -1) then nminc=min(order(isortgc))
if(isortgc(0) ne -1) then nmaxc=max(order(isortgc))
ircxy=where(counter ge nminc and counter le nmaxc)

;create array coordinates of points for various classes
if(ircxy(0) ne -1) then begin
    nploting=n_elements(ircxy)-1
    xout = xl + (xcounter(ircxy)+0.5)*dx
    yout = yl + (ycounter(ircxy)+0.5)*dy
    if xlog then xout=10^xout
    if ylog then yout=10^yout
    oplot,xout,yout,psym=3,$
      symsize=0.3
endif
if(irbxy(0) ne -1) then begin
    nploting=n_elements(irbxy)-1
    xout = xl + (xcounter(irbxy)+0.5)*dx
    yout = yl + (ycounter(irbxy)+0.5)*dy
    if xlog then xout=10^xout
    if ylog then yout=10^yout
    oplot,xout,yout,psym=7,$
      symsize=0.5
endif
if(iraxy(0) ne -1) then begin
    nploting=n_elements(iraxy)-1
    xout = xl + (xcounter(iraxy)+0.5)*dx
    yout = yl + (ycounter(iraxy)+0.5)*dy
    if xlog then xout=10^xout
    if ylog then yout=10^yout
    oplot,xout,yout,psym=2
endif

return
end

