pro pplot, x_in, y_in, overplot=overplot, $
           _extra=e
  
  if n_elements(y_in) eq 0 then begin
      y= x_in
      x= dindgen(n_elements(y))
  endif else begin
      y= y_in
      x= x_in
  endelse

  r= where( x gt -1e20 and x lt 1e20 and $
            y gt -1e20 and y lt 1e20 and $
            finite(x) and $
            finite(y) )
  
  if r(0) eq -1 then begin
      message, 'no valid points', /cont
      return
  endif else begin
      if keyword_set(overplot) then begin
          oplot, x[r], y[r], _extra=e
      endif else begin
          plot, x[r], y[r], _extra=e
      endelse
  endelse
end
