;This procedure calculates the number of days which contain valid data
;for a given gain id.
;The file, gain_id_v04.1.dat, is open and read in. 
;The data file contains information in the following positions:
;positions    information
;1-5          gain id
;8-16         start date
;18-22        start time
;25-32        end date
;35-39        end time
;44-45        DBM
;49-64        ELE Bias Ion
;65-67        valid days in the block
;69-75        computer on which file is mounted
PRO read_gain_ids, gain_ids
;+
; NAME: read_gain_ids
;
; PURPOSE: read gain_id file into structures for use in IDL
;
; CATEGORY: utility
;
; CALLING SEQUENCE: read_gain_ids, gain_ids
; 
; INPUTS: none
;
; KEYWORD PARAMETERS: none
;
; OUTPUTS: gain_ids, an array of structures, in the form:
;                   { $
;                     gain_id:'', $
;                     start_date:'', $
;                     start_time:'', $
;                     start_doy96:double(0), $
;                     end_date:'', $
;                     end_time:'', $
;                     end_doy96:double(0), $
;                     mode:0, $
;                     bias_ele:intarr(2), $
;                     bias_ion:intarr(2), $
;                     ndays:0, $
;                     machine:'' $
;                   }
;
; PROCEDURE: parse gain_id file, copy into structures
;
; EXAMPLE: 
;    read_gain_ids, gid
;    idx= (where( gid.gain_id eq '0410' ))(0)
;    print, gid(idx).start_date, gid(idx).end_date
;
; MODIFICATION HISTORY: 
;    written, September 29, 1999, jbf
;-
  
  openr, unit, /get_lun, '/opt/hydra/gain_data/gain_id_v04.1.dat'
  iline=''                    
  
  gain_id_struct1= { $
                     gain_id:'', $
                     start_date:'', $
                     start_time:'', $
                     start_doy96:double(0), $
                     end_date:'', $
                     end_time:'', $
                     end_doy96:double(0), $
                     mode:0, $
                     bias_ele:intarr(2), $
                     bias_ion:intarr(2), $
                     ndays:0, $
                     machine:'' $
                   }
  
  gain_ids= [ gain_id_struct1 ]
 
  i=0
  while not eof(unit) do begin
      READF, unit, iline
      if strtrim(iline,2) ne '' and strmid(iline,0,1) ne '#' then begin
          gid= gain_id_struct1
          gid.gain_id= strmid(iline,1,4)       
          gid.start_date= strmid(iline,8,8)
          gid.start_time= strmid(iline,18,5)
          gid.start_doy96= gen_time(gid.start_date+' '+gid.start_time)
          gid.end_date= strmid(iline,25,8)
          gid.end_time= strmid(iline,35,5)
          gid.end_doy96= gen_time(gid.end_date+' '+gid.end_time)
          gid.mode= long( strmid(iline,40,6) )
          gid.bias_ele(0)= long( strmid(iline,46,5) )
          gid.bias_ele(1)= long( strmid(iline,51,4) )
          gid.bias_ion(0)= long( strmid(iline,55,5) )
          gid.bias_ion(1)= long( strmid(iline,60,4) )
          gid.ndays= long( strmid(iline,64,3) )
          gid.machine= strtrim( strmid( iline,67,20 ) )
          gain_ids= [ gain_ids, gid ]
      endif
  ENDWHILE
  gain_ids= gain_ids(1:*)
  close, unit
end




