function read_sdt_name_map, sdt_name
;  maps sdt file name to tag name in output structure.
  map= [[ 'POLAR_v_56_12_A', 'POLAR_v_56' ], $
        [ 'POLAR_v_56_34_A', 'POLAR_v_56' ], $
        [ 'POLAR_v_56_12_A_Comp', 'POLAR_v_56' ], $
        [ 'POLAR_v_56_34_A_Comp', 'POLAR_v_56' ], $
        [ 'POLAR_v_56_34_A_NoC', 'POLAR_v_56' ], $
        [ 'POLAR_EX_GSM_34_A_NoC', 'POLAR_EX_GSM' ], $
        [ 'POLAR_EY_GSM_34_A_NoC', 'POLAR_EY_GSM' ], $
        [ 'POLAR_EZ_GSM_34_A_NoC', 'POLAR_EZ_GSM' ], $
        [ 'POLAR_EX_FAC_34_A_NoC', 'POLAR_EX_FAC' ], $
        [ 'POLAR_EY_FAC_34_A_NoC', 'POLAR_EY_FAC' ], $
        [ 'POLAR_EZ_FAC_34_A_NoC', 'POLAR_EZ_FAC' ], $
        [ 'POLAR_V_X_GSM_34_A_NoC', 'POLAR_V_X_GSM' ], $
        [ 'POLAR_V_Y_GSM_34_A_NoC', 'POLAR_V_Y_GSM' ], $
        [ 'POLAR_V_Z_GSM_34_A_NoC', 'POLAR_V_Z_GSM' ] ]
        
  map= strupcase(map)

  r= where( map(0,*) eq strupcase(sdt_name) )
  if r(0) ne -1 then begin
      new_name= map(1,r(0))
      message, 'Renaming '+sdt_name+' to '+new_name+'.', /cont
      return, new_name
  endif else begin
      return, sdt_name
  endelse
end     
  
pro read_sdt3, file, header_out, data_out

   openr, unit, /get_lun, file
   
   header= {production_date:'', $
            file:file, $
            start_time:-1L, $
            end_time:-1L }

   s='*'
   while strmid(s,0,1) eq '*' do begin
       readf, unit, s           ; skip comments at beginning
       if strmid(s,2,10) eq 'Date/Time:' then begin
           header.production_date= strmid(s,13,30)
       endif
   endwhile

   while strmid(s,0,6) ne '%Start' do begin
       readf, unit, s
   end   
   
   repeat begin
       
       type= strmid(s,7,22)       
       print, 'Reading '+type+'...'
       
;       here are the name mappings
       type= read_sdt_name_map( type )
       
       done_with_header=0
       while not done_with_header do begin
           readf, unit, s
           case 1 of
               strmid(s,0,5) eq '%Time': begin
                   itime= long( strmid( s, 5, 9 ) )
                   if header.start_time eq -1 then begin
                       header.start_time= itime                        
                       time_offset= 0
                       header.end_time= long( strmid( s, 27, 9 ) )
                   endif else begin
                       time_offset= ( itime - header.start_time ) * 86400
                   endelse
               end
               strmid(s,0,7) eq '%Points': begin
                   ipoints= long( strmid( s, 8, 9 ) )
                   if n_elements(common_time) eq 0 then begin
                       common_time= dblarr( ipoints )                       
                   endif 
                   time= dblarr( ipoints )
                   data= dblarr( ipoints )
                   newtime=0
               end
               strmid(s,0,17) eq '%Component Depths': begin
                   done_with_header=1
               end
               else:
           endcase
       endwhile
       
       i1=0L & r1=0.D & r2=0.D
       for j=0L,ipoints-1 do begin
           readf, unit, i1, r1, r2
           time(j)= r1 + time_offset
           data(j)= r2
           if j gt n_elements(common_time)-1 then begin
               newtime=1 
           endif else begin
               if common_time(j) ne 0. then begin
                   if common_time(j) ne time(j) then begin
                       newtime=1
                   endif
               endif
           endelse
       endfor

       while strmid(s,0,3) ne 'End' and not eof(unit) do begin
           readf, unit, s
       endwhile

       if newtime then begin
           message, 'Interpolating data to common time tags.', /cont
           data= interpol( data, time, common_time )
       endif
       
       next_tag= create_struct( type, data )
       
       if common_time(0) eq 0. then begin
           common_time= time
       endif
           
       if n_elements( next_tag ) gt 0 then begin
           if n_elements( extra ) eq 0 then begin
               extra= next_tag
           endif else begin
               extra= create_struct( extra, next_tag )
           endelse
       endif

       while strmid(s,0,5) ne 'Start' and not eof(unit) do begin
           readf, unit, s
       end   
       
   endrep until eof(unit)
   
   close, unit
   free_lun, unit

   extra1= { time:common_time }
   extra= create_struct( extra1, extra )
   
   if n_params() eq 1 then begin
       time=extra
   endif

   data_out= extra
   header_out= header

   return
end

