
function rhistogram, Amin_in, Amax_in, Aweight, $
                     binsize=binsize, min=min, max=max

  if n_elements(Aweight) ne n_elements(Amin_in) then $
    Aweight= replicate(1.,n_elements(Amin_in))
  if n_elements(max) eq 0 then max=ceil(max( Amax_in ))
  if n_elements(min) eq 0 then min=floor(min( Amin_in ))
  if n_elements(binsize) eq 0 then binsize=1.

  nh= long( ( max-min ) / binsize ) + 1
  result= fltarr( nh )

  amin=amin_in
  amax=amax_in
  r=where(amin gt amax,nr)
  if nr ne 0 then begin
      amin_save=amin(r)
      amin(r)=amax(r)
      amax(r)=amin_save
  endif

  for i=0,n_elements(Amin)-1 do begin
      ibin0= floor((Amin(i)-min)/binsize)
      invN0= ( (min+(ibin0+1)*binsize) - ( Amin(i) ) ) / binsize
      ibin1= floor((Amax(i)-min)/binsize)
      invN1= ( Amax(i) - ( (min+(ibin1*binsize)) ) ) / binsize
      invN= 1
      
      TT= total( invN0 + invN1 + invN*(ibin1-ibin0-1) )

      if TT ne 0.0 then begin
          if invN0 gt 0. and $
            ibin0 ge 0 and ibin0 lt nh and $
            ibin0 lt ibin1 then $
            result(ibin0)= result(ibin0)+invN0/TT * Aweight(i)
          if invN1 gt 0. and $
            ibin1 lt nh and ibin1 ge 0 and $
            ibin0 lt ibin1 then $
            result(ibin1)= result(ibin1)+invN1/TT * Aweight(i)
          if ibin1-ibin0 gt 1 then begin
              idx= indgen( (ibin1-1)-(ibin0+1)+1 ) + (ibin0+1)
              r= where( idx ge 0 and idx lt nh )
              if r(0) ne -1 then $
                result(idx(r))= result(idx(r)) + invN/TT * Aweight(i)
          endif else if ibin0 eq ibin1 then begin
              result(ibin0)= result(ibin0)+Aweight(i)
          endif
      endif
  endfor

  return, result
  
end
  
