pro sub_struct, structure, tags_in, sub_structure, remain_structure, $
                clip_tags=clip_tags
;+
; NAME: sub_struct
;
; PURPOSE: extract part of a structure by matching tag names
;
; CATEGORY: utility
;
; CALLING SEQUENCE:  sub_struct, struct, match_expr, sub_struct, remain_struct
; 
; INPUTS: 
;    struct        a structure
;    match_expr    a string that defines which tag_names the returned 
;        structure will have.  Use regular-expression-like strings, e.g. "x*"
;        This can be an array as well, to include a tag that matches a
;        number of expressions.
;
; KEYWORD PARAMETERS:
;    clip_tags=n   a convenience that will clip off the first n
;        characters from the matching tagnames.  
;
; OUTPUTS:
;    sub_struct      a structure that is a subset of the tags of the 
;                    input structure.  If no tags match, then left undefined.
;    remain_struct   this structure contains the rest of the tags.
;
; RESTRICTIONS:
;
; PROCEDURE: see the code.
;
; EXAMPLE: 
;   sub_struct, !d, 'x_*', new, remain
;   help, /struct, new, remain
;   sub_struct, !d, 'x_*', clip_tags=2, new
;   help, /struct, new    ; tags don't have the 'x_' prefix.
;   sub_struct, !d, 'zzzzzzz*', new
;   help, /struct, new    ; prints <undefined>.
;
; MODIFICATION HISTORY:
;   written, May 16, 2000, Jeremy Faden
;-
  
  if n_elements( structure ) gt 1 then begin
      message, 'does not work for arrays of structures'
  endif

  if n_elements( clip_tags ) eq 0 then clip_tags=0

  tags= strupcase( tags_in )

  tag_names= tag_names( structure )
  include= intarr(n_elements(tag_names))
  for i=0,n_elements(tags)-1 do begin
      r= where( reg_expr_match( tag_names, tags(i) ) )
      if r(0) ne -1 then begin
          include(r)=1
          tag_names[r]= strmid( tag_names[r],clip_tags(i),256 )
      endif
  endfor
  
  r= where( include, count )
  if count gt 0 then $
    result= create_struct( tag_names[r[0]], structure.(r[0]) )
  for i=1,count-1 do begin
      result= create_struct( result, $
                             create_struct( tag_names[r[i]],structure.(r[i])) )
  endfor

  r= where( include eq 0, count )
  if count gt 0 then $
    remain= create_struct( tag_names[r[0]], structure.(r[0]) )
  for i=1,count-1 do begin
      remain= create_struct( remain, $
                             create_struct( tag_names[r[i]],structure.(r[i])) )
  endfor

  if n_elements( result ) eq 0 then begin
      if n_elements( sub_structure ) ne 0 then x= temporary( sub_structure )
  endif else begin
      sub_structure= result
  endelse

  if n_elements( remain ) eq 0 then begin
      if n_elements( remain_structure ) ne 0 then $
        x= temporary( remain_structure )
  endif else begin
      remain_structure= remain
  endelse
  
end
  
