function sub_struct, structure, tags_in, $
                     clip_tags=clip_tags
;+
; NAME: sub_struct
;
; PURPOSE: extract part of a structure by matching tag names
;
; CATEGORY: utility
;
; CALLING SEQUENCE:  new_struct= sub_struct( struct, match_expr )
; 
; INPUTS: 
;    struct        a structure
;    match_expr    a string that defines which tag_names the returned 
;        structure will have.  Use regular-expression-like strings, e.g. "x*"
;        This can be an array as well, to include a tag that matches a
;        number of expressions.
;
; KEYWORD PARAMETERS:
;    clip_tags=n   a convenience that will clip off the first n
;        characters from the matching tagnames.  
;
; OUTPUTS:
;    returns a structure that is a subset of the tags of the 
;    input structure.
;
; RESTRICTIONS:
;
; PROCEDURE: see the code.
;
; EXAMPLE: 
;   help, /struct, sub_struct( !d, 'x_*' )
;   help, /struct, sub_struct( !d, 'x_*', clip_tags=2 )
;
; MODIFICATION HISTORY:
;
;-
  
  if n_elements( structure ) gt 1 then begin
      message, 'does not work for arrays of structures'
  endif

  if n_elements( clip_tags ) eq 0 then clip_tags=0

  tags= strupcase( tags_in )

  tag_names= tag_names( structure )
  include= intarr(n_elements(tag_names))
  for i=0,n_elements(tags)-1 do begin
      r= where( reg_expr_match( tag_names, tags(i) ) )
      if r(0) ne -1 then begin
          include(r)=1
          tag_names[r]= strmid( tag_names[r],clip_tags(i),256 )
      endif
  endfor
  
  r= where( include, count )
  if count gt 0 then $
    result= create_struct( tag_names[r[0]], structure.(r[0]) )
  for i=1,count-1 do begin
      result= create_struct( result, $
                             create_struct( tag_names[r[i]],structure.(r[i])) )
  endfor

  return, result
end
  
