pro testit
;  npts_arr= [12,50,100,140,200,400,600,700,900,1300]
 ; npts_arr= [ npts_arr, 5000,10000,30000,100000 ]
;  npts_arr= [10,30,100,300,600,1000,3000]/3
  npts_arr= (findgen(13)+1)/12 * 10000
  time= fltarr(n_elements(npts_arr))

  dots, /fill
  for iii=0,n_elements(npts_arr)-1 do begin

      npts= npts_arr(iii)
      npts_int= npts

;      common saveit, x_tri, y_tri, z_tri
;      if n_elements( x_tri ) eq 0 then begin
          x_tri= randomn(s,npts)
          y_tri= randomn(s,npts)
          z_tri= x_tri^2 / 3 +y_tri^2 / 7
;      endif
      
      hydra_tricolor, x_tri, y_tri, z_tri, zrange=zrange
      x= randomn(s,npts_int)
      y= randomn(s,npts_int)

      triangulate, x_tri, y_tri, T

      s= systime(1)      
      z= tri_interpolate(x_tri, y_tri, z_tri, T, x, y )
      time(iii)=systime(1)-s

      oplot, x, y, psym=8, symsize=1.3
      hyd_scatter, x, y, z, zrange=zrange, psym=8, /overplot
  endfor
  dots
  plot, npts_arr, time, psym=8 
  r= linfit( npts_arr, time )
  oplot, !x.crange, r(0)+r(1)*!x.crange
  print, 'time per point=' + string(format='(f9.3)',r(1)*1000) + ' msec'
  stop
end

function tri_interpolate, x_tri, y_tri, z_tri, T, x_in, y_in, $
                          sigma_z= sigma_z_tri, $
                          sigma_interp= sigma_result, $
                          missing=missing, $
                          tri_locate=iT_in

  x= x_in
  y= y_in

  if n_elements( missing ) eq 0 then missing= -1e31
  result= fltarr( n_elements(x) ) + missing

  if n_elements(iT_in) eq 0 then begin
      iT= tri_locate( x_tri, y_tri, T, x, y, ndiv=200 )
  endif else begin
      iT= iT_in
  endelse

  r= where( iT ne -1 )
  if r(0) ne -1 then begin

      iT= iT(r)
      x= x_in(r)
      y= y_in(r)

      x1= x_tri(T(0,iT))  &   x2= x_tri(T(1,iT))  &   x3= x_tri(T(2,iT))
      y1= y_tri(T(0,iT))  &   y2= y_tri(T(1,iT))  &   y3= y_tri(T(2,iT))
      z1= z_tri(T(0,iT))  &   z2= z_tri(T(1,iT))  &   z3= z_tri(T(2,iT))

      result(r)= $
        -( x*z2*y3 - x1*z2*y3 + y*z1*x3 - $
           x*z2*y1 + x*y2*z1 + y*x2*z3 + $
           y*z2*x1 - x*y2*z3 - x*z1*y3 - $
           y*z2*x3 + x1*y2*z3 + x*y1*z3 - $
           y*x2*z1 - y*x1*z3 + y1*z2*x3 - $
           y1*x2*z3 + z1*x2*y3 - z1*y2*x3) / $
        (-x2*y3+ x2*y1 + x1*y3 + y2*x3 - y2*x1 - y1*x3)


      if n_elements( sigma_z_tri ) gt 0 then begin
          sigma_result= make_array( size=size( result ) )
          sig_z1= sigma_z_tri(T(0,iT))
          sig_z2= sigma_z_tri(T(1,iT))
          sig_z3= sigma_z_tri(T(2,iT))
          denom= (x2*y3-x2*y1-x1*y3-y2*x3+y2*x1+y1*x3)
          dzdz1= ( x*y2  -x*y3 +y*x3 -y*x2  +x2*y3 -y2*x3 ) / denom
          dzdz2= (-x1*y3 +x*y3 -x*y1 +y1*x3 -y*x3  +y*x1 ) / denom
          dzdz3= ( y2*x1 -x*y2 +x*y1 -x2*y1 +y*x2  -y*x1 ) / denom
          sigma_result(r)= sqrt( dzdz1^2 * sig_z1^2 + $
                                 dzdz2^2 * sig_z2^2 + $
                                 dzdz3^2 * sig_z3^2 )

      endif

  endif

  return, result
end

