function tri_locate_check, x, y, T, x1, y1, ilocate
  
  result= replicate(0,n_elements(ilocate))
  
  r= where( ilocate ge 0 )

  if r(0) ne -1 then begin
      x_T0= x(T(0,ilocate(r)))
      x_T1= x(T(1,ilocate(r)))
      x_T2= x(T(2,ilocate(r)))
      
      y_T0= y(T(0,ilocate(r)))
      y_T1= y(T(1,ilocate(r)))
      y_T2= y(T(2,ilocate(r)))

      mag_cross1= $
        ( x_T1-x_T0 ) * ( y1(r)-y_T0 )  -  $
        ( y_T1-y_T0 ) * ( x1(r)-x_T0 )
      
      mag_cross2= $
        ( x1(r)-x_T0 ) * ( y_T2-y_T0 )  -  $
        ( y1(r)-y_T0 ) * ( x_T2-x_T0 )
      
      mag_cross3= $
        ( x_T2-x_T1 ) * ( y1(r)-y_T1 )  -  $
        ( y_T2-y_T1 ) * ( x1(r)-x_T1 )
      
      mag_cross4= $
        ( x1(r)-x_T1 ) * ( y_T0-y_T1 )  -  $
        ( y1(r)-y_T1 ) * ( x_T0-x_T1 )
      
      result(r)=  $
        mag_cross1 * mag_cross2 gt 0. and mag_cross3 * mag_cross4 gt 0.
  endif
  
  return, result
end
