pro testit
  x_tri= randomu(seed,100)
  y_tri= randomu(seed,100)
  triangulate, x_tri, y_tri, T
  s= sort( randomu(seed,n_elements(x_tri) ) )  
  plot_triangles, x_tri, y_tri, T
  stop
  x_tri= x_tri(s)
  y_tri= y_tri(s)
  x= randomu(seed,10)
  y= randomu(seed,10)
  plot_triangles, x_tri, y_tri, T
  multi=1
  ilocate= tri_locate( x_tri, y_tri, T, x, y, multi=multi )
  oplot, x, y, psym=1
  ii=1
  oplot, [x[ii]], [y[ii]], psym=7
  plot_triangles, x_tri, y_tri, T(*,ilocate[ii]), /overplot, color=!cs.yellow
  stop  
end

function tri_locate1, x,y,T,x1,y1, multiple_matches=multi

  mag_cross1= $
    ( x(T(1,*))-x(T(0,*)) ) * ( y1-y(T(0,*)) )  -  $
    ( y(T(1,*))-y(T(0,*)) ) * ( x1-x(T(0,*)) )

  mag_cross2= $
    ( x1-x(T(0,*)) ) * ( y(T(2,*))-y(T(0,*)) )  -  $
    ( y1-y(T(0,*)) ) * ( x(T(2,*))-x(T(0,*)) )

  mag_cross3= $
    ( x(T(2,*))-x(T(1,*)) ) * ( y1-y(T(1,*)) )  -  $
    ( y(T(2,*))-y(T(1,*)) ) * ( x1-x(T(1,*)) )
  
  mag_cross4= $
    ( x1-x(T(1,*)) ) * ( y(T(0,*))-y(T(1,*)) )  -  $
    ( y1-y(T(1,*)) ) * ( x(T(0,*))-x(T(1,*)) )
  
  r= where(  mag_cross1 * mag_cross2 gt 0. and $
             mag_cross3 * mag_cross4 gt 0. )
  
  if r(0) ne -1 then begin
      if keyword_set(multi) then begin
          idx= r
      endif else begin
          idx= r(0)
      endelse
  endif else begin
      idx= -1
  endelse
  
  return, idx

end

function tri_locate_idl, x_tri, y_tri, T, x, y, gs=gs, limits=limits, $
                         multiple_matches=multi
  
;  common tri_locate_discretize, gs0, limits0, idisc, nhit, nbuf, rtri
  
  if n_elements(limits) eq 0 then begin
      limits=dblarr(4)
      limits(0)=min(x_tri,max=ma)
      limits(2)=ma
      limits(1)=min(y_tri,max=ma)
      limits(3)=ma
      limits= limits + abs(limits) * 0.0001 * [ -1, -1, 1, 1 ] ; fudge factor
  endif
  
  if n_elements(gs) eq 0 then begin
      gs_min= ( limits(2:3)-limits(0:1) ) / 50
      gs=[min( abs(x_tri(T(0,*))-x_tri(T(1,*))) > $
               abs(x_tri(T(2,*))-x_tri(T(1,*))) ),$
          min( abs(y_tri(T(0,*))-y_tri(T(1,*))) > $
               abs(y_tri(T(2,*))-y_tri(T(1,*))) ) ] > gs_min
  endif

  if min(x_tri) lt limits(0) or $
    min(y_tri) lt limits(1) or $
    max(x_tri) gt limits(2) or $
    max(y_tri) gt limits(3) then begin
      message, 'triangles fall outside the limits set by limits'
  end

  have_idisc=0
  if n_elements(gs0) gt 0 then begin
      if total(abs(gs0-gs)) eq 0. then begin
          if total(abs(limits0-limits)) eq 0. then begin
              have_idisc=1
          endif
      endif
  endif
  
  nx= ceil((limits(2)-limits(0))/gs(0)+1)
  ny= ceil((limits(3)-limits(1))/gs(1)+1)

  if have_idisc eq 0 then begin
      idisc= lonarr( nx, ny )
      idisc(*)=lindgen(long(nx)*ny)
      nhit= lonarr(nx*ny)
      nbuf= 100                 ; determined experimentally
      rtri= lonarr(nbuf,nx*ny)-1
      gs0= gs
      limits0= limits
  endif else begin
      rtri(*)= -1
  endelse

  tri_min_x= x_tri(T(0,*)) < x_tri(T(1,*)) < x_tri(T(2,*))
  tri_max_x= x_tri(T(0,*)) > x_tri(T(1,*)) > x_tri(T(2,*))
  tri_min_y= y_tri(T(0,*)) < y_tri(T(1,*)) < y_tri(T(2,*))
  tri_max_y= y_tri(T(0,*)) > y_tri(T(1,*)) > y_tri(T(2,*))

  bounds= [ tri_min_x, tri_min_y, tri_max_x, tri_max_y ] 
  ibounds= make_array( /long, size=size(bounds) )

  ibounds(0,*)= (bounds(0,*)-limits(0))/gs(0)
  ibounds(1,*)= (bounds(1,*)-limits(1))/gs(1)
  ibounds(2,*)= (bounds(2,*)-limits(0))/gs(0)
  ibounds(3,*)= (bounds(3,*)-limits(1))/gs(1)

  ibounds= floor( ibounds )

  ntri=n_elements(T)/3

  redo:
  for itri=0,ntri-1 do begin
      
      ibound= ibounds(*,itri)
      
      ihit= idisc(ibound(0):ibound(2),ibound(1):ibound(3))
      ihit= reform( ihit, n_elements(ihit) )

;      if jacks eq 0 then begin
      rtri(nhit(ihit)<(nbuf-1),ihit)=itri
      nhit(ihit)= nhit(ihit)+1


;      endif else begin
;          n= n_elements(ihit)
;          if ( ijack + n ) gt n_elements(jacks_map)/2 then begin
;              message, 'buffer overrun. ijack='+strtrim(ijack,2), /cont
;              jacks_map= [ jacks_map, lonarr(1000,2) ]
;          endif          
;          jacks_map(ijack:(ijack+n-1),0)= replicate( itri, n )
;          jacks_map(ijack:(ijack+n-1),1)= ihit
;          ijack= ijack+n
;      endelse
  endfor
  
;  if jacks eq 0 then begin
  if max(nhit) ge nbuf then begin
      nbuf= max(nhit)+1
      message, 'buffer overrun. resorting with nbuf='+strtrim(nbuf,2), /cont
      rtri= lonarr(nbuf,nx*ny)
      nhit(*)= 0
      goto, redo
  endif
;  endif

;  if jacks eq 0 then begin
;  idrtri= replicate(1,nbuf)#lindgen(nx*ny)
;  keep1= [1,replicate(0,nbuf-1)]#replicate(1,nx*ny)
;  r= where( rtri gt -1 or keep1 )
  rtri_save= rtri
;  rtri=rtri(r)
;  idrtri=idrtri(r)
;  u= uniq(idrtri)
;  endif else begin
;;      not fully developed!!!
;      jacks_map= jacks_map(0:ijack-1,*)
;      s= sort( jacks_map(*,1) )
;      rtri= jacks_map(s,0)
;      u= uniq( jacks_map(*,1),s )
;  endelse

;  reverse_indeces= [ [0,u]+n_elements(u)+1, rtri ]
  
  result= lonarr(n_elements(x))-1

  ixs= floor((x-limits(0))/gs(0))
  iys= floor((y-limits(1))/gs(1))
  rokay= where( ixs ge 0 and ixs lt nx and $
                iys ge 0 and iys lt ny )
  ihits= idisc( ixs(rokay), iys(rokay) )  

  if keyword_set(multi) then begin
      multi_matches= lonarr(n_elements(result))
      multi_idx= n_elements(result)
  endif

  for ii=0,n_elements(rokay)-1 do begin
      i= rokay(ii)
      ihit= ihits(ii)
;      r= reverse_indeces( reverse_indeces(ihit):(reverse_indeces(ihit+1)-1) )
      r3= rtri_save(*,ihit)
      r4= where( r3 gt -1 )
      if r4(0) ne -1 then r=r3(r4) else r=-1
      if r(0) ne -1 then begin
          rr= tri_locate1( x_tri,y_tri,T(*,r),x(i),y(i), $
                           multiple_matches=multi )
          if rr(0) eq -1 then begin
              result(i)=-1 
              multi_matches(i)= multi_idx              
          endif else begin
              result(i)=r(rr(0))
              if keyword_set(multi) then begin
                  multi_matches(i)= multi_idx
                  multi_matches= [ multi_matches, r(rr) ]
                  multi_idx= multi_idx+n_elements(rr)
              endif
          endelse
      endif
  endfor

  if keyword_set( multi ) then begin
      multi= multi_matches
  endif
  
  return, result
end


function tri_locate, x_tri, y_tri, T, x, y, gs=gs, limits=limits, $
                     ndivisions=ndiv, multiple_matches=multi

  call_external_so= '/home/jbf/eg/idl/callext/tri_locate.so'
;  call_external_so= './tri_locate.so'

;  f= findfile( call_external_so )
  f= ''
  if f(0) eq '' then begin
      return, tri_locate_idl( x_tri, y_tri, T, x, y, $
                              gs=gs, limits=limits, $
                              multiple_matches=multi )
  endif

  if n_elements(ndiv) eq 0 then ndiv=150

  if n_elements(limits) eq 0 then begin
      limits=dblarr(4)
      limits(0)=min(x_tri,max=ma)
      limits(2)=ma
      limits(1)=min(y_tri,max=ma)
      limits(3)=ma
      limits= limits + abs(limits) * 0.0001 * [ -1, -1, 1, 1 ] ; fudge factor
  endif
  
  if n_elements(gs) eq 0 then begin
      gs_min= ( limits(2:3)-limits(0:1) ) / ndiv
      gs=[min( abs(x_tri(T(0,*))-x_tri(T(1,*))) > $
               abs(x_tri(T(2,*))-x_tri(T(1,*))) ),$
          min( abs(y_tri(T(0,*))-y_tri(T(1,*))) > $
               abs(y_tri(T(2,*))-y_tri(T(1,*))) ) ] > gs_min
  endif

  if min(x_tri) lt limits(0) or $
    min(y_tri) lt limits(1) or $
    max(x_tri) gt limits(2) or $
    max(y_tri) gt limits(3) then begin
      message, 'triangles fall outside the limits set by limits'
  end

  dx_tri= double( x_tri )
  dy_tri= double( y_tri )
  dT= long(T)
  dx= double(x)
  dy= double(y)
  result= make_array( size= size(x),/long )
  
  nT= long( n_elements( dT )/3 )
  nxy_tri= long( n_elements( x_tri ) )
  nxy= long( n_elements( x ) )

  gs= double(gs)
  limits= double(limits)

  xxx= call_external( call_external_so, 'tri_locate', $
                      dx_tri, dy_tri, nxy_tri, dT, nT, dx, dy, nxy, $
                      gs, limits, result )
  
  return, result

end


