function where_multi, bool_array
;+
; NAME: where_multi
; PURPOSE: "where" function that returns indeces to multi-dimensional array
; CATEGORY: utility
; CALLING SEQUENCE: idx= where_multi(condition)
; INPUTS: 
;    condition    multi-dimensional boolean array
; OUTPUTS:
;    idx          indeces where condition is 1 (true).  Index is an array
;                   m by n, where m is number if dimensions of
;                   condition,  and n is the number of instances where
;                   condition is true.  If condition is never true,
;                   then -1 is returned.
; EXAMPLE:   
;    A= randomn(s,3,4,5)
;    Amax= max(A)
;    print, where_multi( A eq Amax )
;
; MODIFICATION HISTORY:
;    Written, jbf, June 1, 2000.
;-

  s= size( bool_array )
  r= where( bool_array, count )
  if r(0) eq -1 then return, -1
  idx= make_array( /long, s(0), count )
  r_= r
  for idim=0,s(0)-1 do begin
      idx(idim,*)= r_ mod s(idim+1)
      r_= r_ / s(idim+1)
  endfor
  return, idx
end
