pro comparecdf, filesun, fileint, percentage, stop=stop

  if (n_params() NE 3) then begin
      print, "Usage: comparecdf, 'filesun', 'fileint', percentage"
      stop
  endif


  !p.multi=[0,1,2]
  openw, 1, 'cdfdif.txt'

  cut=percentage/100.0
  printf,1,format=$
    '(A47, F10.5, A1)',$
    "Indices whose values disagree by greater than ",percentage,"%"
  idsun = cdf_open( filesun )
  idint = cdf_open( fileint )

  r     = cdf_inquire( idint )
  nvar  = r.nzvars

;  lastvar=1
  lastvar=nvar-1

  print, "VARIABLE NUMBER   NDIM   NRECORD   NAME"

  for i=0, lastvar do begin
      r1= cdf_varinq( idint, i, /zvar )
      name     = r1.name
      ndimen = r1.dim

      cdf_control, idint, var=i, /zvar, get_var_info=r2      
      nrecord= r2.maxrec
      print, 'Variable '+string(i)+' '+string(ndimen)+string(nrecord)+' '+name

      if (nrecord GT 1) and (cdf_varexist(idsun,name)) then begin
          hyd_cdf_varget, idsun, name, dataa, rec_count=nrecord
          hyd_cdf_varget, idint, name, datab, rec_count=nrecord
          
          if ((max(abs(dataa)) EQ 0) AND (max(abs(datab)) GT 0)) then begin
              diff= dataa-datab
              print, 'Sparc side shows all zeroes, but not the Intel side'
              plot, diff,$
                title='Raw Difference '+name+'      ZVAR #'+string(i)
              plot, diff,$
                title='Raw Difference '+name+'      ZVAR #'+string(i)
              stop
          endif

          if (max(abs(dataa)) GT 0) then begin
              rnonzerostuff=where(dataa NE 0)
              reldiff = (dataa[rnonzerostuff]-datab[rnonzerostuff])/$
                float(dataa[rnonzerostuff])
              rbad=where(abs(reldiff) GT cut)
              diff= float(dataa[rnonzerostuff]-datab[rnonzerostuff])
              if (rbad(0) NE -1) then begin
                  print, $
                    "DISAGREEMENT AT THESE INDICES BY MORE THAN",$
                    percentage,"%: ",rnonzerostuff[rbad]
                  printf,1,format='(/A,/A9,A17,A17)', name,"Index","Relative","Raw Diff."
                  s=size(dataa)
                  for j=0, n_elements(rbad)-1 do begin

                      inds=index1_2_N(rnonzerostuff[rbad[j]],s)
                      if n_elements(inds) le 4 then begin
                          print, format='(a20, 4i8)', $
                            'Disagreement at: ', inds
                      endif else begin
                          print, 'Disagreement at: ', inds
                      endelse

                      printf,1,format='(I9, 2X, G15.7, 2X, G15.7,G15.7,G15.7)',$
                        rnonzerostuff[rbad[j]],$
                        reldiff[rbad[j]],$
                        diff[rbad[j]],$
                        dataa[rnonzerostuff[rbad[j]]],$
                        datab[rnonzerostuff[rbad[j]]]
                  endfor

                  plot, rnonzerostuff, reldiff,$
                    title=name+' Relative Difference   ZVAR #'+string(i)
                  plot, diff, /ynoz, $
                    title=name+' Raw Difference   ZVAR #'+string(i)
                  if keyword_set(stop) then stop
              endif else begin
                  print, '  Variables agree'
              endelse
;          stop
          endif
      endif else begin
          if not cdf_varexist(idsun,name) then begin
              print, 'Variable: ', name, ' does not exist on sparc.'
          endif
      endelse
      
  endfor

  close, 1
  cdf_close, idint
  cdf_close, idsun

end
