function dstat_query_many, var_label, start_date, end_date, var_array
; var_label  - input  dstat variable name
; start_date - input  YYYYMMDD
; end_date   - input  YYYYMMDD
; var_array  - output array

if start_date eq end_date then begin
    message, 'ERROR - You did not request MANY dates.  Use DSTAT_QUERY.'
    return, -1
endif

dstat_access
forward_function dstat_open
cdf=cdf_open( '/opt/hydra/dstatdb/hyd_dstat.cdf' )
rec_start = gen_time(start_date)-1
arr_size  = gen_time(end_date) - rec_start
;print, "Day of Mission = "  , strtrim(rec_start,2),";",$
;    "   Days in Interval = ", strtrim(r_count,2)

hyd_cdf_varget, $
  cdf, $
  var_label, $
  rec_start=rec_start, $
  rec_count=arr_size, $
  var_array
var_array=transpose(var_array)
cdf_close, cdf

;for i=0,r_count-1 do begin
;  print, var_array[i]
;endfor

return, 0
end
