 pro find_version, filelist

  openu, 1, /append, 'cdfversion.txt'
  openr, 2, filelist

  file = string(500)
  dir  = '/net/orange/export/data2/gains_tmp/rg/data/'

  while not eof(2) do begin
     readf, 2, file
     item       = dir+file
     id         = cdf_open( item  )

     structure1 = cdf_inquire( id )
     nvar       = structure1.nzvars
     lastvar    = nvar-1
     
; if cdf_index  = 20 then you are pointing at the rgains_version variable
     cdf_index  = 20
     structure2 = cdf_varinq( id, cdf_index, /zvar )
     name       = structure2.name
     ndimen     = structure2.dim
     
     cdf_control, id, var=cdf_index, /zvar, get_var_info=structure3
     nrecord    = structure3.maxrec
     
;     print, string(cdf_index)+' '+$
;         string(ndimen)+$
;         string(nrecord)+' '+$
;         name

     if (nrecord GT 1) and (cdf_varexist(id,name)) then begin
         hyd_cdf_varget, id, name, dataa, rec_count=nrecord
     endif
     print,     file, "   ", name, "=", dataa(0)
     printf, 1, file, "   ", name, "=", dataa(0)
     cdf_close, id

  end

  close, 1
  close, 2
end
