pro testit
  plotsperpage=2
  set_page, nv=plotsperpage

  spin_period = 6.01263
  time     = findgen(1001)*140.0*spin_period/20000.
  spinphi  = 2*!pi*time/spin_period
  spinfunc = cos(spinphi)

  arb_period = 6.01263/1.6
  arbphi     = 2*!pi*time/arb_period
  arbfunc    = 3*sin(arbphi)

  signal     = spinfunc + arbfunc

  signal_less_spintone = hyd_filter0( $
                   time,$
                   signal,$
                   spin_period,$
                   plot=1,$
                   label='BX',$
                   /verbose)

  plot, time,signal_less_spintone,$
    psym=3,$
    min_val=-1E10,$
    xtitle='TIME',$
    ytitle='SIGNAL LESS SPINTONE'

  end_of_prog
  end



