function m3_define_state_flag, flag=flag
;
;
;   (1) Return a structure containing a bit number for each m3 flag.
;
;       sf=m3_define_state_flag()
;
;   (2) Unpack the state flag itself into a structure of vectors 0 or 1.
;
;       sf=m3_define_state_flag(flag=m3_state_flag)
;
;       sf.tag_name(i): 0: Not set
;                       1: Set
;                      -1: Undefined
;
; block_moment.state_flag=
;  Bits 0-15 are for configuration options:
;
;  Bits 16-23 are for runtime decision options:
;
;  Bits 24-30 are for very high-level configuration options:
;
;  Bit 31 indicates all bits undefined:
;
state_flag={ m3_state_flag1, $
             use_floor:0, $
             use_simpson:1, $
             add_extra_patch_points:2, $
             use_flat_top_patch:3, $
             use_E_trigid:4, $
             use_logf:5, $
             use_jacks_new_e:6, $
             use_patch_uperp_m3:7, $
             use_patch_uperp_bm:8, $
             use_patch_uperp_zero:9, $
             use_patch_uperp_iter:10, $
             use_flat_patch:11, $
             b_proxy_override:16, $
             model:24 $
           }
if not keyword_set(flag) then begin
    return, state_flag
endif else begin

    names=tag_names(state_flag)
    state_flag_values=create_struct(names(0), $
                                    long((flag and 2^state_flag.(0)) ne 0))
    for i=1,n_elements(names)-1 do begin
        r=where((flag and 2L^31) eq 0,nr)
        values=replicate(-1,n_elements(flag))
        if nr gt 0 then values(r)=long((flag(r) and 2L^state_flag.(i)) ne 0)
        state_flag_values=create_struct(temporary(state_flag_values), $
                                        names(i), values)
    endfor
    return, state_flag_values
endelse
end
