function noticks, a1, a2, a3
  return, ''
end

;pro testit_energy, print=print, model=model

;  time_in= '19960529 06:31:42'
;  m3_extract_interpolate, time_in, f, phi, theta, sigma_f, valid, $
;    energy, patch_param, block, time_hsm, model=model
;  if keyword_set(print) then begin
;      set_ps, /landscape, file='testit.ps'
;  endif
  
;  !p.multi= [0,12,12]
;  !x.margin=[0,3]
;  !x.omargin=[10,2]
;  !y.margin=[1,1]
;  !y.omargin=[5,2]
;  xrange=[0,1000]
;  yrange=[1e-34,1e-23]
;  ylog=1
;  for itheta= 0,11 do begin
;      for iphi= 0,11 do begin
;          if ( !p.multi[0] mod !p.multi[1] ) eq 0 then ytickform='' else $
;            ytickform='noticks'
;          if ( !p.multi[0] le !p.multi[1] and !p.multi[0] ne 0) then begin
;              xtickform='' 
;              xtitle='energy'
;          endif else begin
;              xtickform='noticks'
;              xtitle=''
;          endelse
          
;          pplot, energy, f(*,iphi,itheta), $
;            xrange=xrange, yrange=yrange, ylog=ylog, psym=3, $
;            ytickform=ytickform, xtickform=xtickform, xtitle=xtitle, $
;            title= 'ith='+strtrim(itheta,2)+' iphi='+strtrim(iphi,2)
          
;      endfor
;  endfor

;  end_of_prog

;end
  
;pro testit, print=print, model=model
;  time_in= '19960529 06:31:42'
;  m3_extract_interpolate, time_in, f, phi, theta, sigma_f, valid, $
;    energy, patch_param, block, time_hsm, model=model, $
;    floor_f= floor_f, floor_parm_f0=f0, floor_parm_e0=e0

;  if keyword_set(print) then begin
;      set_ps, /landscape, file='testit.ps'
;  endif

;  !p.multi= [0,11,10]
;  !x.margin=[0,3]
;  !x.omargin=[10,2]
;  !y.margin=[1,1]
;  !y.omargin=[5,2]
;  xrange=[0,0]
;  yrange=[1e-34,1e-23]
;  ylog=1
;  for ien= 0,n_elements(energy)-1 do begin
;      if ( !p.multi[0] mod !p.multi[1] ) eq 0 then ytickform='' else $
;        ytickform='noticks'
;      if ( !p.multi[0] le !p.multi[1] and !p.multi[0] ne 0) then begin
;          xtickform='' 
;          xtitle='phi'
;      endif else begin
;          xtickform='noticks'
;          xtitle=''
;      endelse
      
;      pplot, phi(ien,*,*), f(ien,*,*), $
;        title=string(energy[ien],format='(f8.2)'), $
;        xrange=xrange, yrange=yrange, ylog=ylog, psym=3, $
;        ytickform=ytickform, xtickform=xtickform, xtitle=xtitle
;  endfor

;  end_of_prog

;  stop
  
;end


;pro testit_2, print=print, model=model

;  model= keyword_set(model)
  
;  if keyword_set(print) then begin
;      set_ps, /landscape, file='testit_2.ps'
;  endif

;  time_in= '19960529 05:31:42'
;  m3_extract_interpolate, time_in, f, phi, theta, sigma_f, valid, $
;    energy, patch_param, block, time_hsm, $
;    moments, moments_str, moments_patch_param, timetag, $
;    model=model, ms_out=ms, bhat_out=bhat, $
;    floor_f= floor_f, floor_parm_f0=f0, floor_parm_e0=e0
;  energy144= reform( energy # replicate(1,144), 110, 12, 12 )

;  if model then begin
;      species=-1
;      patch_parm= m3_get_patch_parameters( 0, 0, species, model=ms, bhat=bhat  )
;      f_patch= m3_patch_3d( patch_parm, $
;                            energy144, $
;                            phi, $
;                            theta, $
;                            [0,0,0] )
;      r= where( f gt 1d-50 )
;      !p.multi=0
;      plot,  f_patch(r), (f(r)- f_patch(r)) / f_patch(r), psym=3, /xlog, $
;        xtitle='f', ytitle=' ( f_interp - f ) / f '
;  endif
  
;;   check propogation of raw points
;  l1_get_block, 19960529, block, bd, mi 
;  if model then begin
;      l1_model_const_bhat, bd, mi, model_parameters= ms, model_depth=0
;  endif

;;  w= widget_base( /column )
;;  x= widget_draw( w, xsize=640, ysize=480, $
;;                  scr_xsize=640, scr_ysize= 480, y_scroll_size=800, /scroll );  y_scroll_size=8000,
;;  widget_control, /realize, w
;;  widget_control, x, get_value=win
;;  wset, win  
  
;  window, xsize=640, ysize=800
  
;  !p.multi=[0,1,6]

;  for iphi=0,11 do begin      
;      rsw= indgen(16)+([0,16,64,80,128,144,192,208,256,272,320,336])[iphi]
;      if iphi mod 2 eq 1 then rsw= reverse(rsw)
;      for itheta=0,11 do begin
;          plot, -(mi.energy[rsw,itheta mod 2]+bd.sc_potential), bd.f[rsw,itheta], /ylog, $
;            xrange=[0,300], psym=-4 , $
;            title='iphi='+strtrim(iphi,2)+' itheta='+strtrim(itheta,2)
;          oplot, energy144(*,iphi,itheta), f(*,iphi,itheta), psym=1, color=!cs.cyan
;          for irsw= 0,n_elements(rsw)-1 do begin
;              min= min( abs( energy144(*,iphi,itheta)  $
;                             +(mi.energy[rsw[irsw],itheta mod 2]+bd.sc_potential) ), imin )
;              print, itheta, iphi, valid(imin,iphi,itheta), $
;                f(imin,iphi,itheta), bd.f[rsw[irsw],itheta], $
;                f(imin,iphi,itheta) - bd.f[rsw[irsw],itheta], $
;                acos(cos(phi(imin,iphi,itheta))), acos(cos(bd.phi_det(rsw[irsw],itheta))), $
;                acos(cos(phi(imin,iphi,itheta)))-acos(cos(bd.phi_det(rsw[irsw],itheta)))
;              if abs( f(imin,iphi,itheta) - bd.f[rsw[irsw],itheta] ) gt 1e-30 and $
;                f(imin,iphi,itheta) ne -1d31 and $
;                valid(imin,iphi,itheta) eq 3 then begin
;                  dots
;                  oplot, [ energy144(imin,iphi,itheta) ], [bd.f[rsw[irsw],itheta]], psym=8, $
;                    color=!cs.red
;                  stop
;              endif
;          endfor
;      endfor
;  endfor
;  end_of_prog

;end


pro m3_extract_interpolate, time_in, f, phi, theta, sigma_f, valid, $
                            energy, patch_param, block, time_hsm, $
                            moments, moments_str, mom_patch_param, timetag, $
                            model=model, ms_out=ms, bhat_out=bhat, $
                            floor_f=floor_f, floor_parm_f0=floor_f0, $
                            floor_parm_e0=floor_e0, $
                            data=data, date=date, $
                            species= species, status=data_status, $
                            glint_in_valid=glint_in_valid

; -- INPUTS: ----
;+
;pro m3_extract_interpolate, time_in, f, phi, theta, sigma_f, valid, $
;                            energy, patch_param, block, time_hsm, $
;                            moments, moments_str, mom_patch_param, timetag, $
;                            model=model, ms_out=ms, bhat_out=bhat, $
;                            floor_f=floor, floor_f0=floor_f0, floor_e0=floor_e0
; 
; 
;    time_in  is like '19960529 06:31:42', or
;             like 1703 it indicates the block number.
;    date=YYYYMMDD specify date.
;    f, phi, theta, sigma_f,   fltarr(110,12,12)
;
;    valid    =0 invalid, =1 patch, =2 intepolated, =3 raw measurement;   
;    energy   fltarr(110)
;    patch_parm  ttp patch params
;    block     block record number
;    time_hsm  hours since midnight
;    moments   fltarr(10) N Ux Uy Uz Qx Qy Qz Tparl Tperp status 
;    moments_str   strarr(10) identifies moments elements
;    mom_patch_param   fltarr(10)  moments patch
;    timetag   hyd_access timetag for the data
;    bhat_out=  keyword returns the average bhat vector.
;-  
; ---------------

  data_status=0

  if size(time_in,/type) eq 7 then begin
      x= m3_time_to_block( gen_time( time_in ) )
      block=x.block
  endif else begin
      block= time_in
  endelse
  
  if n_elements( model ) eq 0 then model=0

  if n_elements( date ) eq 0 then date= 19960529 

  data= m3_make_data( date, block, model=model, ms_out=ms, bhat_out=bhat, $
                      species= species )
  if (finite(data.sc_pot) eq 0) or hd_is_fill(data.sc_pot) then begin
      data_status=-1
      return
  endif

  bhat= data.bavg_hat

;  define output structure  
  energy1= data.species*data.energy
  s= sort(energy1)
  energy= energy1(uniq(energy1,s)) 
  nen= n_elements(energy)
  
  f= dblarr( nen,12,12 )
  phi= dblarr( nen,12,12 )
  theta= dblarr( nen,12,12 )
  sigma_f= dblarr( nen,12,12 )
  ff= dblarr( nen,12,12 )
  valid= replicate(-1.d0, nen,12,12 )

  patch_param= replicate( !values.f_nan, 10 )
  block= data.block

  nen= n_elements(energy)
  energy144= reform( energy # replicate(1,144), nen, 12, 12 )

;  plug in the raw measurements.
  replace_raw=1
  if replace_raw then begin

      l1_get_block, date, block, bd, mi
      if model then begin
          l1_model_const_bhat, bd, mi, model_parameters= ms, model_depth=0
      endif
      
      if ((finite(bd.sc_potential) eq 0) or $
          hd_is_fill(bd.sc_potential)) then begin
          data_status=-1
          return
      endif

      for iphi=0,11 do begin     
          if species eq -1 then begin
              rsw= indgen(16)+$
                ([0,16,64,80,128,144,192,208,256,272,320,336])[iphi]
          endif else begin
              rsw= indgen(16)+32+$
                ([0,16,64,80,128,144,192,208,256,272,320,336])[iphi]
          endelse
          if iphi mod 2 eq 1 then rsw= reverse(rsw)
          for itheta=0,11 do begin
              for irsw= 0,n_elements(rsw)-1 do begin
                  if mi.nom_energy_index_ref[rsw[irsw]] ne 0 then begin
                      min= min( abs( energy144(*,iphi,itheta)  $
                                     - ( species*((mi.energy[rsw[irsw],$
                                                             itheta mod 2]+$
                                                   bd.sc_potential)) )), imin )
                      if min gt 0.01 then begin
                          message, $
                            'Can''t find this energy in replace_raw', /cont
                          stop
                      endif

                      valid(imin,iphi,itheta)= bd.datamask(rsw(irsw),itheta) *3
                      f(imin,iphi,itheta)= bd.f(rsw(irsw),itheta)
                      sigma_f(imin,iphi,itheta)= bd.sigma_f(rsw(irsw),itheta)
                      phi(imin,iphi,itheta)= bd.phi_det(rsw(irsw),itheta)
                  endif
              endfor
          endfor
      endfor
  end

  if n_elements(glint_in_valid) ne 0 then begin
      rg=where(valid eq 0)
      ru=where(valid eq -1)
      if ru(0) ne -1 then valid(ru)=0
      if rg(0) ne -1 then valid(rg)=glint_in_valid
  endif else begin
      r=where(valid ne 3)
      if r(0) ne -1 then valid(r)=0
  endelse

  if species eq -1 then begin
      theta_species= bd.theta_ele
  endif else begin
      theta_species= bd.theta_ion
  endelse          
  for itheta=0,11 do $
    theta(*,*,itheta)= theta_species(itheta)

;  end, plug in the raw measurements

;  calculate floor values  
  floor_f= make_array( size= size(f) )
  
  r= where( f gt 0. )
  f0= min( f(r), imin )
  e0= energy144(r(imin))

  r= where( energy144 lt e0 )
  if r(0) ne -1 then floor_f(r)= f0/2
  r= where( energy144 ge e0 )
  if r(0) ne -1 then floor_f(r)= f0/2 * (double(e0)/double(energy144(r)))^6
  floor_e0= e0
  floor_f0= f0
;  end, calculate floor values
  
  time_hsm= data.time_range(0) mod 1 * 24.

  hd_make_timetags, timetag, $
    data.time_range(0), data.time_range(1)-data.time_range(0)

  if model then begin
      moments= dblarr(10)
      moments(0)=ms.n
      moments(1:3)=ms.u*[cos(ms.phiu)*sin(ms.thetau), $
                         sin(ms.phiu)*sin(ms.thetau), $
                         cos(ms.thetau)]
      moments(4:6)=[0,0,0]
      moments(7)=hd_convert_units('erg', 'K')*(0.5*9.1d-28*ms.wparl^2)
      moments(8)=hd_convert_units('erg', 'K')*(0.5*9.1d-28*ms.wperp^2)
      moments(9)=-1   
      
;  Patch Unpack taken from m3_get_patch_parameters.
;
;
;
      m_bhat=ms.bhat
      
      m_nan= !values.f_nan
      m_bmag1= m_nan
      
      m_U_mag= ms.U
      
      m_Uz= cos(ms.thetau)*m_U_mag
      m_Ux= sin(ms.thetau)*m_U_mag *cos(ms.phiu)
      m_Uy= sin(ms.thetau)*m_U_mag *sin(ms.phiu)
      
      m_Uparl = total( [m_Ux,m_Uy,m_Uz] * m_bhat )
      
      XI= 1/(ms.wperp)^2
      AA=  1/(ms.wparl)^2 - 1/(ms.wperp)^2
      
      m_a= -( XI + AA * m_bhat(0)^2 )
      m_b= -( XI + AA * m_bhat(1)^2 )
      m_c= -( XI + AA * m_bhat(2)^2 )
      m_d= -2 * AA * m_bhat(0) * m_bhat(1)
      m_e= -2 * AA * m_bhat(0) * m_bhat(2)
      m_f= -2 * AA * m_bhat(1) * m_bhat(2)
      m_g= -( 2*m_a * m_Ux +    m_d * m_Uy +   m_e*m_Uz )
      m_h= -(   m_d * m_Ux + 2 *m_b * m_Uy +   m_f*m_Uz )
      m_i= -(   m_e * m_Ux +    m_f * m_Uy + 2*m_c*m_Uz )
      
      CC= alog( (ms.n)/(!pi^(3/2.)*(ms.wparl)*(ms.wperp)^2 ) ) $
        - m_U_mag^2 * XI - AA * ( m_Uparl^2 + $
                                  2*m_Ux*m_Uy*m_bhat(0)*m_bhat(1) + $
                                  2*m_Ux*m_Uz*m_bhat(0)*m_bhat(2) + $
                                  2*m_Uy*m_Uz*m_bhat(1)*m_bhat(2) )
      
      mom_patch_param = [ CC, m_g, m_h, m_i, m_a, m_b, m_c, m_d, m_e, m_f ]
      
  endif else begin

      common m3_extract_interpolate_comm, timetags, indexes, ns, us, qs, $
        tparls, tperps, statuss, mom_patch_params

      if not keyword_set(timetags) then begin

          hyd_access, timetags, 'ele_n', Ns, get_timetags=gen_time(date)+[0,1]
          hyd_access, timetags, 'ele_v', Us
          hyd_access, timetags, 'ele_q', Qs
          hyd_access, timetags, 'ele_tparl', Tparls
          hyd_access, timetags, 'ele_tperp', Tperps
          hyd_access, timetags, 'ele_status', statuss
          hyd_access, timetags, 'ele_mom_patch_param', mom_patch_params
          indexes=dindgen(n_elements(timetags))
      endif
      r=hd_synchronize_nearest_neighbor(timetag, timetags, indexes)
      if not hd_is_fill(r[0]) then begin
          n=ns[r]
          U=Us[r,*]
          Q=Qs[r,*]
          Tparl=Tparls[r]
          Tperp=Tperps[r]
          status=statuss[r]
          mom_patch_param=mom_patch_params[r,*]
      endif else begin
          n=-1e31
          U=replicate(-1e31,3)
          Q=replicate(-1e31,3)
          Tparl=-1e31
          Tperp=-1e31
          status=-1
          mom_patch_param=replicate(-1e31,n_elements(mom_patch_params[0,*]))
      endelse
      mom_patch_param= reform( mom_patch_param )
      moments= [ N, U(*), Q(*), Tparl, Tperp, status ]
  endelse
  
  moments_str= [ 'N', 'Ux', 'Uy', 'Uz', 'Qx', 'Qy', 'Qz', 'Tparl', 'Tperp', 'status' ]

end
