function m3_f_model, energy_in, phi_in, theta_in, ms
;
;   Return f(Energy,alpha) for the model_parameters (ms)
;
;   energy_in in eV
;   phi_in, theta_in in radians
;
;   For vectors energy and angle (matching up point-by-point),
;   the result is a vector.
;
;
me = 9.11d-28                   ;                  in g

bhat=ms.bhat
ehatperp1=crossp([0,0,1],bhat)
m1=sqrt(total(ehatperp1^2))
if m1 ne 0 then begin
    ehatperp1=ehatperp1/m1
endif else begin
    ehatperp1=crossp([0,1,0],bhat)
    ehatperp1=ehatperp1/sqrt(total(ehatperp1^2))
endelse
ehatperp2=crossp(bhat,ehatperp1)

if ms.U ne 0 then message, 'Not coded for bulk speed.'

ux=ms.U*sin(ms.thetau)*cos(ms.phiu)
uy=ms.U*sin(ms.thetau)*sin(ms.phiu)
uz=ms.U*cos(ms.thetau)

uparl=ux*bhat(0)+uy*bhat(1)+uz*bhat(2)
uperp1=ux*ehatperp1(0)+uy*ehatperp1(1)+uz*ehatperp1(2)
uperp2=ux*ehatperp2(0)+uy*ehatperp2(1)+uz*ehatperp2(2)

v=sqrt(2*energy_in*1.6d-12/me)  ; cgs
vx=v*sin(theta_in)*cos(phi_in)
vy=v*sin(theta_in)*sin(phi_in)
vz=v*cos(theta_in)

vparl=vx*bhat(0)+vy*bhat(1)+vz*bhat(2)
vperp1=vx*ehatperp1(0)+vy*ehatperp1(1)+vz*ehatperp1(2)
vperp2=vx*ehatperp2(0)+vy*ehatperp2(1)+vz*ehatperp2(2)

wparl=ms.wparl                  ; cgs
wperp=ms.wperp                  ; cgs

density=ms.n                    ;                 in cm^-3

const=double(density)/(!pi^1.5*wparl*wperp^2)
;
exp_minus=((vparl-uparl)/wparl)^2+ $
  ((vperp1-uperp1)/wperp)^2+((vperp2-uperp2)/wperp)^2
lnf=alog(const)-exp_minus
f= exp(lnf)

return, f
end
