function m3_fill_hole, xin, xlimits
;
;   Fill Holes (given by fill) in array xin using limits xlimits
;
;   xlimits=[x_low,x_high]
;
;   N.B.
;        The filled-in points do not handle wrapping around properly.
;        There is a double gap at the limits.
;
   x=xin
   r=where(x gt -1e30,nr)
   if nr eq 0 then begin
       n=n_elements(x)
       return, xlimits(0)+(xlimits(1)-xlimits(0))*findgen(n)/float(n)
   endif else begin
       xex=x(r(sort(x(r))))
       holes=[xex,xlimits(1)]-[xlimits(0),xex]
       n=n_elements(x)-nr

       dx=total(holes)/float(n+n_elements(holes))
       nholes=(holes/dx-1)
       i=0
       extra=0.0
       while i lt n_elements(nholes) do begin
           dn=nholes(i)-floor(nholes(i))
           if dn ge 0.5 or nholes(i) lt 0 then begin
               extra=extra-(1-dn)
               nholes(i)=ceil(nholes(i))
           endif else begin
               extra=extra+dn
               nholes(i)=floor(nholes(i))
           endelse
           i=i+1
       endwhile
       nholes=long(nholes+0.5)
       r=where(nholes lt 0)
       if r(0) ne -1 then nholes(r)=0
       nh=total(nholes)
       if nh lt n then begin
           nholes(0)=nholes(0)+(n-nh)
       endif else if total(nholes) gt n then begin
           s=sort(nholes)
           r=where(nholes(s) gt 0,nr)
           is=0
           while total(nholes) gt n and is lt nr do begin
               nholes(s(r(is)))=nholes(s(r(is)))-1
               is=is+1
               if is eq nr then begin
                   r=where(nholes(s) gt 0,nr)
                   is=0
               endif
           endwhile
       endif
       rr=where(x lt -1e30)
       ir=0
       for i=0, n_elements(nholes)-1 do begin
           if nholes(i) gt 0 then begin
               x(rr(ir:ir+nholes(i)-1))=([xlimits(0),xex])(i)+$
                 (findgen(nholes(i))+1)*holes(i)/(nholes(i)+1)
               ir=ir+nholes(i)
           endif
       endfor
   endelse
   return, x
end


