function m3_get_data, block, date=date

  if n_elements( date ) eq 0 then date= 19960529
; -- input section --
  block= 1359
  species= 'electrons'  ; 'ions' not implemented
; -------------------

  electrons= species eq 'electrons'

  if not electrons then begin
      message, 'ions not implemented'
  endif

  l1_get_block, date, block, bd, mi

  if electrons then begin
      r= where( mi.nom_energy_index_ref lt 0 )
  endif

  b_phi= bd.phib(r) # replicate(1.,12)
  b_theta= bd.thetab(r) # replicate(1.,12)
  b_mag= bd.magb(r) # replicate(1.,12)
  b_valid= bd.bvalid(r) # replicate(1,12)

  f= bd.f(r,*)
  if electrons then begin
      f_theta= replicate(1,n_elements(r)) # bd.theta_ele
  endif
      
  f_phi= bd.phi_det(r,*)

  f_energy_box= abs(mi.energy(r,*))
  f_energy= f_energy_box(*,mi.box)
  f_energy_sigma_box= mi.energy_sigma(r,*)
  f_energy_sigma= f_energy_sigma_box(*,mi.box) 

  sigma_f= bd.sigma_f(r,*)
  glint_mask= bd.datamask(r,*)

  mask= glint_mask * b_valid

; -- at this point, the following are defined ----
;  b_phi       phi of bfield in fixed payload
;  b_theta
;  b_mag
;  b_valid     bfield data is valid if b_valid=1
;
;  f                     f in cgs     
;  f_theta               theta of detector in fixed payload
;  f_phi                 
;  f_energy              measurement energy in eV
;  f_energy_sigma        error in this energy
;  sigma_f               error in f
;  glint_mask            glint_mask=1 if data is valid
; 
;  mask                  mask is 1 if glint_mask=1 and b_valid=1
; -------------------------------------------------
  help, b_phi, b_theta, b_mag, b_valid, f, f_theta, f_phi, f_energy, $
    f_energy_sigma, sigma_f, glint_mask, mask 


  data= { b_phi:b_phi, $
          b_theta:b_theta, $
          b_mag:b_mag, $
          b_valid:b_valid, $
          f:f, $
          f_theta:f_theta, $
          f_phi:f_phi, $
          f_energy:f_energy, $
          f_energy_sigma:f_energy_sigma, $
          sigma_f:sigma_f, $
          glint_mask:glint_mask, $
          mask:mask }
  
  return, data

end

