function m3_get_patch_parameters, date, patch_time, species, model=model, $
                                  bhat=bhat
  
  sweeps=2
  sp= (['ele','ion'])((species+1)/2)
  
  if keyword_set(model) then begin
      s= size(model)
      if (s(n_elements(s)-2)) eq 8 then ms=model else $
        ms= l1_get_model_parameters()
      
      bhat= ms.bhat 

      nan= !values.f_nan
      bmag1= nan
      wprlsq_kmpers1= nan
      wprpsq_kmpers1= nan
      density_pchfit1= nan
      uprl_pchfit1= nan
      uprp_pchfit1= nan

      u_mag= ms.U/1e5
      
      uz= cos(ms.thetau)*u_mag
      ux= sin(ms.thetau)*u_mag *cos(ms.phiu)
      uy= sin(ms.thetau)*u_mag *sin(ms.phiu)

      uparl = total( [ux,uy,uz] * bhat ) / 1e5 

      XI= 1/(ms.wperp/1e5)^2
      AA=  1/(ms.wparl/1e5)^2 - 1/(ms.wperp/1e5)^2

;      wx= ms.wperp / 1e5
;      wy= ms.wperp / 1e5
;      wz= ms.wparl / 1e5      

      a= -( XI + AA * bhat(0)^2 )
      b= -( XI + AA * bhat(1)^2 )
      c= -( XI + AA * bhat(2)^2 )
      d= -2 * AA * bhat(0) * bhat(1)
      e= -2 * AA * bhat(0) * bhat(2)
      f= -2 * AA * bhat(1) * bhat(2)
      g= -( 2* a * ux + d * Uy + e*Uz )
      h= -( d * ux + 2 *b * Uy + f*Uz )
      i= -( e * ux + f * Uy + 2*c*Uz )
      
      CC= alog( (ms.n*1e15)/(!pi^(3/2.)*(ms.wparl/1e5)*(ms.wperp/1e5)^2 ) ) $
        - U_mag^2 * XI - AA * ( uparl^2 + 2*ux*uy*bhat(0)*bhat(1) + $
                                2*ux*uz*bhat(0)*bhat(2) + $
                                2*uy*uz*bhat(1)*bhat(2) )

      fc= [ CC, g, h, i, a, b, c, d, e, f ]
      fit_status=0
      
  endif else begin
      common fpitch_patch_common_0, date0, sp0, $
        time, fit_status1, fit_coef, min_nrg, bhat1, bmag, bstat, $
        wprlsq_kmpers,wprpsq_kmpers,density_pchfit,uprl_pchfit,uprp_pchfit,$
        length_unit
      if n_elements( date0 ) eq 0 then read=1 else begin
          if date0 ne date and sp eq sp0 then read=1 else read=0
      endelse
      if read eq 1 then begin
          get_anfitmom_cdfdata_access,date,'spf_'+sp+'_time_patch_2',time
          get_anfitmom_cdfdata_access,date,'spf_'+sp+$
            '_fit_status_patch_2',fit_status1
          get_anfitmom_cdfdata_access,date,'spf_'+sp+'_fit_coef_patch_2',$
            fit_coef
          get_anfitmom_cdfdata_access,date,'spf_'+sp+'_bprime_patch_2',$
            wprlsq_kmpers
          get_anfitmom_cdfdata_access,date,'spf_'+sp+'_cprime_patch_2',$
            wprpsq_kmpers
          get_anfitmom_cdfdata_access,date,'spf_'+sp+'_density_patch_2',$
            density_pchfit
          get_anfitmom_cdfdata_access,date,'spf_'+sp+'_uparl_patch_2',$
            uprl_pchfit
          get_anfitmom_cdfdata_access,date,'spf_'+sp+'_uperp_patch_2',$
            uprp_pchfit
          get_anfitmom_cdfdata_access,date,'spf_'+sp+'_min_energy_patch_2',$
            min_nrg
          get_anfitmom_cdfdata_access,date,'spf_'+sp+'_bhat_patch_2',bhat1
          get_anfitmom_cdfdata_access,date,'spf_'+sp+'_bmag_patch_2',bmag
          get_anfitmom_cdfdata_access,date,'spf_'+sp+'_b_status_patch_2',bstat
          get_anfitmom_cdfdata_access,date,$
            'spf_'+sp+'_fit_coef_length_string',length_unit
          date0=date
          sp0=sp
      endif  
      x= min( abs(patch_time-time), imin )
      fc= fit_coef(imin,*)
      
      bhat= bhat1(imin,*)
      bmag1=bmag(imin)
      fit_status= fit_status1(imin)
      wprlsq_kmpers1=wprlsq_kmpers(imin)
      wprpsq_kmpers1=wprpsq_kmpers(imin)
      density_pchfit1=density_pchfit(imin)
      uprl_pchfit1=uprl_pchfit(imin)
      uprp_pchfit1=uprp_pchfit(imin,*)

  endelse

  patch_struct= { fc:fc, $
                  bhat:reform(bhat), $
                  bmag:bmag1, $
                  fit_status:fit_status, $
                  wprlsq_kmps:wprlsq_kmpers1, $
                  wprpsq_kmps:wprpsq_kmpers1, $
                  density_pchfit:density_pchfit1, $
                  uprl_pchfit:uprl_pchfit1, $
                  uprp_pchfit:uprp_pchfit1 $
                }

  return, patch_struct
end
