function m3_angle_interpolate, A, ii
;a1= A(floor(ii))
;a2= A(ceil(ii))
  a1= A(floor(ii)) mod (2*!pi)
  a2= A(ceil(ii)) mod (2*!pi)
  r= where( (a1-a2) gt !pi )
  if r(0) ne -1 then a1(r)=a1(r)-(2*!pi)
  r= where((a2-a1) gt !pi )
  if r(0) ne -1 then a2(r)=a2(r)-(2*!pi)
  alpha2= (ii-floor(ii))
  alpha1= 1-alpha2
  result= a1 * alpha1 + a2 * alpha2
  return, result
end

function m3_pitch_interpolate, phi_det, theta_det, B, ff_time
  phi_det_interp= angle_interpolate( phi_det, ff_time )
  theta_det_interp= angle_interpolate( theta_det, ff_time )
  sin_theta= sin( theta_det_interp )
  vxhat_interp= sin_theta * cos( phi_det_interp )
  vyhat_interp= sin_theta * sin( phi_det_interp )
  vzhat_interp= cos( theta_det_interp )
  bx_interp= interpolate( B(*,0), ff_time )
  by_interp= interpolate( B(*,1), ff_time )
  bz_interp= interpolate( B(*,2), ff_time )
  bmag_interp= sqrt( bx_interp^2 + by_interp^2 + bz_interp^2 )
  pitch_interp= acos( ( bx_interp * vxhat_interp + $
                        by_interp * vyhat_interp + $
                        bz_interp * vzhat_interp ) / ( bmag_interp ) )
  return, pitch_interp
end

function m3_interpolate, data, perfect=perfect, model=ms, $
                         patch_uperp=patch_uperp
  
  nsweep= 144
  
  energy= abs(data.energy)
  s= sort(energy) 
  
  energy_shells= energy(uniq(energy,s)) 
  

  v_mag= hd_magnitude( data.v )
  
  pitch= acos( ( data.bhat(*,0) * data.v(*,0) + $
                 data.bhat(*,1) * data.v(*,1) + $
                 data.bhat(*,2) * data.v(*,2) ) / v_mag )

;  put floor under all the data to avoid the ZERO problem
  r= where( data.f gt 0. )
  f0= min( data.f(r), imin )
  e0= energy(r(imin))
  floor_struct= { f0:f0, e0:e0 }

  f= data.f

  add_floor=1
  if add_floor then begin
      r= where( energy lt e0 )
      if r(0) ne -1 then f(r)= f(r) + (f0/2)
      r= where( energy ge e0 )
      if r(0) ne -1 then f(r)= f(r) + (f0/2) * (double(e0)/double(energy(r)))^6
  endif else begin
      floor_struct.f0=0.
  endelse
;  end, put floor under all the data

  
  nen= n_elements(energy_shells)

  sweep_struct= { log_f:replicate(-1d31,nsweep,nen), $
                  sigma_f:replicate(-1d31,nsweep,nen), $
                  phi:replicate(-1e31,nsweep,nen), $
                  theta:replicate(-1e31,nsweep,nen), $
                  valid:intarr(nsweep,nen), $
                  ff: fltarr(nsweep, nen) }

  isweep= data.detector * nsweep + data.sweep

  u= uniq( isweep )

  phi_det1= atan( data.v(*,1), data.v(*,0) )
  theta_det1= acos( data.v(*,2) / v_mag )

  f_interp= dblarr( n_elements( energy_shells ) )

  patch_en= min( energy )

  if data.B(0) gt -1e30 then begin
      bhat= data.B / ( sqrt( total(data.B^2) ) )
  endif else bhat= [1,1,1]*(-1e31)

  if data.model eq 1 then begin
      patch_parm= m3_get_patch_parameters( '19960529', $
                                           (data.time_range(0)+$
                                            data.time_range(1))/2 mod 1 * $
                                           86400,$
                                           data.species, model=ms, $
                                           bhat= bhat )
  endif else begin
      patch_parm= m3_get_patch_parameters( '19960529', $
                                           (data.time_range(0)+$
                                            data.time_range(1))/2 mod 1 * $
                                           86400,$
                                           data.species, model=0, $
                                           bhat= bhat )
  endelse

  if keyword_set(perfect) then begin
      u_mag= ms.u / 1e5
      uz= cos(ms.thetau)*u_mag
      ux= sin(ms.thetau)*u_mag *cos(ms.phiu)
      uy= sin(ms.thetau)*u_mag *sin(ms.phiu)
      
      uparl= ( ( ux*ms.bhat(0) + uy*ms.bhat(1) + uz*ms.bhat(2) ) * ms.bhat )
      patch_uperp= [ux-uparl(0),uy-uparl(1),uz-uparl(2)]
  endif
  

  for i=0,n_elements(u)-1 do begin
      isw= isweep(u(i))
      r= where( isweep eq isw )
      
      log_f= alog10(f(r))
      sigma_f= data.sigma_f(r)
      valid= data.valid(r)
      
      pitch1= pitch(r)
      energy1= energy(r)
      
      phi_det= phi_det1(r)
      theta_det= theta_det1(r)
      
      bvalid= data.b_valid(r)
      bhat= data.bhat(r,*)
      B= bhat * ( data.bmag(r) # replicate(1,3) )

      sign= energy1(n_elements(r)-1) - energy1(0)
      
;           #obs_1#
      
;      filter out non-monotonic points
      r1= where( ( energy1(1:*)-energy1(0:*) ) * sign lt 0. )
      if r1(0) eq -1 then begin
          ss1=[0]
          ss2=[n_elements(energy1)-1]
      endif else begin
          ss1=[0,r1+1]
          ss2=[r1,n_elements(energy1)-1]
      endelse

      sweep_struct.theta(i,*)= theta_det(0)
                
      for ii= n_elements(ss1)-1,0,-1 do begin
          s1=ss1(ii) & s2=ss2(ii)          

          if s2 gt s1 then begin

              ff= hyd_findex( energy1(s1:s2), energy_shells )
              ff_time= hyd_findex( alog10(energy1(s1:s2)), alog10(energy_shells) )

              ri= where( ff ge 0 and $
                         ff le (s2-s1) )
              ri_phi= ri
              phi_interp= m3_angle_interpolate( phi_det(s1:s2),ff_time(ri) )
              sweep_struct.phi(i,ri)= phi_interp
;              plot, phi_det(s1:s2), psym=4, xrange=[0,20], yrange=[-!pi,!pi]
;              oplot, ff_time(ri), phi_interp, psym=3 

              ri= where( ff ge 0 and $
                         ff le (s2-s1) and $
                         valid(s1+floor(ff)) and $
                         valid(s1+ceil(ff)) and $
                         bvalid(s1+floor(ff)) and $
                         bvalid(s1+ceil(ff)) )
              if ri(0) ne -1 then begin
                  if keyword_set(perfect) then begin
                      pitch_interp= $
                        acos(interpolate( cos(pitch1(s1:s2)),ff_time(ri)) )                  
                      log_f_interp= $
                        alog10( m3_patch( patch_parm, energy_shells(ri), $
                                          pitch_interp, patch_uperp, $
                                          floor_struct ) )
                      sigma_f_interp= interpolate( sigma_f(s1:s2), ff(ri) )
                  endif else begin
                      log_f_interp= interpolate( log_f(s1:s2), ff(ri) )
                      sigma_f_interp= interpolate( sigma_f(s1:s2), ff(ri) )
                  endelse
                  
                  sweep_struct.log_f(i,ri)= log_f_interp
                  sweep_struct.sigma_f(i,ri)= sigma_f_interp
                  sweep_struct.valid(i,ri)= 2
                  sweep_struct.ff(i,ri)= ff(ri)          

                  plot, phi_det, log_f, psym=4 
                  r= where( valid eq 0 )
                  if r(0) ne -1 then $
                    oplot, phi_det(r), log_f(r), psym=7, color=!cs.red
                  oplot, sweep_struct.phi(i,ri), $
                    sweep_struct.log_f(i,ri), psym=3 
                  wait, 0.3

              endif
          endif
      endfor                    ; ii
  endfor

;  add patch points
;  r= where( energy_shells lt patch_en )
;  if r(0) ne -1 then begin
;      pitch= ( (findgen(nsweep)+0.5) / nsweep ) * !pi
;      pitchM= pitch # replicate( 1, n_elements(r) )
;      energyM= replicate(1,nsweep) # energy_shells(r)
;      f_patch= su_patch( patch_parm, energyM, pitchM, patch_uperp, $
;                         floor_struct )
;;      f2= f_model( energyM, pitchM, mp )
;;      f_patch_log= su_patch( patch_parm, energyM, pitchM, patch_uperp, /logf )
;;      f2_log= f_model( energyM, pitchM, mp, /logf )
;      sweep_struct.a(*,r)= pitchM 
;      sweep_struct.log_f(*,r)= alog10(f_patch)
;      sweep_struct.sigma_f(*,r)= 0.
;      sweep_struct.valid(*,r)= 1
;  endif

  r= where( finite( sweep_struct.log_f ) eq 0 )
  if r(0) ne -1 then begin
      sweep_struct.log_f(r)= -1e31
      sweep_struct.sigma_f(r)= -1e31
  endif
  
  sm_struct= { floor_struct:floor_struct, $
               form2:sweep_struct, $
               time_range:[0.d,0.d], $
               energy_avg:energy_shells, $
               block_num:data.block, $
               isub:data.isub, $
               uperp:replicate(-1e31,3), $
               bhat_avg:data.bhat_avg, $
               b_avg:data.b, $
               patch_fc:patch_parm.fc, $
               patch_fit_status:patch_parm.fit_status, $
               patch_bhat:patch_parm.bhat, $
               patch_bmag:patch_parm.bmag, $
               patch_wprlsq_kmps:patch_parm.wprlsq_kmps, $
               patch_wprpsq_kmps:patch_parm.wprpsq_kmps, $
               patch_density_pchfit:patch_parm.density_pchfit, $
               patch_uprl_pchfit:patch_parm.uprl_pchfit, $
               patch_uprp_pchfit:patch_parm.uprp_pchfit }

  return, sm_struct
end


;   #obs 1#
;      tie down to patch points
;      if ( min(energy1)/patch_en ) lt 10^0.4 then begin
;          if sign gt 0 then begin
;              f_patch= m3_patch( patch_parm, patch_en, pitch1(0), patch_uperp,$
;                                 floor_struct )
;              log_f= [ alog10(f_patch), log_f ]
;              sigma_f= [ 0., sigma_f ]
;              energy1= [ patch_en, energy1 ]
;              pitch1= [ pitch1(0), pitch1 ]
;              bvalid= [ 1, bvalid ]
;          endif else begin
;              n= n_elements(pitch1)
;              f_patch= m3_patch(patch_parm, patch_en, pitch1(n-1),patch_uperp,$
;                                floor_struct )
;              log_f= [ log_f, alog10(f_patch) ]
;              sigma_f= [ sigma_f, 0. ]
;              energy1= [ energy1, patch_en ]
;              pitch1= [ pitch1, pitch1(n-1) ]
;              bvalid= [ bvalid, 1 ]  
;          endelse
;      endif
;   #obs 1#
