function m3_make_data, date, iblock, model=model, ms_out=ms, bhat_out=bhat, $
                       species= species
  
  data_cache= '/opt/hydra/moment_code/3d/data/'

  if species eq 1 then sp='ion' else sp='ele'

  f= findfile( data_cache+'data_'+strtrim(date,2)+$
               '_'+string(iblock,format='(i4.4)')+$
               '_'+sp+'.idlsav', count=count )
  if keyword_set( model ) then count=0

  if count eq 1 then begin
      restore, f(0), /verbose
  endif else begin
      l1_get_block, date, iblock, bd, mi
      
      if keyword_set( model ) then begin
          bhat= bd.b_avg / sqrt(total(bd.b_avg^2))
          ms= l1_get_model_parameters( bhat )
          l1_model_const_bhat, bd, mi, model_depth=0, model_parameters= ms
      endif
      
      data= m3_form_data( bd, mi, isub=0, nsub=1, species=species )
      
  endelse

  return, data
  
end
