function m3_patch, patch_parm, energy, pitch, uperp_correct, logf=logf1, $
                   floor_struct
 
  v_mag=sqrt(2*1.6e-19*energy/9.11e-31) ; meters/s
  v_mag=v_mag*1.0e-3            ;km/s
  
  v_parl= ( v_mag * cos(pitch) )(*)
  v_perp= ( v_mag * sin(pitch) )(*)
  
  bhat= patch_parm.bhat  
  x= min( bhat, imin )
  case imin of
      0: bhat_perp= [ 0, bhat(2), -bhat(1) ]
      1: bhat_perp= [ bhat(2), 0, -bhat(0) ]
      2: bhat_perp= [ bhat(1), -bhat(0), 0 ]
  endcase
  bhat_perp= bhat_perp / sqrt( total( bhat_perp^2) )  
;  R_inv rows, columns for hd_mvmult
  R_inv= [ [ crossp( bhat_perp, bhat ) ], $
           [ bhat_perp ], $
           [ bhat ] ]
  
  V_omega_prime= [ [v_perp], [v_perp*0], [v_parl] ] 
  
  V_omega= hd_mvmult( R_inv, V_omega_prime ) 
  
  v_vec_x= V_omega(*,0) + uperp_correct(0)/1e5 ; check the sign
  v_vec_y= V_omega(*,1) + uperp_correct(1)/1e5
  v_vec_z= V_omega(*,2) + uperp_correct(2)/1e5
  
  if patch_parm.fit_status eq 0 then begin
      fc= patch_parm.fc
      lnf_mks=fc(1)*v_vec_x+fc(2)*v_vec_y+fc(3)*v_vec_z+$
        fc(4)*v_vec_x^2+fc(5)*v_vec_y^2+fc(6)*v_vec_z^2+$
        fc(7)*v_vec_x*v_vec_y+fc(8)*v_vec_x*v_vec_z+$
        fc(9)*v_vec_y*v_vec_z
      if keyword_set(logf1)  then begin
          f= ( ( fc(0)+ lnf_mks ) * alog10(exp(1)) - 30)
      endif else begin
          f= ( exp(fc(0)) * exp( lnf_mks ) ) / 1e30
      endelse
  endif else begin
      message, 'fit_status ne 0! flat_patch not implemented!', /cont
      f= make_array( value= !values.f_nan, n_elements(v_vec_x) )
      return, f
  endelse

  r= where( energy lt floor_struct.e0 )
  if r(0) ne -1 then f(r)= f(r)+(floor_struct.f0/2)
  r= where( energy ge floor_struct.e0 )
  if r(0) ne -1 then f(r)= f(r) + $
    (floor_struct.f0/2) * (double(floor_struct.e0)/double(energy(r)))^6

  return, f
end
  
  
