function m3_reform_data, di

  phi= di.form2.phi
  theta= di.form2.theta
  sigma_f= di.form2.sigma_f
  valid= di.form2.valid
  energy= di.energy_avg
  ff= di.form2.ff
  
  if di.floor_struct.f0 ne 0. then begin  ; remove floor function
      r= where( di.form2.log_f gt -1d31, nr ) ;  used for interpolation.     
      f= make_array( value=-1d31, size=size(di.form2.log_f) )
      e0= di.floor_struct.e0
      f0= di.floor_struct.f0
      if nr gt 0 then begin
          f(r)= 10^di.form2.log_f(r)
          r= where( energy lt e0 )
          if r(0) ne -1 then f(*,r)= f(*,r) - (f0/2)
          r= where( energy ge e0 )
          if r(0) ne -1 then begin
              for isweep=0,n_elements(f(*,0))-1 do $
                f(isweep,r)= f(isweep,r) - $
                (f0/2)*(double(e0)/double(energy(r)))^6
          endif
      endif
      
  endif

  nen= n_elements(energy)

  f= reform(transpose(f),nen,12,12)
  phi= reform(transpose(phi),nen,12,12)
  theta= reform(transpose(theta),nen,12,12)
  sigma_f= reform(transpose(sigma_f),nen,12,12)
  ff= reform( transpose(ff),nen,12,12 )
  valid= reform(transpose(valid),nen,12,12)
  
  r= where( valid gt 0 )
  if r(0) ne -1 then begin
      r2= where( ff(r) mod 1 lt 0.00001 or ff(r) mod 1 gt 0.99999 ) 
                                ; original points
      if r2(0) ne -1 then valid(r(r2))= 3
  endif
  result= { f:f, $
            phi:phi, $
            theta:theta, $
            sigma_f:sigma_f, $
            valid:valid, $
            energy:energy $
          }
  
  return, result

end
  

