function sm_flat_top_patch, patch_parm, energy, pitch, $
                            floor_struct=floor_struct, $
                            species= species

;  return f at given energy and pitch angle.
  if n_elements(species) eq 0 then species=-1
  
  if species eq -1 then begin
      mass= 9.11d-28
  endif else begin
      mass= 1.67d-24
  endelse

  v_mag=sqrt(2*1.6e-19*energy/(mass/1000)) ; meters/s
  v_mag=v_mag*1.0e2
  
  vparl= ( v_mag * cos(pitch) )(*)
  vperp= ( v_mag * sin(pitch) )(*)
  
  v_mag2= v_mag^2
  
  vparl2= vparl^2
  vperp2= vperp^2


  renormalize=patch_parm.renormalize
  if keyword_set(renormalize) then begin

      vperp2= vperp2/renormalize^2
      vparl= vparl/renormalize
      vparl2= vparl^2

  endif


  b_best= patch_parm.b
  nbest= patch_parm.n

  logf= b_best(0)+$
    b_best(1)*vperp2^nbest+$
    b_best(2)*vparl2^nbest+$
    b_best(3)*nbest*vparl*vparl2^(nbest-1.0)
  
  f= 10^logf

  if n_elements( floor_struct ) ne 0 then begin
      r= where( energy lt floor_struct.e0 )
      if r(0) ne -1 then f(r)= f(r)+(floor_struct.f0/2)
      r= where( energy ge floor_struct.e0 )
      if r(0) ne -1 then f(r)= f(r) + $
        (floor_struct.f0/2) * (double(floor_struct.e0)/double(energy(r)))^6
  endif

  return, f

end
