function sm_get_flat_top_patch_parameters, data, species=species, $
                                           ion_flat_patch=ion_flat_patch, $
                                           status=status
;   fit data to a flat top patch.  Flat top patch is
;   defined in the U-perp corrected frame, so be sure the
;   data is corrected before passing it in.
;   species=-1 (electrons) by default.
;
;   If ion_flat_patch is used, then the selected data is just averaged.
;
;
fill=-1e31

  status=0
  if hd_is_fill(data.kt_parl) then begin
      patch_parm= { b:dblarr(4), $
                    n:float(-1.0), $
                    bhat:data.bavg_hat, $
                    rchi2:float(-1), $
                    renormalize:double(-1)}
      status=-1
      return, patch_parm
  endif

  verbose=0
  renormalize=1.d8

;  print, systime()

  if n_elements(species) eq 0 then species=-1

  if species eq -1 then begin
      mass= 9.11d-28
  endif else begin
      mass= 1.67d-24
  endelse

  v_mag= hd_magnitude( data.v )
  energy= 0.5 * mass * v_mag^2 / 1.6e-19 / 1d7
  
  T= data.kt_parl * 8.61698e-05

  r= where( energy lt T*3 and $
            data.valid eq 1 and $
            data.f gt 0., ndata )


  if species eq 1 and keyword_set(ion_flat_patch) then begin
      factor=4
      while (ndata eq 0) and (factor lt 10) do begin
          factor=factor+1
          r= where( energy lt T*factor and $
                    data.valid eq 1 and $
                    data.f gt 0., ndata )
      endwhile
      if ndata gt 0 then begin
          g= alog10( data.f(r) )
          sigma_g= data.sigma_f(r) / data.f(r) 
          b=total(g)/ndata
          rchi2=total(((g-b)/sigma_g)^2,/double)/ndata
          sigma_b=0
      
          b= [b,0,0,0]
          sigma_b= [sigma_b,0,0,0]
          patch_parm= { b:b, $
                        n:float(0.0), $
                        bhat:data.bavg_hat, $
                        rchi2:float(-1), $
                        renormalize:renormalize}
      endif else begin
          patch_parm= { b:dblarr(4), $
                        n:float(0.0), $
                        bhat:data.bavg_hat, $
                        rchi2:float(-1), $
                        renormalize:double(-1)}
          status=-1
      endelse 
      return, patch_parm
  endif

  wparl= total( data.v(r,*) * data.bhat(r,*), 2, /double )
  wperp_2= total( data.v(r,*)^2, 2, /double ) - wparl^2
  vparl= wparl ;?????check on this?????

  if keyword_set(renormalize) then begin
      wperp_2= wperp_2/renormalize^2
      vparl= vparl/renormalize
  endif

  g= alog10( data.f(r) )
  sigma_g= data.sigma_f(r) / data.f(r) 

  nns=1000

  nfits=1+findgen(nns)/float(nns-1)*2

  chi_max=1.0e31

  chi_array= replicate(chi_max,nns)

  bsave=replicate(fill,4)
  nbest=-1.0

  
  jkl=0
  repeat begin

      ntri=nfits(jkl)
      ndata=n_elements(g)
      f_0=replicate(1.0, ndata)
      f_1=wperp_2^ntri*1.0d0
      f_2=(vparl^2)^ntri*1.0d0
      f_3=ntri*(vparl^2)^(ntri-0.5)*1.0d0
      inv_accuracy=1
      sigma_b=1

      n_b=4
      if n_elements(g) gt 5 then begin
          generalized_least_squares_fit, g, sigma_g, 4, f_0, f_1, f_2, f_3,$
            b=b, sigma_b=sigma_b, rchi2=rchi2, $
            inv_accuracy=inv_accuracy, istat=istat
      endif else begin
          istat=-999
      endelse
      if(istat ne 0) then begin
          n_b=3
          if n_elements(g) gt 4 then begin
                                ; recovery mode reduce the order
              generalized_least_squares_fit, g, sigma_g, 3, f_0, f_1, f_2,$
                b=b1, sigma_b=sigma_b, rchi2=rchi2, $
                inv_accuracy=inv_accuracy,istat=istat
          endif else begin
              istat=-999
          endelse
          if(istat ne 0) then begin
              n_b=1
              b=total(g)/n_elements(g)
              rchi2=total(((g-b)/sigma_g)^2,/double)/n_elements(g)
              sigma_b=0
              
              b= [b,0,0,0]
              sigma_b= [sigma_b,0,0,0]
          endif else begin
              b= [b1,0]
          endelse
          if finite(rchi2) eq 0 then begin
              b=replicate(fill,4)
              rchi2=1e31
          endif
      endif else if finite(rchi2) eq 0 then begin
          b=replicate(fill,4)
          rchi2=1e31
      endif

      chi_array[jkl]= rchi2

      if(rchi2 lt chi_max) then begin
          chi_max=rchi2
          bsave=b
          sigma_bsave=sigma_b
          save_stat=istat
          nbest=ntri
          nb_save=n_b
      endif

      jkl=jkl+1
  endrep until (jkl eq nns-1) or (rchi2 gt chi_max)
  
  patch_parm= { b:double(bsave), $
                n:float(nbest), $
                bhat:data.bavg_hat, $
                rchi2:float(chi_max), $
                renormalize:double(renormalize)}
;  print, systime()
  if keyword_set(verbose) then begin
      s=sort(chi_array)
      s=s(0:n_elements(s)*0.9)
      max=max(chi_array(s),min=min)
      if max-min gt 100 then ylog=1 else ylog=0
      plot, chi_array(s), ylog=ylog, min_val=1e-10, max_val=1e30
      xyouts, 0.5,0.5, /normal, 'Nbest='+strtrim(nbest,2)
      stop
  endif
  return, patch_parm
end



