pro plot_ibscatter, x, y, sigx, sigy, errorbars=errorbars, $
                    xlog=xlog, ylog=ylog, _extra=e, grid=grid
;+
;
;   Plot Scatter plot of Counts
;
;
;
;-
np=n_elements(x)
xmin = min([x,0])
xmax = (x(sort(x)))(0.99*np)

ymin = min([y,0])
ymax = (y(sort(y)))(0.99*np)

xmin = min([xmin,ymin])-1
ymin = xmin
xmax = max([xmax,ymax])-1
ymax = xmax
if keyword_set(xlog) and xmin le 0.0 then xmin=0.1 else xlog=0
if keyword_set(ylog) and ymin le 0.0 then ymin=0.1 else ylog=0

if keyword_set(grid) then begin
;    plot, x, y, psym=3,$
;      _extra=e, $
;      xrange=[xmin, xmax], yrange=[ymin, ymax], $
;      xstyle=1, ystyle=1, charsize=1.5, _extra=e, $
;      xlog=xlog, ylog=ylog

    dot_plot, x, y, grid, _extra=e, $
      xlog=xlog, ylog=ylog, xrange=[xmin, xmax], yrange=[ymin, ymax]

endif else begin

    plot, x, y, psym=3,$
      title=title, xtitle=xtitle, ytitle=ytitle, $
      xrange=[xmin, xmax], yrange=[ymin, ymax], $
      xstyle=1, ystyle=1, charsize=1.5, _extra=e, $
      xlog=xlog, ylog=ylog

    IF keyword_set(errorbars) THEN BEGIN 
        oploterr, x, y, sigy
        FOR i=0, np-1 DO $
          oplot, [x(i) - sigx(i),x(i) + sigx(i)], [y(i), y(i)]
    ENDIF 
endelse

end
