;
;	startup file to define common plot routines
;

if !version.os_family eq 'unix' then path_sep=':' else path_sep=';'

if !version.os_family eq 'Windows' then device, decomposed=0
if !version.os_family eq 'unix' and !version.arch eq 'x86' then device, decomposed=0
if !version.os_family eq 'unix' and !version.arch eq 'sparc' then device, decomposed=0

; spectra needs more space than is allocated by default.
;.size 48000 20000 ; for idl_4
!path = !path + path_sep + expand_path('+/opt/hydra/archive/utilities/spectra')
!path = !path + path_sep + expand_path('+/opt/hydra/idl_common')
;
;!path = !path + path_sep + '/home/jbf/block'

machine_name= get_machine_name()

set_hydra_path

; kludges for papco
if getenv('plot_init_no_setcolors') eq '' then define_papco_color_names
dots, /fill  ; load the psym with something so papco doesn't crash.

; set color table to hydra_setcolors standard
;if getenv('USER') ne 'hqs' then begin
if getenv('plot_init_no_setcolors') eq '' then hydra_setcolors
if getenv('plot_init_no_setcolors') eq '' then hydra_setcolors, cs
                                ; called a second time while mysterious bug
                                ; causes code to not load white in !p.color
;endif
defsysv, '!cs', exists=exist
if not exist then defsysv, '!cs', cs

setenv, 'win_px_cm='+strtrim(!d.x_px_cm,2)

; turn off xmanager error trapping to make IDL 5 behavior more like
; IDL 4.
xmanager, catch=0

;
;   Set Global PAPCO environment variables
;
;

setenv, 'wget_exe=/opt/gnu/bin/wget'
setenv, 'HYDRA_PLOT_VERSION_PATH=/opt/hydra/gain_data/'
setenv, 'HYDRA_PLOT_VERSION_ADDR=http://supras.physics.uiowa.edu/hydra_data/versions/'


setenv, 'HYDRA_PPAL1_DATA_PATH=/opt/hydra/ppal1_??/'

;data_cache=''
data_cache='/export/home/data_cache/'+path_sep

setenv, 'HYDRA_LEVEL1_DATA_PATH='+data_cache+'/opt/hydra/l1_??/'

setenv, 'HYDRA_DDCAL_DATA_PATH='+data_cache+'/opt/hydra/l1_??/'

setenv, 'HYDRA_SURVEY_DATA_PATH='+data_cache+'/opt/hydra/survey?/'

setenv, 'HYDRA_MOMENTS_DATA_PATH='+data_cache+'/opt/hydra/moment_data?/full/'
;setenv, 'HYDRA_MOMENTS_DATA_PATH=/opt/hydra/moment_data0/full_berkeley_qe_1/'

setenv, 'HYDRA_MOMENTS_RC_DATA_PATH=/opt/hydra/moment_data?/rc/'

setenv, 'HYDRA_FOOTPRINT_DATA_PATH=/opt/hydra/gain_data/versions/footprints/'

setenv, 'HYDRA_SPPION_DATA_PATH=/opt/hydra/moment_data?/sppion/'

setenv, 'HYDRA_TPPION_DATA_PATH=/opt/hydra/moment_data?/tppion/'

setenv, 'HYDRA_SPF_DATA_PATH='+data_cache+'/opt/hydra/moment_data?/spf/'

setenv, 'HYDRA_TPF_DATA_PATH='+data_cache+'/opt/hydra/moment_data?/tpf/'

setenv, 'HYDRA_CDHFKP_DATA_PATH=/opt/hydra/kp?/'

setenv, 'HYDRA_KPTEST_DATA_PATH=/home/ppq/bigdisk/key_parameters/test_kplib/'

setenv, 'HYD_EFI_SPECIAL_DATA=/home/jbf/scratch_pad/data/'

setenv, 'HYD_PAPCO_SCRATCH_DATA=/opt/hydra/papco_scratch/'

setenv, 'EFI_VXYZ_DATA=/opt/hydra/efi_data/vxyz_data/'

setenv, 'HYDRA_WALEN_DATA_PATH=/opt/hydra/walen_data/'

setenv, 'HD_DATA_SETS=/opt/hydra/tmp_data/hyd_access_data_sets/'

setenv, 'HYDRA_PLOT_ID_DIR=/opt/hydra/dstatdb/plotid_numbers'

setenv, 'HYDRA_TPPHR_DATA_PATH=/opt/hydra/moment_data?/tpphr/'

delvar, data_cache

;loadct,26

