; This was written quickly!  There's most likely a better way to do this...
; Pam Puhl-Quinn, U of Iowa Hydra Team, 4/24/00
      
pro dissect_doy96, time_doy96,iyear,imonth,iday,ihour,iminute,isecond,imsec

if (n_params() eq 0) then begin
    doc_library, 'dissect_doy96'
    return
endif

;+
; NAME: dissect_doy96.pro
;
; PURPOSE: Split-up time_doy96 into year,month,day,hour,minute,second,msec
;
; USAGE:  
;   dissect_doy96,time_doy96,iyear,imonth,iday,ihour,iminute,isecond,imsec
;
; INPUT:   time_doy96  Time in decimal day since 19951231, 00:00:00
;
; OUTPUT:  iyear       4-digit year
;          imonth      2-digit month
;          iday        2-digit day
;          ihour       2-digit hour
;          iminute     2-digit minute
;          isecond     2-digit second
;          imsec       3-digit millisecond
;
; AUTHOR:  Pamela Puhl-Quinn, 4/24/00
;-


nyear_max = 10
year = [1995,1996,1997,1998,1999,2000,2001,2002,2003,2004]
doy96_offset = [ -365.d0, 0.d0, 366.d0, 731.d0, 1096.d0, 1461.d0, $
                 1827.d0, 2192.d0, 2557.d0, 2922.d0, 3288.d0]
nmonth_max = 12
month = [1,2,3,4,5,6,7,8,9,10,11,12]
doy_offset_nominal = [0.d0, 31.d0, 59.d0, 90.d0, 120.d0, 151.d0, $
                      181.d0, 212.d0, 243.d0, 273.d0, 304.d0, 334.d0, 365.d0]
doy_offset_correction = [0.d0,0.d0,1.d0,1.d0,1.d0,1.d0,1.d0,1.d0, $
                         1.d0,1.d0,1.d0,1.d0,1.d0]
;============================================================

; Determine iyear
for jyear=0,nyear_max-1 do begin
    if (time_doy96 lt (doy96_offset(jyear+1)+1.d0)) then begin
        iyear = year(jyear)
        kyear = jyear
        goto, out_yearloop
    endif
endfor
message, 'Can not handle year 2005 or above'
      
out_yearloop:

; Determine the time in decimal day of year
time_doy = time_doy96 - doy96_offset(kyear)

; Define doy_offset, depending on whether or not this is a leap year
if (iyear mod 4 eq 0) then begin
    if (iyear mod 400 eq 0) then begin
        doy_offset = doy_offset_nominal + doy_offset_correction
    endif else if (iyear mod 100 eq 0) then begin
        doy_offset = doy_offset_nominal
    endif else begin
        doy_offset = doy_offset_nominal + doy_offset_correction
    endelse
endif else begin
    doy_offset = doy_offset_nominal
endelse
      
; Determine imonth
for jmonth=0,nmonth_max-1 do begin
    if (time_doy lt (doy_offset(jmonth+1)+1.d0)) then begin
        imonth = month(jmonth)
        kmonth = jmonth
        goto, out_monthloop
    endif
endfor
message, 'Something wrong with imonth'

out_monthloop:

; Determine the time in decimal day of month
time_dom = time_doy - doy_offset(kmonth)
iday = long(time_dom)

; Determine the time in hours since midnight
time_hsm = (time_dom-iday)*24.d0
ihour = long(time_hsm)
iminute = long( (time_hsm-ihour)*60.d0 )
isecond = long( ((time_hsm-ihour)*60.d0 - iminute)*60.d0 )
imsec = long( (((time_hsm-ihour)*60.d0 - iminute)*60.d0 - isecond )*1000.d0 )
  
return
end
      
