pro epoch2doy96, t, reverse=reverse

;+
; NAME: epoch2doy96.pro
; PURPOSE: Convert time in epoch to time in doy96
; USAGE: 
;         epoch2doy96, t
; INPUT:  t in epoch
; OUTPUT: t in doy96
; KEYWORDS: /reverse will go from doy96 to epoch
; RESTRICTIONS: t must be scalar or 1-d vector
; AUTHOR: Pamela Puhl-Quinn, 4/00
;-

if ( (size(t))(0) eq 1 ) then begin 
    
    if not keyword_set(reverse) then begin
        cdf_epoch, t(0), iyear,imonth,iday,ihour,iminute,isecond,imsec, $
          /breakdown_epoch
        
        dstr = string(iyear,'(i4.4)')+string(imonth,'(i2.2)')+string(iday,'(i2.2)')
        total_time = double(ihour)*3600.d0 + double(iminute)*60.d0 + $
          double(isecond) + double(imsec)/1000.d0 ; seconds
        
        firstrec_doy96 = gen_time(date=dstr,time=total_time,/seconds)
        
        t = t - t(0)            ; milliseconds since first record
        
        t = t/1000.d0/60.d0/60.d0/24.d0 + firstrec_doy96
        
    endif else begin
        
        dissect_doy96, t(0),iyear,imonth,iday,ihour,iminute,isecond,imsec
        cdf_epoch, firstrec_epoch, iyear,imonth,iday,ihour,iminute,isecond, $
          imsec, /compute_epoch
        
        t = (t - t(0))*24.d0*60.d0*60.d0*1000.d0 ; milliseconds since first rec
        t = t + firstrec_epoch

    endelse

endif else if ((size(t))(0) eq 0 ) then begin

    if not keyword_set(reverse) then begin
        
        cdf_epoch, t, iyear,imonth,iday,ihour,iminute,isecond,imsec, $
          /breakdown_epoch
        
        dstr = string(iyear,'(i4.4)')+string(imonth,'(i2.2)')+ $
          string(iday,'(i2.2)')
        total_time = double(ihour)*3600.d0 + double(iminute)*60.d0 + $
          double(isecond) + double(imsec)/1000.d0 ; seconds
        
        t = gen_time(date=dstr,time=total_time,/seconds)
    endif else begin
        
        dissect_doy96, t,iyear,imonth,iday,ihour,iminute,isecond,imsec
        cdf_epoch, t, iyear,imonth,iday,ihour,iminute,isecond, $
          imsec, /compute_epoch
        
    endelse
    
endif else begin
    
    message, 'Input time must be a scalar, or a 1-D vector'
    
endelse

return
end
