pro get_ma_data_release, plot_number_in, resolution_in, spec_out, titstr,$
                              nif_zgrid=nif_zgrid, nif_xgrid=nif_xgrid, $
                              verbose=verbose, status=status, footprint=fp

;+
; NAME: /opt/hydra/idl_common/ppq/get_ma_data_release.pro
;  Curator of Ma data: Pamela A. Puhl-Quinn
;  Root directory of Ma data source code: /home/ppq/ma_data_source
;-

common get_ma_data_release_common, $
  buffer_pn, buffer_spec, buffer_title, buffer_hits

verbose = keyword_set(verbose)

msghead = '% GET_MA_DATA_RELEASE: '

fp = [msghead]

if n_elements( resolution_in ) eq 0 then message, 'Resolution not specified!'

if (resolution_in ne 'hr' and resolution_in ne 'inertial') then $
  message, '"hr" and "inertial" are the only resolutions understood.'

vstrings = [ ['p', 'Pressure', 'orig'], $ ; 0
             ['psi', 'Flux', 'orig'], $ ; 1
             ['rho', '!7q!x', 'orig'], $ ; 2
             ['uparl', 'U!d!9#!x!n', 'derive'], $ ; 3
             ['uperp', '!9!!!xU!d!9x!x!n!9!!!x', 'derive'], $ ; 4
             ['jparl', 'J!d!9#!x!n', 'derive'], $ ; 5
             ['jperp', '!9!!!xJ!d!9x!x!n!9!!!x', 'derive'], $ ; 6
             ['eparl', 'E!d!9#!x!n', 'derive'], $ ; 7
             ['eperp', '!9!!!xE!d!9x!x!n!9!!!x', 'derive'], $ ; 8
             ['jparl_eparl', 'J!d!9#!x!nE!d!9#!x!n', 'derive'], $ ; 9
             ['eparl_over_eperp', 'E!d!9#!x!n/E!d!9x!x!n', 'derive'], $ ; 10
             ['x','X!dNIF!n', 'orig'], $ ; 11
             ['z','Z!dNIF!n', 'orig'], $ ; 12
             ['mgradpx','-!9G!xP!s!ue!r!dx-NIF!n', 'derive'], $ ; 13
             ['mgradpz','-!9G!xP!s!ue!r!dz-NIF!n', 'derive'], $ ; 14
             ['bx','B!dx,NIF!n', 'orig'], $ ; 15
             ['bz','B!dz,NIF!n', 'orig'], $ ; 16
             ['bmag','!9!!!xB!9!!!x', 'derive'], $ ; 17
             ['jdote','J!9.!xE', 'derive'], $ ; 18
             ['jx','J!dx,NIF!n', 'orig'], $ ; 19
             ['jy','J!dy,NIF!n', 'orig'], $ ; 20
             ['jz','J!dz,NIF!n', 'orig'], $ ; 21
             ['ex','E!dx,NIF!n', 'orig'], $ ; 22
             ['ey','E!dy,NIF!n', 'orig'], $ ; 23
             ['ez','E!dz,NIF!n', 'orig'], $ ; 24
             ['mgradpmag','!9!!!x-!9G!xP!de!n!9!!!x', 'derive'], $ ; 25
             ['atan_mgradpz_mgradpx','atan(-!9G!xP!dz!n/-!9G!xP!dx!n)', $
              'derive'], $      ; 26
             ['mgradp_b_angle', '-!9G!xP!de!n-B angle', 'derive'], $ ; 27
             [' ',' ',' '], $       ; 28
             [' ',' ',' '], $       ; 29
             [' ',' ',' '], $       ; 30
             [' ',' ',' '], $       ; 31
             [' ',' ',' '], $       ; 32
             [' ',' ',' '], $       ; 33
             [' ',' ',' '], $       ; 34
             [' ',' ',' '], $       ; 35
             [' ',' ',' '], $       ; 36
             [' ',' ',' '], $       ; 37
             [' ',' ',' '], $       ; 38
             [' ',' ',' '], $       ; 39
             ['by','B!dy,NIF!n', 'orig'], $ ; 40
             ['mia','M!di!dA!n', 'derive'], $ ; 41
             ['vx','U!dx,NIF!n', 'orig'], $ ; 42
             ['vy','U!dy,NIF!n', 'orig'], $ ; 43
             ['vz','U!dz,NIF!n', 'orig'], $ ; 44
             ['temp','T!de!n', 'derive'], $ ; 45
             ['mgradpx','-!9G!xP!s!ue!r!dx-NIF!n', 'derive'], $ ; 46
             ['mgradpz','-!9G!xP!s!ue!r!dz-NIF!n', 'derive'], $ ; 47
             [' ',' ',' '], $       ; 48
             [' ',' ',' '], $       ; 49
             ['gradbmag','!9!!G!x!9!!!xB!9!!!x!9!!!x', 'derive'], $ ; 50
             ['jperpx','J!d!9x!x,x,NIF!n', 'derive'], $     ; 51
             ['jperpz','J!d!9x!x,z,NIF!n', 'derive'], $     ; 52
             ['uperpx','U!d!9x!x,x,NIF!n', 'derive'], $     ; 53
             ['uperpz','U!d!9x!x,z,NIF!n', 'derive'], $     ; 54
             ['uperpy','U!d!9x!x,y,NIF!n', 'derive'], $     ; 55
             ['jperpy','J!d!9x!x,y,NIF!n', 'derive'], $     ; 56
             ['dbdx','dbdx NIF', 'orig'], $ ; 57
             ['dbdz','dbdz NIF', 'orig'], $ ; 58
             ['drhodx','drhodx NIF', 'orig'], $ ; 59
             ['drhodz','drhodz NIF', 'orig'] ] ; 60

plot_number= plot_number_in
if (size(plot_number))(1) eq 7 then begin
    case strlowcase(plot_number) of
        'dbdx':plot_number=57
        'dbdz':plot_number=58
        'drhodx':plot_number=59
        'drhodz':plot_number=60
        'mgradp_b_angle':plot_number=27
        'jdote':plot_number=18
        'eparl_over_eperp':plot_number=10
        'flux': plot_number=1
        'bmag': plot_number=17
        'pressure': plot_number=0 
        'density': plot_number=2
        'x': plot_number=11
        'z': plot_number=12
        'nif_bx': plot_number=15
        'nif_bz': plot_number=16
        'b_nif_x': plot_number=15
        'b_nif_z': plot_number=16
        'jparl': plot_number=5
        'uparl': plot_number=3 
        'jperp': plot_number=6
        'uperp': plot_number=4
        'rho': plot_number=2
        'eparl': plot_number=7
        'eperp': plot_number=8
        'jparl_eparl': plot_number=9
        'grad_pe': plot_number=25
        'j_nif_x': plot_number=19
        'j_nif_y': plot_number=20
        'j_nif_z': plot_number=21
        'e_nif_x': plot_number=22
        'e_nif_y': plot_number=23
        'e_nif_z': plot_number=24
        'nif_x': plot_number=11
        'nif_z': plot_number=12
        'nif_by': plot_number=40
        'b_nif_y': plot_number=40
        'mia': plot_number=41
        'u_nif_x': plot_number=42
        'u_nif_y': plot_number=43
        'u_nif_z': plot_number=44
        'temperature': plot_number=45
        'grad_pe_nif_x': plot_number=13
        'grad_pe_nif_z': plot_number=14
        'grad_b_mag': plot_number=50
        'jperp_x': plot_number=51
        'jperp_z': plot_number=52
        'uperp_x': plot_number=53
        'uperp_z': plot_number=54
        'uperp_y': plot_number=55 
        'jperp_y': plot_number=56
        else: begin
            message, 'Plot variable currently not assigned: ' + plot_number, $
              /cont
            fp = [fp,' > Plot variable currently not assigned: ' + plot_number]
            hd_add_footprint, fp
            return
        end
    endcase
endif
status = 1
varstr = vstrings(0,plot_number)
if (varstr eq ' ') then begin
    message, 'Plot number currently not assigned: '+ $
      string(plot_number,'(i3.3)'), /cont
    status = 0
    fp = [fp, ' > Plot number currently not assigned: '+ $
          string(plot_number,'(i3.3)')]
    hd_add_footprint, fp
    return
endif

if (size(plot_number_in))(1) eq 7 then fp0 = plot_number_in else fp0 = varstr

fp = [fp, $
      ' > Variable requested: '+fp0, $
      ' > README for "hr" Ma: /home/ppq/ma_data_source/hr/release/README', $
      ' > Current snapshot version of "hr" release code: v1_01', $
      ' > '+snapshot_idl_common_ppq(/id)]

titstr = vstrings(1,plot_number)
typstr = vstrings(2,plot_number)
pnstr = strtrim(plot_number,2)

orig_dir= '/opt/hydra/scratch0/quinn/'
if (resolution_in eq 'hr') then begin
    ident = '_nif_highres.idlsav'
    ss_dir = '/home/jbf/work2/get_ma_data/'
    so_ss = ss_dir+'get_ma_data_new_'+resolution_in+pnstr+'.idlsav' ; spec_out
endif else begin
    ident = '_nif_inertial.idlsav'
    ss_dir = '/opt/hydra/scratch0/quinn/'
    so_ss = ss_dir+varstr+'_nif_'+resolution_in+'.idlsav' ; spec_out
endelse

; Either restore or create the xgrid/zgrid saveset so that
; nif_xgrid and nif_zgrid are filled
xz_ss = ss_dir+'xgrid_ygrid_nif_'+resolution_in+'.idlsav' ; nif_xgrid,zgrid
f = findfile(xz_ss)
if f(0) ne '' then begin
    restore, f(0), verbose=verbose
endif else begin
    restore, orig_dir+'x'+ident, verbose=verbose
    nif_xgrid = reform(x(*,0))
    restore, orig_dir+'z'+ident, verbose=verbose
    nif_zgrid = reform(z(0,*))
    save, nif_xgrid, nif_zgrid, file=xz_ss
endelse

; If the variable requested is an 'orig'inal Ma variable, restore it
; and return
if (typstr eq 'orig') then begin
    restore, orig_dir+varstr+ident, verbose=verbose
    istat = execute('spec_out = temporary('+varstr+')')
    hd_add_footprint, fp
    return
endif

; If the variable requested is a 'derive'd one, first see if the
; saveset already exists and if so, return
f = findfile(so_ss)
if f(0) ne '' then begin
    restore, f(0), verbose=verbose
    titstr = vstrings(1,plot_number)
    hd_add_footprint, fp
    return
endif

;=================================================================
; SAVE SET FOR DERIVED VARIABLE DOESN'T EXIST---MUST MAKE IT BELOW
;=================================================================

resolution = resolution_in
pn = plot_number
vb = verbose

nxg = n_elements( nif_xgrid )
nyg = n_elements( nif_zgrid )
nn= long(nxg)*nyg

;  check to see if stored in buffer
if n_elements( buffer_pn ) eq 0 then begin
    nbuffer= 12
    buffer_pn= intarr(nbuffer)-1
    buffer_spec= fltarr(nxg,nyg,nbuffer)
    buffer_title= strarr(nbuffer)
    buffer_hits= lonarr(nbuffer)
endif

idx= (where( buffer_pn eq pn ))(0)
if idx ne -1 then begin
    spec_out= buffer_spec(*,*,idx)
    titstr= buffer_title(idx)
    buffer_hits(idx)= buffer_hits(idx)+1
    print, 'Using buffer: '+strtrim(pn)+', '+titstr
    hd_add_footprint, fp
    return
endif
;  end check to see if stored in buffer

;=========================================

if (where( [3,4,5,6,7,8,9,10,18,27,51,52,53,54,55,56] eq pn ))(0) ne -1 $
  then begin
    get_ma_data_release, 'b_nif_x', resolution, bx, verbose=vb
    get_ma_data_release, 'b_nif_y', resolution, by, verbose=vb
    get_ma_data_release, 'b_nif_z', resolution, bz, verbose=vb
    b_nif= fltarr(nn,3)
    b_nif(*,0) = bx(*)
    b_nif(*,1) = by(*)
    b_nif(*,2) = bz(*)
    
    get_ma_data_release, 'e_nif_x', resolution, ex, verbose=vb
    get_ma_data_release, 'e_nif_y', resolution, ey, verbose=vb
    get_ma_data_release, 'e_nif_z', resolution, ez, verbose=vb
    e_nif= fltarr(nn,3)
    e_nif(*,0) = ex(*)
    e_nif(*,1) = ey(*)
    e_nif(*,2) = ez(*)
    
; define some useful quantities 
    bmag= hd_magnitude( b_nif )
    bhat= hd_svdivide( temporary(bmag), b_nif ) 
    eparl= hd_dot( e_nif, bhat )
    eperpvec= e_nif - hd_svmult( eparl, bhat )
    eperp= hd_magnitude( temporary(eperpvec) )
endif

surfs= fltarr( nxg,nyg )
case 1 of
    pn ge 3 and pn le 4 or $
      pn eq 53 or pn eq 54 or pn eq 55: begin
        get_ma_data_release, 'u_nif_x', resolution, vx, verbose=vb
        get_ma_data_release, 'u_nif_y', resolution, vy, verbose=vb
        get_ma_data_release, 'u_nif_z', resolution, vz, verbose=vb
        u_nif= fltarr(nn,3)
        u_nif(*,0) = vx(*)
        u_nif(*,1) = vy(*)
        u_nif(*,2) = vz(*)
        uparl= hd_dot( u_nif, bhat )        
        if pn eq 3 then begin  
            surfs(*) = uparl
        end
        if pn eq 4 then begin  
            uperpvec= u_nif - hd_svmult( uparl, bhat )
            uperp= hd_magnitude( temporary(uperpvec) )
            surfs(*) = uperp
        end
        if pn eq 53 or pn eq 54 or pn eq 55 then begin
            uperpvec= u_nif - hd_svmult( uparl, bhat )
            if pn eq 53 then surfs(*)= uperpvec(*,0)
            if pn eq 54 then surfs(*)= uperpvec(*,2)
            if pn eq 55 then surfs(*)= uperpvec(*,1)
        endif
    end
    pn eq 5 or pn eq 6 or pn eq 9 or pn eq 18 or $
      pn eq 51 or pn eq 52 or pn eq 56: begin
        get_ma_data_release, 'j_nif_x', resolution, jx, verbose=vb
        get_ma_data_release, 'j_nif_y', resolution, jy, verbose=vb
        get_ma_data_release, 'j_nif_z', resolution, jz, verbose=vb
        j_nif= fltarr(nn,3)
        j_nif(*,0) = jx(*)
        j_nif(*,1) = jy(*)
        j_nif(*,2) = jz(*)
        jparl= hd_dot( j_nif, bhat )        
        case 1 of
            pn eq 5: begin  
                surfs(*) = jparl
            end
            pn eq 6: begin  
                jperpvec= j_nif - hd_svmult( jparl, bhat )
                jperp= hd_magnitude( temporary(jperpvec) )
                surfs(*) = jperp
            end
            pn eq 9: begin  
                surfs(*) = jparl*eparl
            end
            pn eq 18: begin 
                surfs(*) = hd_dot( j_nif, e_nif )
            end
            pn eq 51: begin
                jperpvec= j_nif - hd_svmult( jparl, bhat )
                surfs(*) = jperpvec(*,0)
            end
            pn eq 52: begin
                jperpvec= j_nif - hd_svmult( jparl, bhat )
                surfs(*) = jperpvec(*,2)
            end
            pn eq 56: begin
                jperpvec= j_nif - hd_svmult( jparl, bhat )
                surfs(*) = jperpvec(*,1)
            end
        end
    endif
    pn eq 7: begin 
        surfs(*) = eparl
    end
    pn eq 8: begin  
        surfs(*) = eperp
    end
    pn eq 10: begin  
        surfs(*) = eparl/eperp
    end
    total(pn eq [13,14]): begin  
        restore, orig_dir+'dpdz'+ident, verbose=vb
        restore, orig_dir+'dpdx'+ident, verbose=vb
        minus_grad_p_nif= -1.0 * reform( [ dpdx(*), 0*dpdx(*), dpdz(*) ],$
                                         n_elements(dpdx(*)), $
                                         3 )
        if pn eq 13 then begin
            surfs(*) = minus_grad_p_nif(*,0)
        endif else if pn eq 14 then begin
            surfs(*) = minus_grad_p_nif(*,2)
        endif
    end
    pn eq 17: begin
        restore, orig_dir+'bx'+ident, verbose=vb
        restore, orig_dir+'by'+ident, verbose=vb
        restore, orig_dir+'bz'+ident, verbose=vb
        surfs(*) = sqrt( bx^2 + by^2 + bz^2 )
    end
    total(pn eq [25,26,27,46,47]): begin  
        restore, orig_dir+'dpdz'+ident, verbose=vb
        restore, orig_dir+'dpdx'+ident, verbose=vb
        minus_grad_p_nif= -1* reform( [ dpdx(*), 0*dpdx(*), dpdz(*) ],$
                                      n_elements(dpdx(*)), $
                                      3 )
        if pn eq 25 then begin
            surfs(*) = hd_magnitude( minus_grad_p_nif )
        endif else if pn eq 26 then begin       
            surfs(*) = atan( minus_grad_p_nif(*,2), minus_grad_p_nif(*,0) )
        endif else if pn eq 27 then begin
            grad_P_mag= hd_magnitude( minus_grad_p_nif )
            surfs(*) = acos( hd_dot( hd_svdivide( grad_P_mag, $
                                                  minus_grad_p_nif ) , bhat ) )
        endif else if pn eq 46 then begin
            surfs(*)= minus_grad_p_nif(*,0)
        endif else if pn eq 47 then begin
            surfs(*)= minus_grad_p_nif(*,2)
        endif
    end
    pn eq 41: begin
        surfs(*)= ma_mach_i(resolution)
    end
    pn eq 45: begin
        restore, orig_dir+'p'+ident, verbose=vb
        restore, orig_dir+'rho'+ident, verbose=vb
        surfs(*)= p / rho
    end
    pn eq 50: begin
        restore, orig_dir+'dbdz'+ident, verbose=vb
        restore, orig_dir+'dbdx'+ident, verbose=vb
        grad_B_mag= dBdx < dBdz ; propogate fill and set size
        r= where( grad_B_mag gt -1e31 )
        grad_B_mag(r)= sqrt( dBdx(r)^2 + dBdz(r)^2 )
        surfs(*)=grad_B_mag
    end
    else: begin
        message, 'Plot number currently not assigned: '+ $
          string(pn,'(i3.3)'), /cont
        fp = [fp, ' > Plot number currently not assigned: '+ $
              string(pn,'(i3.3)')]
        hd_add_footprint, fp
        return
    end
endcase

; De-allocate some space
pos_nif = 0.
b_nif = 0.
u_nif = 0.
e_nif = 0.
j_nif = 0.
minus_grad_p_nif = 0.
pressure_nif = 0.
flux_nif = 0.
rho_nif = 0.

spec_out= temporary( surfs )

buffer_it=1
if buffer_it then begin
    idxs= where( buffer_pn eq -1 )
    if idxs(0) eq -1 then begin
        x= min( buffer_hits, imin )
        idx= imin        
    endif else begin
        idx= idxs(0)
    endelse
    buffer_spec(*,*,idx)= spec_out
    buffer_title(idx)=titstr
    buffer_pn(idx)= pn
    buffer_hits(idx)=0
endif

save, file = so_ss, spec_out, titstr

hd_add_footprint, fp

return
end






