pro get_spphr_data, date, vstring, var

common get_spphr_eledata, ele_cdone, ele_time, ele_l1time, ele_l1density, ele_l1meane,ele_density,ele_meane, ele_anis, ele_trap_density,ele_trap_meane,ele_max_energy,ele_ux, ele_uy,ele_uz,ele_rchi2, ele_ktparl, ele_ktperp

common get_spphr_iondata, ion_cdone, ion_time, ion_l1time, ion_l1density, ion_l1meane,ion_density,ion_meane, ion_anis, ion_trap_density,ion_trap_meane,ion_max_energy,ion_ux, ion_uy,ion_uz,ion_rchi2, ion_ktparl, ion_ktperp

if (date ne '19960529') then message, "Only works for date = '19960529'"

spec = strmid(vstring,0,3)

read = 0
if (spec eq 'ion') then begin
    mass = 1.67d-24
    file = '/home/ppq/bigdisk/key_parameters/ion_kps/'+ $
      'six_parameter_patch/hydra_highres/spphr_ion.dat'
    if n_elements(ion_cdone) eq 0 then read = 1
endif else if (spec eq 'ele') then begin
    mass = 9.1d-28
    file = '/home/ppq/bigdisk/key_parameters/ion_kps/'+ $
      'six_parameter_patch/hydra_highres/spphr_ele.dat'
    if n_elements(ele_cdone) eq 0 then read = 1
endif else begin
    message, 'Variable string not recognized: ' + vstring
endelse

@hd_include
cm2km = 10.d-5
if (read) then begin
    openr, unit, file, /f77_unformatted, /get_lun
    r = {best_struc, $
         fbest:fltarr(10), $
         vrms:0., $
         iretu:0L, $
         npatch:0L, $
         isort:0L, $
         density:0., $   
         ux:0., $
         uy:0., $
         uz:0., $
         wparl:0., $
         wperp:0., $
         rchi2_all:0., $
         rchi2:0.}
    r = {real_struc, $
         iretu:0L, $
         nrealizations:0L, $
         rstudy_density_stats:fltarr(6), $
         rstudy_ux_stats:fltarr(6), $
         rstudy_uy_stats:fltarr(6), $
         rstudy_uz_stats:fltarr(6), $
         rstudy_wparl_stats:fltarr(6), $
         rstudy_wperp_stats:fltarr(6)}
    spp = {spp_struc, $
           status:0L, $
           sc_pot:0., $
           sc_pot_stat:0L, $
           time:0., $
           max_caverage:fltarr(2), $
           min_energy:0., $
           max_energy:0., $
           max_v:0., $
           bhat_block_avg:fltarr(3), $
           bmag:0., $
           var_bhat_block_avg:fltarr(3), $
           trap_density:0., $
           trap_meane:0., $
           l1stat:0L, $
           l1time:0., $
           l1density:0., $
           l1meane:0., $
           spp_best:{best_struc}, $
           spp_real:{real_struc}}
    nmax = 10000
    time = fltarr(nmax)
    l1time = fltarr(nmax)
    l1density = fltarr(nmax)
    l1meane = fltarr(nmax)
    density = fltarr(nmax)
    meane = fltarr(nmax)
    ktparl = fltarr(nmax)
    ktperp = fltarr(nmax)
    anis = fltarr(nmax)
    trap_density = fltarr(nmax)
    trap_meane = fltarr(nmax)
    max_energy = fltarr(nmax)
    ux = fltarr(nmax)
    uy = fltarr(nmax)
    uz = fltarr(nmax)
    rchi2 = fltarr(nmax)
    dum = spp
    ic = -1
    while not eof(unit) do begin
        readu, unit, dum
        if (spec eq 'ion') then dum.l1stat = 1
        if (dum.status eq 1 and dum.spp_best.iretu eq 1 and $
            dum.l1stat eq 1) then begin
            ic = ic+1
            time(ic) = dum.time
            l1time(ic) = dum.l1time
            l1density(ic) = dum.l1density
            l1meane(ic) = dum.l1meane
            density(ic) = dum.spp_best.density
            ux(ic) = dum.spp_best.ux
            uy(ic) = dum.spp_best.uy
            uz(ic) = dum.spp_best.uz
            rchi2(ic) = dum.spp_best.rchi2
            ktparl(ic) = (.5*mass*dum.spp_best.wparl^2)/1.6d-12 ; eV
            ktperp(ic) = (.5*mass*dum.spp_best.wperp^2)/1.6d-12 ; eV
            meane(ic) = 1./3.*(ktparl(ic) + 2.*ktperp(ic))
            anis(ic) = ktparl(ic)/ktperp(ic)
            trap_density(ic) = dum.trap_density
            trap_meane(ic) = dum.trap_meane
            max_energy(ic) = dum.max_energy
        endif
    endwhile
    close, unit
    free_lun, unit
    if (spec eq 'ion') then begin
        ion_time = time(0:ic)
        ion_l1time = l1time(0:ic)
        ion_l1density = l1density(0:ic)
        ion_l1meane = l1meane(0:ic)
        ion_density = density(0:ic)
        ion_meane = meane(0:ic)
        ion_ktparl = ktparl(0:ic)
        ion_ktperp = ktperp(0:ic)
        ion_anis = anis(0:ic)
        ion_trap_density = trap_density(0:ic)
        ion_trap_meane = trap_meane(0:ic)
        ion_max_energy = max_energy(0:ic)
        ion_ux =ux(0:ic)*cm2km
        ion_uy =uy(0:ic)*cm2km
        ion_uz =uz(0:ic)*cm2km
        ion_rchi2 =rchi2(0:ic)
        ion_cdone = 1
    endif else begin
        ele_time = time(0:ic)
        ele_l1time = l1time(0:ic)
        ele_l1density = l1density(0:ic)
        ele_l1meane = l1meane(0:ic)
        ele_density = density(0:ic)
        ele_meane = meane(0:ic)
        ele_ktparl = ktparl(0:ic)
        ele_ktperp = ktperp(0:ic)
        ele_anis = anis(0:ic)
        ele_trap_density = trap_density(0:ic)
        ele_trap_meane = trap_meane(0:ic)
        ele_max_energy = max_energy(0:ic)
        ele_ux =ux(0:ic)*cm2km
        ele_uy =uy(0:ic)*cm2km
        ele_uz =uz(0:ic)*cm2km
        ele_rchi2 =rchi2(0:ic)
        ele_cdone = 1
    endelse

endif                           ;=========================
;=========================================================

istat = execute('var = '+vstring)

if (istat ne 1) then message, 'Something wrong...'

return
end



