PRO plot_err_loglog,x,y,dy,color

   FOR kk=0,n_elements(x)-1 DO BEGIN
      oplot,[x(kk),x(kk)],[y(kk)-dy(kk),y(kk)+dy(kk)],line=0,color=color
      oplot,[x(kk)-.1*x(kk),x(kk)+.1*x(kk)],[y(kk)-dy(kk),y(kk)-dy(kk)],line=0,color=color
      oplot,[x(kk)-.1*x(kk),x(kk)+.1*x(kk)],[y(kk)+dy(kk),y(kk)+dy(kk)],line=0,color=color
   ENDFOR

END;==================================================================
; Given normalized coordinates, return the coordinates on the
; current plot's axes.  The motivation for this procedure was to
; make a way that annotations could be printed within a plot having
; unknown axes.  We might be missing the simple and obvious way to 
; do this, and if you know it please call us.  
;
; Written by: Jeremy Faden, University of Iowa. 
;             jbf@space-theory.physics.uiowa.edu

function norm_axis, n_coord
  return=fltarr(2)
  return(0)=!x.crange(0)+(!x.crange(1)-!x.crange(0))*n_coord(0)
  return(1)=!y.crange(0)+(!y.crange(1)-!y.crange(0))*n_coord(1)
  
  return, return
end
;=====================================================================

; IDL TOOL NAME:
; faverage_diag3.pro
;
; MANDATORY ARGUMENTS:
;		1st argument:  igstat  =1 means interbox_gain = 1
;                                      =2 means use current interbox_gain
;
; OPTIONAL KEYWORDS:
;
; Output devices
;   /display		; display on screen (default)
;   /print		; create a post-script file AND print at UIowa
;   /ps			; create a post-script file, idl.ps
;   /gif		; create a gif file, idl.gif
;   nwindow=number	; designate an IDL window number other than 0
;
; Energy range
;   e_range=[min,max] 	; Energy range to be plotted in eV
;		(default is whole energy range)
;   /high		; Energy range from 0 to 1000eV, linear scale
;   /noshift		; Don't shift the measurements by the SC potential
;
; History:
;   1st version: 	8/30/96 Written, Pamela Puhl-Quinn
;Recompiled, 10/24/96, ppq
;Recompiled, 12/22/96, ppq  b1_42
;Recompiled, 1/6/97, ppq b1_43
;Recompiled, 3/3/97, ppq b1_43
;Recompiled, 3/7/97, ppq b1_44
;Recompiled, 3/26/97, ppq b1_45
;Level 1 read standard, 4/7/97, ppq
;Combined f_average_plots and f_pitch, 4/8/97, ppq
;Recompiled, 7/28/97, ppq b1_50 - level0 is still usable
;Rewrote for intersweep calibrations, 8/4/97
;Simplified for intersweep calibrations, 8/21/97

;=====================================================================
pro faverage_diag3, igstat,$
                    use_release_dir=use_release_dir,$
                    box_num=box_num,correct=correct,$
                    fn_data=fn_data,$
                    r2_sep=r2_sep,r2_12=r2_12,r2_tog=r2_tog,$
                    scat_temp=scat_temp,scat_flow=scat_flow,$
                    savethis=savethis,$
                    plts_sep=plts_sep,plots_tog=plots_tog,$ ;--------------
                    e_range=e_range,$
                    nwindow=nwindow,$ 
                    display=display, $
                    print=print,ps=ps,$
                    high=high,gif=gif,$
                    noshift=noshift,$
                    p1=p1

   common faverage_diag3_blocks, cigstat,$
    l1_data,mode_info,$
    j_energy,j_type,j_correct,j_box,j_block,$
    minimum_index,sc_potential,sc_pot_status,time,$
    energy,faverage,dfaverage,one_cnt_f,$
    sc_stat_str,sc_pot_str,x_title_str_en,x_title_str_sp,slab

   IF (keyword_set(box_num)) THEN box_num = box_num ELSE box_num = 1
   IF (keyword_set(correct)) THEN correct = correct ELSE correct = 0
   IF (keyword_set(use_release_dir)) THEN BEGIN
      IF (strmid(!path,0,31) EQ '/home/ppq/bigdisk/level1_lib_me') THEN BEGIN
         print, 'Need to reset path to access release directory'
         stop
      ENDIF ELSE BEGIN
         use_release_dir = 1
         use_str = 'Release Direc.'
      ENDELSE
   ENDIF ELSE BEGIN
      use_release_dir = 0
      use_str = 'Calib. Direc.'
   ENDELSE

; Setting/Error handling of the species keywords
   species='elec'
   mass = 9.1e-28
   
   if (keyword_set(print)) then print=1 else print = 0 
   if (keyword_set(ps)) then ps=1 else ps=0
   if (keyword_set(gif)) then gif=1 else gif=0
   
   if (keyword_set(nwindow)) then lwindow = nwindow else lwindow = 0
   
; Convert the date and time string using Jeremy's tool----------------------
   date_in = 960529
   time_in = 0000
   hydra_time_io,date_in,time_in,fyear,fmonth,fday,fhour,fminute,fsecond
   date =  strmid(date_in,2,6)  
;--------------------------------------
   
   datestr=strmid(date,0,2)+'/'+strmid(date,2,2)+'/'+strmid(date,4,2)
   
   print, '	'
   print, 'date = '+date
   print, 'species = '+species
   print, 'igstat: ',igstat
   
; Check to see if l1_data already exists in the buffer for these specs, 
; and if not, then the data has to be read
   
   IF (keyword_set(cigstat)) THEN BEGIN
      IF (igstat EQ cigstat) THEN BEGIN
         print, 'Data already in buffer'
         read = 0
      ENDIF ELSE BEGIN
         print, 'Reading from level1'
         read = 1
      ENDELSE 
   ENDIF ELSE BEGIN
      print, 'Reading from level1'
      read = 1
   ENDELSE
   
   
;**********************READ DATA FROM LEVEL 1***********************
   
; Set floor and max values for both f and counts, and set zero count values
   if (species eq 'elec') then begin
      floor_f = 1.d-31
      max_f	= 1.d-24
      floor_c = 1.d-2
      max_c	= 1.d+4
      zero_f  = 1.d-36
      zero_c  = 1.d-3
   endif else begin
      floor_f = 1.d-30
      max_f	= 1.d-17
      floor_c = 1.d-2
      max_c	= 1.d+3
      zero_f  = 1.d-31
      zero_c  = 1.d-3
   endelse
   
   
   IF (read EQ 1) THEN BEGIN 
      
      faverage_l1_diag3,date,l1_data,mode_info,igstat,use_release_dir
      
; Set the value of cdate in the buffer in order to access the
; buffered data on subsequent calls to this procedure without having
; to read the data in from a file every time
      print, 'Set buffer variables...'
      cigstat = igstat
      
      IF (keyword_set(savethis)) THEN BEGIN 
         save,l1_data,mode_info,filename=date+'data_ig'+string(igstat,'(i2.2)')+'.idlsav'
      ENDIF

      j_energy = 16
      j_type = 4
      j_correct = 2
      j_box = 2
      j_block=n_elements(l1_data)
      
; Declare array dimension/types
      minimum_index = intarr(j_type,j_correct,j_box,j_block)
      sc_potential = fltarr(j_block)
      sc_pot_status = intarr(j_block)
      time   = dblarr(j_block)
      
      energy   = dblarr(j_type,j_correct,j_box,j_energy,j_block)
      faverage   = dblarr(j_type,j_correct,j_box,j_energy,j_block)
      dfaverage = dblarr(j_type,j_correct,j_box,j_energy,j_block)
      one_cnt_f = dblarr(j_type,j_correct,j_box,j_energy,j_block)
      
; Define the arrays
      minimum_index = l1_data.min_index
      sc_potential = l1_data.sc_potential
      sc_pot_status = l1_data.sc_potential_stat
      time=l1_data.time/3600.
      
      energy=l1_data.energy
      faverage=l1_data.faverage
      dfaverage = l1_data.dfaverage
      one_cnt_f=l1_data.onef
      
; Handle zero counts (set equal to zero_f instead because of log graphs)
      
      zeros = where(faverage eq 0)
      if (zeros(0) ne -1) then begin
         faverage(zeros) = zero_f
      endif
      
      
; Determine labels for the graphs
      sc_stat_str = strarr(j_block)
      sc_pot_str = strarr(j_block)
      x_title_str_en = strarr(j_block)
      x_title_str_sp = strarr(j_block)
      for i=0,j_block-1 do begin
         if (sc_pot_status(i) eq 0) then begin
            sc_stat_str(i) = '(Unknown)'
            x_title_str_en(i) = 'Observed Energy'
            x_title_str_sp(i) = 'Observed Speed'
            sc_pot_str(i) = ' '
         endif else if (sc_pot_status(i) eq 1) then begin
            sc_stat_str(i) = '(EFI exact)'
            if (keyword_set(noshift)) then begin
               x_title_str_en(i) = 'Observed Energy'
               x_title_str_sp(i) = 'Observed Energy'
            endif else begin
               x_title_str_en(i) = 'Debye Sphere Energy'
               x_title_str_sp(i) = 'Debye Sphere Speed'
            endelse
            sc_pot_str(i) = string(sc_potential(i),format='(f5.1)')+'V'
         endif else if (sc_pot_status(i) eq 2) then begin
            sc_stat_str(i) = '(EFI + 2V)'
            if (keyword_set(noshift)) then begin
               x_title_str_en(i) = 'Observed Energy'
               x_title_str_sp(i) = 'Observed Energy'
            endif else begin
               x_title_str_en(i) = 'Debye Sphere Energy'
               x_title_str_sp(i) = 'Debye Sphere Speed'
            endelse
            sc_pot_str(i) = string(sc_potential(i),format='(f5.1)')+'V'
         endif
      endfor
      
      
; Conform with level0
      j_block = j_block-1
      
      slab = ' Version 1, l1lib_ver= '+strtrim(mode_info.footprint.l1lib_version,2) $
       + ' ,l1_ver= '+ strtrim(mode_info.footprint.l1_version,2) $
       + ' ,hydlib_ver= '+ strtrim(mode_info.footprint.hydralib_version,2) $
       + ' ,'+use_str
      
   ENDIF
;*********************************END READ*************************
end_read:

   slab = ' Version 1, l1lib_ver= '+strtrim(mode_info.footprint.l1lib_version,2) $
    + ' ,l1_ver= '+ strtrim(mode_info.footprint.l1_version,2) $
    + ' ,hydlib_ver= '+ strtrim(mode_info.footprint.hydralib_version,2) $
    + ' ,' + use_str
   
; Set character size for display (which changes for print/ps)
   outs_size = 1
   plt_size = 1.75
   
   if (print EQ 1 or ps EQ 1) then begin
      set_ps, orient='L',/color
      outs_size=.6
      plt_size = 1.25
   endif
   
   !p.background = 234
   !p.color = 0
   !p.font = -1
   
;======================PLOTTING STATMENTS===================
IF (keyword_set(plts_sep)) THEN BEGIN 
   
   icorrect = correct
   ibox =  box_num-1

   istart(0) = 0
   istop(0) = n_elements(time)-1
   j_time = istop(0)-istart(0)+1

   print, '	'
   print, 'plotting <f> time-series...'
   if (print eq 0 and ps eq 0) then $
     window,lwindow,xsize=950,ysize=850,title='Press any key to see next page'

   set_page, nh=3, nv=2

   charge=-1

   en_temp = fltarr(j_type,j_energy,j_time)
   f_temp = fltarr(j_type,j_energy,j_time)
   scpot = fltarr(j_time)
   
   if (keyword_set(noshift)) then BEGIN
      ii = -1
      for jj = istart(0),istop(0) do BEGIN
         ii = ii+1
         if (sc_pot_status(jj) ne 0) then begin
            en_temp(*,*,ii) = reform(energy(*,icorrect,ibox,*,jj)- $
             charge*sc_potential(jj))
         endif else begin
            en_temp(*,*,ii) = reform(energy(*,icorrect,ibox,*,jj))
         endelse
      endfor
   endif else begin
      en_temp = reform(energy(*,icorrect,ibox,*,istart(0):istop(0)))
   ENDELSE

   f_temp = reform(faverage(*,icorrect,ibox,*,istart(0):istop(0)))

   if (keyword_set(high)) then begin
      max_x = 1000.
      min_x = 0.  
      x_unit_str = ' [eV]'
      scpot = sc_potential(istart(0):istop(0))
      kw = {ylog:1,xrange:[min_x,max_x],yrange:[floor_f,max_f], $
            ystyle:1,xstyle:1,ytickformat:'(e8.1)',$
            ytitle:'!5<f> [cm!u-6!ns!u3!n]',charsize:plt_size,$
            psym:-2,symsize:.6}
   endif else if (keyword_set(e_range)) then begin
      en_temp = en_temp*1.d-3   ;eV to keV
      scpot = sc_potential(istart(0):istop(0))*1.d-3
      max_x = e_range(1)*1.e-3  ;keV
      min_x = e_range(0)*1.e-3  ;keV
      x_unit_str = ' [keV]'
      kw = {ylog:1,xlog:1,xrange:[min_x,max_x],yrange:[floor_f,max_f], $
            ystyle:1,xstyle:1,ytickformat:'(e8.1)',$
            ytitle:'!5<f> [cm!u-6!ns!u3!n]',charsize:plt_size,$
            psym:-2,symsize:.6}
   endif else begin
      en_temp = en_temp*1.d-3   ;eV to keV
      scpot = sc_potential(istart(0):istop(0))*1.d-3
      max_x = max(en_temp)
      min_x = min(en_temp(where(en_temp gt 0)))
      x_unit_str = ' [keV]'
      kw = {ylog:1,xlog:1,xrange:[min_x,max_x],yrange:[floor_f,max_f], $
            ystyle:1,xstyle:1,ytickformat:'(e8.1)',$
            ytitle:'!5<f> [cm!u-6!ns!u3!n]',charsize:plt_size,$
            psym:-2,symsize:.6}
   ENDELSE
   
   
;  Dimension the xyouts annotation position vectors
   outs1 = fltarr(2)
   outs2 = fltarr(2)
   outs3 = fltarr(2)
   outs4 = fltarr(2)
   outs5 = fltarr(2)
   outs_eol = float(0.)
   
   for i=0,j_time-1 do BEGIN

      jj = istart(0)+i
      
      pos_pos=where(en_temp(0,*,i) gt 0 and en_temp(0,*,i) le max_x AND f_temp(0,*,i) GT 0)
      plot,en_temp(0,pos_pos,i),f_temp(0,pos_pos,i),$
       _extra = kw,xtitle = x_title_str_en(jj)+x_unit_str
      
      FOR itype= 1, 3 DO BEGIN 
         pos_pos=where(en_temp(itype,*,i) gt 0 and en_temp(itype,*,i) le max_x AND f_temp(itype,*,i) GT 0)
         oplot,en_temp(itype,pos_pos,i),f_temp(itype,pos_pos,i),psym=-(itype+3),symsize=.6
      ENDFOR
      
      IF (keyword_set(noshift)) THEN BEGIN 
         oplot,[scpot(i),scpot(i)],[floor_f,max_f],line=3
      ENDIF            
      
;  Form the time string
      hour_block=long(time(jj))
      minute_block=long((time(jj)-long(time(jj)))*60.)
      second_block=long(((time(jj)-long(time(jj)))*60.   $
                         -minute_block)*60.)
      
      hour_string=string(hour_block,'(i2.2)')
      minute_string=string(minute_block,'(i2.2)')
      second_string=string(second_block,'(i2.2)')
      timestring=hour_string+':'+minute_string+':'+second_string
      
;  Annotation:
;  Set the normalized position vectors for the xyouts annotation
;  (This only needs to be done once, but must be done after the
;  first plot call so that !x.crange and !y.crange are correct)
      
      if (i eq 0) then begin
         if (keyword_set(high)) then begin
            outs1 = norm_axis([.5,.9])
            outs1(1) = 10.^outs1(1)
            outs2 = norm_axis([.5,.85])
            outs2(1) = 10.^outs2(1)
            outs3 = norm_axis([.5,.8])
            outs3(1) = 10.^outs3(1)
            outs4 = norm_axis([.5,.75])
            outs4(1) = 10.^outs4(1)
            outs5 = norm_axis([.5,.7])
            outs_eol = .6*max_x
            outs5(1) = 10.^outs5(1)
         endif else begin
            outs1 = norm_axis([.5,.9])
            outs1 = 10.^outs1
            outs2 = norm_axis([.5,.85])
            outs2 = 10.^outs2
            outs3 = norm_axis([.5,.8])
            outs3 = 10.^outs3
            outs4 = norm_axis([.5,.75])
            outs4 = 10.^outs4
            outs5 = norm_axis([.5,.7])
            outs_eol = 10.^(outs5(0)+.6)
            outs5 = 10.^outs5
         endelse
      endif 
      xyouts, outs1(0), outs1(1), $
       datestr+' , '+species,charsize=outs_size
      xyouts, outs2(0), outs2(1), $
       'UT='+timestring, $
       charsize=outs_size
      xyouts, outs3(0), outs3(1), $
       '!7U!5!dsc!n='+sc_pot_str(jj)+'  '+sc_stat_str(jj),$
       charsize=outs_size
      xyouts, outs4(0), outs4(1), $
       'Correct: ' + string(correct,'(i2)'), $
       charsize=outs_size
      xyouts, outs5(0), outs5(1), $
       'Box (1=odd, 2=even): ' + string(box_num,'(i2)'), $
       charsize=outs_size
      
      label_page,side_label=slab
      IF (print NE 1) THEN BEGIN
         print, 'Press any key to see next page'
         res = get_kbrd(1)
      ENDIF

   ENDFOR

ENDIF
;--------------------------------------------------------------------
IF (keyword_set(plots_tog)) THEN BEGIN 
; Create an 11-element color table
; color = 0 is black
; color = 1 is white
; color = 2 is grey
; color = 3 is green
; color = 4 is dark blue
; color = 5 is red
; color = 6 is purple
; color = 7 is orange
; color = 8 is rust
; color = 9 is hunter green
; color = 10 is hot pink

red=  [0, 255, 153, 0,   0,   255, 88,  255, 131, 0,   243]
green=[0, 255, 153, 255, 0,   0,   0,   178, 20 , 147, 0  ]
blue= [0, 255, 153, 0,   255, 0,   132, 0,   46 , 37,  191]
tvlct,red,green,blue

!p.background=1
!p.color=0
   
   icorrect = correct

   istart = lonarr(3)
   istop = lonarr(3)
   istart(0) = 0
   istop(0) = n_elements(time)-1
   j_time = n_elements(time)

   print, '	'
   print, 'plotting <f> time-series...'
   if (print eq 0 and ps eq 0) then $
     window,lwindow,xsize=950,ysize=850,title='Press any key to see next page'

   set_page, nh=1, nv=1
   symtype = [-2,-4,-5,-6]

   charge=-1

   en_temp = fltarr(j_type,j_box,j_energy,j_time)
   f_temp = fltarr(j_type,j_box,j_energy,j_time)
   df_temp = fltarr(j_type,j_box,j_energy,j_time)
   scpot = fltarr(j_time)
   
   if (keyword_set(noshift)) then BEGIN
      ii = -1
      for jj = istart(0),istop(0) do BEGIN
         ii = ii+1
         if (sc_pot_status(jj) ne 0) then begin
            en_temp(*,*,*,ii) = reform(energy(*,icorrect,*,*,jj)- $
             charge*sc_potential(jj))
         endif else begin
            en_temp(*,*,*,ii) = reform(energy(*,icorrect,*,*,jj))
         endelse
      endfor
   endif else begin
      en_temp = reform(energy(*,icorrect,*,*,istart(0):istop(0)))
   ENDELSE

   f_temp = reform(faverage(*,icorrect,*,*,istart(0):istop(0)))
   df_temp =reform(dfaverage(*,icorrect,*,*,istart(0):istop(0)))

   if (keyword_set(high)) then begin
      max_x = 1000.
      min_x = 0.  
      x_unit_str = ' [eV]'
      scpot = sc_potential(istart(0):istop(0))
      kw = {ylog:1,xrange:[min_x,max_x],yrange:[floor_f,max_f], $
            ystyle:1,xstyle:1,ytickformat:'(e8.1)',$
            ytitle:'!5<f> [cm!u-6!ns!u3!n]',charsize:plt_size,$
            psym:symtype(0),symsize:.6}
   endif else if (keyword_set(e_range)) then begin
      en_temp = en_temp*1.d-3   ;eV to keV
      scpot = sc_potential(istart(0):istop(0))*1.d-3
      max_x = e_range(1)*1.e-3  ;keV
      min_x = e_range(0)*1.e-3  ;keV
      x_unit_str = ' [keV]'
      kw = {ylog:1,xlog:1,xrange:[min_x,max_x],yrange:[floor_f,max_f], $
            ystyle:1,xstyle:1,ytickformat:'(e8.1)',$
            ytitle:'!5<f> [cm!u-6!ns!u3!n]',charsize:plt_size,$
            psym:symtype(0),symsize:.6}
   endif else begin
      en_temp = en_temp*1.d-3   ;eV to keV
      scpot = sc_potential(istart(0):istop(0))*1.d-3
      max_x = max(en_temp)
      min_x = min(en_temp(where(en_temp gt 0)))
      x_unit_str = ' [keV]'
      kw = {ylog:1,xlog:1,xrange:[min_x,max_x],yrange:[floor_f,max_f], $
            ystyle:1,xstyle:1,ytickformat:'(e8.1)',$
            ytitle:'!5<f> [cm!u-6!ns!u3!n]',charsize:plt_size,$
            psym:symtype(0),symsize:.6}
   ENDELSE
   
   
;  Dimension the xyouts annotation position vectors
   outs1 = fltarr(2)
   outs2 = fltarr(2)
   outs3 = fltarr(2)
   outs4 = fltarr(2)
   outs5 = fltarr(2)
   outs6 = fltarr(2)
   
;   FOR i=0,0 DO BEGIN 
   for i=0,j_time-1 do BEGIN

      jj = istart(0)+i
      
      pos_pos=where(en_temp(0,1,*,i) gt 0 and en_temp(0,1,*,i) le max_x AND f_temp(0,1,*,i) GT 0)
      IF (pos_pos(0) EQ -1) THEN GOTO, next_plot

      x = reform(en_temp(0,1,pos_pos,i))
      y = reform(f_temp(0,1,pos_pos,i))
      dy = reform(df_temp(0,1,pos_pos,i))
      plot,x,y,$
       _extra = kw,xtitle = x_title_str_en(jj)+x_unit_str
      plot_err_loglog,x,y,dy,0
      
; Even box...
      FOR itype= 1, 3 DO BEGIN
         pos_pos=where(en_temp(itype,1,*,i) gt 0 and en_temp(itype,1,*,i) le max_x AND f_temp(itype,1,*,i) GT 0)
         IF (pos_pos(0) EQ -1) THEN GOTO, next_oplot_even
         x = reform(en_temp(itype,1,pos_pos,i))
         y = reform(f_temp(itype,1,pos_pos,i))
         dy = reform(df_temp(itype,1,pos_pos,i))
         oplot,x,y,psym=symtype(itype),symsize=.6,color=9
         plot_err_loglog,x,y,dy,9
         next_oplot_even:
      ENDFOR


; Odd box...
      FOR itype= 0, 3 DO BEGIN 
         pos_pos=where(en_temp(itype,0,*,i) gt 0 and en_temp(itype,0,*,i) le max_x AND f_temp(itype,0,*,i) GT 0)
         IF (pos_pos(0) EQ -1) THEN GOTO, next_oplot_odd
         x = reform(en_temp(itype,0,pos_pos,i))
         y = reform(f_temp(itype,0,pos_pos,i))
         dy = reform(df_temp(itype,0,pos_pos,i))
         oplot,x,y,psym=symtype(itype),symsize=.6,color=10
         plot_err_loglog,x,y,dy,10
         next_oplot_odd:
      ENDFOR
      
      IF (keyword_set(noshift)) THEN BEGIN 
         oplot,[scpot(i),scpot(i)],[floor_f,max_f],line=3
      ENDIF            
      
;  Form the time string
      hour_block=long(time(jj))
      minute_block=long((time(jj)-long(time(jj)))*60.)
      second_block=long(((time(jj)-long(time(jj)))*60.   $
                         -minute_block)*60.)
      
      hour_string=string(hour_block,'(i2.2)')
      minute_string=string(minute_block,'(i2.2)')
      second_string=string(second_block,'(i2.2)')
      timestring=hour_string+':'+minute_string+':'+second_string
      
;  Annotation:
;  Set the normalized position vectors for the xyouts annotation
;  (This only needs to be done once, but must be done after the
;  first plot call so that !x.crange and !y.crange are correct)
      
      if (i eq 0) then begin
         if (keyword_set(high)) then begin
            outs1 = norm_axis([.75,.9])
            outs1(1) = 10.^outs1(1)
            outs2 = norm_axis([.75,.85])
            outs2(1) = 10.^outs2(1)
            outs3 = norm_axis([.75,.8])
            outs3(1) = 10.^outs3(1)
            outs4 = norm_axis([.75,.75])
            outs4(1) = 10.^outs4(1)
            outs5 = norm_axis([.75,.7])
            outs5(1) = 10.^outs5(1)
            outs6 = norm_axis([.5,.65])
            outs6(1) = 10.^outs6(1)
         endif else begin
            outs1 = norm_axis([.75,.9])
            outs1 = 10.^outs1
            outs2 = norm_axis([.75,.85])
            outs2 = 10.^outs2
            outs3 = norm_axis([.75,.8])
            outs3 = 10.^outs3
            outs4 = norm_axis([.75,.75])
            outs4 = 10.^outs4
            outs5 = norm_axis([.75,.7])
            outs5 = 10.^outs5
            outs6 = norm_axis([.75,.65])
            outs6 = 10.^outs6
         endelse
      endif 
      xyouts, outs1(0), outs1(1), $
       datestr+' , '+species,charsize=outs_size
      xyouts, outs2(0), outs2(1), $
       'UT='+timestring, $
       charsize=outs_size
      xyouts, outs3(0), outs3(1), $
       '!7U!5!dsc!n='+sc_pot_str(jj)+'  '+sc_stat_str(jj),$
       charsize=outs_size
      xyouts, outs4(0), outs4(1), $
       'Correct: ' + string(correct,'(i2)'), $
       charsize=outs_size
      xyouts, outs5(0), outs5(1), $
       'Bx1:pnk Bx2:grn', $
       charsize=outs_size
      xyouts, outs6(0), outs6(1), $
       'igstat: ' + string(igstat,'(i2)'), $
       charsize=outs_size
      
      label_page,side_label=slab
      IF (print NE 1) THEN BEGIN
         print, 'Press any key to see next page'
         res = get_kbrd(1)
      ENDIF

      next_plot:

   ENDFOR

ENDIF
;--------------------------------------------------------------------
IF (keyword_set(p1)) THEN BEGIN 
; Create an 11-element color table
; color = 0 is black
; color = 1 is white
; color = 2 is grey
; color = 3 is green
; color = 4 is dark blue
; color = 5 is red
; color = 6 is purple
; color = 7 is orange
; color = 8 is rust
; color = 9 is hunter green
; color = 10 is hot pink

red=  [0, 255, 153, 0,   0,   255, 88,  255, 131, 0,   243]
green=[0, 255, 153, 255, 0,   0,   0,   178, 20 , 147, 0  ]
blue= [0, 255, 153, 0,   255, 0,   132, 0,   46 , 37,  191]
tvlct,red,green,blue

!p.background=1
!p.color=0

typestr = ['1x Up','1x Dn','2x Up','2x Dn']
symtype = [-3,-3,-3,-3]
   
   icorrect = correct

   istart = lonarr(3)
   istop = lonarr(3)
   istart(0) = 0
   istop(0) = n_elements(time)-1
   j_time = n_elements(time)

   print, '	'
   print, 'plotting <f> time-series...'
   if (print eq 0 and ps eq 0) then $
     window,lwindow,xsize=950,ysize=850,title='Press any key to see next page'

;   set_page, nh=4, nv=2
   !p.multi = [0,4,2]
   charge=-1

   en_temp = fltarr(j_type,j_box,j_energy,j_time)
   f_temp = fltarr(j_type,j_box,j_energy,j_time)
   df_temp = fltarr(j_type,j_box,j_energy,j_time)
   scpot = fltarr(j_time)
   
   if (keyword_set(noshift)) then BEGIN
      ii = -1
      for jj = istart(0),istop(0) do BEGIN
         ii = ii+1
         if (sc_pot_status(jj) ne 0) then begin
            en_temp(*,*,*,ii) = reform(energy(*,icorrect,*,*,jj)- $
             charge*sc_potential(jj))
         endif else begin
            en_temp(*,*,*,ii) = reform(energy(*,icorrect,*,*,jj))
         endelse
      endfor
   endif else begin
      en_temp = reform(energy(*,icorrect,*,*,istart(0):istop(0)))
   ENDELSE

   f_temp = reform(faverage(*,icorrect,*,*,istart(0):istop(0)))
   df_temp = reform(dfaverage(*,icorrect,*,*,istart(0):istop(0)))

   if (keyword_set(high)) then begin
      max_x = 1000.
      min_x = 0.  
      x_unit_str = ' [eV]'
      scpot = sc_potential(istart(0):istop(0))
      kw = {xlog:1,ylog:1,xrange:[min_x,max_x],yrange:[floor_f,max_f], $
            ystyle:1,xstyle:1,ytickformat:'(e8.1)',$
            ytitle:'!5<f> [cm!u-6!ns!u3!n]',charsize:plt_size,$
            psym:symtype(0),symsize:.6}
   endif else if (keyword_set(e_range)) then begin
      en_temp = en_temp*1.d-3   ;eV to keV
      scpot = sc_potential(istart(0):istop(0))*1.d-3
      max_x = e_range(1)*1.e-3  ;keV
      min_x = e_range(0)*1.e-3  ;keV
      x_unit_str = ' [keV]'
      kw = {xlog:1,ylog:1,xrange:[min_x,max_x],yrange:[floor_f,max_f], $
            ystyle:1,xstyle:1,ytickformat:'(e8.1)',$
            ytitle:'!5<f> [cm!u-6!ns!u3!n]',charsize:plt_size,$
            psym:symtype(0),symsize:.6}
   endif else begin
      en_temp = en_temp*1.d-3   ;eV to keV
      scpot = sc_potential(istart(0):istop(0))*1.d-3
      max_x = max(en_temp)
      min_x = min(en_temp(where(en_temp gt 0)))
      x_unit_str = ' [keV]'
      kw = {xlog:1,ylog:1,xrange:[min_x,max_x],yrange:[floor_f,max_f], $
            ystyle:1,xstyle:1,ytickformat:'(e8.1)',$
            ytitle:'!5<f> [cm!u-6!ns!u3!n]',charsize:plt_size,$
            psym:symtype(0),symsize:.6}
   ENDELSE
   
   
;  Dimension the xyouts annotation position vectors
   outs1 = fltarr(2)
   outs2 = fltarr(2)
   outs3 = fltarr(2)
   outs4 = fltarr(2)
   outs5 = fltarr(2)
   outs6 = fltarr(2)
   
   for i=0,j_time-1 do BEGIN

      jj = istart(0)+i

;      print, 'i,jj',i,jj
      
; Reference curve with all the relevant info
      pos_pos=where(en_temp(0,1,*,i) gt 0 and en_temp(0,1,*,i) le max_x AND f_temp(0,1,*,i) GT 0)
      x = en_temp(0,1,pos_pos,i)
      y = f_temp(0,1,pos_pos,i)
      dy = df_temp(0,1,pos_pos,i)
      plot,x,y,_extra = kw,xtitle = x_title_str_en(jj)+x_unit_str
      plot_err_loglog,x,y,dy,0

      IF (keyword_set(noshift)) THEN BEGIN 
         oplot,[scpot(i),scpot(i)],[floor_f,max_f],line=3
      ENDIF            
      
;  Form the time string
      hour_block=long(time(jj))
      minute_block=long((time(jj)-long(time(jj)))*60.)
      second_block=long(((time(jj)-long(time(jj)))*60.   $
                         -minute_block)*60.)
      
      hour_string=string(hour_block,'(i2.2)')
      minute_string=string(minute_block,'(i2.2)')
      second_string=string(second_block,'(i2.2)')
      timestring=hour_string+':'+minute_string+':'+second_string
      
;  Annotation:
;  Set the normalized position vectors for the xyouts annotation
;  (This only needs to be done once, but must be done after the
;  first plot call so that !x.crange and !y.crange are correct)
      
      if (i eq 0) then begin
         if (keyword_set(high)) then begin
            outs1 = norm_axis([.5,.9])
            outs1(1) = 10.^outs1(1)
            outs2 = norm_axis([.5,.85])
            outs2(1) = 10.^outs2(1)
            outs3 = norm_axis([.5,.8])
            outs3(1) = 10.^outs3(1)
            outs4 = norm_axis([.5,.75])
            outs4(1) = 10.^outs4(1)
            outs5 = norm_axis([.5,.7])
            outs5(1) = 10.^outs5(1)
            outs6 = norm_axis([.5,.65])
            outs6(1) = 10.^outs6(1)
         endif else begin
            outs1 = norm_axis([.5,.9])
            outs1 = 10.^outs1
            outs2 = norm_axis([.5,.85])
            outs2 = 10.^outs2
            outs3 = norm_axis([.5,.8])
            outs3 = 10.^outs3
            outs4 = norm_axis([.5,.75])
            outs4 = 10.^outs4
            outs5 = norm_axis([.5,.7])
            outs5 = 10.^outs5
            outs6 = norm_axis([.5,.65])
            outs6 = 10.^outs6
         endelse
      endif 
      xyouts, outs1(0), outs1(1), $
       datestr+' , '+species,charsize=outs_size
      xyouts, outs2(0), outs2(1), $
       'UT='+timestring, $
       charsize=outs_size
      xyouts, outs3(0), outs3(1), $
       '!7U!5!dsc!n='+sc_pot_str(jj)+'  '+sc_stat_str(jj),$
       charsize=outs_size
      xyouts, outs4(0), outs4(1), $
       'Correct: ' + string(correct,'(i2)'), $
       charsize=outs_size
      xyouts, outs5(0), outs5(1), $
       'Box2, '+typestr(0), $
       charsize=outs_size
      xyouts, outs6(0), outs6(1), $
       'igstat: ' + string(igstat,'(i2)'), $
       charsize=outs_size

; Even box...
      FOR itype= 1, 3 DO BEGIN 
         
         pos_pos=where(en_temp(0,1,*,i) gt 0 and en_temp(0,1,*,i) le max_x AND f_temp(0,1,*,i) GT 0)
         x = en_temp(0,1,pos_pos,i)
         y = f_temp(0,1,pos_pos,i)
         dy = df_temp(0,1,pos_pos,i)
         plot,x,y,_extra = kw,xtitle = x_title_str_en(jj)+x_unit_str
         plot_err_loglog,x,y,dy,0
         
         pos_pos=where(en_temp(itype,1,*,i) gt 0 and en_temp(itype,1,*,i) le max_x AND f_temp(itype,1,*,i) GT 0)
         x = en_temp(itype,1,pos_pos,i)
         y = f_temp(itype,1,pos_pos,i)
         dy = df_temp(itype,1,pos_pos,i)
         oplot,x,y,psym=symtype(itype),symsize=.6,color=9
         plot_err_loglog,x,y,dy,9

         xyouts, outs5(0), outs5(1), $
          'Box2, '+typestr(itype), $
          charsize=outs_size

      ENDFOR


; Odd box...
      FOR itype= 0, 3 DO BEGIN 
         
         pos_pos=where(en_temp(0,1,*,i) gt 0 and en_temp(0,1,*,i) le max_x AND f_temp(0,1,*,i) GT 0)
         x = en_temp(0,1,pos_pos,i)
         y = f_temp(0,1,pos_pos,i)
         dy = df_temp(0,1,pos_pos,i)
         plot,x,y,_extra = kw,xtitle = x_title_str_en(jj)+x_unit_str
         plot_err_loglog,x,y,dy,0

         pos_pos=where(en_temp(itype,0,*,i) gt 0 and en_temp(itype,0,*,i) le max_x AND f_temp(itype,0,*,i) GT 0)
         x = en_temp(itype,0,pos_pos,i)
         y = f_temp(itype,0,pos_pos,i)
         dy = df_temp(itype,0,pos_pos,i)
         oplot,x,y,psym=symtype(itype),symsize=.6,color=10
         plot_err_loglog,x,y,dy,10

         xyouts, outs5(0), outs5(1), $
          'Box1, '+typestr(itype), $
          charsize=outs_size

      ENDFOR
      
      label_page,side_label=slab
      IF (print NE 1 and ps NE 1) THEN BEGIN
         print, 'Press any key to see next page'
         res = get_kbrd(1)
      ENDIF

   ENDFOR

ENDIF
;---------------------------------------------------------------

IF (keyword_set(r2_sep)) THEN BEGIN

   rchi2 = fltarr(2,2,2000)
   time_rchi2 = fltarr(2000)
   
   
   FOR icorrect= 0,1 DO BEGIN 
      FOR ibox= 0,1 DO BEGIN 
         FOR itime= 0,n_elements(time)-1 DO BEGIN

            IF (sc_pot_status(itime) EQ 0) THEN GOTO, jump_out
            
            pos_pos=where(energy(0,icorrect,ibox,*,itime) gt 0 AND faverage(0,icorrect,ibox,*,itime) GT 0)
; Need to have at least three points for the spline!
            IF (n_elements(pos_pos) LT 3) THEN GOTO, jump_out

            y = alog(faverage(0,icorrect,ibox,pos_pos,itime))
            x = energy(0,icorrect,ibox,pos_pos,itime)

            y = reform(y)
            x = reform(x)

            n = n_elements(x)
            yp0 = (y(1)-y(0))/(x(1)-x(0))
            ypn_1 = (y(n-1)-y(n-2))/(x(n-1)-x(n-2))
            secder = spl_init(x,y,yp0=yp0,ypn_1=ypn_1)
            
            max_x = max(x)
            min_x = min(x)
            max_y = max(y)
            min_y = min(y)
            kw = {xlog:1,$
                  ytickformat:'(e8.1)',$
                  ytitle:'!5<f> [cm!u-6!ns!u3!n]',charsize:plt_size,$
                  psym:-2,symsize:.6}
            
            
; Using 1x, Up for the reference, spline-interpolate the others
            
            pos_pos1=where(energy(1,icorrect,ibox,*,itime) gt 0 $
                           AND energy(1,icorrect,ibox,*,itime) LE x(n-1) $
                           AND faverage(1,icorrect,ibox,*,itime) GT 0)
            IF (n_elements(pos_pos1) LT 2) THEN GOTO, jump_out
; Sort the energy array (carry along faverage and dfaverage too)!
            sorted = sort(energy(1,icorrect,ibox,pos_pos1,itime))
            t1 = reform(energy(1,icorrect,ibox,pos_pos1(sorted),itime))
            v1 = reform(faverage(1,icorrect,ibox,pos_pos1(sorted),itime))
            w1 = reform(dfaverage(1,icorrect,ibox,pos_pos1(sorted),itime))
            spliners1 = spl_interp(x,y,secder,t1)
            
            pos_pos2=where(energy(2,icorrect,ibox,*,itime) gt 0 $
                           AND energy(2,icorrect,ibox,*,itime) LE x(n-1) $
                           AND faverage(2,icorrect,ibox,*,itime) GT 0)
            IF (n_elements(pos_pos2) LT 2) THEN GOTO, jump_out
; Sort the energy array (carry along faverage and dfaverage too)!
            sorted = sort(energy(2,icorrect,ibox,pos_pos2,itime))
            t2 = reform(energy(2,icorrect,ibox,pos_pos2(sorted),itime))
            v2 = reform(faverage(2,icorrect,ibox,pos_pos2(sorted),itime))
            w2 = reform(dfaverage(2,icorrect,ibox,pos_pos2(sorted),itime))
            spliners2 = spl_interp(x,y,secder,t2)
            
            pos_pos3=where(energy(3,icorrect,ibox,*,itime) gt 0 $
                           AND energy(3,icorrect,ibox,*,itime) LE x(n-1) $
                           AND faverage(3,icorrect,ibox,*,itime) GT 0)
            IF (n_elements(pos_pos3) LT 2) THEN GOTO, jump_out
; Sort the energy array (carry along faverage and dfaverage too)!
            sorted = sort(energy(3,icorrect,ibox,pos_pos3,itime))
            t3 = reform(energy(3,icorrect,ibox,pos_pos3(sorted),itime))
            v3 = reform(faverage(3,icorrect,ibox,pos_pos3(sorted),itime))
            w3 = reform(dfaverage(3,icorrect,ibox,pos_pos3(sorted),itime))
            spliners3 = spl_interp(x,y,secder,t3)
            
;   plot,x,y,_extra=kw,xrange=[min([x,t1,t2,t3]),max([x,t1,t2,t3])],yrange=[min([y,spliners1,spliners2,spliners3]),max([y,spliners1,spliners2,spliners3])]
;   oplot,[x(0),x(0)],[-100,100],line=3
;   oplot,[x(n-1),x(n-1)],[-100,100],line=3
;   oplot,t1,spliners1,psym=-4,symsize=.6
;   oplot,t2,spliners2,psym=-5,symsize=.6
;   oplot,t3,spliners3,psym=-6,symsize=.6
;   plot,x,secder,xrange=[min([x,t1,t2,t3]),max([x,t1,t2,t3])],psym=-2,symsize=.6,/xlog,charsize=plt_size
;   res = get_kbrd(1)
            
; Find the rchi2 for this block
            sigma1 = w1/v1
            sigma2 = w2/v2
            sigma3 = w3/v3
            
            sum = 0.
            sum = sum + total( ( (alog(v1) - spliners1)/sigma1 )^2  )
            sum = sum + total( ( (alog(v2) - spliners2)/sigma2 )^2  )
            sum = sum + total( ( (alog(v3) - spliners3)/sigma3 )^2  )
            
            time_rchi2(itime) = time(itime)
            rchi2(icorrect,ibox,itime) = sum/float( $
                                                   n_elements(pos_pos1)+ $
                                                   n_elements(pos_pos2)+ $
                                                   n_elements(pos_pos3) )
            GOTO, other_side
            
jump_out:
            time_rchi2(itime) = time(itime)
            rchi2(icorrect,ibox,itime) = -1.e+31
            
other_side:
            
         ENDFOR
      ENDFOR
   ENDFOR
   
   
   rchi2 = rchi2(0:1,0:1,0:n_elements(time)-1)
   time_rchi2 = time_rchi2(0:n_elements(time)-1)

   IF (keyword_set(savethis)) THEN BEGIN 
      save,rchi2,time_rchi2,filename=date+'rchi2_boxes_sep_ig'+string(igstat,'(i2.2)')+'.idlsav'
   ENDIF
   
   !p.multi = [0,1,2]

   
   IF (print NE 1) THEN window,1,xsize=800,ysize=800
   FOR ibox=0,1 DO BEGIN

      good0 =  where(rchi2(0,ibox,*) GT 0)
      good1 = where(rchi2(1,ibox,*) GT 0)
      goodboth =  where(rchi2(0,ibox,*) GT 0 AND rchi2(1,ibox,*) GT 0)

      plot,time_rchi2(goodboth),rchi2(0,ibox,goodboth)-rchi2(1,ibox,goodboth),xtitle='time',title=date+', rchi2_uncorrected - rchi2_corrected, Box='+string(ibox+1,'(i2)')+', igstat='+string(igstat,'(i2)'),symsize=.6,psym=4
      oplot,[0,10],[0,0],line=3      

      plot,time_rchi2(good0),rchi2(0,ibox,good0),psym=-2,xtitle='time',title=date + ',   * = rchi2 uncorrected, + = rchi2 corrected, Box: '+string(ibox+1,'(i2)'),symsize=.6,/ylog,yrange=[1,1000]
      oplot,time_rchi2(good1),rchi2(1,ibox,good1),psym=-1,symsize=.6
      
      label_page,side_label=slab

      IF (print EQ 0) THEN res = get_kbrd(1)
      
   ENDFOR
   
ENDIF

;-----------------------------------------------------------------------
IF (keyword_set(r2_tog)) THEN BEGIN

   rchi2 = fltarr(2,2000)
   time_rchi2 = fltarr(2000)

   !p.multi = [0,1,2]
   
   
   FOR icorrect= 0,1 DO BEGIN 
      FOR itime= 0,n_elements(time)-1 DO BEGIN
         
;         IF (sc_pot_status(itime) EQ 0) THEN GOTO, jump_out5
         
; 1x, Up Box 2 is the reference curve for the splines
         pos_pos=where(energy(0,icorrect,1,*,itime) gt 0 AND faverage(0,icorrect,1,*,itime) GT 0)
; Need to have at least three points for the spline!
         IF (n_elements(pos_pos) LT 3) THEN GOTO, jump_out5
         
         y = alog(faverage(0,icorrect,1,pos_pos,itime))
         x = energy(0,icorrect,1,pos_pos,itime)
         
         y = reform(y)
         x = reform(x)
         
         n = n_elements(x)
         yp0 = (y(1)-y(0))/(x(1)-x(0))
         ypn_1 = (y(n-1)-y(n-2))/(x(n-1)-x(n-2))
         secder = spl_init(x,y,yp0=yp0,ypn_1=ypn_1)
         
         max_x = max(x)
         min_x = min(x)
         max_y = max(y)
         min_y = min(y)
         kw = {xlog:1,$
               ytickformat:'(e8.1)',$
               ytitle:'!5<f> [cm!u-6!ns!u3!n]',charsize:plt_size,$
               psym:-2,symsize:.6}
         
            
; Using 1x, Up Box 2 for the reference, spline-interpolate the others

         ibox = 0
         pos_pos0=where(energy(0,icorrect,ibox,*,itime) gt 0 $
                        AND energy(0,icorrect,ibox,*,itime) LE x(n-1) $
                        AND faverage(0,icorrect,ibox,*,itime) GT 0)
         IF (n_elements(pos_pos0) LT 2) THEN GOTO, jump_out5
; Sort the energy array (carry along faverage and dfaverage too)!
         sorted = sort(energy(0,icorrect,ibox,pos_pos0,itime))
         t0 = reform(energy(0,icorrect,ibox,pos_pos0(sorted),itime))
         v0 = reform(faverage(0,icorrect,ibox,pos_pos0(sorted),itime))
         w0 = reform(dfaverage(0,icorrect,ibox,pos_pos0(sorted),itime))
         spliners0 = spl_interp(x,y,secder,t0)            
         
         pos_pos1=where(energy(1,icorrect,ibox,*,itime) gt 0 $
                        AND energy(1,icorrect,ibox,*,itime) LE x(n-1) $
                        AND faverage(1,icorrect,ibox,*,itime) GT 0)
         IF (n_elements(pos_pos1) LT 2) THEN GOTO, jump_out5
; Sort the energy array (carry along faverage and dfaverage too)!
         sorted = sort(energy(1,icorrect,ibox,pos_pos1,itime))
         t1 = reform(energy(1,icorrect,ibox,pos_pos1(sorted),itime))
         v1 = reform(faverage(1,icorrect,ibox,pos_pos1(sorted),itime))
         w1 = reform(dfaverage(1,icorrect,ibox,pos_pos1(sorted),itime))
         spliners1 = spl_interp(x,y,secder,t1)
         
         pos_pos2=where(energy(2,icorrect,ibox,*,itime) gt 0 $
                        AND energy(2,icorrect,ibox,*,itime) LE x(n-1) $
                        AND faverage(2,icorrect,ibox,*,itime) GT 0)
         IF (n_elements(pos_pos2) LT 2) THEN GOTO, jump_out5
; Sort the energy array (carry along faverage and dfaverage too)!
         sorted = sort(energy(2,icorrect,ibox,pos_pos2,itime))
         t2 = reform(energy(2,icorrect,ibox,pos_pos2(sorted),itime))
         v2 = reform(faverage(2,icorrect,ibox,pos_pos2(sorted),itime))
         w2 = reform(dfaverage(2,icorrect,ibox,pos_pos2(sorted),itime))
         spliners2 = spl_interp(x,y,secder,t2)
         
         pos_pos3=where(energy(3,icorrect,ibox,*,itime) gt 0 $
                        AND energy(3,icorrect,ibox,*,itime) LE x(n-1) $
                        AND faverage(3,icorrect,ibox,*,itime) GT 0)
         IF (n_elements(pos_pos3) LT 2) THEN GOTO, jump_out5
; Sort the energy array (carry along faverage and dfaverage too)!
         sorted = sort(energy(3,icorrect,ibox,pos_pos3,itime))
         t3 = reform(energy(3,icorrect,ibox,pos_pos3(sorted),itime))
         v3 = reform(faverage(3,icorrect,ibox,pos_pos3(sorted),itime))
         w3 = reform(dfaverage(3,icorrect,ibox,pos_pos3(sorted),itime))
         spliners3 = spl_interp(x,y,secder,t3)


         ibox = 1
         pos_pos4=where(energy(1,icorrect,ibox,*,itime) gt 0 $
                        AND energy(1,icorrect,ibox,*,itime) LE x(n-1) $
                        AND faverage(1,icorrect,ibox,*,itime) GT 0)
         IF (n_elements(pos_pos4) LT 2) THEN GOTO, jump_out5
; Sort the energy array (carry along faverage and dfaverage too)!
         sorted = sort(energy(1,icorrect,ibox,pos_pos4,itime))
         t4 = reform(energy(1,icorrect,ibox,pos_pos4(sorted),itime))
         v4 = reform(faverage(1,icorrect,ibox,pos_pos4(sorted),itime))
         w4 = reform(dfaverage(1,icorrect,ibox,pos_pos4(sorted),itime))
         spliners4 = spl_interp(x,y,secder,t4)
         
         pos_pos5=where(energy(2,icorrect,ibox,*,itime) gt 0 $
                        AND energy(2,icorrect,ibox,*,itime) LE x(n-1) $
                        AND faverage(2,icorrect,ibox,*,itime) GT 0)
         IF (n_elements(pos_pos5) LT 2) THEN GOTO, jump_out5
; Sort the energy array (carry along faverage and dfaverage too)!
         sorted = sort(energy(2,icorrect,ibox,pos_pos5,itime))
         t5 = reform(energy(2,icorrect,ibox,pos_pos5(sorted),itime))
         v5 = reform(faverage(2,icorrect,ibox,pos_pos5(sorted),itime))
         w5 = reform(dfaverage(2,icorrect,ibox,pos_pos5(sorted),itime))
         spliners5 = spl_interp(x,y,secder,t5)

         pos_pos6=where(energy(3,icorrect,ibox,*,itime) gt 0 $
                        AND energy(3,icorrect,ibox,*,itime) LE x(n-1) $
                        AND faverage(3,icorrect,ibox,*,itime) GT 0)
         IF (n_elements(pos_pos6) LT 2) THEN GOTO, jump_out5
; Sort the energy array (carry along faverage and dfaverage too)!
         sorted = sort(energy(3,icorrect,ibox,pos_pos6,itime))
         t6 = reform(energy(3,icorrect,ibox,pos_pos6(sorted),itime))
         v6 = reform(faverage(3,icorrect,ibox,pos_pos6(sorted),itime))
         w6 = reform(dfaverage(3,icorrect,ibox,pos_pos6(sorted),itime))
         spliners6 = spl_interp(x,y,secder,t6)
         
         
;         plot,x,y,_extra=kw,xrange=[min([x,t0,t1,t2,t3,t4,t5,t6]),max([x,t0,t1,t2,t3,t4,t5,t6])],yrange=[min([y,spliners0,spliners1,spliners2,spliners3,spliners4,spliners5,spliners6]),max([y,spliners0,spliners1,spliners2,spliners3,spliners4,spliners5,spliners6])]
;         oplot,[x(0),x(0)],[-100,100],line=3
;         oplot,[x(n-1),x(n-1)],[-100,100],line=3
;         oplot,t0,spliners0,psym=-4,symsize=.6
;         oplot,t1,spliners1,psym=-5,symsize=.6
;         oplot,t2,spliners2,psym=-6,symsize=.6
;         oplot,t3,spliners3,psym=-7,symsize=.6
;         oplot,t4,spliners4,psym=-1,symsize=.6
;         oplot,t5,spliners5,psym=-4,symsize=.6
;         oplot,t6,spliners6,psym=-5,symsize=.6
;         
;         plot,x,secder,xrange=[min([x,t0,t1,t2,t3,t4,t5,t6]),max([x,t0,t1,t2,t3,t4,t5,t6])],psym=-2,symsize=.6,/xlog,charsize=plt_size
;         
;         res = get_kbrd(1)
         
; Find the rchi2 for this block
         sigma0 = w0/v0
         sigma1 = w1/v1
         sigma2 = w2/v2
         sigma3 = w3/v3
         sigma4 = w4/v4
         sigma5 = w5/v5
         sigma6 = w6/v6
         
         sum = 0.
         sum = sum + total( ( (alog(v0) - spliners0)/sigma0 )^2  )
         sum = sum + total( ( (alog(v1) - spliners1)/sigma1 )^2  )
         sum = sum + total( ( (alog(v2) - spliners2)/sigma2 )^2  )
         sum = sum + total( ( (alog(v3) - spliners3)/sigma3 )^2  )
         sum = sum + total( ( (alog(v4) - spliners4)/sigma4 )^2  )
         sum = sum + total( ( (alog(v5) - spliners5)/sigma5 )^2  )
         sum = sum + total( ( (alog(v6) - spliners6)/sigma6 )^2  )
         
         time_rchi2(itime) = time(itime)
         rchi2(icorrect,itime) = sum/float( $
                                           n_elements(pos_pos0)+ $
                                           n_elements(pos_pos1)+ $
                                           n_elements(pos_pos2)+ $
                                           n_elements(pos_pos3)+ $
                                           n_elements(pos_pos4)+ $
                                           n_elements(pos_pos5)+ $
                                           n_elements(pos_pos6)  )
         GOTO, other_side5
         
jump_out5:
         time_rchi2(itime) = time(itime)
         rchi2(icorrect,itime) = -1.e+31
         
other_side5:

         
      ENDFOR
   ENDFOR
   
   rchi2 = rchi2(0:1,0:n_elements(time)-1)
   time_rchi2 = time_rchi2(0:n_elements(time)-1)

   IF (keyword_set(savethis)) THEN BEGIN 
      save,rchi2,time_rchi2,filename=date+'rchi2_boxes_tog_ig'+string(igstat,'(i2.2)')+'.idlsav'
   ENDIF

   !p.multi = [0,1,2]
   
   
   IF (print NE 1) THEN window,1,xsize=800,ysize=800
      
   good0 = where(rchi2(0,*) GT 0)
   good1 = where(rchi2(1,*) GT 0)
   goodboth = where(rchi2(0,*) GT 0 AND rchi2(1,*) GT 0)

   plot,time_rchi2(goodboth),rchi2(0,goodboth)-rchi2(1,goodboth),xtitle='time',title=date+', rchi2_uncorrected - rchi2_corrected, Both boxes, igstat='+string(igstat,'(i2)'),symsize=.6,psym=4
   oplot,[0,10],[0,0],line=3
   
   plot,time_rchi2(good0),rchi2(0,good0),psym=-2,xtitle='time',title=date + ',   * = rchi2 uncorrected, + = rchi2 corrected, Both boxes, igstat='+string(igstat,'(i2)'),symsize=.8,/ylog,yrange=[1,1000],ytitle='rchi2'
   oplot,time_rchi2(good1),rchi2(1,good1),psym=-1,symsize=.8
   
   label_page,side_label=slab
      
ENDIF
;-------------------------------------------------------------------
IF (keyword_set(scat_temp)) THEN BEGIN

   fn = '/home/ppq/bigdisk/key_parameters/CDF/lr/source_code/version3code/'+ $
    'po_k0_gsfc_19960529_v03.cdf'
   print, 'Opening file ',fn
   cdfid = CDF_OPEN(fn)
   print, 'cdfid: ',cdfid
   
   CDF_CONTROL, cdfid, var='ELE_AVG_E',get_var_info = vinfo
   ;vinfo.maxrec contains the maximum record number in the CDF file
   cdfnrec = vinfo.maxrec
   
   time_ele = fltarr(cdfnrec+1)
   averageE_ele = fltarr(cdfnrec+1)
   density_ele = fltarr(cdfnrec+1)
 
   CDF_VARGET, cdfid, 'Time_PB5', time_pb5, rec_count = cdfnrec+1
   CDF_VARGET, cdfid, 'ELE_AVG_E', averageE, rec_count = cdfnrec+1
   CDF_VARGET, cdfid, 'ELE_DENSITY', density, rec_count = cdfnrec+1
   
   CDF_CLOSE, cdfid

   ; The time is measured in seconds from midnight
   FOR i=0,cdfnrec DO BEGIN 
	time_ele(i) = time_pb5(2,i)/1000./3600.
	density_ele(i) = density(i)
	averageE_ele(i) = averageE(i)
   ENDFOR 
 
   time_ele = time_ele(0:cdfnrec)
   density_ele = density_ele(0:cdfnrec)
   averageE_ele = averageE_ele(0:cdfnrec)
   
; Synchronize the times for the scatter plot...
   restore,date+'rchi2_noig.idlsav',/verbose
   
   index_ele = lonarr(n_elements(time_rchi2))
   FOR jj=0,n_elements(time_rchi2)-1 DO BEGIN
      index = where(long(time_ele*3600.) EQ long(time_rchi2(jj)*3600.))
      index_ele(jj) = index(0)
   ENDFOR
   
   
   !p.multi = [0,1,4]
   
   FOR ibox= 0,1 DO BEGIN
      FOR icorrect=0,1 DO BEGIN
         
         good = where(rchi2(icorrect,ibox,*) GT 0)
         plot, averageE_ele(index_ele(good)),rchi2(icorrect,ibox,good),psym=2,symsize=.6, $
          xtitle='averageE_ele [eV]',ytitle='rchi2, icorrect: '+string(icorrect,'(i2)')+', ibox: '+string(ibox+1,'(i2)'),/xlog,/ylog 
         
         IF (print EQ 0) THEN res = get_kbrd(1)
         
         
      ENDFOR
   ENDFOR
   time_stamp
   
   
ENDIF

;---------------------------------------------------------------

IF (keyword_set(r2_12)) THEN BEGIN

   rchi2_12 = fltarr(2,2,2000)
   time_rchi2_12 = fltarr(2000)
   
   FOR icorrect= 0,1 DO BEGIN 
      FOR ibox= 0,0 DO BEGIN 
         FOR itime= 0,n_elements(time)-1 DO BEGIN

            IF (sc_pot_status(itime) EQ 0) THEN GOTO, jump_out_12
               
            pos_pos=where(energy(0,icorrect,ibox,*,itime) gt 0 AND faverage(0,icorrect,ibox,*,itime) GT 0)
; Need to have at least three points for the spline!
            IF (n_elements(pos_pos) LT 3) THEN GOTO, jump_out_12
            
            y = alog(faverage(0,icorrect,ibox,pos_pos,itime))
            x = energy(0,icorrect,ibox,pos_pos,itime)
            
            y = reform(y)
            x = reform(x)
            
            n = n_elements(x)
            yp0 = (y(1)-y(0))/(x(1)-x(0))
            ypn_1 = (y(n-1)-y(n-2))/(x(n-1)-x(n-2))
            secder = spl_init(x,y,yp0=yp0,ypn_1=ypn_1)
            
            max_x = max(x)
            min_x = min(x)
            max_y = max(y)
            min_y = min(y)
            kw = {xlog:1,$
                  ytickformat:'(e8.1)',$
                  ytitle:'!5<f> [cm!u-6!ns!u3!n]',charsize:plt_size,$
                  psym:-2,symsize:.6}
            
            
; Using 1x, Up for the reference, spline-interpolate the others
            
            t3 = float(energy(3,icorrect,ibox,2-icorrect,itime))
            v3 = float(faverage(3,icorrect,ibox,2-icorrect,itime))
            w3 = float(dfaverage(3,icorrect,ibox,2-icorrect,itime))

            IF (t3 GT x(n-1) OR t3 LE 0 OR v3 LE 0 OR w3 LE 0) THEN GOTO, jump_out_12

            print, t3+sc_potential(itime),v3,w3

            spliners3 = spl_interp(x,y,secder,t3)
            
;   plot,x,y,_extra=kw,xrange=[min([x,t3]),max([x,t3])],yrange=[min([y,spliners3]),max([y,spliners3])]
;   oplot,[x(0),x(0)],[-100,100],line=3
;   oplot,[x(n-1),x(n-1)],[-100,100],line=3
;   oplot,[t3,t3],[spliners3,spliners3],psym=6,symsize=.6
;   plot,x,secder,xrange=[min([x,t3]),max([x,t3])],psym=-2,symsize=.6,/xlog,charsize=plt_size
;   res = get_kbrd(1)
            
; Find the rchi2 for this block
            sigma3 = w3/v3
            
            sum = 0.
            sum = sum + total( ( (alog(v3) - spliners3)/sigma3 )^2  )
            
            time_rchi2_12(itime) = time(itime)
            rchi2_12(icorrect,ibox,itime) = sum
            GOTO, other_side_12
            
jump_out_12: 
            time_rchi2_12(itime) = time(itime)
            rchi2_12(icorrect,ibox,itime) = -1.e+31
            
other_side_12:
            
            
         ENDFOR
      ENDFOR
   ENDFOR
   
   
   rchi2_12 = rchi2_12(0:1,0:1,0:n_elements(time)-1)
   time_rchi2_12 = time_rchi2_12(0:n_elements(time)-1)

   !p.multi = [0,1,2]

   IF (print NE 1) THEN window,1,xsize=800,ysize=800
   FOR ibox=0,0 DO BEGIN

      good =  where(rchi2_12(0,ibox,*) GT 0 AND rchi2_12(1,ibox,*) GT 0)
      
      plot,time_rchi2_12(good),rchi2_12(0,ibox,good)-rchi2_12(1,ibox,good),psym=4,xtitle='time',title=date + ', (rchi2_12 uncorrected - rchi2_12 corrected), Box: '+string(ibox+1,'(i2)'),symsize=.6,ystyle=1

      oplot, [2,8],[0,0],line=3

      plot,time_rchi2_12(good),rchi2_12(1,ibox,good),psym=1,xtitle='time',title=date + ', * = rchi2_12 uncorrected, + = rchi2_12 corrected, Box: '+string(ibox+1,'(i2)'),symsize=.6,ystyle=1,/ylog

      oplot, time_rchi2_12(good),rchi2_12(0,ibox,good),psym=2,symsize=.6

      label_page,side_label=slab      
   ENDFOR
   
ENDIF

;-------------------------------------------------------------------
IF (keyword_set(scat_flow)) THEN BEGIN

   fn = '/home/ppq/bigdisk/key_parameters/ion_kps/byblock/po_k0_ion_gsfc_19960529_v01.4.cdf'
   print, 'Opening file ',fn
   cdfid = CDF_OPEN(fn)
   print, 'cdfid: ',cdfid
   
   CDF_CONTROL, cdfid, var='time',get_var_info = vinfo
   ;vinfo.maxrec contains the maximum record number in the CDF file
   cdfnrec = vinfo.maxrec
   
   time_ion = dblarr(cdfnrec+1)
   u_ion = dblarr(3,cdfnrec+1)
   u_mag = dblarr(cdfnrec+1)
 
   CDF_VARGET, cdfid, 'time', time_ion, rec_count = cdfnrec+1
   CDF_VARGET, cdfid, 'h_u',u_ion , rec_count = cdfnrec+1
   
   CDF_CLOSE, cdfid

   u_mag = sqrt(u_ion(0,*)^2+u_ion(1,*)^2+u_ion(2,*)^2)


; Synchronize the times for the scatter plot...
   restore,date+'rchi2_12_noig.idlsav',/verbose
   
   index_ion = lonarr(n_elements(time_rchi2_12))
   FOR jj=0,n_elements(time_rchi2_12)-1 DO BEGIN
      index = where(long(time_ion) ge long(time_rchi2_12(jj)*3600.))
      index_ion(jj) = index(0)
   ENDFOR
   
    
   !p.multi = [0,1,2]
   
   FOR ibox= 0,0 DO BEGIN
      FOR icorrect=0,1 DO BEGIN
         
         good = where(rchi2_12(icorrect,ibox,*) GT 0)
         plot, u_mag(index_ion(good)),rchi2_12(icorrect,ibox,good),psym=2,symsize=.6, $
          xtitle='u_mag_ion [km/s]',ytitle='rchi2_12, icorrect: '+string(icorrect,'(i2)')+', ibox: '+string(ibox+1,'(i2)'),/xlog,/ylog,yrange=[min(rchi2_12(*,*,good)),max(rchi2_12(*,*,good))]

         oplot, [1,10000],[1,1],line=3
         
         IF (print EQ 0) THEN res = get_kbrd(1)
         
         
      ENDFOR
   ENDFOR
   time_stamp
   
   
ENDIF


if (print EQ 1) then begin
   end_of_prog, /print
endif else if (gif eq 1) then begin
   print, 'idl.gif created'
   write_gif,'idl.gif', TVRD()
   end_of_prog
endif else begin
   end_of_prog
endelse

end_flag:


stop 
END

