pro average_this_ele,species_shell,block_data,mode_info,pa_range,data,icall,status=status,noangles=noangles

; Work first with a temporary array
   temp = data

; Change from degrees to radians
   dtor = acos(-1.)/180.
   alpha_min = pa_range(0)*dtor
   alpha_max = pa_range(1)*dtor
   
   status = 1
   iwhole = -1
   i1 = -1
   i2 = -1
   mass = 9.1e-28
   factor = mode_info.factor
   
   det_array = intarr(2,6)
   det_array(0,*) = [0,2,4,6,8,10]
   det_array(1,*) = [1,3,5,7,9,11]
   
   FOR ibox=0,1 DO BEGIN

      dets = det_array(ibox,*)
      
      for i = 0, 54 do begin
;Whole block
         good_all = where(species_shell.datamask(i,dets,*) ne 0 )
         IF (NOT noangles) THEN BEGIN 
            good_points = where(species_shell.datamask(i,dets,*) ne 0 and $
                                species_shell.alpha(i,dets,*) ge alpha_min $
                                and $
                                species_shell.alpha(i,dets,*) le alpha_max)
         ENDIF ELSE BEGIN 
            good_points = where(species_shell.datamask(i,dets,*) ne 0)
         ENDELSE

         ftemp = species_shell.f(i,dets,*)
         ctemp = species_shell.corrected_counts(i,dets,*)
         if (good_all(0) ne -1 and good_points(0) ne -1) then begin
            iwhole = iwhole+1
            temp.count(iwhole) = n_elements(good_points)
            temp.count_all(iwhole) = n_elements(good_all)
            temp.faverage(iwhole)=total(ftemp(good_points))/ $
             float(n_elements(good_points))
            temp.caverage(iwhole)=total(ctemp(good_points))/ $
             float(n_elements(good_points))
            e_old = mode_info.energy_ele(i,ibox)
            if (block_data.sc_potential_stat ne 0) then BEGIN
               temp.energy(iwhole)=					$
                e_old + species_shell.species*block_data.sc_potential
            endif else begin
               temp.energy(iwhole)=e_old
            endelse
            v_old = sqrt(2.*e_old*1.6d-12/mass)
            v4 =  v_old^4
            temp.onef(iwhole) =					$ 
             1./(v4*factor*float(n_elements(good_points)))


;      IF (icall EQ 1 AND long(e_old*10.) EQ 267) THEN BEGIN 
;         help, v4
;         print, '--------------------------'
;         print, 'time: ',block_data.time
;         print, 'level: ',iwhole
;         print, 'N: ', n_elements(good_points)
;         print, 'factor: ',factor
;         print, 'shifted energy: ',temp.energy(iwhole)
;         print, 'obs energy: ', e_old
;         print, 'sc_potential: ',block_data.sc_potential
;         print, 'sc_potential_status: ',block_data.sc_potential_stat
;         print, 'obs velocity: ',v_old,v4
;         print, 'onef: ',temp.onef(iwhole)
;      ENDIF 


            temp.onec(iwhole) = 1./float(n_elements(good_points))
         endif else if (good_all(0) ne -1 and good_points(0) eq -1) then begin
            iwhole = iwhole+1
            temp.count(iwhole) = -1
            temp.count_all(iwhole) = n_elements(good_all)
            temp.faverage(iwhole)=-1
            temp.caverage(iwhole)=-1
            e_old = mode_info.energy_ele(i,ibox)
            if (block_data.sc_potential_stat ne 0) then begin
               temp.energy(iwhole)=					$
                e_old + species_shell.species*block_data.sc_potential
            endif else begin
               temp.energy(iwhole)=e_old
            endelse
            temp.onef(iwhole) = -1
            temp.onec(iwhole) = -1
         endif
         
;1st half of block
         good_all = where(species_shell.datamask(i,dets,0:11) ne 0 )
         IF (NOT noangles) THEN BEGIN 
            good_points = where(species_shell.datamask(i,dets,0:11) ne 0 and $
                                species_shell.alpha(i,dets,0:11) ge alpha_min $
                                and $
                                species_shell.alpha(i,dets,0:11) le alpha_max)
         ENDIF ELSE BEGIN 
            good_points = where(species_shell.datamask(i,dets,0:11) ne 0)
         ENDELSE

         ftemp = species_shell.f(i,dets,0:11)
         ctemp = species_shell.corrected_counts(i,dets,0:11)
         if (good_all(0) ne -1 and good_points(0) ne -1) then begin
            i1 = i1+1
            temp.count1(i1) = n_elements(good_points)
            temp.count1_all(i1) = n_elements(good_all)
            temp.faverage1(i1)=total(ftemp(good_points))/ $
             float(n_elements(good_points))
            temp.caverage1(i1)=total(ctemp(good_points))/ $
             float(n_elements(good_points))
            e_old = mode_info.energy_ele(i,ibox)
            if (block_data.sc_potential_stat ne 0) then begin
               temp.energy1(i1)=					$
                e_old + species_shell.species*block_data.sc_potential
            endif else begin
               temp.energy1(i1)=e_old
            endelse
            v_old = sqrt(2.*e_old*1.6d-12/mass)
            temp.onef1(i1) =					$ 
             1./(v_old^4*factor*float(n_elements(good_points)))
            temp.onec1(i1) = 1./float(n_elements(good_points))
            
         endif else if (good_all(0) ne -1 and good_points(0) eq -1) then begin
            i1 = i1+1
            temp.count1(i1) = -1
            temp.count1_all(i1) = n_elements(good_all)
            temp.faverage1(i1)= -1
            temp.caverage1(i1)= -1
            e_old = mode_info.energy_ele(i,ibox)
            if (block_data.sc_potential_stat ne 0) then begin
               temp.energy1(i1)=					$
                e_old + species_shell.species*block_data.sc_potential
            endif else begin
               temp.energy1(i1)=e_old
            endelse
            temp.onef1(i1) = -1
            temp.onec1(i1) = -1
         endif
         
;2nd half of block
         good_all = where(species_shell.datamask(i,dets,12:23) ne 0)
         IF (NOT noangles) THEN BEGIN 
            good_points=where(species_shell.datamask(i,dets,12:23) ne 0 and $
                              species_shell.alpha(i,dets,12:23) GE alpha_min $
                              and $
                              species_shell.alpha(i,dets,12:23) le alpha_max)
         ENDIF ELSE BEGIN
            good_points=where(species_shell.datamask(i,dets,12:23) ne 0)
         ENDELSE

         ftemp = species_shell.f(i,dets,12:23)
         ctemp = species_shell.corrected_counts(i,dets,12:23)
         if (good_all(0) ne -1 and good_points(0) ne -1) then begin
            i2 = i2+1
            temp.count2(i2) = n_elements(good_points)
            temp.count2_all(i2) = n_elements(good_all)
            e_old = mode_info.energy_ele(i,ibox)
            v_old = sqrt(2.*e_old*1.6d-12/mass)
            temp.faverage2(i2)=total(ftemp(good_points))/ $
             float(n_elements(good_points))
            temp.caverage2(i2)=total(ctemp(good_points))/ $
             float(n_elements(good_points))
            if (block_data.sc_potential_stat ne 0) then begin
               temp.energy2(i2)=					$
                e_old + species_shell.species*block_data.sc_potential
            endif else begin
               temp.energy2(i2)=e_old
            endelse
            temp.onef2(i2) =					$ 
             1./(v_old^4*factor*float(n_elements(good_points)))
            temp.onec2(i2) = 1./float(n_elements(good_points))
         endif else if (good_all(0) ne -1 and good_points(0) eq -1) then begin
            i2 = i2+1
            temp.count2(i2) = -1
            temp.count2_all(i2) = n_elements(good_all)
            e_old = mode_info.energy_ele(i,ibox)
            temp.faverage2(i2)= -1
            temp.caverage2(i2)= -1
            if (block_data.sc_potential_stat ne 0) then begin
               temp.energy2(i2)=					$
                e_old + species_shell.species*block_data.sc_potential
            endif else begin
               temp.energy2(i2)=e_old
            endelse
            temp.onef2(i2) = -1
            temp.onec2(i2) = -1
         endif
         
      ENDFOR

   ENDFOR

; Could have masking of an entire block/half block

   IF (iwhole EQ -1 OR i1 EQ -1 OR i2 EQ -1) THEN BEGIN
      status = 0
      return
   ENDIF

; Need to sort the arrays to be monotonically increasing

   sorted = sort(temp.energy)
   nonzero = where(temp.energy(sorted) ne 0)
   ul = n_elements(nonzero) - 1
   data.energy(0:ul) = temp.energy(sorted(nonzero))
   data.faverage(0:ul) = temp.faverage(sorted(nonzero))
   data.caverage(0:ul) = temp.caverage(sorted(nonzero))
   data.count(0:ul) = temp.count(sorted(nonzero))
   data.count_all(0:ul) = temp.count_all(sorted(nonzero))
   data.onef(0:ul) = temp.onef(sorted(nonzero))
   data.onec(0:ul) = temp.onec(sorted(nonzero))

   sorted = sort(temp.energy1)
   nonzero = where(temp.energy1(sorted) ne 0)
   ul = n_elements(nonzero) - 1
   data.energy1(0:ul) = temp.energy1(sorted(nonzero))
   data.faverage1(0:ul) = temp.faverage1(sorted(nonzero))
   data.caverage1(0:ul) = temp.caverage1(sorted(nonzero))
   data.count1(0:ul) = temp.count1(sorted(nonzero))
   data.count1_all(0:ul) = temp.count1_all(sorted(nonzero))
   data.onef1(0:ul) = temp.onef1(sorted(nonzero))
   data.onec1(0:ul) = temp.onec1(sorted(nonzero))

   sorted = sort(temp.energy2)
   nonzero = where(temp.energy2(sorted) ne 0)
   ul = n_elements(nonzero) - 1
   data.energy2(0:ul) = temp.energy2(sorted(nonzero))
   data.faverage2(0:ul) = temp.faverage2(sorted(nonzero))
   data.caverage2(0:ul) = temp.caverage2(sorted(nonzero))
   data.count2(0:ul) = temp.count2(sorted(nonzero))
   data.count2_all(0:ul) = temp.count2_all(sorted(nonzero))
   data.onef2(0:ul) = temp.onef2(sorted(nonzero))
   data.onec2(0:ul) = temp.onec2(sorted(nonzero))

   data.npts = iwhole+1
   data.npts_ta = i1 + 1        ; = i2 + 1
   
   mini = where(data.energy ge 0)
   data.min_index = mini(0)
   mini = where(data.energy1 ge 0)
   data.min_index1 = mini(0)
   mini = where(data.energy2 ge 0)
   data.min_index2 = mini(0)

   return
end;===========================================================

pro average_this_ion,species_shell,block_data,mode_info,pa_range,data,status=status,noangles=noangles
   
; Work first with a temporary array
   temp =  data

; Change from degrees to radians
   dtor = acos(-1.)/180.
   alpha_min = pa_range(0)*dtor
   alpha_max = pa_range(1)*dtor
   
   status = 1
   iwhole = -1
   i1 = -1
   i2 = -1
   mass = 1.67e-24
   factor = mode_info.factor
   
   det_array = intarr(2,6)
   det_array(0,*) = [0,2,4,6,8,10]
   det_array(1,*) = [1,3,5,7,9,11]

   FOR ibox=0,1 DO BEGIN 

      dets = det_array(ibox,*)

      FOR i = 0, 54 DO BEGIN 
; Whole block
         good_all = where(species_shell.datamask(i,dets,*) ne 0 )

         IF (NOT noangles) THEN BEGIN 
            good_points = where(species_shell.datamask(i,dets,*) ne 0 and $
                                species_shell.alpha(i,dets,*) ge alpha_min $
                                AND  $
                                species_shell.alpha(i,dets,*) le alpha_max)
         ENDIF ELSE BEGIN 
            good_points = where(species_shell.datamask(i,dets,*) ne 0)
         ENDELSE 
            
                                
         ftemp = species_shell.f(i,dets,*)
         ctemp = species_shell.corrected_counts(i,dets,*)
         if (good_all(0) ne -1 and good_points(0) ne -1) then begin
            iwhole = iwhole+1
            temp.count(iwhole) = n_elements(good_points)
            temp.count_all(iwhole) = n_elements(good_all)
            temp.faverage(iwhole)=total(ftemp(good_points))/ $
             float(n_elements(good_points))
            temp.caverage(iwhole)=total(ctemp(good_points))/ $
             float(n_elements(good_points))
            e_old = mode_info.energy_ion(i,ibox)
            if (block_data.sc_potential_stat ne 0) then begin
               temp.energy(iwhole)=					$
                e_old + species_shell.species*block_data.sc_potential
            endif else begin
               temp.energy(iwhole)=e_old
            endelse
            v_old = sqrt(2.*e_old*1.6d-12/mass)
            temp.onef(iwhole) =					$ 
             1./(v_old^4*factor*float(n_elements(good_points)))
            temp.onec(iwhole) = 1./float(n_elements(good_points))
         endif else if (good_all(0) ne -1 and good_points(0) eq -1) then begin
            iwhole = iwhole+1
            temp.count(iwhole) = -1
            temp.count_all(iwhole) = n_elements(good_all)
            temp.faverage(iwhole)=-1
            temp.caverage(iwhole)=-1
            e_old = mode_info.energy_ion(i,ibox)
            if (block_data.sc_potential_stat ne 0) then begin
               temp.energy(iwhole)=					$
                e_old + species_shell.species*block_data.sc_potential
            endif else begin
               temp.energy(iwhole)=e_old
            endelse
            temp.onef(iwhole) = -1
            temp.onec(iwhole) = -1
         endif

; 1st half of block
         good_all = where(species_shell.datamask(i,dets,0:11) ne 0 )
         IF (NOT noangles) THEN BEGIN 
            good_points = where(species_shell.datamask(i,dets,0:11) ne 0 and $
                                species_shell.alpha(i,dets,0:11) ge alpha_min $
                                and $
                                species_shell.alpha(i,dets,0:11) le alpha_max)
         ENDIF ELSE BEGIN 
            good_points = where(species_shell.datamask(i,dets,0:11) ne 0)
         ENDELSE

         ftemp = species_shell.f(i,dets,0:11)
         ctemp = species_shell.corrected_counts(i,dets,0:11)
         if (good_all(0) ne -1 and good_points(0) ne -1) then begin
            i1 = i1+1
            temp.count1(i1) = n_elements(good_points)
            temp.count1_all(i1) = n_elements(good_all)
            temp.faverage1(i1)=total(ftemp(good_points))/ $
             float(n_elements(good_points))
            temp.caverage1(i1)=total(ctemp(good_points))/ $
             float(n_elements(good_points))
            e_old = mode_info.energy_ion(i,ibox)
            if (block_data.sc_potential_stat ne 0) then begin
               temp.energy1(i1)=					$
                e_old + species_shell.species*block_data.sc_potential
            endif else begin
               temp.energy1(i1)=e_old
            endelse
            v_old = sqrt(2.*e_old*1.6d-12/mass)
            temp.onef1(i1) =					$ 
             1./(v_old^4*factor*float(n_elements(good_points)))
            temp.onec1(i1) = 1./float(n_elements(good_points))
         endif else if (good_all(0) ne -1 and good_points(0) eq -1) then begin
            i1 = i1+1
            temp.count1(i1) = -1
            temp.count1_all(i1) = n_elements(good_all)
            temp.faverage1(i1)= -1
            temp.caverage1(i1)= -1
            e_old = mode_info.energy_ion(i,ibox)
            if (block_data.sc_potential_stat ne 0) then begin
               temp.energy1(i1)=					$
                e_old + species_shell.species*block_data.sc_potential
            endif else begin
               temp.energy1(i1)=e_old
            endelse
            temp.onef1(i1) = -1
            temp.onec1(i1) = -1
         endif

; 2nd half of block
         good_all = where(species_shell.datamask(i,dets,12:23) ne 0)
         IF (NOT noangles) THEN BEGIN 
            good_points = where(species_shell.datamask(i,dets,12:23) ne 0 and $
                                species_shell.alpha(i,dets,12:23) ge alpha_min and $
                                species_shell.alpha(i,dets,12:23) le alpha_max)
         ENDIF ELSE BEGIN 
            good_points = where(species_shell.datamask(i,dets,12:23) ne 0)
         ENDELSE

         ftemp = species_shell.f(i,dets,12:23)
         ctemp = species_shell.corrected_counts(i,dets,12:23)
         if (good_all(0) ne -1 and good_points(0) ne -1) then begin
            i2 = i2+1
            temp.count2(i2) = n_elements(good_points)
            temp.count2_all(i2) = n_elements(good_all)
            e_old = mode_info.energy_ion(i,ibox)
            v_old = sqrt(2.*e_old*1.6d-12/mass)
            temp.faverage2(i2)=total(ftemp(good_points))/ $
             float(n_elements(good_points))
            temp.caverage2(i2)=total(ctemp(good_points))/ $
             float(n_elements(good_points))
            if (block_data.sc_potential_stat ne 0) then begin
               temp.energy2(i2)=					$
                e_old + species_shell.species*block_data.sc_potential
            endif else begin
               temp.energy2(i2)=e_old
            endelse
            temp.onef2(i2) =					$ 
             1./(v_old^4*factor*float(n_elements(good_points)))
            temp.onec2(i2) = 1./float(n_elements(good_points))
         endif else if (good_all(0) ne -1 and good_points(0) eq -1) then begin
            i2 = i2+1
            temp.count2(i2) = -1
            temp.count2_all(i2) = n_elements(good_all)
            e_old = mode_info.energy_ion(i,ibox)
            temp.faverage2(i2)= -1
            temp.caverage2(i2)= -1
            if (block_data.sc_potential_stat ne 0) then begin
               temp.energy2(i2)=					$
                e_old + species_shell.species*block_data.sc_potential
            endif else begin
               temp.energy2(i2)=e_old
            endelse
            temp.onef2(i2) = -1
            temp.onec2(i2) = -1
         endif
         
      ENDFOR

   ENDFOR

; Could have masking of an entire block/half block

   IF (iwhole EQ -1 OR i1 EQ -1 OR i2 EQ -1) THEN BEGIN
      status = 0
      return
   ENDIF

; Need to sort the arrays to be monotonically increasing

   sorted = sort(temp.energy)
   nonzero = where(temp.energy(sorted) ne 0)
   ul = n_elements(nonzero) - 1
   data.energy(0:ul) = temp.energy(sorted(nonzero))
   data.faverage(0:ul) = temp.faverage(sorted(nonzero))
   data.caverage(0:ul) = temp.caverage(sorted(nonzero))
   data.count(0:ul) = temp.count(sorted(nonzero))
   data.count_all(0:ul) = temp.count_all(sorted(nonzero))
   data.onef(0:ul) = temp.onef(sorted(nonzero))
   data.onec(0:ul) = temp.onec(sorted(nonzero))

   sorted = sort(temp.energy1)
   nonzero = where(temp.energy1(sorted) ne 0)
   ul = n_elements(nonzero) - 1
   data.energy1(0:ul) = temp.energy1(sorted(nonzero))
   data.faverage1(0:ul) = temp.faverage1(sorted(nonzero))
   data.caverage1(0:ul) = temp.caverage1(sorted(nonzero))
   data.count1(0:ul) = temp.count1(sorted(nonzero))
   data.count1_all(0:ul) = temp.count1_all(sorted(nonzero))
   data.onef1(0:ul) = temp.onef1(sorted(nonzero))
   data.onec1(0:ul) = temp.onec1(sorted(nonzero))

   sorted = sort(temp.energy2)
   nonzero = where(temp.energy2(sorted) ne 0)
   ul = n_elements(nonzero) - 1
   data.energy2(0:ul) = temp.energy2(sorted(nonzero))
   data.faverage2(0:ul) = temp.faverage2(sorted(nonzero))
   data.caverage2(0:ul) = temp.caverage2(sorted(nonzero))
   data.count2(0:ul) = temp.count2(sorted(nonzero))
   data.count2_all(0:ul) = temp.count2_all(sorted(nonzero))
   data.onef2(0:ul) = temp.onef2(sorted(nonzero))
   data.onec2(0:ul) = temp.onec2(sorted(nonzero))

   data.npts = iwhole+1
   data.npts_ta = i1 + 1        ; = i2 + 1
   
   mini = where(data.energy ge 0)
   data.min_index = mini(0)
   mini = where(data.energy1 ge 0)
   data.min_index1 = mini(0)
   mini = where(data.energy2 ge 0)
   data.min_index2 = mini(0)
   
   return
END ;===========================================================

; Called by faverage.pro
; Versions must be the same
;1st argument must have form:	960529
;2nd argument must have form:	'03:46:00'
;3rd argument must have form:  6

pro faverage_l1,date,time,nmin_in,pa_range,species,indir_in,l1_data,mode_info,version_faverage

   IF (n_params() EQ 0) THEN BEGIN
      print, 'This routine is called by faverage.pro, NOT stand-alone'
      stop
   ENDIF

   version = 3.0
   IF (version NE version_faverage) THEN BEGIN
      print, 'faverage.pro and faverage_l1.pro are not the same version'
      print, 'faverage.pro version: ',version_faverage
      print, 'faverage_l1.pro version: ',version
      print, 'aborting'
      stop
   ENDIF

   IF (pa_range(0) EQ 0 AND pa_range(1) EQ 180) THEN noangles = 1 ELSE noangles = 0


;date=970410
;time='19:00:00'
;nmin_in=5
;pa_range=[0,180]
;species='elec'
;l1_data,mode_info,indir=indir

nmin = long(nmin_in)
nen = 110
data_struc = {data_struc, $
                n_energy:fix(0),$
		species:fix(0),$
		mode:fix(0),$
		sc_potential:float(0.),$
		sc_potential_stat:long(0),$
		min_index:long(0),$
		min_index1:long(0),$
		min_index2:long(0),$
		npts:long(0),$
		npts_ta:long(0),$
		time:double(0.),$
		count:lonarr(nen),$
		count1:lonarr(nen),$
		count2:lonarr(nen),$
		count_all:lonarr(nen),$
		count1_all:lonarr(nen),$
		count2_all:lonarr(nen),$
		faverage:dblarr(nen),$
		faverage1:dblarr(nen),$
		faverage2:dblarr(nen),$
		caverage:dblarr(nen),$
		caverage1:dblarr(nen),$
		caverage2:dblarr(nen),$
		energy:dblarr(nen),$
		energy1:dblarr(nen),$
		energy2:dblarr(nen),$
		onef:dblarr(nen),$
		onef1:dblarr(nen),$
		onef2:dblarr(nen),$
		onec:dblarr(nen),$
		onec1:dblarr(nen),$
		onec2:dblarr(nen)}


;Initialize
if (indir_in ne 'nada') then BEGIN
   print, 'indir=',indir_in
   init_level1,date,block_data,mode_info,indir=indir_in,noangles=noangles
endif else BEGIN
   print, 'no indir'
   init_level1,date,block_data,mode_info,noangles=noangles
ENDELSE

;Figure out the record numbers I need
time_hr =double(strmid(time,0,2)) + double(strmid(time,3,2))/60. +   $
		double(strmid(time,6,2))/3600.

rec_array = where(mode_info.rectime gt time_hr and  $
		  mode_info.rectime le time_hr + nmin/60.)

l1_data = replicate(data_struc,n_elements(rec_array))

;Send each block of data to the averaging routine
nblock=-1
icall = 0
for i = rec_array(0),rec_array(n_elements(rec_array)-1) do begin

   read_level1,i,block_data,mode_info
   correct_interpolate, block_data, mode_info
   calculate_pitch,block_data,mode_info
   calculate_f,block_data,mode_info

   if (species eq 'elec') then begin

;      if (pre_acc eq 1) then begin
;;        Apply the pre-acceleration voltage
;         ele_bias_1 = long(strmid(mode_info.l1stat.mode_bias_name,6,2))
;         ele_bias_2 = long(strmid(mode_info.l1stat.mode_bias_name,9,2))
;;        There should be six electron sweeps
;         for jstart = 0,383,64 do begin
;            for idet=0,10,2 do begin           ; Box 1
;	      cheff = channeltron_efficiency(  $
;		-mode_info.energy(jstart:jstart+31,0),11,ele_bias_1)
;	      cheff0 = channeltron_efficiency(  $
;		-mode_info.energy(jstart:jstart+31,0),11,-1)
;	      block_data.f(jstart:jstart+31,idet)=  $
;		block_data.f(jstart:jstart+31,idet)*cheff0/cheff
;            endfor
;            for idet=1,11,2 do begin           ; Box 2
;	      cheff = channeltron_efficiency(  $
;		-mode_info.energy(jstart:jstart+31,1),12,ele_bias_2)
;	      cheff0 = channeltron_efficiency(  $
;		-mode_info.energy(jstart:jstart+31,1),12,-1)
;	      block_data.f(jstart:jstart+31,idet)=  $
;		block_data.f(jstart:jstart+31,idet)*cheff0/cheff
;            endfor
;         endfor
;      endif
	
      speed_shells,species_shell,block_data,mode_info,/ele
      data = data_struc
      data.n_energy = nen
      icall =  icall + 1
      average_this_ele,species_shell,block_data,mode_info,pa_range,data,icall,status=status,noangles=noangles
      data.species = -1
   endif else begin
      speed_shells,species_shell,block_data,mode_info,/ion
      data = data_struc
      data.n_energy = nen
      average_this_ion,species_shell,block_data,mode_info,pa_range,data,status=status,noangles=noangles
      data.species = 1
   ENDELSE

   IF (status EQ 1) THEN BEGIN 
      nblock=nblock+1
      data.time = block_data.time
      data.mode = block_data.mode
      data.sc_potential = block_data.sc_potential
      data.sc_potential_stat = block_data.sc_potential_stat      
      l1_data(nblock) = data
   ENDIF 

endfor


end_flag:

end
