pro average_this_ele,$
                     species_shell,$
                     block_data, $
                     mode_info,$
                     data,$
                     ibox,$
                     icorrect,$
                     itype,$
                     dir_array,$
                     det_array

dir_array = reform(dir_array)
det_array = reform(det_array)
   
;print, 'ibox: ',ibox
;print, 'icorrect: ',icorrect
;print, 'itype: ',itype
;print, 'dir_array: ',dir_array
;print, 'det_array: ',det_array
   
   ienergy = -1
   mass = 9.1e-28
   factor = 2.66587e-6

;   IF (block_data.time/3600. GT 3.5 AND icorrect EQ 1 AND ibox EQ 0 AND itype EQ 0) THEN BEGIN
;      openw,1,'ftest.dat'
;   ENDIF

   FOR i = 0, 54 do BEGIN
      
      icounter =  -1
      iall = -1
      
      FOR idir = 0,2 DO BEGIN
         
         good_all=where(species_shell.datamask(i,det_array,dir_array(idir)) $
                        NE 0)
         good_pts=where(species_shell.datamask(i,det_array,dir_array(idir)) $
                        NE 0 AND $
                        species_shell.f(i,det_array,dir_array(idir)) $
                        GE 0 )
         
         IF (good_pts(0) NE -1) THEN BEGIN
            icounter = icounter + n_elements(good_pts)
            IF (idir EQ 0) THEN BEGIN
               ftemp = $
                reform(species_shell.f(i,det_array(good_pts),dir_array(idir)))
               dftemp = $
                reform(species_shell.sigma_f(i,det_array(good_pts),dir_array(idir)))
               cctemp = $
                reform(species_shell.corrected_counts(i,det_array(good_pts),dir_array(idir)))
               fbuf = reform(ftemp)
               dfbuf = reform(dftemp)
               ccbuf = reform(cctemp)
            ENDIF ELSE BEGIN
               ftemp =  [fbuf,reform(species_shell.f(i,det_array(good_pts),dir_array(idir)))]
               dftemp = [dfbuf,reform(species_shell.sigma_f(i,det_array(good_pts),dir_array(idir)))]
               cctemp = [ccbuf,reform(species_shell.corrected_counts(i,det_array(good_pts),dir_array(idir)))]
               fbuf = reform(ftemp)
               dfbuf = reform(dftemp)
               ccbuf = reform(cctemp)
            ENDELSE 
         ENDIF
         
         IF (good_all(0) NE -1) THEN BEGIN
            iall =  iall + n_elements(good_all)
         ENDIF 
         
      ENDFOR
      
      IF (icounter NE -1) THEN BEGIN
         
         ftemp = ftemp(0:icounter)
         dftemp = dftemp(0:icounter)
         cctemp = cctemp(0:icounter)
         
         ienergy = ienergy+1
         data.count(itype,icorrect,ibox,ienergy) = icounter+1
         data.count_all(itype,icorrect,ibox,ienergy) = iall
         data.faverage(itype,icorrect,ibox,ienergy)=total(ftemp)/float(icounter+1)
         data.dfaverage(itype,icorrect,ibox,ienergy) = sqrt(total(dftemp^2))/float(icounter+1)
         caverage = total(cctemp)/float(icounter+1)

; Shift the energy levels by the spacecraft potential

         e_temp = mode_info.energy_ele(i,ibox)
         
         if (block_data.sc_potential_stat ne 0) then begin
            data.energy(itype,icorrect,ibox,ienergy)= $
             e_temp + species_shell.species*block_data.sc_potential
         endif else begin
            data.energy(itype,icorrect,ibox,ienergy)=e_temp
         endelse
         v_old = sqrt(2.*e_temp*1.6d-12/mass)
         data.onef(itype,icorrect,ibox,ienergy) =  $
          1./(v_old^4*factor*float(icounter+1))

;      IF (ibox EQ 0 AND icorrect EQ 1 AND long(block_data.time) EQ 12613 AND icounter NE -1) THEN BEGIN
;         print, i+1,e_temp,caverage,icounter+1
;      ENDIF

; Fill this one out if the caverage isn't at least 30
         IF (caverage LT 30) THEN BEGIN
            data.count(itype,icorrect,ibox,ienergy) = icounter+1
            data.count_all(itype,icorrect,ibox,ienergy) = iall+1
            data.faverage(itype,icorrect,ibox,ienergy) = -2
            data.dfaverage(itype,icorrect,ibox,ienergy) = -2
            data.onef(itype,icorrect,ibox,ienergy) = -2
         ENDIF

;         IF (block_data.time/3600. GT 3.5 AND icorrect EQ 1 AND ibox EQ 0) THEN BEGIN 
;            FOR iii=0,icounter DO BEGIN
;               printf,1,i,itype,mode_info.energy_ele(i,ibox),ftemp(iii),dftemp(iii),format='(2(i3,1x),3(e10.4,1x))'
;            ENDFOR
;         ENDIF


      ENDIF ELSE IF (icounter EQ -1 AND iall NE -1) THEN BEGIN
         ienergy = ienergy+1
         data.count(itype,icorrect,ibox,ienergy) = icounter+1
         data.count_all(itype,icorrect,ibox,ienergy) = iall+1
         data.faverage(itype,icorrect,ibox,ienergy) = -1
         data.dfaverage(itype,icorrect,ibox,ienergy) = -1
         data.onef(itype,icorrect,ibox,ienergy) = -1
; Shift the energy levels by the spacecraft potential
         e_temp = mode_info.energy_ele(i,ibox)
         if (block_data.sc_potential_stat ne 0) then begin
            data.energy(itype,icorrect,ibox,ienergy)= $
             e_temp + species_shell.species*block_data.sc_potential
         endif else begin
            data.energy(itype,icorrect,ibox,ienergy)=e_temp
         endelse
      ENDIF

   ENDFOR
   
   data.npts(itype,icorrect,ibox) = ienergy + 1
   
   mini = where(data.energy(itype,icorrect,ibox,*) GE 0)
   data.min_index(itype,icorrect,ibox) = mini(0)

;   IF (block_data.time/3600. GT 3.5 AND icorrect EQ 1 AND ibox EQ 0 AND itype EQ 3) THEN BEGIN
;      close,1
;      stop
;   ENDIF

return
END	;===========================================================

pro faverage_l1_diag3,date,l1_data,mode_info,igstat,use_release_dir
 
   IF (use_release_dir) THEN cloopend = 0 ELSE cloopend = 1
   
   data = {data, $
           sc_potential:float(0.),$
           sc_potential_stat:long(0),$
           min_index:lonarr(4,2,2),$
           npts:lonarr(4,2,2),$
           time:double(0.d0),$
           count:lonarr(4,2,2,16),$
           count_all:lonarr(4,2,2,16),$
           faverage:dblarr(4,2,2,16),$
           dfaverage:dblarr(4,2,2,16),$
           energy:dblarr(4,2,2,16),$
           onef:dblarr(4,2,2,16) $
          }
   
; Special input directory
   indir_in = '/opt/hydra/new_spectra_data/'

; Figure out the record numbers I need

   init_level1,date,block_data,mode_info,indir=indir_in,/force,/noangles
   time_array = findgen(48)/2.
;findgen(101)/16. + 2.
;[2, 2.5, 3, 3.5, 4, 4.5, 5, 5.5, 6, 6.5, 7, 7.5, 8]
   rec_array = lonarr(n_elements(time_array))
   FOR jjj=0,n_elements(time_array)-1 DO BEGIN 
      dum_array = where(mode_info.rectime GT time_array(jjj))
      rec_array(jjj) = dum_array(0)
   ENDFOR
   
   l1_data = replicate(data,n_elements(rec_array))
   
   direc = lonarr(4,3)
   direc(0,*) = [0,4,8]
   direc(1,*) = [1,5,9]
   direc(2,*) = [12,16,20]
   direc(3,*) = [13,17,21]
   
   dets = lonarr(2,6)
   dets(0,*) = [0,2,4,6,8,10]
   dets(1,*) = [1,3,5,7,9,11]

; First time through use the nominal stuff, next use the calibrated
   FOR icorrect=0,cloopend DO BEGIN
;   FOR icorrect=1,1 DO BEGIN

      
      IF (icorrect EQ 0 AND cloopend EQ 1) THEN BEGIN
         init_level1,date,block_data,mode_info,/use_nominal_energies,indir=indir_in,/force,/noangles
      ENDIF ELSE BEGIN
         init_level1,date,block_data,mode_info,indir=indir_in,/force,/noangles

;;;         recalc_gainfactor,mode_info,/all
;;;         openw,1,'gainstest.dat'
;;;         FOR istep=0,383 DO BEGIN
;;;            FOR idet=0,11 DO BEGIN 
;;;               ibox = mode_info.box(idet)
;;;               printf,1,istep+1,idet+1,$
;;;                mode_info.rgains_seq(istep,idet),$
;;;                mode_info.eff_seq(istep,ibox),$
;;;                mode_info.igains_seq(istep,ibox)
;;;            ENDFOR
;;;         ENDFOR
;;;         close,1
;;;         stop

      ENDELSE

;Send each block of data to the averaging routine
      
      nblock =  -1
      for jjj= 0,n_elements(rec_array)-1 do BEGIN
         
         nblock =  nblock + 1
         
         i = rec_array(jjj)
         
         read_level1,i,block_data,mode_info
         
; Change the interbox gains if necessary
         IF (igstat EQ 1 AND cloopend EQ 1) THEN BEGIN
            print, 'Resetting igains to 1'
            mode_info.igains_seq = fltarr(384,2) + 1
            recalc_gainfactor,mode_info,/ig
         ENDIF ELSE IF (igstat EQ 1 AND cloopend EQ 0) THEN BEGIN
            print, 'Resetting igains to 1'
            mode_info.igains_ele = fltarr(55,2) + 1
            recalc_gainfactor,mode_info,/ig
         ENDIF

         correct_interpolate, block_data, mode_info
         calculate_f,block_data,mode_info
         sigma_cc_sigma_f,block_data,mode_info

;         IF (block_data.time/3600. GT 3.5 AND icorrect EQ 1) THEN BEGIN 
;            openw,1,'ftest.dat'
;            printf,1,'date: ',date,' time: ',block_data.time,'  LEVEL1 LIB'
;            printf,1,'  '
;            printf,1,'  '
;            FOR i=0,383 DO BEGIN
;               FOR j=0,11 DO BEGIN
;                  ibox = mode_info.box(j)
;                  IF (mode_info.energy_index(i,ibox) LT 0) THEN BEGIN 
;                     printf,1,i+1,j+1,ibox+1,mode_info.energy_index(i,ibox), $
;                      -mode_info.energy(i,ibox), $
;                      mode_info.rgains_seq(i,j), $
;                      mode_info.eff_seq(i,ibox), $
;                      mode_info.igains_seq(i,ibox),$
;                      block_data.counts(i,j),$
;                      block_data.corrected_counts(i,j), $
;                      block_data.f(i,j), $
;                      block_data.datamask(i,j), $
;                      format='(i3,1x,i2,1x,i1,1x,i3,1x,f7.1,2x,3(f6.3,2x),i4,2x,f6.1,2x,e9.3,2x,i1)'
;                     
;                  ENDIF
;               ENDFOR
;            ENDFOR
;            close,1
;            stop
;         ENDIF


         speed_shells,species_shell,block_data,mode_info,/ele

         print, 'time: ',block_data.time/3600.
         
         FOR itype=0,3 DO BEGIN
            FOR ibox=0,1 DO BEGIN
               average_this_ele,$
                species_shell,$
                block_data, $
                mode_info,$
                data,$
                ibox,$
                icorrect,$
                itype,$
                direc(itype,*),$
                dets(ibox,*)
            ENDFOR 
         ENDFOR

         l1_data(nblock).min_index(*,icorrect,*) =  data.min_index(*,icorrect,*)
         l1_data(nblock).npts(*,icorrect,*) =  data.npts(*,icorrect,*)
         l1_data(nblock).count(*,icorrect,*,*) = data.count(*,icorrect,*,*)
         l1_data(nblock).count_all(*,icorrect,*,*) = data.count_all(*,icorrect,*,*)
         l1_data(nblock).faverage(*,icorrect,*,*) = data.faverage(*,icorrect,*,*)
         l1_data(nblock).dfaverage(*,icorrect,*,*) = data.dfaverage(*,icorrect,*,*)
         l1_data(nblock).energy(*,icorrect,*,*) = data.energy(*,icorrect,*,*)
         l1_data(nblock).onef(*,icorrect,*,*) = data.onef(*,icorrect,*,*)
         
         l1_data(nblock).time = block_data.time
         l1_data(nblock).sc_potential = block_data.sc_potential
         l1_data(nblock).sc_potential_stat = block_data.sc_potential_stat

         
      ENDFOR                    ;record loop
      
   ENDFOR                       ;icorrect loop
   
end_flag:
   
end
