PRO faverage_panel
   
   COMMON widgetData
   
;--- form a structure for the widget data
   wid = {wid, $
          typeVector: lonarr(10),$
          timeVector: fltarr(3) $
         }
   widgetData = wid
   
   
;--- create the base-window --------------------------------
   panel_base=WIDGET_BASE(title='Spin-Averaged f and cc',$
	 column=1)

; --- Choose plot species---------------------------------------------------
   type_base = WIDGET_BASE(panel_base, /FRAME, COLUMN=1,/EXCLUSIVE)
   typeNames = ['electrons', $
                'ions' $
               ]
   spb_type = lonarr(N_ELEMENTS(typeNames))

   FOR i=0, N_ELEMENTS(typeNames)-1 DO $
    spb_type(i) = WIDGET_BUTTON(type_base, $
                                VALUE=typeNames(i),$
                                UVALUE='spb_spec'+strtrim(string(i),2))

   widgetData.typeVector(0)=0
   WIDGET_CONTROL, spb_type(widgetData.typeVector(0)), SET_BUTTON=1


; --- Choose plot variable--------------------------------------------------
   type_base=WIDGET_BASE(panel_base, column=1, /FRAME, /EXCLUSIVE) 
   typeNames=   ['Average f',   $
                 'Average cc' $
                ]

   spb_type=lonarr(N_ELEMENTS(typeNames))

   FOR i=0, N_ELEMENTS(typeNames)-1 DO $
      spb_type(i)=WIDGET_BUTTON(type_base, $
			VALUE=typeNames(i), $
			UVALUE='spb_varb'+strtrim(string(i), 2))

   typeVector(1)=0
   WIDGET_CONTROL, spb_type(typeVector(1)), SET_BUTTON=1

;--- realize the window

   WIDGET_CONTROL, panel_base,/realize

;--- register the window

   xmanager, 'faverage_panel', panel_base


END


;***************************************************************************
;* 
;* PROCEDURE:     
;*      PRO faverage_panel_event, event
;* 
;* DESCRIPTION:  
;*	This processes events from the XMANAGER.
;*
;* INPUTS:       
;*	event		an XManager event
;*			
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	called by XMANAGER
;*
;***************************************************************************
PRO faverage_panel_event, event

COMMON widgetData

   WIDGET_CONTROL,GET_UVALUE=uval, event.id

   IF strleft(uval, 8) EQ 'spb_type' THEN BEGIN
      widgetData.typeVector(0)=fix(strfrom(uval,8))

   ENDIF ELSE IF strleft(uval,8) EQ 'spb_varb' THEN BEGIN
      widgetData.typeVector(1)=fix(strfrom(uval,8))   
END

   




















