;+ 
; FUNCTION: find_ppa_recnum.pro
; PURPOSE: After calling init_ppa_l1, use this function to
;          return the record numbers of the time-dependent
;          CDF variables, which are ultimately fed to read_ppa_l1
;          in order to retrieve the actual PPA L1 data.
; WRITTEN: Pamela A. Puhl-Quinn, 3/98
; USAGE: 
;         recnums = find_ppa_recnum(times, ppa_info)
;    
;         IN:  times = Either one singular time or a 2-element array of
;                      [start_time,stop_time] in any of the following
;                      formats:
;                      'HH:MM:SS','HH:MM',HHMMSS,HHMM,HH.HHH,H
;
;              ppa_info = data structure returned from a call to
;                          init_ppa_l1
;
;         OUT:  recnums = Record numbers for all of the time-dependent
;                         records found within the time range given
;-

FUNCTION find_ppa_recnum, time_in, ppa_info

   dumdate = '19990101'
   
   IF (n_elements(time_in) EQ 1) THEN BEGIN
      
      time = time_in
      hydra_time_io, dumdate, time
      tsec = time*3600.
      
      index = (where(ppa_info.rectime GE tsec))(0)
      
      IF (index EQ -1) THEN BEGIN 
         index = n_elements(ppa_info.rectime) - 1
         message, 'Defaulting to the last record', /cont
      ENDIF
      
      return, index
      
   ENDIF ELSE IF (n_elements(time_in) EQ 2) THEN BEGIN  
      
      time1 = time_in(0)
      time2 = time_in(1)
      hydra_time_io, dumdate, time1
      hydra_time_io, dumdate, time2
      tsec = [time1,time2]*3600.
      
      inds = where(ppa_info.rectime GE tsec(0) AND $
                   ppa_info.rectime LE tsec(1))
      IF (inds(0) EQ -1) THEN BEGIN
         message, 'No PPA rectimes found within time range given'
      ENDIF
      
      return, inds
      
   ENDIF ELSE BEGIN 
      
      message, 'Input time must be singular, or a start/end pair'

      return, ' '
      
   ENDELSE
   
   
END

