FUNCTION f2func,f1dum,x,y,sigx,sigy,iswitch

f1dum = double(f1dum)
x = double(x)
y = double(y)
sigx = double(sigx)
sigy = double(sigy)
answer = double(0.d0)

answer = (-total((f1dum*x-y)/((f1dum*sigx)^2+sigy^2),/double)/$
              total(1.0d0/((f1dum*sigx)^2+sigy^2),/double))*iswitch ;;ok jds

return,answer
END;=========================================================

FUNCTION dkappadf1,f1dum,f2dum,x,y,sigx,sigy,iswitch

   f1dum =  double(f1dum)
   f2dum =  double(f2dum)
   x =  double(x)
   y = double(y)
   sigx = double(sigx)
   sigy = double(sigy)
   denom = double(0.d0)
   testdum = double(0.d0)
   df2df1 = double(0.d0)
   dchidf2 = double(0.d0)
   answer = double(0.d0)

;      print,format='(3(e25.18,2x))', x(0),x(1),x(2)
;      print,format='(3(e25.18,2x))', y(0),y(1),y(2)
;      print,format='(3(e25.18,2x))', sigx(0),sigx(1),sigx(2)
;      print,format='(3(e25.18,2x))', sigy(0),sigy(1),sigy(2)
;      print,format='(2(e25.18,2x))', f1dum,f2dum

  denom=(f1dum*sigx)^2+sigy^2
  testdum= total (2.d0*(f1dum*x+f2dum-y)*x/(denom) - $
                  (f1dum*x+f2dum-y)^2*2.d0*f1dum*sigx^2/(denom)^2,/double  );;;
  df2df1= - ( ($
                total(1/denom,/double)*$
                total(x/denom-2.d0*f1dum*sigx^2*(f1dum*x-y)/denom^2,/double)$
                +total((f1dum*x-y)/denom,/double)* $
                 total(2.d0*f1dum*sigx^2/denom^2,/double) $
              )/$
              (total(1./denom,/double))^2 )

  dchidf2 =total(2.d0*(f1dum*x+f2dum-y)/denom,/double)
  answer = testdum+ dchidf2*df2df1*iswitch

;      print,format='(e25.18,2x)', answer

return,answer
END;=====================================================================
;FUNCTION d2kappadf12,f1dum,f2dum,x,y,sigx,sigy,iswitch
;
;; g is just dkappadf1
;; h is just df2df1
;
;denom = (f1dum*sigx)^2 + sigy^2;
;
;; h and it's partial derivative WRT f1dum===================
;num_h = -(   total(1/denom,/double)* $
;             total(x/denom-2.d0*f1dum*sigx^2*(f1dum*x-y)/denom^2,/double) + $
;             total((f1dum*x-y)/denom,/double)* $
;             total(2.d0*f1dum*sigx^2/denom^2,/double) )
;den_h = (total(1./denom,/double))^2
;h = num_h/den_h
;
;dhdf1_1 = total(-2*f1dum*sigx^2/denom^2)*total(x/denom-2*f1dum*sigx^2*(f1*x*y)/denom^2)
;
;dhdf1_2 = total(1./denom)*total(-2*x*f1dum*sigx^2/denom^2-((4*f1dum*sigx^2*x-2*sigx^2*y)/denom^2-(2*f1dum^2*sigx^2*x-2*f1dum*sigx^2*y)*2*f1dum*sigx^2/denom^3))
;
;dhdf1_3 = total(x/denom-(f1dum*x-y)/denom^2*2*f1dum*sigx^2)*total(2*f1dum*sigx^2/denom^2)
;
;dhdf1_4 = total((f1dum*x-y)/denom)*total(2*sigx^2/denom^2-2*2*f1dum*sigx^2*2*f1dum*sigx^2/denom^3)
;
;dhdf1_5 = num_h*(-2/(total(1./denom)^3)*total(-2*f1dum*sigx^2/denom^2)
;
;dhdf1 = -(dhdf1_1+dhdf1_2+hdhf1_3+dhdf1_4)/den_h + dhdf1_5
;
;;---------------------------------------------------
;; partial derivative of g WRT f1dum
;dgdf1_1 = total(2*x^2/denom - 2*(f1dum*x+f2dum-y)*x*2*f1dum*sigx^2/denom^2)
;dgdf1_2 = -total(2*sigx^2*(3*f1dum^2*x^2+f2dum^2+y^2+4*f1dum*x*f2dum-4*f1dum*x*y-2*f2dum*y)/denom^2)
;dgdf1_3 = total(2*(f1dum^3*x^2+f1dum*f2dum^2+f1dum*y^2+2*f1dum^2*x*f2dum-2*f1dum^2*x*y-2*f1dum*f2dum*y)*2*f1dum*sigx^2/denom^3)
;dgdf1_4 = total(2*x/denom-2*(f1dum*x+f2dum-y)/denom^2)*h
;dgdf1_5 = dhdf1*total(2*(f1dum*x+f2-y)/denom)
;
;dgdf1 = dgdf1_1+dgdf1_2+dgdf1_3+dgdf1_4+dgdf1_5
;
;;---------------------------------------------------
;; partial derivative of g WRT f2dum
;dgdf2 = total(2*x/denom-2*f1dum*sigx^2*(2*f2dum+2*f1dum*x-2*y)/denom^2)+total(2./denom)*h
;;---------------------------------------------------
;
;; Finally, the total derivative of g WRT f1, which is the second total
;; derivative of kappa WRT f1
;
;answer = dgdf1+dgdf2*h
;
;return, answer
;END
;========================================================================
; Written, 5/1/97, Jack Scudder
; Modified, 5/2/97, Pamela Puhl-Quinn and Jeremy Faden
;	    5/19/97, added guess_slope keyword
; Curator, Pamela Puhl-Quinn

pro gen_fit_v03_diag,x=x,sigma_x=sigx,y=y,sigma_y=sigy, $ ; data to fit (IN) 
        nparms=nparms, $       ; number of parameters to fit (IN)
	guess_slope=guess_slope,$ ;your best guess on the slope value  (IN)
        errorpercent=errorpercent, $ ; converge to this rel. tolerence(IN)
        slope=slope, intercept=intercept, $    ; parameter fits (OUT)
        chisq=chisq, rchisq=rchisq, $ ; fit chisq and reduced chisq (OUT)
        s2=s2, $   ; ( normalized distance of each point from fit ) ^ 2
        c95=c95, c99=c99,$  ; 95% and 99% confidence intervals (OUT)
        verbose=verbose,$   ; 0=no diags, 1=diags (IN)
        kappa_picture=kappa_picture,$ ; window number for kappa vs f1 plot (IN)
        print=print,$  ; In case you want to print the above plot (IN)
	itime=itime,$  ; Pam's diag parameter (IN)
        status=status  ; 2=fail, kappa search failed (OUT)
                       ; 1=zero bracketed,passed tolerence test on f1
		       ; 0=dkappadf1 < 1.e-19
                       ; 3=fail, zero brack., passed tol., MAXIMUM!

x=double(x)
y=double(y)
sigx=double(sigx)
sigy=double(sigy)

;purpose to develop general fitting routine by
; hypothesis testing for straight line model
; with smart start and Marquardt back end
; including error estimates.

  IF (keyword_set(print)) THEN print = 1 ELSE print = 0
  IF (print EQ 1) THEN set_ps, orient='L'

  if not keyword_set(nparms) then nparms = 2
  if nparms lt 1 or nparms gt 2 then begin
      print, 'one or two parameter fit only: nparms=1 or nparms=2'
      return
  endif
  if not keyword_set(errorpercent) then errorpercent=1d-11

  if(nparms eq 2) then iswitch=1
  if(nparms eq 1) then iswitch=0

  ireturncode=-1
  zero=1d-19
  npts= n_elements(x)

if (keyword_set(guess_slope)) then begin
   slope1 = guess_slope
   intercept1 = f2func(slope1,x,y,sigx,sigy,iswitch)
   slope_init=slope1
   intercept_init=intercept1
endif else begin
   ; Proceed to make one linear plots 
   ; Assuming no error in x
   a=total((x/sigy)^2)
   b=total((1./sigy)^2)
   c=total(x/sigy^2)
   det=a*b-c^2
   y1=total(x*y/sigy^2)
   y2=total(y/sigy^2)
   slope1= (b*y1-c*y2)/det
   intercept1= (-c*y1+a*y2)/det
   slope_init = slope1
   intercept_init = intercept1
endelse

; Now, calculate the dkappadf1 here at slope1
IF (keyword_set(verbose) OR keyword_set(kappa_picture)) THEN print, 'Initializing...'
init_counter = 0
init_loop:  f1dum = slope1

  init_counter = init_counter + 1	; Count attempts to bracket zero
	
  f2dum = f2func(f1dum,x,y,sigx,sigy,iswitch)
  testinit1 = dkappadf1(f1dum,f2dum,x,y,sigx,sigy,iswitch)
  intercept1 = f2dum

; Find slope2 from this derivative information
  kappaslope1 = total((f1dum*x + f2dum - y)^2/((f1dum*sigx)^2+sigy^2))
  slope2 = slope1 - kappaslope1/testinit1

; Now what is dkappadf1 at slope2?
  f1dum = slope2
  f2dum = f2func(f1dum,x,y,sigx,sigy,iswitch)
  testinit2 = dkappadf1(f1dum,f2dum,x,y,sigx,sigy,iswitch)
  intercept2 = f2dum

  IF (keyword_set(verbose) OR keyword_set(kappa_picture)) THEN BEGIN
     print, 'Init_loop: slope1,slope2',slope1,slope2
     print, 'Init_loop: intercept1,intercept2',intercept1,intercept2
     print, 'Init_loop: testinit1,testinit2',testinit1,testinit2
  ENDIF

; Evaluate whether or not we've bracketed the zero:
  if (testinit1*testinit2 lt 0) then begin
	arrays = dblarr(2)
	arrayt = dblarr(2)
	arrayi = dblarr(2)
	arrays = [slope1,slope2]
	arrayt = [testinit1,testinit2]
	arrayi = [intercept1,intercept2]
	f1left = min(arrays,imin)
	f1right = max(arrays,imax)
	testleft = arrayt(imin)
	testright = arrayt(imax)
	f2left = arrayi(imin)
	f2right = arrayi(imax)
        IF (keyword_set(kappa_picture)) THEN goto, plot_kappa
	goto, zero_in
  endif else begin

; dkappakf1 is virtually zero
  	if(abs(testinit2) lt zero) then begin
		f1new = slope2
		f2new = f2dum
    		ireturncode=0
      		GOTO, terminal
  	endif

; Can't bracket the zero, too many attempts
  	if (init_counter ge 1) then begin
		GOTO, search_kappaspace
  	endif


; Try again to bracket the zero
	slope1=slope2
	goto, init_loop

  ENDELSE
;===================KAPPA PICTURE (UNNECESSARY SEARCH)===========
plot_kappa:
print, 'performing unnecessary kappa search...'
IF (print EQ 0) THEN window,kappa_picture,xsize=600,ysize=600

f1 = dblarr(100)
f1 = dindgen(100)/99.*(f1right-f1left) + f1left

; Search kappa space, where kappa is only a function of f1
f2calc = dblarr(100)
kappa = dblarr(100)
high = 1.e+30
for ikl=0,99 do begin			; f1 loop
  	f2calc(ikl) = f2func(f1(ikl),x,y,sigx,sigy,iswitch)
        kappa(ikl)=total((f1(ikl)*x+f2calc(ikl)-y)^2/$
                                 (sigy^2+(f1(ikl)*sigx)^2) )
        if(kappa(ikl) lt high) then begin
		save1_kappa=ikl
		high = kappa(ikl)
	endif
endfor

print, 'kappa a minimum at (f1,f2):',f1(save1_kappa),f2calc(save1_kappa)
print, 'kappa equals: ',kappa(save1_kappa)

plot,f1,kappa,xtitle='f1',ytitle='kappa',yrange=[.9*min(kappa),max(kappa)],xstyle=1,ystyle=1
oplot, [f1(save1_kappa),f1(save1_kappa)],[0,max(kappa)],line=0

GOTO, zero_in

;=================BEGIN KAPPA SPACE SEARCH (NECESSARY SEARCH)================

search_kappaspace:
IF (keyword_set(verbose) OR keyword_set(kappa_picture)) THEN print, 'kappa search necessary'
IF (print EQ 0 AND keyword_set(kappa_picture)) THEN window,kappa_picture,xsize=600,ysize=600

angle=dblarr(100)
angle = dindgen(100)/99.*(85-(-85)) + (-85)  ;degrees
angle = angle*3.14159/180.d0
f1 = tan(angle)
;plot, f1, ytitle='f1 range in kappa search'

; Chi-squared, looping over f1 and f2 separately
;chisquare=dblarr(100,100)
;f2=dblarr(100)
;f2=dindgen(100)/99.d0*(f2right-f2left) + f2left
;for ikl=0,99 do begin			; f1 loop
;    for jkl=0,99 do begin		; f2 loop
;        chisquare(ikl,jkl)=total((f1(ikl)*x+f2(jkl)-y)^2/$
;                                 (sigy^2+(f1(ikl)*sigx)^2) )
;        if(ikl eq 0 and jkl eq 0) then high=chisquare(0,0)
;        if(chisquare(ikl,jkl) lt high) then begin
;		save1=ikl
;        	save2=jkl
;		high = chisquare(ikl,jkl)
;	endif
;    endfor
;endfor
;print, 'Chi-squared a minimum at (f1,f2):',f1(save1),f2(save2)
;print, 'Chi-squared equals: ',chisquare(save1,save2)


; Search kappa space, where kappa is only a function of f1
f2calc = dblarr(100)
kappa = dblarr(100)
high = 1.e+30
for ikl=0,99 do begin			; f1 loop
  	f2calc(ikl) = f2func(f1(ikl),x,y,sigx,sigy,iswitch)
        kappa(ikl)=total((f1(ikl)*x+f2calc(ikl)-y)^2/$
                                 (sigy^2+(f1(ikl)*sigx)^2) )
        if(kappa(ikl) lt high) then begin
		save1_kappa=ikl
		high = kappa(ikl)
	endif
ENDFOR
IF (high EQ 1.e+30) THEN BEGIN
   IF (keyword_set(verbose)) then print, 'kappa search found no minimum...'
   f1new = slope_init
   f2new = intercept_init
   ireturncode = 2
   GOTO, terminal
ENDIF 

IF (keyword_set(verbose) OR keyword_set(kappa_picture)) THEN BEGIN
   print, 'kappa a minimum at (f1,f2):',f1(save1_kappa),f2calc(save1_kappa)
   print, 'kappa equals: ',kappa(save1_kappa)
ENDIF

IF (keyword_set(kappa_picture)) THEN BEGIN
   plot,f1,kappa,xtitle='f1',ytitle='kappa',yrange=[.9*min(kappa),max(kappa)],xstyle=1,ystyle=1

   oplot, [f1(save1_kappa),f1(save1_kappa)],[0,max(kappa)],line=0
ENDIF

; Need to bracket the zero knowing where this minimum is...
; First, do we have points on either side of the minimum?
IF (save1_kappa EQ 0 OR save1_kappa EQ 99) THEN BEGIN
   IF (keyword_set(verbose)) then print, 'kappa search found no minimum...'
   f1new = slope_init
   f2new = intercept_init
   ireturncode = 2
   GOTO, terminal
ENDIF

; If we're here, the kappa search has found a minimum, and
; we're going to check and see what the derivatives look like
f1dum = f1(save1_kappa)
f2dum = f2calc(save1_kappa)*iswitch
testmin = dkappadf1(f1dum,f2dum,x,y,sigx,sigy,iswitch)

IF (testmin LT 0) THEN BEGIN
   f1dum = f1(save1_kappa+1)
   f2dum = f2calc(save1_kappa+1)*iswitch
   testdum = dkappadf1(f1dum,f2dum,x,y,sigx,sigy,iswitch)
   IF (testdum GT 0) THEN BEGIN
      IF (keyword_set(verbose) OR keyword_set(kappa_picture)) THEN print,'kappa search bracketed a minimum'
      f1left = f1(save1_kappa)
      f1right = f1(save1_kappa+1)
      testleft = testmin
      testright = testdum
      GOTO, zero_in
   ENDIF ELSE BEGIN
      IF(keyword_set(verbose) OR keyword_set(kappa_picture)) THEN print,'kappa search found a min and max between initial range'
      f1new = slope_init
      f2new = intercept_init
      ireturncode = 2
      GOTO,terminal
   ENDELSE
ENDIF ELSE BEGIN
   f1dum = f1(save1_kappa-1)
   f2dum = f2calc(save1_kappa-1)*iswitch
   testdum = dkappadf1(f1dum,f2dum,x,y,sigx,sigy,iswitch)
   IF (testdum LT 0) THEN BEGIN
      IF (keyword_set(verbose) OR keyword_set(kappa_picture)) THEN print,'kappa search bracketed a minimum'
      f1left = f1(save1_kappa-1)
      f1right = f1(save1_kappa)
      testleft = testdum
      testright = testmin
      GOTO, zero_in
   ENDIF ELSE BEGIN
      IF (keyword_set(verbose) OR keyword_set(kappa_picture)) THEN print,'kappa search found a min and max between initial range'
      f1new = slope_init
      f2new = intercept_init
      ireturncode = 2
      GOTO,terminal
   ENDELSE
ENDELSE
      
;==============END KAPPA SPACE SEARCH============================

; Bolzano search for the zero of dkappadf1 proceeds
zero_in: 
IF (keyword_set(verbose) OR keyword_set(kappa_picture)) THEN print, 'Zeroing in...'
loop_counter = 0

  loop: f1new = f1left- testleft*(f1right-f1left)/(testright-testleft) ;;

  jump_in: 

  loop_counter = loop_counter+1

  f2new=-total((f1new*x-y)/((f1new*sigx)^2+sigy^2))/$
    total (1.0d0/((f1new*sigx)^2+sigy^2))$
    *iswitch ;;ok jds
  f1dum=f1new
  f2dum=f2new*iswitch
  testnew = dkappadf1(f1dum,f2dum,x,y,sigx,sigy,iswitch)

  IF (keyword_set(verbose) OR keyword_set(kappa_picture)) THEN BEGIN
     print, loop_counter
     print, f1left,f1new,f1right,format='(3(e25.18,2x))'
     print, testleft,testnew,testright,format='(3(e25.18,2x))'
     print, ''
  ENDIF
  IF (keyword_set(kappa_picture)) THEN BEGIN
     xyouts,f1new,.95*min(kappa),'+',alignment=.5
;     wait,.25
  ENDIF

; Is testnew too close to 'zero' to pass up?
  IF (abs(testnew) LT zero) THEN BEGIN
      ireturncode=0
      goto, terminal
  ENDIF

; Have we been in this zero-in loop too long???
  if (loop_counter ge 100) then begin
	ireturncode=3
	goto, terminal
  endif

; Are f1left and f1right both close enough to f1new?
  IF (abs(f1new -f1left) LT (zero+abs(errorpercent/100.*f1left)) AND $
      abs(f1new-f1right) LT (zero+abs(errorpercent/100.*f1right))) THEN BEGIN  
     IF (testleft LT 0) THEN BEGIN   ; Make sure it's a minimum
        ireturncode = 1
        GOTO, terminal
     ENDIF ELSE BEGIN
        ireturncode=3
        GOTO, terminal
     ENDELSE
  ENDIF

; Is f1left close enough to f1new, but f1right isn't?
  IF (abs(f1new -f1left) LT (zero+abs(errorpercent/100.*f1left))) THEN BEGIN
     IF (keyword_set(verbose) OR keyword_set(kappa_picture)) THEN print, 'Flipping...'
     f1new=0.5*(f1left+f1right)
     GOTO, jump_in
  ENDIF

; Is f1right close enough to f1new, but f1left isn't?
  IF (abs(f1new-f1right) LT (zero+abs(errorpercent/100.*f1right))) THEN BEGIN
     IF (keyword_set(verbose) OR keyword_set(kappa_picture)) THEN print, 'Flipping...'
     f1new=0.5*(f1left+f1right)
     GOTO, jump_in
  ENDIF

; testnew and testright on same side of zero, re-bracket and try again
  IF (testnew*testright GT 0) THEN BEGIN
      f1right=f1new
      f2right=f2new
      testright = testnew
  ENDIF

; testnew and testleft on same side of zero, re-bracket and try again
  IF (testnew*testleft GT 0) THEN BEGIN
      f1left=f1new
      f2left=f2new
      testleft = testnew
  ENDIF

  GOTO, loop 
 
terminal: 

  slope=f1new
  intercept=f2new                      ; will be zero for 1-param fit
  status=ireturncode
  
;evaluate chisquare at the bottom
  s2= (f1new*x+f2new-y)^2/(sigy^2+(f1new*sigx)^2)  
  chisq=total( s2 )
  rchisq=chisq/double(npts-2-1)

;calculate the curvature matrix exactly
  denom=(f1new*sigx)^2+sigy^2
  num=f1new*x+f2new-y
  m11=0.5d0* total(  2*x^2/(denom) -$ 
                   2*(num)*x*2*f1new* sigx^2/(denom)^2 -$ 
                   (2*(sigx*num)^2/(denom)^2)-$
                   (2*f1new*sigx^2*2*(num)*x/(denom)^2)+$
                   2*2*f1new*(sigx*num)^2*2*f1new*sigx^2/(denom)^3 )
  m12= 0.5d0*total ( 2*x/(denom) -$;;
                   2*2*f1new*(num)*1*(sigx/denom)^2 );;;
  m22 =0.5d0* total( 2/(denom))

; calculate the approximate error boxes about the best fit
; twoparms 95% 
  thetap= 5.99d0
  if(iswitch eq 1) then begin
      errorf195=(m22*thetap/(m11*m22-m12^2))^0.5
      errorf295=(m11*thetap/(m11*m22-m12^2))^0.5
      c95=[errorf195,errorf295]
  endif else begin
      errorf195=(thetap/m11)^0.5
      c95=errorf195
  endelse

; twoparms at 99% = 9.21
  thetap= 9.21d0
  if (iswitch eq 1) then begin
      errorf199=(m22*thetap/(m11*m22-m12^2))^0.5
      errorf299=(m11*thetap/(m11*m22-m12^2))^0.5
      c99=[errorf199,errorf299]
  endif else begin
      errorf199=(thetap/m11)^0.5
      c99=errorf199
  ENDELSE

  IF (keyword_set(verbose) OR keyword_set(kappa_picture)) THEN BEGIN
     print, 'slope,intercept',slope,intercept
     print, 'rchisq',rchisq
     print, 'c95',c95
     print, 'c99',c99
     print, 'status',status
     print, 'errorpercent',errorpercent
  ENDIF

;  IF (print EQ 1) THEN BEGIN
;     end_of_prog,/print
;  ENDIF ELSE BEGIN
;     end_of_prog
;  ENDELSE

end


