function xticks, axis,index,value
   
   day = long(value/86400.) + 1
   hour = long( (value-(day-1)*86400)/3600. )
   min = long ( value - (day-1)*86400 - 3600*hour ) /60.
   sec = (value - (day-1)*86400) mod 60
   
   return, string(day,hour,min,format="(i2.2,'_',i2.2,':',i2.2)")
end

PRO cdhf_geo, date, print=print, ps=ps, pcl=pcl, gif=gif
;+
; NAME: cdhf_geo.pro
;
; PURPOSE: Display Hydra key parameters (Goddard/CDHF ones) in a
; 'geo'physical manner, with organization in space and L-shell.
;
; CALLING SEQUENCE: cdhf_geo, date, print=print, ps=ps, pcl=pcl, gif=gif
; 
; INPUTS: date - 'YYYYMMDD'
;
; KEYWORD PARAMETERS: /print, /ps, /pcl, /gif
;
; OUTPUTS: To screen
;
; COMMON BLOCKS: cdhf_geo_blocks
;
; MODIFICATION HISTORY:
;   Current version:  5/16/97 Written, Pamela Puhl-Quinn
;   Revised 5/16/97, ppq
;   Revised 9/24/97, ppq
;
;-

   common cdhf_geo_blocks, cdate, time, time2, density, averageE, lshell, gsex, nblks, ndays, date_str, gsez, gsey, kplib_version, kp_data_version

   IF n_params() EQ 0 THEN BEGIN
       doc_library, 'cdhf_geo'
       return
   ENDIF

   
   if (keyword_set(cdate)) then begin  
      
      if (cdate eq date) then begin
         read=0 
         print, 'data already in buffer'
      endif else begin
         read=1
         print, 'data being read from file'
      endelse
      
   endif else begin
      print, 'data being read from file'
      read=1
   endelse
   
   if (keyword_set(print)) then print=1 else print = 0
   if (keyword_set(ps)) then ps = 1 else ps = 0
   if (keyword_set(pcl)) then pcl = 1 else pcl = 0
   if (keyword_set(gif)) then gif = 1 else gif = 0
   
   IF (print EQ 1 OR ps EQ 1) THEN set_ps,orient='L',/color
   
   if (read eq 1) then begin
      
;=========READ KEY PARAMETERS CDF FILE==========
      f = hydra_findfile(date,/CDHF)
      IF f EQ '' THEN BEGIN
         message, 'No CDHF Key Parameter Data for this day', /cont
         return
      ENDIF ELSE BEGIN
         fn_cdf = f
         f = hydra_findfile(date,/level1)
         IF f EQ '' THEN BEGIN
            message, 'No Level1 Data for this day', /cont
            return
         ENDIF ELSE BEGIN
            fn_l1 = f
         ENDELSE
      ENDELSE

      date_str =  string(0)
      nblks = long(0)
      
      date_str = date
      
      print, 'Opening file ',fn_cdf
      cdfid = CDF_OPEN(fn_cdf)
      print, 'cdfid: ',cdfid
      
      CDF_CONTROL, cdfid, var='ELE_MEAN_ENERGY',get_var_info = vinfo
;vinfo.maxrec contains the maximum record number in the file
      cdfnrec = vinfo.maxrec+1
      nblks = cdfnrec
      
      CDF_VARGET, cdfid, 'Time_PB5', time_pb5, rec_count = cdfnrec
      CDF_VARGET, cdfid, 'ELE_MEAN_ENERGY', averageE_ele, rec_count = cdfnrec
      CDF_VARGET, cdfid, 'ELE_DENSITY', density_ele, rec_count = cdfnrec
      CDF_ATTGET, cdfid, 'kplib_version',0,kplib_version
      CDF_ATTGET, cdfid, 'kp_data_version',0,kp_data_version
      CDF_ATTGET, cdfid, 'whos_sc_pot',0,whos_sc_pot
      CDF_ATTGET, cdfid, 'scan_interval',0,scan_interval
      
;Diagnostic reads (not required for plot)
;log_file = string('                                  ')
;epoch = dblarr(cdfnrec)
;post_gap = lonarr(cdfnrec)
;dqf = lonarr(cdfnrec)
;instr_mode = lonarr(2,cdfnrec)
;sc_pos_gsm = fltarr(3,cdfnrec)
;max_energy = fltarr(cdfnrec)
;min_energy = fltarr(cdfnrec)
;CDF_ATTGET, cdfid, 'log_filename',0,log_file
;CDF_ATTGET, cdfid, 'quality_url',0,log_file
;CDF_ATTGET, cdfid, 'CATDESC','POST_GAP',log_file
;CDF_VARGET, cdfid, 'Epoch', epoch, rec_count=cdfnrec
;CDF_VARGET, cdfid, 'POST_GAP', post_gap, rec_count=cdfnrec
;CDF_VARGET, cdfid, 'DQF', dqf, rec_count=cdfnrec
;CDF_VARGET, cdfid, 'INSTR_MODE', instr_mode, rec_count=cdfnrec
;CDF_VARGET, cdfid, 'SC_pos_gsm', sc_pos_gsm, rec_count=cdfnrec
;CDF_VARGET, cdfid, 'MAX_ENERGY', max_energy, rec_count=cdfnrec
;CDF_VARGET, cdfid, 'MIN_ENERGY', min_energy, rec_count=cdfnrec
      
      CDF_CLOSE, cdfid
      
; The time is measured in seconds from midnight
      
      time = time_pb5(2,*)/1000.
      density = density_ele
      averageE = averageE_ele
      
      cdfnrec_kp = cdfnrec
      
; Now extract the level1 data
      print, 'Opening file ',fn_l1
      cdfid = CDF_OPEN(fn_l1)
      print, 'cdfid: ',cdfid
      CDF_CONTROL, cdfid, var='BLOCK_TIME',get_var_info = vinfo
      cdfnrec= vinfo.maxrec+1
      
      time_l1 = dblarr(cdfnrec)
      
      CDF_VARGET, cdfid, 'BLOCK_TIME', epoch, rec_count = cdfnrec
      CDF_VARGET, cdfid, 'L_SHELL', lsh, rec_count = cdfnrec
      CDF_VARGET, cdfid, 'POS_GSE', pos_gse, rec_count = cdfnrec
      
      for i = 0, cdfnrec-1 do begin
         CDF_EPOCH, epoch(i),y,mon,d,h,m,s,mil,/breakdown_epoch
         time_l1(i) = h*3600.+m*60.+s+mil/1000.
      ENDFOR
      
      CDF_close, cdfid
      
      
      time2 =  fltarr(cdfnrec_kp)
      lshell = fltarr(cdfnrec_kp)
      gsex = fltarr(cdfnrec_kp)
      gsey = fltarr(cdfnrec_kp)
      gsez = fltarr(cdfnrec_kp)
; Must synchronize the l1 and kp times
      for i = 0, cdfnrec_kp-1  do begin
         ping = where(long(time_l1) eq long(time(i)))
         time2(i) = time_l1(ping(0))
         lshell(i) = lsh(ping(0))
         gsex(i) = pos_gse(0,ping(0))
         gsey(i) = pos_gse(1,ping(0))
         gsez(i) = pos_gse(2,ping(0))
      endfor
      
;----------------------
      cdate = date
      
   endif                        ; General data read
   
; Create an 11-element color table
; color = 0 is black
; color = 1 is white
; color = 2 is grey
; color = 3 is green
; color = 4 is dark blue
; color = 5 is red
; color = 6 is purple
; color = 7 is orange
; color = 8 is rust
; color = 9 is hunter green
; color = 10 is hot pink
   
   red=  [0, 255, 153, 0,   0,   255, 88,  255, 131, 0,   243]
   green=[0, 255, 153, 255, 0,   0,   0,   178, 20 , 147, 0  ]
   blue= [0, 255, 153, 0,   255, 0,   132, 0,   46 , 37,  191]
   tvlct,red,green,blue
   
   !p.background=1
   !p.color=0

   color_arr = [9,4,5,0,7,9,4,5,0,7,9,4,5,0,7,9,4,5,0,7,9,4,5,0]
   
   IF (print EQ 0 AND ps EQ 0) THEN window,0,xsize=900,ysize=750
       map_set,30,-100,0,/ortho,/isotropic,/grid,/cont,/label,color=9,position=[.4,.55,.6,.75]

       xyouts,.5,.8,'!6'+date,/normal,charsize=3,alignment=.5

   FOR itime=1,24 DO BEGIN
      t2 = itime*3600.
      t1 = (itime-1)*3600.
      
      day_south = where(gsex GT 0 AND gsez LE 0 AND time LE t2 AND time GE t1)
      day_north = where(gsex GT 0 AND gsez GT 0 AND time LE t2 AND time GE t1)
      
      night_south = where(gsex LE 0 AND gsez LE 0 AND time LE t2 AND time GE t1)
      night_north = where(gsex LE 0 AND gsez GT 0 AND time LE t2 AND time GE t1)
      plot,lshell,density,/nodata,/xlog,/ylog,ytitle='Density',xtitle='North Pass LSHELL',color=0,yrange=[.1,100],position=[.1,.7,.3,.9],/noerase
      IF (day_north(0) NE -1) THEN BEGIN 
         oplot,lshell(day_north),density(day_north),psym=2,symsize=.5,color=color_arr(itime-1)
      ENDIF

      plot,lshell,density,/nodata,/xlog,/ylog,ytitle='Density',xtitle='South Pass LSHELL',color=0,yrange=[.1,100],position=[.1,.4,.3,.6],/noerase
      IF (day_south(0) NE -1) THEN BEGIN

         oplot,lshell(day_south),density(day_south),psym=2,symsize=.5,color=color_arr(itime-1)
      ENDIF

      plot,lshell,density,/nodata,/xlog,/ylog,ytitle='Density',xtitle='North Pass LSHELL',color=0,yrange=[.1,100],position=[.7,.7,.9,.9],/noerase
      IF (night_north(0) NE -1) THEN BEGIN 
         oplot,lshell(night_north),density(night_north),psym=2,symsize=.5,color=color_arr(itime-1)
      ENDIF

      plot,lshell,density,/nodata,/xlog,/ylog,ytitle='Density',xtitle='South Pass LSHELL',color=0,yrange=[.1,100],position=[.7,.4,.9,.6],/noerase
      IF (night_south(0) NE -1) THEN BEGIN

         oplot,lshell(night_south),density(night_south),psym=2,symsize=.5,color=color_arr(itime-1)
      ENDIF

      xyouts,.35,.65,'DAY SIDE',orient=90,/normal,alignment=.5
      xyouts,.65,.65,'NIGHT SIDE',orient=-90,/normal,alignment=.5
      xyouts,.2,.3,'<------------- SUN',/normal

      xyouts,.5,.55-itime*.018,'HOUR: [ '+string(t1/3600.,'(f4.1)')+','+string(t2/3600.,'(f4.1)')+' ] ',/normal,alignment=.5,color=color_arr(itime-1)
      
      wait, 1
      
      IF (print EQ 0 AND !p.multi(0) EQ 0) THEN BEGIN
         res = get_kbrd(1)
      ENDIF
   
   ENDFOR

   slab = '  kplib: '+string(kplib_version,'(f5.2)')+' ,kp_data_version: '+string(kp_data_version,'(f5.2)')+' Up-to-Date'

   label_page,side_label= slab

;===================================================================
   
   if (gif eq 1) then begin
      write_gif,'idl.gif',tvrd(),red,green,blue
   endif
   
   if (print EQ 1) then begin
      end_of_prog, /print
   endif else if (ps eq 1) then begin
      end_of_prog
   endif else if (pcl eq 1) then begin
      device,/close
      spawn, 'lp -d cis_color idl.pcl'
      print, 'spawning lp -d cis_color idl.pcl'
      set_plot,'x'
   endif
   
END

