PRO check_papco_moments, print=print

   date = '19960529'

; ----------------------------------------------------------

   id = cdf_open('po_k0_mfe_19960529_v02.cdf')
   cdf_control, id, variable='Epoch', get_var_info=r
   
   cdf_varget, id, 'Epoch', epoch, $
    rec_start=0, rec_count=r.maxrec + 1

   cdf_varget, id, 'B_GSM', b_gsm, $
    rec_start=0, rec_count=r.maxrec + 1
   
   cdf_close, id

   mfe_time = (epoch MOD 86400000)/1000.
   mfe_b_gsm = fltarr(4,n_elements(mfe_time))
   mfe_b_gsm(0:2,*) = b_gsm
   mfe_b_gsm(3,*) = sqrt(total(mfe_b_gsm(0:2,*)^2, 1))

; ----------------------------------------------------------

   extract_moments, date, 0200, 6, mom_ele

   b_pay_ele = fltarr(4,n_elements(mom_ele.time))
   b_pay_ele(0:2,*) = mom_ele.mfe_b_avg
   b_pay_ele(3,*) = sqrt(total(b_pay_ele(0:2,*)^2, 1))
   b_gsm_ele = fltarr(4,n_elements(mom_ele.time))
   hydra_payload_to_gsm,date,mom_ele.time,b_pay_ele,b_gsm_ele,istat,rate=0

   u_pay_ele = fltarr(4,n_elements(mom_ele.time))
   u_pay_ele(0:2,*) = mom_ele.v*1.e-5   ; km/s
   u_pay_ele(3,*) = sqrt(total(u_pay_ele(0:2,*)^2, 1))
   u_gsm_ele = fltarr(4,n_elements(mom_ele.time))

   hydra_payload_to_gsm,date,mom_ele.time,u_pay_ele,u_gsm_ele,istat,rate=1

   u_parl_ele = 1./b_gsm_ele(3,*)*(total(u_gsm_ele(0:2,*)*b_gsm_ele(0:2,*), 1))

   u_perp_gsm_ele = fltarr(4,n_elements(mom_ele.time))
   u_perp_gsm_ele(0,*) = u_gsm_ele(0,*) - $
    u_parl_ele*b_gsm_ele(0,*)/b_gsm_ele(3,*)
   u_perp_gsm_ele(1,*) = u_gsm_ele(1,*) - $
    u_parl_ele*b_gsm_ele(1,*)/b_gsm_ele(3,*)
   u_perp_gsm_ele(2,*) = u_gsm_ele(2,*) - $
    u_parl_ele*b_gsm_ele(2,*)/b_gsm_ele(3,*)
   u_perp_gsm_ele(3,*) = sqrt(total(u_perp_gsm_ele(0:2,*)^2, 1))

; ----------------------------------------------------------
   extract_moments, date, 0200, 6, mom_ion, /ion

   b_pay_ion = fltarr(4,n_elements(mom_ion.time))
   b_pay_ion(0:2,*) = mom_ion.mfe_b_avg
   b_pay_ion(3,*) = sqrt(total(b_pay_ion(0:2,*)^2, 1))
   b_gsm_ion = fltarr(4,n_elements(mom_ion.time))
   hydra_payload_to_gsm,date,mom_ion.time,b_pay_ion,b_gsm_ion,istat,rate=0

   u_pay_ion = fltarr(4,n_elements(mom_ion.time))
   u_pay_ion(0:2,*) = mom_ion.v*1.e-5   ; km/s
   u_pay_ion(3,*) = sqrt(total(u_pay_ion(0:2,*)^2, 1))
   u_gsm_ion = fltarr(4,n_elements(mom_ion.time))

   hydra_payload_to_gsm,date,mom_ion.time,u_pay_ion,u_gsm_ion,istat,rate=1

   u_parl_ion = 1./b_gsm_ion(3,*)*(total(u_gsm_ion(0:2,*)*b_gsm_ion(0:2,*), 1))

   u_perp_gsm_ion = fltarr(4,n_elements(mom_ion.time))
   u_perp_gsm_ion(0,*) = u_gsm_ion(0,*) - $
    u_parl_ion*b_gsm_ion(0,*)/b_gsm_ion(3,*)
   u_perp_gsm_ion(1,*) = u_gsm_ion(1,*) - $
    u_parl_ion*b_gsm_ion(1,*)/b_gsm_ion(3,*)
   u_perp_gsm_ion(2,*) = u_gsm_ion(2,*) - $
    u_parl_ion*b_gsm_ion(2,*)/b_gsm_ion(3,*)
   u_perp_gsm_ion(3,*) = sqrt(total(u_perp_gsm_ion(0:2,*)^2, 1))

; ----------------------------------------------------------
   IF (keyword_set(print)) THEN print = 1 ELSE print = 0
   IF (NOT print) THEN window, 1, xsize=800, ysize=800
   !p.multi = [0,1,4]
   loadct, 39
   !p.background = 255
   !p.color = 0
   !p.font = -1
   !p.noclip = 0
   font = '!5'
   !p.charthick = 1.5
   !p.charsize = 1.0
   filename = 'papco_moments_check.ps'

   IF (print) THEN set_ps, orient='L', /color, file=filename

   FOR ii=0,3 DO BEGIN
      plot, mom_ele.time, u_perp_gsm_ele(ii,*), xtickformat='tick_hms',ytitle='u_perp!u'+string(ii+1,'(i1)')+'!n!dGSM!n', title='BLACK:Hydra/ele, RED: Hydra/ion'
      oplot,mom_ion.time, u_perp_gsm_ion(ii,*), color=98
      oplot,[1*3600,9*3600],[0,0],line=3
   ENDFOR
   time_stamp

   IF (NOT print) THEN res = get_kbrd(1)

   FOR ii=0,3 DO BEGIN
      plot, mom_ele.time, b_gsm_ele(ii,*), xtickformat='tick_hms', ytitle='B!u'+string(ii+1,'(i1)')+'!n!dGSM!n', title='BLACK:Hydra/ele, RED:Hydra/ion, GREEN:MFE Key Parameters'
      oplot,mom_ion.time, b_gsm_ion(ii,*), color=98
      oplot, mfe_time, mfe_b_gsm(ii,*), color=52
      oplot,[1*3600,9*3600],[0,0],line=3

   ENDFOR
   time_stamp

   IF (print) THEN BEGIN
      end_of_prog
      spawn, 'printps '+filename
      print, 'Printing '+filename
   ENDIF

   stop

   return
END



