;+
; NAME: pitch_plot.pro
; Diagnostics directory: 	/home/ppq/bigdisk/ppa/pitch_plot/pitch_plot_tool
; Public directory:	 	/home/ppq/idl_tools_public/release
;
; WRITTEN:	Pamela A. Puhl-Quinn, 11/12/96
; 		ppq, 2/4/97, recompiled, b1_43, exe: lz_pitch_plot_b1_43
;		ppq, 2/18/97, recompiled for TM 4 too, exe: lz_pitch_plot_b1_43
;		ppq, 6/16/97, recompiled, exe: lz_pitch_plot_b1_48
;
; USAGE:  
;    pitch_plot,960713,1028,/cps
;
; MANDATORY ARGUMENTS:
;		1st argument:  YYMMDD or YYYYMMDD
;		2nd argument: 'HH:MM:SS','HH:MM',HHMMSS,HHMM,HH.HHH,H
;
; MANDATORY KEYWORDS: (one at a time)
;   /cps		; Counts per second (Raw counts/Probability)
;   /prob		; Probability function
;   /raw_cnts		; Raw counts
;   /eo_cps		; Energy ordered cps
;   /eo_prob		; Energy ordered prob
;   /eo_raw		; Energy ordered raw counts
;
; OPTIONAL KEYWORDS:
;   /nwindow		; specify the device window number
;   /print		; create a post-script file AND print at UIowa
;   /ps			; create a post-script file, idl.ps
;   /gif		; create a gif-file, idl.gif
;-

pro pitch_plot, date_in, time_in, print=print, ps=ps, $
		gif=gif, cps=cps, prob=prob, $
		raw_cnts=raw_cnts,eo_cps=eo_cps,eo_prob=eo_prob,$
		eo_raw=eo_raw,nwindow=nwindow

common pitch_plot,buffer,cdate,ctime, $
		pitch,red_alpha,red_energy,cps_2d,prob_2d,$
		raw_2d, $
		red_alpha_sorted,red_energy_sorted,$
		cps_2d_sorted,prob_2d_sorted,raw_2d_sorted,$
		offset,offset_sorted,nhbins,nlevels

; Convert the date and time into something useful==================
hydra_time_io,date_in,time_in,fyear,fmonth,fday,fhour,fminute,fsecond
date =  strmid(date_in,2,6)
time = string(fhour,'(i2.2)')+':'+string(fminute,'(i2.2)')+':'+string(fsecond,'(i2.2)')
;=================================================

; Check to see if the data for 'date' already exists in the buffer, 
; and if not, then the data will have to be read from the file

if (keyword_set(cdate) and keyword_set(ctime)) then begin  
  	if (cdate eq date and ctime eq time) then begin
		read=0			; data already in buffer 		
	endif else begin
		read=1			; data needs to be read
	endelse
endif else begin
  	read=1				; data needs to be read
endelse

date_time = date+'_'+time
filename = './pitch'+date_time		; As determined by lz (below)

if (keyword_set(print)) then print = 1 else print = 0
if (keyword_set(ps)) then ps = 1 else ps = 0
if (keyword_set(gif)) then gif = 1 else gif = 0
if (keyword_set(nwindow)) then lwindow=nwindow else lwindow=0

if (print eq 1 or ps eq 1) then begin
	set_ps, orient='P'
	charout=1.
endif else begin
	charout=1.5
endelse

;========================READ DATA============================
if (read eq 0) then begin
	print, 'Data already in buffer'
	goto, plot_stuff
endif

;===========================DATA EXTRACTION===================
;dir_exe='/home/ppq/bigdisk/ppa/pitch_plot/pitch_plot_tool/'
dir_exe='/home/ppq/idl_tools_public/release/'
name_exe = 'lz_pitch_plot_b1_48'
print, '	'
print, 'extracting data...'
print, 'dir_exe='+dir_exe
print, 'spawning '+dir_exe+name_exe+' '+date+' '+time

spawn, dir_exe+name_exe+" "+date+" "+time


;=================NEW DATA STRUCTURE READ=========================

print,'Reading extracted data from file '+filename

	openr,1,filename,/f77_unformatted

    nbins = long(0)
    nlev = long(0)
    nhbins = long(0)
    nlevels = long(0)
    readu,1,nbins
    readu,1,nlev
    readu,1,nhbins
    readu,1,nlevels

pitch={pitch_name_697,	lib_string:	'b1_00',$
			year:		byte(0),$
			month:		byte(0),$
			day:		byte(0),$
			hour:		byte(0),$
			min:		byte(0),$
			sec:		byte(0),$
			fill:		byte(0),$
			sample_time:	float(0.),$
			time_offset:	fltarr(nlev),$ 
			raw_2d:		lonarr(nbins,nlev),$
			prob_both_2d:	fltarr(nbins,nlev),$
			red_alpha:	fltarr(nbins),$
			red_energy:	fltarr(nlev), $
			width:		lonarr(nbins), $
			nsamples:	lonarr(nlev)}

dum=pitch

    readu,1,dum
    pitch=dum
    pitch.red_alpha = pitch.red_alpha*180./3.14159

close,1


; Set the value of cdate in the buffer in order to access the
; buffered data on subsequent calls to this procedure without having
; to read the data in from a file every time
cdate = date
ctime = time
;======================================================================
plot_stuff:

syear = strtrim(long(pitch.year),2)
smonth = strtrim(long(pitch.month),2) & if (strlen(smonth) eq 1) then smonth='0'+smonth
sday = strtrim(long(pitch.day),2) & if (strlen(sday) eq 1) then sday = '0' + sday
shour = strtrim(long(pitch.hour),2) & if (strlen(shour) eq 1) then shour = '0'+shour
smin = strtrim(long(pitch.min),2) & if (strlen(smin) eq 1) then smin = '0'+smin
ssec = strtrim(long(pitch.sec),2) & if (strlen(ssec) eq 1) then ssec = '0'+ssec

block_time = syear+smonth+sday+'_'+shour+':'+smin+':'+ssec

; Clip the structure arrays, resize them too
raw_2d = fltarr(nhbins,nlevels)
prob_2d = fltarr(nhbins,nlevels)
red_alpha = fltarr(nhbins)
red_energy = fltarr(nlevels)
width = lonarr(nhbins)
nsamples = lonarr(nlevels)

raw_2d = pitch.raw_2d(0:nhbins-1,0:nlevels-1)
prob_2d = pitch.prob_both_2d(0:nhbins-1,0:nlevels-1)*pitch.sample_time
red_alpha = pitch.red_alpha(0:nhbins-1)
red_energy = pitch.red_energy(0:nlevels-1)
width = pitch.width(0:nhbins-1)
nsamples = pitch.nsamples(0:nlevels-1)

; Re-sort the energy into a monotonically increasing array

offset = fltarr(nlevels)
offset = pitch.time_offset(0:nlevels-1)
;offset(0) = 0.
;for i = 1, nlevels-1 do begin
;	offset(i) = offset(i-1) + nsamples(i)/512.*9.2
;endfor

cps_2d = fltarr(nhbins,nlevels)
nezero = where(prob_2d gt 0)
eqzero = where(prob_2d eq 0)
cps_2d(nezero) = raw_2d(nezero)/prob_2d(nezero)
if (eqzero(0) ne -1) then cps_2d(eqzero) = -999

sorted_indices=sort(red_energy)

red_energy_sorted = fltarr(nlevels)
prob_2d_sorted = fltarr(nhbins,nlevels)
raw_2d_sorted = fltarr(nhbins,nlevels)
red_alpha_sorted = fltarr(nhbins)
offset_sorted = fltarr(nlevels)

red_alpha_sorted(*) = red_alpha(*)
red_energy_sorted(*)=red_energy(sorted_indices)
prob_2d_sorted(*,*) = prob_2d(*,sorted_indices)
raw_2d_sorted(*,*) = raw_2d(*,sorted_indices)
offset_sorted = offset(sorted_indices)

cps_2d_sorted = fltarr(nhbins,nlevels)
nezero = where(prob_2d_sorted gt 0)
eqzero = where(prob_2d_sorted eq 0)
cps_2d_sorted(nezero) = raw_2d_sorted(nezero)/prob_2d_sorted(nezero)
if (eqzero(0) ne -1) then cps_2d_sorted(eqzero) = -999

;==========================Counts/sec================================
if (keyword_set(cps)) then begin

pi=acos(-1)

!p.multi=[0,4,9]

if (print eq 0 and ps eq 0) then window,lwindow,xsize=768,ysize=880

; yrange set by max(cps_2d) and some fraction of it
ymax = max(cps_2d(*,0))
ymin = 0. - .2*ymax

plot,	red_alpha,cps_2d(*,0),$	
	xtitle='pitch_angle [degrees]',$
	title='E=' + strtrim(long(red_energy(0)),2)+'eV'+ $
		'  offset='+string(offset(0),'(f5.1)')+ 's',$
	psym=0,$
	ytitle='Counts/s',$
	charsize=charout,$
	yrange=[ymin,ymax],$
	min_value = 0,$
	xrange=[-10,190],$
	ystyle=1,$
	xstyle=1
oplot,	[-10,190],[0,0],line=2

for i=1,nlevels-1 do begin

ymax = max(cps_2d(*,i))
ymin = 0. - .2*ymax
	
plot,	red_alpha,cps_2d(*,i),$
	psym=0,$
	title='E=' + strtrim(long(red_energy(i)),2)+'eV' + $
		'  offset= '+string(offset(i),'(f5.1)')+ 's',$
	charsize=charout,$
	yrange=[ymin,ymax],$
	min_value = 0,$
	xrange=[-10,190],$
	ystyle=1,$
	xstyle=1
oplot,	[-10,190],[0,0],line=2

endfor

time_stamp

out_str = 'HYDRA/PPA: '+ block_time + $
		' , Version: ' + strtrim(pitch.lib_string,2)
print, out_str

xyouts,.02,.5,out_str,/normal,alignment = 0.5,orient=90

if (gif eq 1) then write_gif,'idl.gif',tvrd()

endif
;==========================Energy ordered Counts/sec==============
if (keyword_set(eo_cps)) then begin

pi=acos(-1)

!p.multi=[0,4,9]

if (print eq 0 and ps eq 0) then window,lwindow,xsize=768,ysize=880

ymax = max(cps_2d_sorted(*,0))
ymin = 0. - .2*ymax

plot,	red_alpha_sorted,cps_2d_sorted(*,0),$	
	xtitle='pitch_angle [degrees]',$
	title='E=' + strtrim(long(red_energy_sorted(0)),2)+'eV'+ $
		'  offset='+string(offset_sorted(0),'(f5.1)')+ 's',$
	psym=0,$
	ytitle='Counts/s',$
	charsize=charout,$
	yrange=[ymin,ymax],$
	min_value = 0,$
	xrange=[-10,190],$
	ystyle=1,$
	xstyle=1
oplot,	[-10,190],[0,0],line=2

for i=1,nlevels-1 do begin

ymax = max(cps_2d_sorted(*,i))
ymin = 0. - .2*ymax
	
plot,	red_alpha_sorted,cps_2d_sorted(*,i),$
	psym=0,$
	title='E=' + strtrim(long(red_energy_sorted(i)),2)+'eV' + $
		'  offset= '+string(offset_sorted(i),'(f5.1)')+ 's',$
	charsize=charout,$
	yrange=[ymin,ymax],$
	min_value = 0,$
	xrange=[-10,190],$
	ystyle=1,$
	xstyle=1
oplot,	[-10,190],[0,0],line=2

endfor


out_str = 'HYDRA/PPA: '+ block_time + $
		' , Version: ' + strtrim(pitch.lib_string,2)
print, out_str

xyouts,.02,.5,out_str,/normal,alignment = 0.5,orient=90

time_stamp

if (gif eq 1) then write_gif,'idl.gif',tvrd()

endif
;==========================Probability Function=====================
if (keyword_set(prob)) then begin

pi=acos(-1)

!p.multi=[0,4,9]

if (print eq 0 and ps eq 0) then window,lwindow,xsize=768,ysize=880

ymax = max(prob_2d(*,0))
ymin = 0. - .2*ymax

plot,	red_alpha,prob_2d(*,0),$
	xtitle='pitch_angle [degrees]',$
	title='E=' + strtrim(long(red_energy(0)),2)+'eV'+ $
		'  offset='+string(offset(0),'(f5.1)')+ 's',$
	psym=0,$
	ytitle='Prob',$
	charsize=charout,$
	yrange=[ymin,ymax],$
	xrange=[-10,190],$
	xstyle=1,$
	ystyle=1

oplot,	[-10,190],[0,0],line=2

for i=1,nlevels-1 do begin

ymax = max(prob_2d(*,i))
ymin = 0. - .2*ymax

plot, 	red_alpha,prob_2d(*,i),$
	psym=0,$
	title='E=' + strtrim(long(red_energy(i)),2)+'eV'+ $
		'  offset='+string(offset(i),'(f5.1)')+ 's',$
	charsize=charout,$
	yrange=[ymin,ymax],$
	xrange=[-10,190],$
	xstyle=1,$
	ystyle=1
oplot,	[-10,190],[0,0],line=2
endfor

out_str = 'HYDRA/PPA: '+ block_time + $
		' , Version: ' + strtrim(pitch.lib_string,2)
print, out_str

xyouts,.02,.5,out_str,/normal,alignment = 0.5,orient=90

time_stamp

if (gif eq 1) then write_gif,'idl.gif',tvrd()

endif
;==============Energy Ordered Probability Function=====================
if (keyword_set(eo_prob)) then begin

pi=acos(-1)

!p.multi=[0,4,9]

if (print eq 0 and ps eq 0) then window,lwindow,xsize=768,ysize=880

ymax = max(prob_2d_sorted(*,0))
ymin = 0. - .2*ymax


plot,	red_alpha_sorted,prob_2d_sorted(*,0),$
	xtitle='pitch_angle [degrees]',$
	title='E=' + strtrim(long(red_energy_sorted(0)),2)+'eV'+ $
		'  offset='+string(offset_sorted(0),'(f5.1)')+ 's',$
	psym=0,$
	ytitle='Prob',$
	charsize=charout,$
	yrange=[ymin,ymax],$
	xrange=[-10,190],$
	xstyle=1,$
	ystyle=1
oplot,	[-10,190],[0,0],line=2

for i=1,nlevels-1 do begin

ymax = max(prob_2d_sorted(*,i))
ymin = 0. - .2*ymax

plot, 	red_alpha_sorted,prob_2d_sorted(*,i),$
	psym=0,$
	title='E=' + strtrim(long(red_energy_sorted(i)),2)+'eV'+ $
		'  offset='+string(offset_sorted(i),'(f5.1)')+ 's',$
	charsize=charout,$
	yrange=[ymin,ymax],$
	xrange=[-10,190],$
	xstyle=1,$
	ystyle=1
oplot,	[-10,190],[0,0],line=2
endfor

time_stamp

out_str = 'HYDRA/PPA: '+ block_time + $
		' , Version: ' + strtrim(pitch.lib_string,2)
print, out_str

xyouts,.02,.5,out_str,/normal,alignment = 0.5,orient=90

if (gif eq 1) then write_gif,'idl.gif',tvrd()

endif
;==========================Raw Counts=====================
if (keyword_set(raw_cnts)) then begin

pi=acos(-1)

!p.multi=[0,4,9]

if (print eq 0 and ps eq 0) then window,lwindow,xsize=768,ysize=880

ymax = max(raw_2d(*,0))
ymin = 0. - .2*ymax

plot, 	red_alpha,raw_2d(*,0),$
	xtitle='pitch_angle [degrees]',$
	title='E=' + strtrim(long(red_energy(0)),2)+'eV'+ $
		'  offset='+string(offset(0),'(f5.1)')+ 's',$
	psym=0,$
	ytitle='raw',$
	charsize=charout,$
	yrange=[ymin,ymax],$
	xrange=[-10,190],$
	xstyle=1,$
	ystyle=1
oplot,	[-10,190],[0,0],line=2

for i=1,nlevels-1 do begin

ymax = max(raw_2d(*,i))
ymin = 0. - .2*ymax

plot, 	red_alpha,raw_2d(*,i),$
	psym=0,$
	title='E=' + strtrim(long(red_energy(i)),2)+'eV'+ $
		'  offset='+string(offset(i),'(f5.1)')+ 's',$
	charsize=charout,$
	yrange=[ymin,ymax],$
	xrange=[-10,190],$
	xstyle=1,$
	ystyle=1
oplot,	[-10,190],[0,0],line=2

endfor

out_str = 'HYDRA/PPA: '+ block_time + $
		' , Version: ' + strtrim(pitch.lib_string,2)
print, out_str

xyouts,.02,.5,out_str,/normal,alignment = 0.5,orient=90

time_stamp

if (gif eq 1) then write_gif,'idl.gif',tvrd()

endif
;==========================Energy ordered Raw Counts=====================
if (keyword_set(eo_raw)) then begin

pi=acos(-1)

!p.multi=[0,4,9]

if (print eq 0 and ps eq 0) then window,lwindow,xsize=768,ysize=880

ymax = max(raw_2d_sorted(*,0))
ymin = 0. - .2*ymax

plot, 	red_alpha_sorted,raw_2d_sorted(*,0),$
	xtitle='pitch angle [degrees]',$
	title='E=' + strtrim(long(red_energy_sorted(0)),2)+'eV'+ $
		'  offset='+string(offset_sorted(0),'(f5.1)')+ 's',$
	psym=0,$
	ytitle='raw',$
	charsize=charout,$
	yrange=[ymin,ymax],$
	xrange=[-10,190],$
	xstyle=1,$
	ystyle=1

for i=1,nlevels-1 do begin

ymax = max(raw_2d_sorted(*,i))
ymin = 0. - .2*ymax

plot, 	red_alpha_sorted,raw_2d_sorted(*,i),$
	psym=0,$
	title='E=' + strtrim(long(red_energy_sorted(i)),2)+'eV'+ $
		'  offset='+string(offset_sorted(i),'(f5.1)')+ 's',$
	charsize=charout,$
	yrange=[ymin,ymax],$
	xrange=[-10,190],$
	xstyle=1,$
	ystyle=1

endfor

out_str = 'HYDRA/PPA: '+ block_time + $
		' , Version: ' + strtrim(pitch.lib_string,2)
print, out_str

xyouts,.02,.5,out_str,/normal,alignment = 0.5,orient=90

time_stamp

if (gif eq 1) then write_gif,'idl.gif',tvrd()

endif
;======================================================================

if (read eq 1) then begin
	print, 'Removing file: ',filename
	spawn, 'rm '+filename
endif


if (print eq 1) then begin
	end_of_prog,/print
endif else begin
	end_of_prog
endelse

end
