PRO renorm_chi2, ps=ps

   IF (keyword_set(ps)) THEN ps = 1 ELSE ps = 0

   myname = 'renorm_chi2.pro'
   
   npts = 50
   x = dindgen(npts)
   seed = -2938785
   y = (x*3. + 50.) + 20.*randomn(seed,npts)
   
   rchi2 = fltarr(100)
   diff_sig = fltarr(100)
   diff_slope = fltarr(100)
   diff_intercept = fltarr(100)
   slope = fltarr(100)
   intercept = fltarr(100)
   slope_error = fltarr(100)
   intercept_error = fltarr(100)

   FOR it=0,99 DO BEGIN

      sig = dblarr(npts) + it+1
      diff_sig(it) = (it+1) - 20.
      
      mm = dblarr(2,2)
      mm(0,0) = total( (x/sig)^2, /double )
      mm(0,1) = total( x/sig^2, /double )
      mm(1,0) = mm(0,1)
      mm(1,1) = total( 1./sig^2, /double )
      
      inhomo = dblarr(2)
      inhomo(0) = total( y*x/sig^2, /double )
      inhomo(1) = total( y/sig^2, /double )
      
      imm = invert(mm,istat,/double)
      
      slope(it) = imm(0,0)*inhomo(0) + imm(0,1)*inhomo(1)
      intercept(it) = imm(1,0)*inhomo(0) + imm(1,1)*inhomo(1)
      
      chi2 = total( ( y - (slope(it)*x + intercept(it)) )^2/sig^2, /double )
      
      ndf = npts-2-1
      
      rchi2(it) = chi2/float(ndf)
      
;   chi2_surface = dblarr(100,100)
;   m = dindgen(100)*(10.-0.)/99. + 0.
;   b = dindgen(100)*(100.-0.)/99. + 0.
;   FOR i=0,99 DO BEGIN
;      FOR j=0,99 DO BEGIN
;         chi2_surface(i,j) = total( ( y - (m(i)*x + b(j)) )^2/sig^2, /double )
;      ENDFOR
;   ENDFOR
;   surface, chi2_surface, m, b, xtitle='m', ytitle='b', ztitle='chi2', charsize=2.5
      
      theta_p = 2.3             ; 2 params, 68%
      mm_temp = mm/chi2*float(ndf)
      
      slope_error(it) = sqrt(mm(1,1)*theta_p/(mm(0,0)*mm(1,1) - mm(0,1)^2))
      intercept_error(it) = sqrt(mm(0,0)*theta_p/(mm(0,0)*mm(1,1) - mm(0,1)^2))
      
      slope_error_temp = sqrt(mm_temp(1,1)*theta_p/(mm_temp(0,0)*mm_temp(1,1) - mm_temp(0,1)^2))
      intercept_error_temp = sqrt(mm_temp(0,0)*theta_p/(mm_temp(0,0)*mm_temp(1,1) - mm_temp(0,1)^2))
      
      diff_slope(it) = slope_error(it) - slope_error_temp
      diff_intercept(it) = intercept_error(it) - intercept_error_temp
      

   ENDFOR

   IF (NOT ps) THEN window, 0, xsize=700, ysize=700
   !p.multi = [0,1,2]

   IF (ps) THEN set_ps, orient='P', file='renorm_chi2.ps'

   plot, rchi2, diff_slope/slope_error*100., psym=2, ytitle='% by which !7r!x!s!dslope!n!r!uoriginal!n exceeds !7r!x!s!dslope!n!r!unormalized!n!c!c(normalized refers to !7v!x!u2!n)', xtitle='!7v!x!dR!u2!n', /xlog, ystyle=1, yrange=[0,100], xrange=[.01,1],charsize=1.5, title='2 parameter fit: y = mx + b'
   oplot, 10^(!x.crange), [0,0], line=3
   oplot, [1,1], !y.crange, line=3

   plot, rchi2, diff_intercept/intercept_error*100., psym=2, ytitle='% by which !7r!x!s!dintercept!n!r!uoriginal!n exceeds !7r!x!s!dintercept!n!r!unormalized!n!c!c(normalized refers to !7v!x!u2!n)',xtitle='!7v!x!dR!u2!n', /xlog, ystyle=1, yrange=[0,100], xrange=[.01,1],charsize=1.5
   oplot, 10^(!x.crange), [0,0], line=3
   oplot, [1,1], !y.crange, line=3

   time_stamp, label=' '+myname

   IF (ps) THEN end_of_prog

   stop
   return
END
