PRO test_ddcal

   id = cdf_open('/opt/hydra/l1_12/19980504_hyd_ddcal_v3.04.cdf')

   cdf_varget, id, 'MAX_BLOCK_NUMBER', nblocks, rec_start=0, rec_count=1

   cdf_varget, id, 'BLOCK_TIME', epoch, rec_start=0, rec_count=nblocks
   time = (epoch MOD 86400000)/1000.
   
   cdf_close, id

;   set_ps, orient='L',file='ddcal_dt.ps'
   dt = time(1:nblocks-1) - time(0:nblocks-2)
   plot, time, dt, /ylog, psym=3, ystyle=1, $
    ytitle='ddcal dt !cbetween measurements',xtickformat='tick_hms_pam',$
    yrange=[10,200]
   FOR jj=1,10 DO BEGIN 
      oplot, [min(time),max(time)], $
       [13.8*jj,13.8*jj],line=3
   ENDFOR
   time_stamp
;   end_of_prog

   stop

   return

END
