pro test_momext, ps=ps

if (keyword_set(ps)) then ps = 1 else ps = 0


extract_moments, 980502, 0200, 7, emom, /nofilter
extract_moments, 980502, 0200, 7, imom, /nofilter, /ion


!p.multi = [0,1,4]

if (not ps) then window, 0, xsize=700, ysize=700

if (ps) then set_ps, orient='L', file='mom_status.ps'

smart_range_ssm, emom.time, _extrax
plot, emom.time, emom.fifth_digit_of_status, _extra=_extrax, psym=2, $
  charsize=1.25, symsize=.5, yrange=[-1,6], ystyle=1, ytitle='ELE: 5th digit of status', title='19980502'
plot, emom.time, emom.n, _extra=_extrax, psym=2, $
  charsize=1.25, symsize=.5, ytitle='ELE density'

plot, imom.time, imom.fifth_digit_of_status, _extra=_extrax, psym=2, $
  charsize=1.25, symsize=.5, yrange=[-1,6], ystyle=1, ytitle='ION: 5th digit of status'
plot, imom.time, imom.n, _extra=_extrax, psym=2, $
  charsize=1.25, symsize=.5, ytitle='ION density'

if (ps) then end_of_prog

stop

return
end


