;
;                                                                      ;      
;                 ISTP Key Parameter Visualization Tool                ;  
;                            Version 2.0                               ;
;                                                                      ;
;                                by                                    ;
;                         Syau-Yun W. Hsieh                            ;
;                                                                      ;
;                  E-mail: xrswh@istp1.gsfc.nasa.gov                   ;
;           Phone: (301) 286-4981       Fax: (301) 286-1683            ;
;                                                                      ;
;
pro get_defdir,dirdiv,defdir
case !version.os of
'vms':begin
	dirdiv=']'
	defdirdiv=':'
	defdir='SYS$LOGIN:'
      end
'windows':begin
	    dirdiv='\'    &    defdir='C:\'
	  end
'Win32':begin
	    dirdiv='\'    &    defdir='C:\'
	end
'MacOS':begin
	    dirdiv=':'    &    defdir='Macintosh HD:'
	end
else:begin   ; unix 
       dirdiv='/'    &   defdir='~/'   
     end
endcase
end

pro get_message,mes_no,message
case mes_no of
0: message='<How to make a skeleton table from a CDF file ?  >'+$
	   '  Just select a CDF file.   You may specify a '+$
	   'directory path and file filter in this '+ $ 
	   'interface or the following step.'

1: message='< What is Plot File ? >'+  $
	'The concept of Plot File is created for visualizing the '+$
	'predetermined data selections and plot settings in a '+   $
	'regular basis.  The purpose of this feature is to '+      $
	'provide an effective and easy access to view and plot '+  $
	'the data the way we always want.  You can create as '+    $
	'many plot files as you want in using this powerful ' +    $
	'feature and make regular data visualization effectively.'+$
	'     < How to Create and Update a Plot File ? >'+         $
	'Very Simple.  First, you select the data by '+            $ 
	'clicking " Select Data " on the menu bar from the main '+ $
	'interface and customize the plot settings from each " Plot'+$
	' Control " interface.  If you want to view the same data '+ $
	'and plot settings in a regular basis, then you click ' +    $
	'" Plot File "  and then " Save ... ".  You specify a file '+$
	'name with directory path for the Plot File.  The KPVT will '+$
	'create a Plot File in the file name you have just specified '+$
	'when you click "OK".  A Plot File can '+$
	'be modified and saved at any time during the viewing.  '
else:
endcase
end

pro get_pfilename,outfile

get_defdir,dirdiv,defdir
pfiledir=defdir 
defcdfdiv='.'
outfile=pfiledir+'kpvt_plotfile'
end

pro getpath_event,eventgp
common maincom, mainflag ,Gimage 
common setvalue,imagecdf,varname,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length,imagefile
common fillbloc,fillpath,fillext,outfile
common sysbloc,sys_def
common defcom, def, sysdirs, syspcmd ,sdata,mday,spanel_index

widget_control,eventgp.id, get_uvalue=uval
case uval of
1: begin
     widget_control,fillext,get_value=fillext_val
     if ((mainflag.purpose eq 0) or (mainflag.purpose eq 1))then begin
	 filterspec=fillext_val(0)
	 mainflag.gonext=1
     endif else begin
	 outfile=fillext_val(0)
	 mainflag.yesorno=1
     endelse
     widget_control,eventgp.top,/destroy
   end
2: begin
     if ((mainflag.purpose eq 0) or (mainflag.purpose eq 1))then   $
	  mainflag.gonext=0 else mainflag.yesorno=0
     widget_control,eventgp.top,/destroy
   end
3: badnews,'************* To be implemented. *****************'
22:begin
     widget_control,fillext,get_value=fillext_val
     if mainflag.purpose eq 1 then filterspec=fillext_val(0)   $
			      else outfile=fillext_val(0)
     print, fillext_val
   end
else: begin   ; get directory path
	ndir=uval mod 101
	startpath=sysdirs.listval(ndir)
	widget_control,fillpath,set_value=startpath
      end
endcase

end

pro getpath,purpose,gp_title,mymessage
common maincom, mainflag ,Gimage
common defcom, def, sysdirs, syspcmd ,sdata,mday,spanel_index
common setvalue,imagecdf,varname,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length,imagefile
common fillbloc,fillpath,fillext,outfile
common sysbloc,sys_def

base_gp=widget_base(title=gp_title,/column,xoffset=50,yoffset=100) 
if ((purpose eq 1) or (purpose eq 3)) then                             $
   show_message=widget_text(base_gp,value=mymessage,xsize=50,ysize=8,  $
		       /frame,  /wrap,/scroll)
base1=widget_base(base_gp,/frame,/column)

if ((purpose eq 0) or (purpose eq 1)) then begin
   base11=widget_base(base1,/row)
   text1=widget_label(base11, value='Directory Path:      ')
   fillpath=widget_text(base11,value=startpath,xsize=40,/frame  )
   cpath=widget_button(base11,value='  Change to... ',/menu)
   num_dirs=n_elements(sysdirs.listval)
   cpath_but=lonarr(num_dirs)
   for i=0,num_dirs-1 do cpath_but(i)=widget_button(cpath,                  $
				   value=sysdirs.listval(i),uvalue=101+i)
endif

base22=widget_base(base1,/row)
case 1 of
(purpose eq 0) or (purpose eq 1):begin 
				   text21val='File Filter:    '    
				   fillextval=filterspec
				 end
purpose eq 2: begin
		 text21val='Output File Name:  '
		 fillextval=outfile
	      end
purpose eq 3: begin
		 text21val='Plot File Name:  '
		 fillextval=outfile
	      end
else:
endcase

text21=widget_label(base22,value=text21val  )
fillext=widget_text(base22,value=fillextval,uvalue=22,xsize=40,/frame, $
		    /editable)
nu=widget_label(base_gp,value='      ')
base2=widget_base(base_gp,/row,space=20)
butval=['     OK     ','    Cancel    ','     Help     ']
but=lonarr(3)
nu=widget_label(base2,value='         ')
for i=0,2 do but(i)=widget_button(base2,value=butval(i),uvalue=i+1,/frame)
widget_control,base_gp,/realize,/hourglass
xmanager,"getpath",base_gp,group_leader=sys_def.leader,/MODAL
end

pro show_status,status

case status of
1: mesout='Generating Skeleton Table ......  '
2: mesout='Loading and Processing Data ......  '
3: mesout='Printing ......  '
else:
endcase
window,status,title='Processing Status'    
wset,status
xyouts,0.5,0.5,mesout,alignment=0.5,charsize=2.0,charthick=2.0,color=200, $
	       /normal
end

pro get_filefilter,type
common setvalue,imagecdf,imageKP,num_panel,foldername,$ 
       pdtitle,startpath,filterspec,cdf_selection,cdf_length,imagefile 

case  1  of
((!version.os eq 'windows') or (!version.os eq 'Win32') or  $
 (!version.os eq 'vms') ):begin
    case type of
     1:  filterspec='*.CDF'
     2:  filterspec='*.SFD'
     3:  filterspec='*.SKT'
     4:  filterspec='*.*'
     5:  filterspec='*.GIF'
     6:  filterspec='*.JPEG'
     7:  filterspec='.SKT'
     else:
    endcase
  end  
else:  begin   ; for unix and 'MacOS'
	 case type of
	 1:  filterspec='*.cdf'
	 2:  filterspec='*.sfd'
	 3:  filterspec='*.skt'
	 4:  filterspec='*.*'
	 5:  filterspec='*.gif'
	 6:  filterspec='*.jpeg'
	 7:  filterspec='.skt'
	 else:
	 endcase
       end   
endcase
end

function find_doy,yr,mon,dayday
; find day of year
firstday=[0,31,59,90,120,151,181,212,243,273,304,334,366]
if (((yr mod 4)eq 0) and ((yr mod 100) ne 0)) or ((yr mod 400) eq 0) $
then firstday(2)=firstday(2:*)+1
doy=dayday+firstday(mon-1)
return,doy
end

pro add_coordinates,ps=ps  ; SPECIAL ACT
common setvalue,imagecdf,imageKP,num_panel,foldername,$ 
       pdtitle,startpath,filterspec,cdf_selection,cdf_length,imagefile 
common defcom, def, sysdirs, syspcmd,sdata,mday,spanel_index            
common image_common,img,imgpos,imgcs,one
common dicom,label_0,label_1,label_2,info_all_image,imageindex_set,  $
	     select_one,info_one_image,fileline,KPline,screen_list,  $
	     select_screen,one_imageindex,coordtype,gi_info 

; get data first
imagefile=sdata.cdf(spanel_index)
id=cdf_open(imagefile)
varname='GEODETIC_LAT'
cdf_varget,id,varname,varval,rec_count=1,interval=[3,228,200,1,1], $
	      rec_start=imageindex_set(one_imageindex)
glat = transpose( reform(varval) )
varname='GEODETIC_LONG'
cdf_varget,id,varname,varval,rec_count=1,interval=[3,228,200,1,1], $
	      rec_start=imageindex_set(one_imageindex)
glon = transpose( reform(varval) )
cdf_close,id
;
case img.add_coord of
1:begin
    lon=glon & lat=glat
  end
2:begin
    geo_to_mag,glat,glon,mlat,mlon
    lon=mlon & lat=mlat
  end
else:
endcase

if keyword_set(ps) then begin
   deviceval=0    &  normval=1
endif else begin
   deviceval=1    &  normval=0
endelse
contour,lon,/noerase,xstyle=5,ystyle=5,                                $
       levels=[0,90,180,270],device=deviceval, normal=normval,         $
       c_labels=[1,1,1,1],c_linestyle=1,c_thick=1.5,color=!d.n_colors-1
contour,lat,/noerase,xstyle=5,ystyle=5,levels=[0,10,30,50,70,80],      $
       c_labels=[1,1,1,1,1,1],c_linestyle=1,color=!d.n_colors-1,       $
       device=deviceval, normal=normval, c_thick=1.5
!p.region=0

end

;"geo_to_mag" --procedure used in UVI Glynn Germany's kpfvu tool - SY  
;
pro geo_to_mag,lat,lon,lat_mag,lon_mag
; from code supplied by Dirk Lummerzheim    

lat_p=11*!dtor    ; geographic co-latitude of north pole
lon_p=-70*!dtor   ; geographic longitude (east positive) of north pole

;convert input values from degrees to radians
lat_g=(90-lat)*!dtor  ; convert to co-latitude
lon_g=lon*!dtor

;convert to magnetic coords
lat_mag=acos( cos(lat_p)*cos(lat_g) + $
		  sin(lat_p)*sin(lat_g)*cos(lon_g-lon_p) )
lon_mag=asin( sin(lat_g)*sin(lon_g-lon_p)/ $
		       sin(lat_mag) )

;check for bad values of lon
i=where(finite(lon_mag) lt 1, ii)
if ii gt 0 then lon_mag(i)=0

;convert back from radians to degrees
lon_mag=lon_mag/!dtor
lat_mag=90-lat_mag/!dtor  ; convert from co-latitude

lm=atan( tan(lat_p), cos(lon_g-lon_p) )
i=where(lat_g gt lm, ii)
if ii gt 0 then lon_mag(i)=180-lon_mag(i)
lon_mag=360-((lon_mag + 180) mod 360)
end

pro add_magnetic  ; SPECIAL ACT
common setvalue,imagecdf,imageKP,num_panel,foldername,$ 
       pdtitle,startpath,filterspec,cdf_selection,cdf_length,imagefile 
common defcom, def, sysdirs, syspcmd,sdata,mday,spanel_index            
common dicom,label_0,label_1,label_2,info_all_image,imageindex_set,  $
	     select_one,info_one_image,fileline,KPline,screen_list,  $
	     select_screen,one_imageindex,coordtype 

; get data first
imagefile=sdata.cdf(spanel_index)
id=cdf_open(imagefile)
varname='GEODETIC_LAT'
cdf_varget,id,varname,varval,rec_count=1,interval=[3,228,200,1,1], $
	      rec_start=imageindex_set(one_imageindex)
glat = transpose( reform(varval) )
varname='GEODETIC_LONG'
cdf_varget,id,varname,varval,rec_count=1,interval=[3,228,200,1,1], $
	      rec_start=imageindex_set(one_imageindex)
glon = transpose( reform(varval) )
cdf_close,id
;
; plot it   - a good idea from 
!p.region=!p.position
contour,glon,/noerase,xstyle=5,ystyle=5,levels=[0,90,180,270],/device, $
       c_labels=[1,1,1,1],c_linestyle=1,c_thick=1.5,color=!d.n_colors-1
contour,glat,/noerase,xstyle=5,ystyle=5,levels=[0,10,30,50,70,80],  $
       c_labels=[1,1,1,1,1,1],c_linestyle=1,color=!d.n_colors-1,    $
       /device,c_thick=1.5
!p.region=0

end

pro change_cs_event,eventcc
common defcom, def, sysdirs, syspcmd,sdata,mday,spanel_index            
common image_common,img,imgpos,imgcs,one 
common dicom,label_0,label_1,label_2,info_all_image,imageindex_set,  $
	     select_one,info_one_image,fileline,KPline,screen_list,  $
	     select_screen,one_imageindex,coordtype,gi_info 
common cc, labelcc1,label_cc,cc110,cc12range,is_sensitive

widget_control,eventcc.top,get_uvalue=idata,/no_copy
widget_control,labelcc1,get_uvalue=edata,/no_copy
widget_control,eventcc.id,get_uvalue=uval
case uval of
1: begin     ; apply the changes
     if imgcs.moreORone eq 0 then begin
	get_plotformat
	window,20,xsize=imgpos.screen_x,ysize=imgpos.screen_y,  $
	       title='Group Images in Time Series'
	wset,20
	show_groupimage,idata,edata
     endif else begin
	showone,idata,edata
     endelse
   end
2:  widget_control,eventcc.top,/destroy    ; cancel
3:  widget_control,eventcc.top,/destroy
4:    ; help
11: begin
      img.cscale=0    ; auto scaling without color bar
      imgcs.cscale1=0
      if is_sensitive eq 1 then begin
	 widget_control,label_cc,sensitive=0
	 widget_control,cc110,sensitive=0
      endif
      is_sensitive=0
    end
12: begin
      img.cscale=1    ; auto scaling with color bar
      imgcs.cscale1=1
      if is_sensitive eq 1 then begin
	 widget_control,label_cc,sensitive=0
	 widget_control,cc110,sensitive=0
      endif
      is_sensitive=0
    end

13: begin           ; common color scaling
      is_sensitive=1
      img.cscale=2
      imgcs.cscale1=2
      widget_control,label_cc,sensitive=1
      widget_control,cc110,sensitive=1
      case img.spikeout of
      0: begin
	   if imgcs.moreORone eq 0 then begin
	      imgcs.newfcs_min=imgcs.fcs_min
	      imgcs.newfcs_max=imgcs.fcs_set
	      xminx=imgcs.newfcs_min  &  xmaxx=imgcs.newfcs_max 
	   endif else begin
	      imgcs.new_min1 = imgcs.min1
	      imgcs.new_max1 = imgcs.max1
	      xminx=imgcs.new_min1  &  xmaxx=imgcs.new_max1
	   endelse   
	      delta = ( imgcs.fcs_max - imgcs.fcs_min ) / 4
	      widget_control,cc12range(0), $
		      set_slider_min=imgcs.fcs_min-delta,               $
		      set_slider_max=imgcs.fcs_max
	      widget_control,cc12range(1),  $
		      set_slider_min=imgcs.fcs_min,                     $
		      set_slider_max=imgcs.fcs_max+delta
       
	 end
      else: begin
		case sdata.instrument(spanel_index) of
		'uvi': begin
		       if imgcs.moreORone eq 0 then begin
			  imgcs.newfcs_min=imgcs.uvi_fcs_min
			  imgcs.newfcs_max=imgcs.uvi_fcs_max
			  xminx= imgcs.newfcs_min  &  xmaxx=imgcs.newfcs_max 
		       endif else begin
			  imgcs.new_min1 = imgcs.uvi_min1
			  imgcs.new_max1 = imgcs.uvi_max1
			  xminx= imgcs.new_min1   &    xmaxx=imgcs.new_max1 
		       endelse
		       delta=( imgcs.uvi_fcs_max-imgcs.uvi_fcs_min)/4
		       widget_control,cc12range(0),set_value=xminx,    $
				set_slider_min=imgcs.uvi_fcs_min-delta,$
				set_slider_max=imgcs.uvi_fcs_max
		       widget_control,cc12range(1),set_value=xmaxx,    $
				set_slider_min=imgcs.uvi_fcs_min,      $
				set_slider_max=imgcs.uvi_fcs_max+delta
		     end
		else:
		endcase
	    end
      endcase
      widget_control,cc12range(0),set_value=xminx
      widget_control,cc12range(1),set_value=xmaxx
     end

21: begin    ; minimum scale range
      widget_control,cc12range(0),get_value=cval
      if imgcs.moreORone eq 0 then begin
	 imgcs.newfcs_min = cval
	 imgcs.fcs_def = 1
      endif else begin
	imgcs.new_min1= cval
	imgcs.def1=1
      endelse
    end

22: begin    ; maximum scale range
      widget_control,cc12range(1),get_value=cval
      if imgcs.moreORone eq 0 then begin
	imgcs.newfcs_max = cval
	imgcs.fcs_def = 2
      endif else begin
	imgcs.new_max1= cval
	imgcs.def1=1
      endelse
    end

31: begin
      img.spikeout=0       ; without spike removal
      if is_sensitive eq 1 then begin
	 if imgcs.moreORone eq 0 then begin
	    imgcs.newfcs_min = imgcs.fcs_min1
	    imgcs.newfcs_max = imgcs.fcs_set
	    xminx=imgcs.newfcs_min    &   xmaxx=imgcs.newfcs_max
	 endif else begin
	    imgcs.new_min1 = imgcs.min1
	    imgcs.new_max1 = imgcs.max1
	    xminx=imgcs.new_min1    &   xmaxx=imgcs.new_max1
	 endelse
	 widget_control,cc12range(0),set_value=xminx
	 widget_control,cc12range(1),set_value=xmaxx
      endif
    end
32: begin
      img.spikeout=1       ; with spike removal
      if is_sensitive eq 1 then begin
	 case sdata.instrument(spanel_index) of
	 'uvi': begin
		  if imgcs.moreORone eq 0 then begin
		     imgcs.newfcs_min=imgcs.uvi_fcs_min
		     imgcs.newfcs_max=imgcs.uvi_fcs_max
		     xminx=imgcs.newfcs_min   &   xmaxx=imgcs.newfcs_max
		  endif else begin
		     imgcs.new_min1=imgcs.uvi_min1
		     imgcs.new_max1=imgcs.uvi_max1
		     xminx=imgcs.uvi_min1   &   xmaxx=imgcs.uvi_max1
		  endelse
		end
	 else:
	 endcase
	 widget_control,cc12range(0),set_value=xminx
	 widget_control,cc12range(1),set_value=xmaxx
      endif
    end
9:    ; special help file about spike removal
else:
endcase
if widget_info(eventcc.top,/valid)then begin
   widget_control,eventcc.top,set_uvalue=idata,/no_copy
   widget_control,labelcc1,set_uvalue=edata,/no_copy
endif

end

pro change_cs,window_ext,idata,edata
common defcom, def, sysdirs, syspcmd,sdata,mday,spanel_index            
common image_common,img,imgpos,imgcs,one 
common dicom,label_0,label_1,label_2,info_all_image,imageindex_set, $
	     select_one,info_one_image,fileline,KPline,screen_list, $
	     select_screen,one_imageindex,coordtype,gi_info 
common cc, labelcc1,label_cc,cc110,cc12range,is_sensitive

basecc=widget_base(/column,title='Change Color Scale'+window_ext,yoffset=120)
cc0=widget_base(basecc,/row,space=5)
butcc=lonarr(4) & butcc_val=['  Apply the Change(s)  ','  Cancel  ',   $
			     '  Exit  ','  Help  ']
for i=0,3 do butcc(i)=widget_button( cc0,value=butcc_val(i),uvalue=i+1,/frame)
nu=widget_label(basecc,value='    ')
cc01=widget_base(basecc,/row)
nu=widget_label(cc01,value='      ')
cc22_but=widget_button(cc01,   uvalue=9,/frame ,                   $
		       value='              Read Me First !!              ')
nu=widget_label(cc01,value='      ')
labelcc1=widget_label(basecc,value='  ')

label=widget_label(basecc,value='Display Image(s) with' )
cc1=widget_base(basecc,/column,/frame)
cc11=widget_base(cc1,/exclusive,/column)
cc11_but=lonarr(3)
cc11_butval=['   Auto   Color Scaling   ( without Color Bar )',   $
	     '   Auto   Color Scaling   ( with    Color Bar )',   $
	     '   Common Color Scaling   ( with    Color Bar )'  ]
for i=0,2 do cc11_but(i)=widget_button(cc11, value=cc11_butval(i),      $
				    uvalue=11+i,/no_release )
nu=widget_label(cc1,value='    ')
label_cc=widget_label(cc1,value='Select the Range of Common Color Scale')
cc110=widget_base(cc1,/row)
nu=widget_label(cc110,value='   ')
cc111=widget_base(cc110,/column,/frame)
cc12=lonarr(2)   
cc12label_val=[ '< Minimum >' , '< Maximum >'] 
cc12range=lonarr(2) 
for i=0,1 do begin 
    cc12(i)=widget_base(cc111,/row)
    label=widget_label(cc12(i),value=cc12label_val(i))
    cc12range(i)=widget_slider(cc12(i), xsize=400, uvalue=21+i)
		; minimum=slider_min, $
		; maximum=slider_max, uvalue=21+i)  
endfor
nu=widget_label(cc110,value='     ')
nu=widget_label(cc1,value='   ')
; special act here
if sdata.instrument(spanel_index) eq 'uvi' then begin
   nu=widget_label(basecc,value='  ')
   label=widget_label(basecc,value='Process Image Data with' )
   cc2=widget_base(basecc,/exclusive,/frame,/row)
   cc21_but=lonarr(2)
   cc21_butval=['  No Spike Removal  ', '  Spike Removal  '  ]
   for i=0,1 do  cc21_but(i)=widget_button(cc2, value=cc21_butval(i), $
					 uvalue=31+i,/no_release )
endif
;
widget_control,basecc,/realize
;
if imgcs.moreORone eq 0 then widget_control,cc11_but(0),/set_button   $
			else widget_control,cc11_but(1),/set_button
widget_control,label_cc,sensitive=0
widget_control,cc110,sensitive=0
is_sensitive=0
if sdata.instrument(spanel_index) eq 'uvi' then                       $
		 widget_control,cc21_but(0),/set_button
widget_control,basecc,set_uvalue=idata,/no_copy
widget_control,labelcc1,set_uvalue=edata,/no_copy
xmanager,"change_cs",basecc
end

pro get_minmaxval,minval,maxval
common defcom, def, sysdirs, syspcmd,sdata,mday,spanel_index            
common image_common,img,imgpos,imgcs,one 

case imgcs.cscale1 of
2: begin      ; use a common scale
     case imgcs.def1 of
     0: begin    ; common scale not been changed
	  case img.spikeout of
	  0: begin
	       minval=imgcs.min1
	       maxval=imgcs.max1
	     end
	  else: begin
		  case sdata.instrument(spanel_index) of
		  'uvi':begin
			  minval = imgcs.uvi_min1
			  maxval = imgcs.uvi_max1
			end
		  else:
		  endcase
		end
	  endcase
	end
     else: begin    ; common scale has been changed
	     minval=imgcs.new_min1
	     maxval=imgcs.new_max1
	   end
     endcase
   end
else: begin     ; 0 or 1: use individual color scale
	case img.spikeout of
	0: begin
	     minval = imgcs.min1
	     maxval = imgcs.max1
	   end
	else: begin
		 case sdata.instrument(spanel_index) of
		 'uvi':begin
			 minval = imgcs.uvi_min1
			 maxval = imgcs.uvi_max1
		       end
		 else:
		 endcase
	      end
	endcase
      end
endcase
end

pro show_oneimage,imagedata,epochdata,ps=ps 
common defcom, def, sysdirs, syspcmd,sdata,mday,spanel_index            
common image_common,img,imgpos,imgcs,one 
common dicom,label_0,label_1,label_2,info_all_image,imageindex_set,  $
	     select_one,info_one_image,fileline,KPline,screen_list,  $
	     select_screen,one_imageindex,coordtype,gi_info 

one_imagetime=epochdata(one_imageindex) 
; labels 
title_1='!3'+ sdata.title(spanel_index) 
title_2='!3'+ img.date    
title_3='!3'+one_imagetime 
title_4='!3'+ img.varlabel
coord=['Coordinate Grid: Geodetic Coordinates',  $
       'Coordinate Grid: Magnetic Coordinates']
subtitle_2='!3Key Parameter Visualization Tool V2.0       @ ' + systime() 
; 
x0=one.image_xpos 
x1=x0 + one.imagesize_x 
y0=one.image_ypos 
y1=y0 + one.imagesize_y 
cbar_x0=x1 + one.one_gap_bar 
cbar_x1=cbar_x0 + one.cbar_w 
cbar_y0=y0 
cbar_y1=y0 + one.imagesize_y 
; 
erase,255 
!p.color=0 

oneimagedata=rebin( imagedata(*,*,one_imageindex),         $ 
		    fix(one.imagesize_x),fix(one.imagesize_y) ) 
if imgcs.plotone_def eq 0 then begin      ; imgcs.plotone_def=0 means this     
					  ; single image is plotted 1st time
   imgcs.min1 = max( [ min(oneimagedata), 0 ] )
   imgcs.max1 = max( oneimagedata)
   if sdata.instrument(spanel_index) eq 'uvi' then begin
      imgcs.uvi_min1=max( [ min(oneimagedata), 0 ] )
      std = stdev(oneimagedata)
      med = median(oneimagedata)
      imgcs.uvi_max1 = max(oneimagedata)
      if( ( imgcs.uvi_max1 - med ) gt 3*std )then imgcs.uvi_max1=med+(3*std)
   endif
   minval=imgcs.min1         &     maxval=imgcs.max1   

endif else get_minmaxval,minval,maxval

if keyword_set(ps) then $ 
      tv,bytscl(oneimagedata),one.image_xpos/one.screen_x,             $ 
	 one.image_ypos/one.screen_y,xsize=one.imagesize_x/one.screen_x,$ 
	 ysize=one.imagesize_y/one.screen_y,/normal                    $ 
else  tv,bytscl(oneimagedata,min=minval,max=maxval),one.image_xpos,    $
	 one.image_ypos 
mr=spanel_index 
case 1 of
((sdata.instrument(mr) eq 'asi') or (sdata.instrument(mr) eq 'uvi')):begin
	 xrange=[sdata.ymin(mr),sdata.ymax(mr)]
	 yrange=[sdata.xmin(mr),sdata.xmax(mr)]
	 ixlabel=sdata.ylabel(mr)    &    iylabel=sdata.xlabel(mr) 
     end
else: begin
	xrange=[sdata.xmin(mr),sdata.xmax(mr)]
	yrange=[sdata.ymin(mr),sdata.ymax(mr)]
	ixlabel=sdata.xlabel(mr)    &    iylabel=sdata.ylabel(mr) 
      end
endcase
xx0=float(x0)/float(one.screen_x) & yy0=float(y0)/float(one.screen_y)
xx1=float(x1)/float(one.screen_x) & yy1=float(y1)/float(one.screen_y)
one_pos=[float(x0/one.screen_x), float(y0/one.screen_y), $
	 float(x1/one.screen_x), float(y1/one.screen_y)  ] 

if keyword_set(ps) then begin 
   plot,xrange,yrange,position=[xx0,yy0,xx1,yy1],/normal,/noerase,ystyle=1, $ 
	xstyle=1,psym=3,xrange=xrange,yrange=yrange,xtitle=ixlabel,      $ 
	ytitle=iylabel,color=0,charsize=1.0 ,charthick=1.5,ticklen=-0.02           
   ; add coordinates or not?? 
   !p.region= [xx0,yy0,xx1,yy1]     &    ps=1
   if img.add_coord ne 0 then add_coordinates,ps=ps
   ;
   if imgcs.cscale1 ne 0 then begin  ; draw a color bar 
	bar_cstep=!d.n_colors    &   tmp=indgen(bar_cstep) 
	colorbar=congrid(rotate(tmp,1), one.cbar_w, one.imagesize_y) 
	tvscl, colorbar, cbar_x0/one.screen_x, cbar_y0/one.screen_y,  $
	       /normal,xsize=one.cbar_w/one.screen_x,  $
	       ysize=one.imagesize_y/one.screen_y 
	plot,[0,1],[minval,maxval],/normal,/noerase,/nodata,xticks=1,  $
	       xstyle=1,xtickname=[' ',' '], yticks=4,  $
	       ytickname=[' ',' ',' ',' ',' '],ystyle=1,color=0,  $
	       position=[cbar_x0/one.screen_x,cbar_y0/one.screen_y,$ 
	       cbar_x1/one.screen_x,cbar_y1/one.screen_y],charsize=0.85 
	axis,yaxis=1,yrange=[minval,maxval],charsize=0.85,ytitle=img.varunit,$ 
	       ticklen=-0.06,charthick=1.5,yticks=4,ystyle=1,/normal 
   endif
   xyouts, 0.5, (y1+95)/one.screen_y,title_1,/normal,alignment=0.5,   $
		charsize=1.5,charthick=1.5 
   xyouts, 0.5, (y1+75)/one.screen_y,title_2,/normal,alignment=0.5,   $
		charsize=1.2,charthick=1.25 
   xyouts, 0.5, (y1+50)/one.screen_y,title_3,/normal,alignment=0.5,   $
		charsize=1.2,charthick=1.25
   xyouts, 0.5, (y1+15)/one.screen_y,title_4,/normal,alignment=0.5,   $ 
		charsize=1.35,charthick=1.5
   if img.add_coord ne 0 then xyouts,0.5,30/one.screen_y,             $
		coord(img.add_coord-1),/normal,alignment=0.5,charsize=1.0,$
		charthick=1.5
   xyouts, 0.5, 10/one.screen_y,subtitle_2,/normal,alignment=0.5,     $
		charsize=1.,charthick=1.5       
endif else begin 
   plot,xrange,yrange,position=[x0,y0,x1,y1],/device,/noerase,ystyle=1,  $ 
	xstyle=1,psym=3,xrange=xrange,yrange=yrange,xtitle=ixlabel,      $ 
	ytitle=iylabel,color=0 ,charsize=1.0,ticklen=-0.02,charthick=1.5  
   ; add coordinates or not?? 
   if img.add_coord ne 0 then begin 
       !p.region=[x0,y0,x1,y1]
       add_coordinates
   endif
   ;
   if imgcs.cscale1 ne 0 then begin    ;draw a color bar 
      bar_cstep=!d.n_colors  &  tmp=indgen(bar_cstep) 
      colorbar=congrid(rotate(tmp,1), one.cbar_w, one.imagesize_y) 
      tvscl, colorbar, cbar_x0, cbar_y0 
      plot,[0,1],[minval,maxval],/device,/noerase,/nodata,xticks=1,xstyle=1,$ 
	   xtickname=[' ',' '], yticks=4,ytickname=[' ',' ',' ',' ',' '], $
	   ystyle=1,color=0,position=[cbar_x0,cbar_y0,cbar_x1,cbar_y1],   $ 
	   charsize=0.85,charthick=1.5
      axis,yaxis=1,yrange=[minval,maxval], charsize=0.85,ytitle=img.varunit,$ 
	   charthick=1.5,yticks=4,ystyle=1,ticklen=-0.06
   endif
   out_xpos=one.screen_x/2. 
   xyouts,out_xpos,(y1+95),title_1,/device,alignment=0.5,charsize=1.35,   $
	  charthick=1.5 
   xyouts,out_xpos,(y1+75),title_2,/device,alignment=0.5,charsize=1.0,  $ 
	  charthick=1.5
   xyouts,out_xpos,(y1+50),title_3,/device,alignment=0.5,charsize=1.0,  $
	  charthick=1.5 
   xyouts,out_xpos,(y1+15),title_4,/device,alignment=0.5,charsize=1.25,  $ 
	  charthick=1.5
   if img.add_coord ne 0 then xyouts,out_xpos,30,             $
	   coord(img.add_coord-1),/device,alignment=0.5,charsize=1.0,$
	   charthick=1.5
   xyouts,out_xpos,10,subtitle_2,/device,alignment=0.5  ,charsize=0.85,  $     
	  charthick=1.5
endelse 
if imgcs.plotone_def eq 0 then imgcs.plotone_def =1

end 
  
pro showone,imagedata,epochdata 
common defcom, def, sysdirs, syspcmd,sdata,mday,spanel_index            
common image_common,img,imgpos,imgcs,one 
common dicom,label_0,label_1,label_2,info_all_image,imageindex_set,  $
	     select_one,info_one_image,fileline,KPline,screen_list,  $
	     select_screen,one_imageindex,coordtype,gi_info 
 
;define the limits for the best visual size of individual image 
one_xmin=250     ; uvi and vis will be displayed in actual size
one_ymin=250
;find good zoom size 
case 1 of 
(img.imagesize_x lt one_xmin) and (img.imagesize_y lt one_ymin):begin 
    factor=2. 
    found_zoom_size=0 
    while found_zoom_size eq 0 do begin 
      zoom_size=1.*factor 
      oneimagesize_x=img.imagesize_x *zoom_size 
      oneimagesize_y=img.imagesize_y *zoom_size 
      if ((oneimagesize_x ge one_xmin) or (oneimagesize_y ge one_ymin))then $  
	 found_zoom_size=1      $ 
      else begin 
	 factor=factor+1. 
	 found_zoom_size=0 
      endelse 
    endwhile 
  end 
else:begin 
       zoom_size=1. 
       oneimagesize_x=img.imagesize_x 
       oneimagesize_y=img.imagesize_y 
     end 
endcase 

;define  other parameters 
oneimage_xpos=95   &   oneimage_ypos=115 
header=115  &  cbar_w=15  &  cbar_h=img.imagesize_y   &  one_gap_bar=10
one_screen_x=oneimage_xpos + oneimagesize_x + one_gap_bar + cbar_w +  $ 
	     oneimage_xpos 
one_screen_y=oneimage_ypos + oneimagesize_y + header 
 
if strlowcase(!d.name) ne 'ps' then begin  
   if !version.os ne 'MacOS' then begin
       device,window_state=xx 
       ;help,xx 
       ;print,'window_state:',xx 
       if xx(21) eq 1 then begin 
	   device,get_window_position=yy 
	   window,21,xsize=one_screen_x,ysize=one_screen_y,xpos=yy(0), $ 
		ypos=yy(1),title='Individual Image' 
       endif else begin 
	   window,21,xsize=one_screen_x,ysize=one_screen_y,   $
		title='Individual Image' 
       endelse 
   endif else window,21,xsize=one_screen_x,ysize=one_screen_y,title=   $
			'Individual Image'
   wset,21 
endif 
;define structure
one={ imagesize_x: 600.0, imagesize_y: 600., image_xpos: 600.,image_ypos:600.,$
      header:600.,cbar_w: 600., cbar_h:600.,one_gap_bar:600., screen_x:600.,   $
      screen_y:600. }
one.imagesize_x=oneimagesize_x   &  one.imagesize_y= oneimagesize_y
one.image_xpos=oneimage_xpos     &  one.image_ypos=oneimage_ypos
one.header=header &  one.cbar_w=cbar_w   &  one.cbar_h=cbar_h
one.one_gap_bar=one_gap_bar
one.screen_x=one_screen_x    &   one.screen_y=one_screen_y
show_oneimage,imagedata,epochdata 
 
end 
 
pro listone,epochdata 
common defcom, def, sysdirs, syspcmd,sdata,mday,spanel_index            
common image_common,img,imgpos,imgcs,one
common dicom,label_0,label_1,label_2,info_all_image,imageindex_set,  $
	     select_one,info_one_image,fileline,KPline,screen_list,  $
	     select_screen,one_imageindex,coordtype,gi_info 

all_image_list=strarr(img.image_index_max - img.image_index_min + 1) 
for i=0, (img.image_index_max - img.image_index_min) do                   $ 
   all_image_list(i)='Frame '+ strcompress(string(i+img.image_index_min), $
		     /remove_all)+' : '+ epochdata(i) 
one_image_info='Select an image frame to display an individual '+   $ 
	       'image from the ones displayed on screen number: '+  $
	       string(img.screen_index)      
widget_control,select_one,set_value=all_image_list 
widget_control,info_one_image,set_value=one_image_info 
end 
 
pro ehandler,ev 
 
widget_control,/destroy,ev.top 
 
end 

pro get_cscale, i, imin, imax
common defcom, def, sysdirs, syspcmd,sdata,mday,spanel_index            
common image_common,img,imgpos,imgcs,one 

case img.cscale of
2: begin  ; use a common scale
     case imgcs.fcs_def of
     0: begin    ; common scale not been changed
	  case img.spikeout of
	  0: begin
	       imin=imgcs.fcs_min
	       imax=imgcs.fcs_set
	     end
	  else: begin
		  case sdata.instrument(spanel_index) of
		  'uvi':begin
			  imin=imgcs.uvi_fcs_min
			  imax=imgcs.uvi_fcs_set
			end
		  else:
		  endcase
		end
	  endcase
	end
     else: begin    ; common scale has been changed
	     imin=imgcs.newfcs_min
	     imax=imgcs.newfcs_max
	   end
     endcase
   end
else: begin     ; 0 or 1: use individual color scale
	case img.spikeout of
	0: begin
	     imin=imgcs.cscale_min(i)
	     imax=imgcs.cscale_max(i)
	   end
	else: begin
		 case sdata.instrument(spanel_index) of
		 'uvi':begin
			 imin=imgcs.uvi_cscale_min(i)
			 imax=imgcs.uvi_cscale_max(i)
		       end
		 else:
		 endcase
	      end
	endcase
      end
endcase

end

pro write_title,title_flag,ps=ps
common defcom, def, sysdirs, syspcmd,sdata,mday,spanel_index            
common image_common,img,imgpos,imgcs,one 

case title_flag of
1: begin   ; main
     title1='!3'+ sdata.title(spanel_index) 
     title2='!3'+ img.date
     title3='!3'+ img.varlabel
     if keyword_set(ps) then begin 
	xyouts,imgpos.title_xpos*1./imgpos.screen_x,                       $
	       imgpos.title1_ypos*1./imgpos.screen_y,                      $
	       title1, alignment=0.5, charsize=1.5,/normal,color=0,       $
	       charthick=1.95 
	xyouts,imgpos.title_xpos*1./imgpos.screen_x,                       $
	       imgpos.title2_ypos*1./imgpos.screen_y,                      $
	       title2, alignment=0.5, charsize=1.2,/normal,color=0 ,   $
	       charthick=1.5
	xyouts,imgpos.title_xpos*1./imgpos.screen_x,                       $
	       imgpos.title3_ypos*1./imgpos.screen_y,                      $
	       title3, alignment=0.5, charsize=1.35,/normal,color=0 ,   $
	       charthick=1.75
     endif else begin 
	xyouts,imgpos.title_xpos,imgpos.title1_ypos,title1,alignment=0.5,  $
	       charsize=1.35,/device 
	xyouts,imgpos.title_xpos,imgpos.title2_ypos,title2,alignment=0.5,  $
	       charsize=1.0,/device 
	xyouts,imgpos.title_xpos,imgpos.title3_ypos,title3,alignment=0.5,  $
	       charsize=1.0,/device 
     endelse 
   end
2: begin   ; sub
      if img.cscale ne 2 then subtitle1='!3Unit:  '+ img.varunit else $
			      subtitle1=img.varunit
      subtitle2='!3Key Parameter Visualization Tool V2.0         @ '+systime() 
      if keyword_set(ps) then begin
	  xyouts,imgpos.title_xpos*1./imgpos.screen_x,               $
		 imgpos.subtitle1_ypos*1./imgpos.screen_y,           $ 
		 subtitle1,alignment=0.5,charsize=1.0,/normal,charthick=1.5 
	  xyouts,imgpos.title_xpos*1./imgpos.screen_x,               $
		 imgpos.subtitle2_ypos*1./imgpos.screen_y,           $ 
		 subtitle2,alignment=0.5,charsize=1.0,/normal ,charthick=1.5
      endif else begin 
	  xyouts,imgpos.title_xpos,imgpos.subtitle1_ypos,subtitle1,  $
		 alignment=0.5, charsize=1.0,/device      
	  xyouts,imgpos.title_xpos,imgpos.subtitle2_ypos,subtitle2,  $
		 alignment=0.5, charsize=1.0, /device 
      endelse 
   end
3: begin
     title2='!3'+ img.date
     if keyword_set(ps) then begin 
	xyouts,imgpos.title_xpos*1./imgpos.screen_x,                   $
	       imgpos.title2_ypos*1./imgpos.screen_y,                  $
	       title2, alignment=0.5, charsize=1.2,/normal,color=0 ,   $
	       charthick=1.5
     endif else begin 
	xyouts,imgpos.title_xpos,imgpos.title2_ypos,title2,  $
	       alignment=0.5,charsize=1.0,/device 
     endelse 
   end
else: print,'Something is wrong @ write_title
endcase
end

pro show_groupimage,imagedata,epochdata,ps=ps 
common defcom, def, sysdirs, syspcmd,sdata,mday,spanel_index            
common image_common,img,imgpos,imgcs,one 
common dicom,label_0,label_1,label_2,info_all_image,imageindex_set,  $
	     select_one,info_one_image,fileline,KPline,screen_list,  $
	     select_screen,one_imageindex,coordtype,gi_info 

erase,255 
!p.color=0 
title_flag=1
write_title,title_flag,ps=ps     ; write main titles

; check if it is a full screen
if (( img.screen_index +1) lt img.num_screen) then full_screen=1  $
					      else full_screen=0 
case full_screen of 
1:     num_image_c=img.num_image_screen 
0:     num_image_c=img.num_image - (img.num_screen-1)*img.num_image_screen 
else:   
endcase 
num_rec=num_image_c
start_recnum = img.screen_index * img.num_image_screen
;
imageindex_set=intarr(num_image_c)
if img.plotmore_def eq 0 then begin    ; plotmore_def is a flag for 1st plot
  inum = num_image_c
  ; set up a structure
  imgcs={ fcs_def:0, cscale_min:fltarr(inum), cscale_max:fltarr(inum),      $
	  fcs_min:1.e12, fcs_max:1.e12, newfcs_min:1.e12, newfcs_max:1.e12, $ 
	  moreORone:0, fcs_set:1.e12,    $ 
	  plotone_def:0, def1:0, min1:1.e12, max1:1.e12, uvi_min1:1.e12,   $
	  uvi_max1:1.e12, new_min1:1.e12, new_max1:1.e12, cscale1:0  }
  if sdata.instrument(spanel_index) eq 'uvi' then begin
     ; reset a structure
     imgcs={ fcs_def:0, cscale_min:fltarr(inum), cscale_max:fltarr(inum),  $
	     fcs_min:1.e12, fcs_max:1.e12, uvi_cscale_min:fltarr(inum),    $  
	     uvi_cscale_max:fltarr(inum), uvi_fcs_min:1.e12,               $
	     uvi_fcs_max:1.e12, newfcs_min:1.e12, newfcs_max:1.e12,        $
	     moreORone:0, fcs_set:1.e12, uvi_fcs_set:1.e12,   $ 
	     plotone_def:0, def1:0, min1:1.e12, max1:1.e12, uvi_min1:1.e12, $
	     uvi_max1:1.e12, new_min1:1.e12, new_max1:1.e12, cscale1:0  }
  endif
      imgcs.plotone_def=0       ; for 1st time plotting
      imgcs.def1=0              ;
      imgcs.cscale1=1           ;
endif
;
if img.loadmore eq 0 then begin
   imagefile=sdata.cdf(spanel_index)
   id=cdf_open(imagefile) 
   imagecdf=cdf_inquire(id) 
   epochdata=strarr(num_rec) 
   if sdata.instrument(spanel_index) eq 'uvi' then                   $ 
	imagedata = fltarr( sdata.ysize, sdata.xsize, num_rec )     $
   else imagedata = fltarr( sdata.xsize, sdata.ysize, num_rec )
endif
;
for i=0,num_image_c-1 do begin 
  image_index=(img.screen_index *img.num_image_screen) + i  
  imageindex_set(i)=image_index 
  if img.loadmore eq 0 then begin       ; loaded data is clean
     load_image,id,image_index,imagedata1,epochdata1
     imagedata(*,*,i)=imagedata1
     epochdata(i)=epochdata1
  endif
  newimagedata=rebin(imagedata(*,*,i),fix(img.newimage_x),fix(img.newimage_y)) 
  ;
  if keyword_set(ps) then begin 
      get_cscale,i,imin,imax
      xyouts,imgpos.epoch_xpos(i)*1./imgpos.screen_x,   $
	    imgpos.epoch_ypos(i)*1./imgpos.screen_y,      $ 
	    epochdata(i),alignment=0.5,charsize=1.0,charthick=1.5,/normal
      tv, bytscl(newimagedata,min=imin,max=imax),                  $
	   imgpos.image_xpos(i)*1./imgpos.screen_x,                 $
	   imgpos.image_ypos(i)*1./imgpos.screen_y,                 $ 
	   xsize=img.newimage_x*1./imgpos.screen_x,                 $ 
	   ysize=img.newimage_y*1./imgpos.screen_y, /normal  
      if img.cscale eq 1 then begin
	   acbar=findgen(imgpos.acbar_w)#replicate(1,imgpos.acbar_h)
	   xnorm=1./imgpos.screen_x
	   ynorm=1./imgpos.screen_y
	   tvscl,acbar,imgpos.acbar_x0(i)*xnorm,imgpos.acbar_y0(i)*ynorm, $
		xsize=imgpos.acbar_w*xnorm,ysize=imgpos.acbar_h*ynorm,/normal
	   plot,[imin,imax],[0,1],/noerase, /nodata,xticks=1,xstyle=1,     $
	      xtickname=[' ',' '],yticks=1,ystyle=1,color=0,charsize=0.5,  $
	      ytickname=[' ',' '],xticklen=-0.02,charthick=1.0,            $
	      position=[imgpos.acbar_x0(i)*xnorm,imgpos.acbar_y0(i)*ynorm, $
	      imgpos.acbar_x1(i)*xnorm,imgpos.acbar_y1(i)*ynorm],/normal
	   axis,xaxis=0,xrange=[imin,imax],charthick=1.0,xticklen=-0.02, $
		xticks=1,xstyle=1,xcharsize=0.5,/normal
      endif
   endif else begin 
      case img.plotmore_def of
      0:  begin   ; first time plotting  & collect scale infos 
	     imgcs.cscale_min(i) = max([min(newimagedata),0])      ; def
	     imgcs.cscale_max(i) = max(newimagedata)      ; def
	     if sdata.instrument(spanel_index) eq 'uvi' then begin
		 imgcs.uvi_cscale_min(i)=max([min(newimagedata),0])
		 std = stdev(newimagedata)
		 med = median(newimagedata)
		 iimax = max(newimagedata)
		 if((iimax - med) gt 3*std) then iimax = med+(3*std)
		 imgcs.uvi_cscale_max(i) = iimax
	     endif
	     imin= imgcs.cscale_min(i)
	     imax= imgcs.cscale_max(i)
	  end
      else: get_cscale,i,imin,imax
      endcase         
      xyouts,imgpos.epoch_xpos(i),imgpos.epoch_ypos(i),epochdata(i),   $
	     alignment=0.5,charsize=1.0,/device 
      tv, bytscl(newimagedata,min=imin,max=imax),imgpos.image_xpos(i), $
	  imgpos.image_ypos(i) 
     
      if img.cscale eq 1 then begin
	 acbar=findgen(imgpos.acbar_w)#replicate(1,imgpos.acbar_h)
	 if keyword_set(ps) then begin
	     xnorm=1./imgpos.screen_x
	     ynorm=1./imgpos.screen_y
	     tvscl,acbar,imgpos.acbar_x0(i)*xnorm,imgpos.acbar_y0(i)*ynorm, $
		   /normal
	     plot,[imin,imax],[0,1],/noerase, /nodata,xticks=1,  $
		xstyle=1,xtickname=[' ',' '],yticks=1,ystyle=1,color=0,     $
		ytickname=[' ',' '],xticklen=-0.02,charsize=0.5,$
		position=[imgpos.acbar_x0(i)*xnorm,imgpos.acbar_y0(i)*ynorm, $
			  imgpos.acbar_x1(i)*xnorm,imgpos.acbar_y1(i)],$
		charthick=1.0,/normal
	     axis,xaxis=0,xrange=[imin,imax],charthick=1.0,xticklen=-0.02, $
		xticks=1,xstyle=1,xcharsize=0.5,/normal
	 endif else begin
	     tvscl,acbar,imgpos.acbar_x0(i),imgpos.acbar_y0(i)
	     plot,[imin,imax],[0,1],/device,/noerase,color=0,  $
		/nodata,xticks=1,xstyle=1,xtickname=[' ',' '],yticks=1,  $
		ystyle=1,ytickname=[' ',' '],xticklen=-0.02,charsize=0.5,$
		position=[imgpos.acbar_x0(i),imgpos.acbar_y0(i),  $
			  imgpos.acbar_x1(i), imgpos.acbar_y1(i)]
	     axis,xaxis=0,xrange=[imin,imax],          $
		charthick=1.0,xticklen=-0.02,xticks=1,xstyle=1,xcharsize=0.5
	 endelse
      endif
   endelse     
   
   case 1 of 
     (i eq 0): begin 
		 img.image_index_min = image_index 
		 img.image_time_min = epochdata(i) 
		 if num_image_c eq 1 then begin 
		      img.image_index_max = image_index 
		      img.image_time_max = epochdata(i) 
		 endif 
	       end 
     (i eq num_image_c-1): begin 
			     img.image_index_max = image_index 
			     img.image_time_max = epochdata(i) 
			   end 
   else: 
   endcase 
endfor 

if img.loadmore eq 0 then begin
   cdf_close,id
   if(( start_recnum eq 0) and (img.firststart eq 0)) then begin
      title_flag = 3
      write_title,title_flag,ps=ps
      img.firststart=1
   endif
   img.loadmore=1    ; 1 means the group data is loaded 
endif

if img.plotmore_def eq 0 then begin
     ; get min and max for fix scaling
   imgcs.fcs_min = min(imgcs.cscale_min)
   imgcs.fcs_max = max(imgcs.cscale_max)
   if n_elements(imgcs.cscale_max) le 1 then imgcs.fcs_set=imgcs.fcs_max   $
	 else  imgcs.fcs_set =median(imgcs.cscale_max)
   if sdata.instrument(spanel_index) eq 'uvi' then begin  ; SPECIAL ACT HERE!!
      imgcs.uvi_fcs_min = min( imgcs.uvi_cscale_min )
      imgcs.uvi_fcs_max = max( imgcs.uvi_cscale_max )
      imgcs.uvi_fcs_set = max( imgcs.uvi_cscale_max)
   endif
     ; reset the flags
   img.plotmore_def=1      ; done the 1st plot
   imgcs.fcs_def=0         ; def common scale
endif
  
if img.cscale eq 2 then begin
   fcbar=findgen(imgpos.fcbar_w)#replicate(1,imgpos.fcbar_h)
   if keyword_set(ps) then begin
     xnorm=1./imgpos.screen_x
     ynorm=1./imgpos.screen_y
     tvscl,fcbar,imgpos.fcbar_x0*xnorm,imgpos.fcbar_y0*ynorm,/normal,$
      xsize=imgpos.fcbar_w*xnorm,ysize=imgpos.fcbar_h*ynorm
     plot,[imgcs.newfcs_min,imgcs.newfcs_max],[0,1],/noerase,  $
      /nodata,xticks=4,xstyle=1,xtickname=[' ',' ',' ',' ',' '],yticks=1, $
      ystyle=1,ytickname=[' ',' '],color=0,xticklen=-0.18,charsize=0.85,$
      position=[imgpos.fcbar_x0*xnorm,imgpos.fcbar_y0*ynorm,   $
      imgpos.fcbar_x1*xnorm,imgpos.fcbar_y1*ynorm],charthick=1.5,/normal
     axis,xaxis=0,xrange=[imgcs.newfcs_min,imgcs.newfcs_max],          $
      charthick=1.5,xticklen=-0.18,xticks=4,xstyle=1,xcharsize=0.85
   endif else begin
     tvscl,fcbar,imgpos.fcbar_x0,imgpos.fcbar_y0
     plot,[imgcs.newfcs_min,imgcs.newfcs_max],[0,1],/device,/noerase,  $
     /nodata,xticks=4,xstyle=1,xtickname=[' ',' ',' ',' ',' '],yticks=1,     $
      ystyle=1,ytickname=[' ',' '],color=0,xticklen=-0.07,charsize=0.8,$
      position=[imgpos.fcbar_x0,imgpos.fcbar_y0,imgpos.fcbar_x1,      $
      imgpos.fcbar_y1]
     axis,xaxis=0,xrange=[imgcs.newfcs_min,imgcs.newfcs_max],          $
      charthick=1.5,xticklen=-0.07,xticks=4,xstyle=1,xcharsize=0.8
   endelse
endif

title_flag=2
write_title,title_flag,ps=ps       ; write sub-titles

end             

pro get_oneuvinfo                  ; special act for uvi
common defcom, def, sysdirs, syspcmd,sdata,mday,spanel_index            
common image_common,img,imgpos,imgcs,one 
common dicom,label_0,label_1,label_2,info_all_image,imageindex_set,  $
	     select_one,info_one_image,fileline,KPline,screen_list,  $
	     select_screen,one_imageindex,coordtype,gi_info 
; This procedure is to get useful infos  for the selected single image


end
 
pro get_moreuvinfo,epochdata        ; special act for uvi

common defcom, def, sysdirs, syspcmd,sdata,mday,spanel_index            
common image_common,img,imgpos,imgcs,one 
common dicom,label_0,label_1,label_2,info_all_image,imageindex_set,  $
	     select_one,info_one_image,fileline,KPline,screen_list,  $
	     select_screen,one_imageindex,coordtype,gi_info 

imagefile = sdata.cdf(spanel_index)
filternum=[2,3,4,5,6] & filterlist=['1304','1356','LBHS','LBHL','SOLR']
id=cdf_open(imagefile)
widget_control,gi_info,set_value=' '
for i=0, (img.image_index_max -img.image_index_min)do begin
   varname='FILTER'
   cdf_varget,id,varname,filter,rec_count=1,interval=[3,228,200,23,20], $
	      rec_start=imageindex_set(i)
   whereis=where(filternum eq filter,count)
   if count ne 0 then filter=filterlist(whereis) else filter='(unknown)'
   varname='GAIN'
   cdf_varget,id,varname,gain,rec_count=1,interval=[3,228,200,23,20], $
	      rec_start=imageindex_set(i)
   timeframe= 'Frame '+ strcompress( string( imageindex_set(i) ),    $
		/remove_all)+': '+ epochdata(i) 
   tlen=strlen(timeframe)
   if tlen lt 19 then begin
     case 19-tlen of
     1: aspace=' '
     2: aspace='  '
     3: aspace='   '
     4: aspace='    '
     5: aspace='     '
     6: aspace='      '
     else: aspace=''
     endcase
   endif else aspace=''
   more_uvinfo=timeframe +aspace+ '   '+              $
		'Filter: '+strcompress( string( filter),/remove_all)+  $
		'   '+'Gain: '+ strcompress( string( gain),/remove_all)
   widget_control,gi_info,/append,set_value=more_uvinfo
endfor
widget_control,gi_info,/set_text_top_line   
cdf_close,id

end

pro showmore,imagedata,epochdata 
common defcom, def, sysdirs, syspcmd,sdata,mday,spanel_index            
common image_common,img,imgpos,imgcs,one 
common dicom,label_0,label_1,label_2,info_all_image,imageindex_set,  $
	     select_one,info_one_image,fileline,KPline,screen_list,  $
	     select_screen,one_imageindex,coordtype,gi_info 

wset,20    
show_groupimage,imagedata,epochdata 

wdelete,2
all_screenindex = 'Screen Number:  '+string(img.screen_index) 
all_imageindex = 'Image Frame:  '+  $ 
		 strcompress(string(img.image_index_min),/remove_all)+ $ 
		 ' - '+strcompress(string(img.image_index_max),/remove_all) 
all_imagetime=   'Time:         '+  $ 
		 strcompress(string(img.image_time_min),/remove_all)+ $ 
		 ' - '+strcompress(string(img.image_time_max),/remove_all) 
widget_control,label_0,set_value= all_screenindex 
widget_control,label_1,set_value= all_imageindex 
widget_control,label_2,set_value= all_imagetime 
; 
end 

pro load_image,cdfid,index,imagedata1,epochdata1 
common defcom, def, sysdirs, syspcmd,sdata,mday,spanel_index            
common image_common,img,imgpos,imgcs,one 
 
si=spanel_index
varname=sdata.zvar(spanel_index) 

zinterval = sdata.zinterval( si, 0:sdata.z_ndims(si)-1 )
if n_elements(zinterval) le 1 then zinterval = zinterval            $
			      else zinterval = reform(zinterval)
zoffset = sdata.zoffset( si, 0:sdata.z_ndims(si)-1 )
if n_elements(zoffset) le 1 then zoffset = zoffset                  $
			      else zoffset = reform(zoffset)
case sdata.zis_zvar(si) of
1:cdf_varget,cdfid,varname,imagedata1,rec_count=1,/zvariable,           $
	     interval=zinterval,rec_start= index
0:cdf_varget,cdfid,varname,imagedata1,rec_count=1,interval=zinterval,   $
	     rec_start=index
else: print,'Something is wrong @load_image'
endcase

varname='Epoch' 
einterval = sdata.einterval(  0:sdata.z_ndims(si)-1 )
eoffset = sdata.eoffset(  0:sdata.z_ndims(si)-1 )
varinfo=cdf_varinq(cdfid,varname)
case varinfo.is_zvar of
1:  cdf_varget,cdfid,varname,epoch_val,rec_count=1,/zvariable,         $
	       interval=einterval,rec_start=index
0:  cdf_varget,cdfid,varname,epoch_val,rec_count=1,interval=einterval, $ 
	       rec_start=index
else: print,'Something is wrong @load_image'
endcase
imagedata1=reform(imagedata1) 
num=n_elements(epoch_val)
if num le 1 then epoch_val=epoch_val else epoch_val=reform(epoch_val)  

case sdata.instrument(si) of     ; remove the fill, zero out the fill 
'asi': begin
	     imagedata1 = imagedata1*(imagedata1 ne 255)
	  end
'uvi': begin
	     imagedata1 = transpose(imagedata1)
	     imagedata1 = imagedata1*(imagedata1 ne -127)
	     imagedata1 = imagedata1*(imagedata1 ne -32768)
	  end
else:
endcase
cdf_epoch,epoch_val,yr,mon,day,hr,min,sec,millisec,/break 
epochdata1 = strcompress(string(hr),  /remove_all ) + ':' +    $ 
	     strcompress(string(min), /remove_all ) + ':' +    $ 
	     strcompress(string(sec), /remove_all ) 
doy=find_doy(yr,mon,day)
image_date=strcompress(string(mon ),/remove_all)+'/'+              $
	   strcompress(string(day),/remove_all)+'/'+               $
	   strcompress(string( yr),/remove_all)+'       ( DOY : '+ $
	   strcompress(string(doy),/remove_all)+' )'
img.date=image_date
end 

pro get_plotformat
common image_common,img,imgpos,imgcs,one 
 
imgpos={ screen_x: 600, screen_y: 600,                              $
	 image_xpos: intarr(img.num_image_screen),                  $
	 image_ypos: intarr(img.num_image_screen),                  $
	 epoch_xpos: intarr(img.num_image_screen),                  $
	 epoch_ypos: intarr(img.num_image_screen),                  $   
	 fcbar_h:0, fcbar_w:0, fcbar_gap:0, fcbar_x0:0, fcbar_x1:0, $
	 fcbar_y0:0, fcbar_y1:0, acbar_h:0, acbar_w:0, acbar_gap:0, $ 
	 acbar_x0:intarr(img.num_image_screen),                     $
	 acbar_x1:intarr(img.num_image_screen),                     $
	 acbar_y0:intarr(img.num_image_screen),                     $
	 acbar_y1:intarr(img.num_image_screen),                     $
	 title_xpos: 600, title1_ypos: 600, title2_ypos:600,        $
	 title3_ypos:600, subtitle1_ypos: 600, subtitle2_ypos: 600 } 

imgpos.screen_x = 30 + img.num_newimage_x * img.newimage_x +          $
		  (img.num_newimage_x -1) * img.x_offset + 30
case img.cscale of 
0: imgpos.screen_y=65+img.num_newimage_y*(img.y1_offset+img.newimage_y) + 65
1: imgpos.screen_y= 65 + img.num_newimage_y*(img.y1_offset+img.newimage_y + $
		    img.y2_offset) + 65
2: imgpos.screen_y= 65 + img.num_newimage_y*(img.y1_offset+img.newimage_y)+ $
		    img.y3_offset + 65
else:
endcase

imgpos.title_xpos = floor( imgpos.screen_x / 2. )
imgpos.title1_ypos = imgpos.screen_y - 20
imgpos.title2_ypos = imgpos.screen_y - 40
imgpos.title3_ypos = imgpos.screen_y - 65
imgpos.subtitle1_ypos=40
imgpos.subtitle2_ypos=10

imgpos.fcbar_h = 20
imgpos.fcbar_w = fix( imgpos.screen_x *( 10./16. ) )
imgpos.fcbar_gap = 40
imgpos.fcbar_x0 = fix( imgpos.screen_x * ( 3./16. ) )
imgpos.fcbar_x1 = imgpos.fcbar_x0 + imgpos.fcbar_w
imgpos.fcbar_y0 = 65+(img.y3_offset-imgpos.fcbar_gap-imgpos.fcbar_h)
imgpos.fcbar_y1 = imgpos.fcbar_y0 + imgpos.fcbar_h

imgpos.acbar_h = 12
imgpos.acbar_w = fix( img.newimage_x / 2.)
imgpos.acbar_gap = 10

for i=0,img.num_newimage_y -1 do begin 
    for j=0, img.num_newimage_x -1 do begin 
       img.pos_index=(i*img.num_newimage_x)+j
       imgpos.image_xpos(img.pos_index) = 30+j*(img.newimage_x+img.x_offset) 
       imgpos.epoch_xpos(img.pos_index)=30+j*(img.newimage_x+img.x_offset)+$ 
			    floor( float(img.newimage_x + img.x_offset)/2.) 
       case img.cscale of
       1: begin    ; auto scaling with colorbars
	     imgpos.image_ypos(img.pos_index) = imgpos.screen_y-65-     $
		     (i+1)*( img.newimage_y+img.y1_offset) - i*img.y2_offset
	     imgpos.epoch_ypos(img.pos_index) = imgpos.screen_y-65-     $
		     i*(img.newimage_y+img.y1_offset)- i*img.y2_offset-  $ 
		     floor( float(img.y1_offset) *0.85 ) 
	     imgpos.acbar_x0(img.pos_index)=30+fix(img.newimage_x/4.)+  $
		     j*(img.newimage_x+img.x_offset)
	     imgpos.acbar_x1(img.pos_index)=imgpos.acbar_x0(img.pos_index)+$
					     imgpos.acbar_w
	     imgpos.acbar_y1(img.pos_index)=   $
		     imgpos.image_ypos(img.pos_index)-imgpos.acbar_gap
	     imgpos.acbar_y0(img.pos_index)=imgpos.acbar_y1(img.pos_index)-$
					     imgpos.acbar_h
	  end
       else: begin
	       imgpos.image_ypos(img.pos_index) = imgpos.screen_y-65-  $
		     (i+1)*(img.newimage_y+img.y1_offset)
	       imgpos.epoch_ypos(img.pos_index) = imgpos.screen_y-65-  $
		     i*(img.newimage_y+img.y1_offset)-                  $ 
		     floor( float(img.y1_offset) *0.85 ) 
	     end
       endcase
    endfor        
endfor 

end

pro get_pvalue,zoom_size 
common defcom, def, sysdirs, syspcmd,sdata,mday,spanel_index            
common image_common,img,imgpos,imgcs,one 
	  
img.x_offset=30     
img.y1_offset=30   ; offset for epoch which at the top of the image in y
img.y2_offset=40   ; offset for a color bar at the bottom of each image in y
img.y3_offset=80  ; offset for the common color bar at the bottom of g images 

img.newimage_y=img.imagesize_y * zoom_size   ; same as x 
img.num_newimage_y=floor( img.screen_y / (img.y1_offset + img.newimage_y ) )

img.num_image_screen=img.num_newimage_x * img.num_newimage_y 
img.num_screen=img.num_image / img.num_image_screen 
 
extra_screen=img.num_image mod img.num_image_screen 
if extra_screen ne 0 then img.num_screen=img.num_screen+1   

end 
 
pro get_num_x,zoom_size
common image_common,img,imgpos,imgcs,one 

img.newimage_x=img.imagesize_x * zoom_size 
img.num_newimage_x=floor(img.screen_x / img.newimage_x)   ; get num in x
new_adjust=img.screen_x mod img.newimage_x  ; check if room for offset
if (new_adjust eq 0) then begin             ; no room left for offset   
  img.num_newimage_x=img.num_newimage_x - 1 
  offset_i=(img.screen_x-(img.num_newimage_x*img.newimage_x))         $
			/ (img.num_newimage_x-1)
  if offset_i lt 30 then img.num_newimage_x = img.num_newimage_x - 1
endif else if (new_adjust/(img.num_newimage_x-1) lt 30 )then           $
			   img.num_newimage_x = img.num_newimage_x - 1 

end
 
pro process_image
common defcom, def, sysdirs, syspcmd,sdata,mday,spanel_index            
common image_common,img,imgpos,imgcs,one 
 
num_image_x=floor(img.screen_x /img.imagesize_x) 
num_image_xmin=4 
num_image_xmax=5 
case 1 of  
(num_image_x lt num_image_xmin): begin  
   factor=2. 
   found_zoom_size=0 
   while found_zoom_size eq 0 do begin 
     zoom_size=1./factor 
     pass_x=img.imagesize_x mod factor 
     pass_y=img.imagesize_y mod factor 
     if(( pass_x eq 0) and (pass_y eq 0)) then begin   ;valid zoom size     
       get_num_x,zoom_size
       if img.num_newimage_x ge num_image_xmin then begin 
	   get_pvalue,zoom_size
	   found_zoom_size =1 
       endif else begin   ; if still less than 4 then needs to reduce again 
	   found_zoom_size=0 
	   factor=factor+1. 
       endelse 
     endif else begin   ; if not valid then needs to find another one 
		   found_zoom_size=0 
		   factor=factor+1. 
     endelse 
   endwhile 
   end                       
 
(num_image_x gt num_image_xmax):begin    
  factor=2.  
  found_zoom_size = 0 
  while found_zoom_size eq 0 do begin 
    zoom_size=1. * factor 
    get_num_x, zoom_size   
    if (img.num_newimage_x gt num_image_xmax) then begin 
	  found_zoom_size=0 
	  factor=factor+1. 
    endif else begin   ; < & = 6 
		  get_pvalue, zoom_size
		  found_zoom_size =1 
    endelse    
  endwhile 
  end 
						  
(num_image_x ge num_image_xmin) and                   $
      (num_image_x le num_image_xmax): begin   
      zoom_size=1. 
      get_num_x, zoom_size
      get_pvalue, zoom_size 
      found_zoom_size =1 
   end 
endcase 
end 
  
pro setenv_more,imagefile,imageKP
common defcom, def, sysdirs, syspcmd,sdata,mday,spanel_index            
common image_common,img,imgpos,imgcs,one 

img={ screen_x:600, screen_y:600, num_image:600, num_screen:50,           $
      num_image_screen:50,  x_offset:50, y1_offset:50, y2_offset:50,      $
      y3_offset:50, screen_index:0, imagesize_x:600, imagesize_y:600,     $
      num_newimage_x:0, num_newimage_y:0, newimage_x:100, newimage_y:100, $ 
      image_index_min:600, image_index_max:600,image_time_min:'',         $
      image_time_max:'',pos_index:600, cscale:0, varlabel:'', varunit:'', $
      date:'' , plotmore_def:0, spikeout:0, add_coord:0, loadmore:0,      $
      firststart:0 }  
labelpos = strpos( sdata.zlabel(spanel_index), '(' )
if labelpos ne -1 then varlabel=strmid(sdata.zlabel(spanel_index),0,   $
       labelpos-1) else varlabel=sdata.zlabel(spanel_index)
img.varlabel=varlabel
len=strlen(sdata.zlabel(spanel_index))
varunit=strmid( sdata.zlabel(spanel_index),labelpos+2,len-(labelpos+2)-2 )
img.varunit=varunit

device,get_screen_size=screen_size 
if((screen_size(0) lt 512) or (screen_size(1) lt 512) ) then begin
    img.screen_x=400         ; img.screen_x:  image plotting area in x 
    img.screen_y=400         ; img.screen_y:  image plotting area in y  
endif else begin
   if !version.os eq 'MacOS' then begin
      img.screen_x=500
      img.screen_y=500
   endif else begin
      img.screen_x=600     ; may need to set at 602 for vis
      img.screen_y=600 
   endelse
endelse
     
id=cdf_open(imagefile)
varname=imageKP
si=spanel_index
case sdata.zis_zvar(si) of
1: begin
     cdf_control,id,variable=varname,/zvariable,get_var_info=vinfo
     img.num_image = vinfo.maxrec + 1 
   end
0: begin
     imagecdf = cdf_inquire(id)
     img.num_image = imagecdf.maxrec + 1
   end
endcase
cdf_close,id
img.imagesize_x = sdata.ysize   
img.imagesize_y = sdata.xsize  
process_image

end
	  
pro get_newimgfile_event,eventnif
common defcom, def, sysdirs, syspcmd,sdata ,mday ,spanel_index          
common setvalue,imagecdf,imageKP,num_panel,foldername,$ 
       pdtitle,startpath,filterspec,cdf_selection,cdf_length,imagefile 
common newimg,newfile,extratop_img,imgfile_label   
common flagcom,sdata_flag,file_label

widget_control,eventnif.id,get_uvalue=uval
case uval of
1: begin    ;ok and plot it
     widget_control, eventnif.top, /destroy
     sdata.cdf = newfile
     if sdata_flag ne 100 then widget_control, extratop_img, /destroy
     status=2 
     show_status,status
     display_image
     if sdata_flag eq 100 then sdata_flag=101
   end
2:  widget_control,eventnif.top,/destroy    ;cancel
3:    ;help
31: begin     ;select a new cdf file 
	pdtitle=' Select Data: Select a New CDF File '
	get_filefilter,1
	file_selection=pickfile(title=pdtitle,filter=filterspec,           $ 
		    file=filename,path=sdata.dir(spanel_index) )
	yesfile=where(file_selection ne '',count)
	if count ne 0 then begin
	  newfile=file_selection                        
	  widget_control,imgfile_label,set_value='  Current File :  '+newfile
	endif else badnews,'  *****    No New CDF/File Selected.   *****  '
    end
endcase
end

pro get_newimgfile   
common defcom, def, sysdirs, syspcmd,sdata ,mday ,spanel_index          
common newimg,newfile,extratop_img,imgfile_label
common flagcom,sdata_flag,file_label

if sdata_flag eq 100 then bartitle=' Plot File : Select Data '    $
   else bartitle=' Select Another File to View the Same Data Selections '
newfile =sdata.cdf
basenif=widget_base(/column,title=bartitle,xoffset=20,yoffset=100)
; top
base0=widget_base(basenif,/row,space=5)
control_val=['     OK  ==>  Go Plot !!     ','    Cancel    ','    Help    ']
control=lonarr(3)
for i=0,2 do control(i)=widget_button(base0,value=control_val(i),  $
				      uvalue=i+1, /frame, font=def.widfont )
if sdata_flag eq 100 then begin
  nu=widget_label(basenif,value='  ')
  label=widget_label(basenif,value='Data Type : Image Data',font=def.widfont)
endif

; bottom
base1=widget_base(basenif,/column,/frame)
kplabel=widget_label(base1,value=  ' Key Parameter: '+ $ 
		     sdata.var(spanel_index), /align_left, font=def.widfont )
nu=widget_label(base1,value='  ')
; 
base2=widget_base(base1,/row)
label=widget_label(base2,value=' From:   ',font=def.widfont)
base3=widget_base(base2, /column, /frame)
if sdata_flag eq 100 then    $
     label=widget_label(base3,value='  Source       :  '+  $
		  sdata.title(spanel_index),font=def.widfont,/align_left) 
dir_label =widget_label(base3,value='  Directory    :  '+  $
		  sdata.dir(spanel_index),/align_left,font=def.widfont)
if sdata_flag ne 100 then filenow=sdata.cdf(spanel_index)  $
		     else filenow='(None)'
imgfile_label=widget_label(base3,value='  Current File :  '+  $
			filenow, /align_left, font=def.widfont)
nu=widget_label(base3,value=' ')
imgfile_but=widget_button(base3,value='   Select a New CDF File   ',   $
			  uvalue=31, /frame ,font=def.widfont)
;                                                                       
widget_control,basenif,/realize
xmanager,"get_newimgfile",basenif
end

pro display_image_event,eventdi 
common defcom, def, sysdirs, syspcmd,sdata,mday,spanel_index            
common image_common,img,imgpos,imgcs,one
common dicom,label_0,label_1,label_2,info_all_image,imageindex_set,  $
	     select_one,info_one_image,fileline,KPline,screen_list,  $
	     select_screen,one_imageindex,coordtype,gi_info 
common setting,psflag,rpflag,poflag
common setvalue,imagecdf,imageKP,num_panel,foldername,$ 
       pdtitle,startpath,filterspec,cdf_selection,cdf_length,imagefile 
common hcbloc,otflag,hc_input,lpr_command,WH,off_LL,WH_val,off_LLval, $ 
	      psfile,psfile_name,colorflag,windex,windex_val,okflag 
common sysbloc,sys_def 
common maincom, mainflag,Gimage
common fillbloc,fillpath,fillext,outfile
common newimg,newfile,extratop_img,imgfile_label
 
widget_control,eventdi.top,get_uvalue=imagedata,/no_copy 
widget_control,label_1,get_uvalue=epochdata,/no_copy 
type=tag_names(eventdi,/structure) 
widget_control,eventdi.id,get_uvalue=uval 
case uval of 
100: begin       
       one_imageindex=eventdi.index
       showone,imagedata,epochdata 
       imgcs.plotone_def=0       
       imgcs.def1=0              ;
       imgcs.cscale1=1           ;
     end 
 1: begin    
       xloadct,group=eventdi.top 
    end
 2: begin   
       imgcs.moreORone = 0   
       window_ext=' ( Group Images ) '
       data=imagedata & time=epochdata
       change_cs,window_ext,data,time         
    end
 3: begin    
       if one_imageindex ne -1 then begin
	  imgcs.moreORone = 1
	  window_ext=' ( Individual Image ) '
	  data=imagedata & time=epochdata
	  change_cs,window_ext,data,time
       endif else badnews,'  You need to select an individual image first.'
    end
 5:          ; save plot in PostScript file
 6:          ; save plot in GIF file
 7:          ; save plot in JPEG file
13: begin                           ; make a hardcopy 
       sys_def.lpr_plot=1 
       hardcopy 
       if okflag eq 1 then begin 
	  ps=1 
	  case windex_val of 
	  20:   show_groupimage,imagedata,epochdata ,ps=ps  
	  21:   show_oneimage,imagedata,epochdata,ps=ps 
	  else: 
	  endcase 
	  output_plot 
       endif 
		     
       case !version.os of 
       'windows': set_plot,'win' 
       else: set_plot,'x' 
       endcase 
    end 
14: begin 
      extratop_img = eventdi.top
      get_newimgfile
    end
15: begin   
	mainflag.purpose=3    &    message_no=1 
	get_message,message_no,mymessage
	title=' Create or Update a Plot File '
	get_pfilename,outfile
	getpath,mainflag.purpose,title,mymessage
	if mainflag.yesorno eq 1 then begin
	      save,filename=outfile,sdata,spanel_index
	endif else badnews,     $
	   '  No Plot File Has Been Created or Updated.  '
    end
16: begin    ; exit 
      widget_control,eventdi.top,/destroy 
      if !version.os ne 'MacOS' then begin
	   device,window_state=xx 
	   if xx(21) eq 1 then wdelete,21 
	   if xx(20) eq 1 then wdelete,20 
      endif
    end 
17: begin    ; help
;      badnews,'To be supplied.'
    end 
90: begin 
      img.screen_index= fix(strcompress(                         $
			string(screen_list(eventdi.index)),/remove_all) ) 
      wdelete,20   ; reset window
      show_status,2
      img.cscale=0  
      imageKP=sdata.zvar(spanel_index) 
      imagefile=sdata.cdf(spanel_index)
      get_plotformat
      window,20,xsize=imgpos.screen_x,ysize=imgpos.screen_y,     $
			 title='Group Images in Time Series' 
      img.plotmore_def=0   &   img.spikeout=0    &   img.loadmore=0
      showmore,imagedata,epochdata    
      listone,epochdata 
      one_imageindex=-1
      if sdata.instrument(spanel_index) eq 'uvi' then get_moreuvinfo,epochdata
      
      widget_control,eventdi.top,set_uvalue=imagedata,/no_copy
      widget_control,label_1,set_uvalue=epochdata,/no_copy
      widget_control,eventdi.top,get_uvalue=imagedata,/no_copy
      widget_control,label_1,get_uvalue=epochdata,/no_copy
    end 
21: begin   ; 
       img.add_coord=0          ;   
       if one_imageindex ne -1 then showone,imagedata,epochdata 
    end
22: begin   ; 
      img.add_coord=1
      if one_imageindex ne -1 then showone,imagedata,epochdata      
    end
23: begin   
      img.add_coord=2
      if one_imageindex ne -1 then showone,imagedata,epochdata 
    end
else: 
endcase   
 
if widget_info(eventdi.top,/valid) then begin  
    widget_control,eventdi.top,set_uvalue=imagedata,/no_copy 
    widget_control,label_1,set_uvalue=epochdata,/no_copy 
endif 

end 
 
pro display_image 
common defcom, def, sysdirs, syspcmd,sdata,mday,spanel_index            
common setting,psflag,rpflag,poflag 
common sysbloc,sys_def 
common hcbloc,otflag,hc_input,lpr_command,WH,off_LL,WH_val,off_LLval, $ 
	      psfile,psfile_name,colorflag,windex,windex_val,okflag 
common image_common,img,imgpos,imgcs,one
common dicom,label_0,label_1,label_2,info_all_image,imageindex_set,  $
	     select_one,info_one_image,fileline,KPline,screen_list,  $
	     select_screen,one_imageindex,coordtype,gi_info 

if !version.os eq 'windows' then loadct,13,/silent else loadct,39,/silent 
all_image_info='                              '  &  one_image_info='   '
CDFname='  '   &  imagedata=0   &  epochdata='' 
all_image_list=strarr(10) & all_image_list(*)='  '

WH_val=[20.5,25.5] &  off_LLval=[0.8,1.0 ]  
otflag=1
;
imageKP=sdata.zvar(spanel_index) 
imagefile=sdata.cdf(spanel_index)
setenv_more,imagefile,imageKP
all_image_info='This file contains '+strcompress(string(img.num_image),$ 
	      /remove_all) +' images.  They are grouped into ' + $ 
	      strcompress(string(img.num_screen),/remove_all)+' display ' +$ 
	      'screens.  Select a screen number to view these images.  The '+$
	      'screen number starts from 0.' 
basedi=widget_base(/column,title=' Plot Control - Image Data ',yoffset=80) 
;left 
basedi_left=widget_base(basedi,/row,space=5) 
control_val=[' Change Plot Settings ',' Save ', ' Print ',              $
	     ' View Another File ? ',' Create/Update a Plot File ',     $ 
	     ' Exit ',' Help ' ] 
control=lonarr(7)
; 0,1 has menu underneath
control(0)=widget_button(basedi_left,value=control_val(0),/menu,  $
			 font=def.widfont )
 sub_control0=lonarr(3)
 sub_control0_val=[' Color Table ',' Color Scale ( for Group Images ) ',  $
		   ' Color Scale ( for Individual Image ) '  ]
 for i=0,2 do sub_control0(i)=widget_button(control(0),font=def.widfont,     $
				      value=sub_control0_val(i),uvalue=i+1 )
control(1)=widget_button(basedi_left,value=control_val(1),font=def.widfont, $
			 /menu )
 sub_control1=lonarr(3)
 sub_control1_val=[' PostScript File ', ' GIF File ', ' JPEG File '  ]
 for i=0,2 do sub_control1(i)=widget_button(control(1), uvalue=i+5 ,     $
			    value=sub_control1_val(i), font=def.widfont  )
for i=2,6 do control(i)=widget_button(basedi_left,value=control_val(i),  $ 
				      uvalue=10+(i+1),font=def.widfont ) 
basedi_2=widget_base(basedi,/row,space=10) 
basedi_right=widget_base(basedi_2,/column,/frame) 
base11=widget_base(basedi_right,/column) 
fileline=widget_label(base11,value='File: ' + imagefile  )   
KPline=widget_label(base11, value='Key Parameter: '+ imageKP )             
nu=widget_label(basedi_right,value=' ')   
label012=widget_label(basedi_right, font=def.widfont ,          $
		      value='Select a Group of Images in Time Sequence' )         
base12=widget_base(basedi_right,/row,/frame) 
info_all_image=widget_text(base12,value=all_image_info,xsize=25, /wrap,   $ 
			   ysize=5 )       
base121=widget_base(base12,/column) 
dscreen_label=widget_label(base121,value='Screen Number',font=def.widfont)  
screen_list=sindgen(img.num_screen) 

select_screen=widget_list(base121, value=screen_list, uvalue=90,  $
			      xsize=20, ysize=5, /frame )     
nu=widget_label(basedi_right,value=' ',font=def.widfont )     
;  lower left part
label013=widget_label(basedi_right,value='Select an Individual Image',  $
		      font=def.widfont )
base13=widget_base(basedi_right,/column,/frame)
base14=widget_base(base13,/row) 
info_one_image=widget_text(base14,value=one_image_info,xsize=25,/wrap,ysize=4)
			 ;  font=def.widfont )      
base15=widget_base(base14,/column) 
label_4=widget_label(base15,value='Image Frame ',font=def.widfont ) 
select_one=widget_list(base15,value=all_image_list,uvalue=100,xsize=20,    $ 
		       ysize=4,/frame)    ; ,font=def.widfont )         
; SPECIAL ACT !!
if sdata.instrument(spanel_index) eq 'uvi' then begin
   coordlabel=widget_label(base13,value=' Plot in Image Pixel Frame',  $
			   font=def.widfont )
   base16=widget_base(base13,/column,/exclusive,/frame)
   coordtype=lonarr(3) 
   coordtype_val=[' Image only ',' Image + Geodetic Coordinates ',        $
		  ' Image + Magnetic Coordinates ' ]
   for i=0,2 do coordtype(i)=widget_button(base16,value=coordtype_val(i), $
			 uvalue=21+i,/no_release, font=def.widfont )
endif

base_display=widget_base(basedi_2,/column) 
label_55=widget_label(base_display,value=' Information about ',font=def.widfont) 
base16=widget_base(base_display,/frame,/column,space=5)
label_0=widget_label(base16,value='Screen Number: ',font=def.widfont) 
label_1=widget_label(base16,value='Image Frame:   ',font=def.widfont ) 
label_2=widget_label(base16,value='Time       :   ',font=def.widfont) 

if sdata.instrument(spanel_index) eq 'uvi' then begin    ;SPECIAL ACT
   gi_info = widget_text(base16,value=' ',/frame,xsize=45,ysize=10,/scroll)
   nu = widget_label(base16,value='  ')
   i_infolabel = widget_label(base16,value='Frame: ',font=def.widfont )
   i_info = widget_text(base16,value=' ',/frame,xsize=45,ysize=10,/scroll)
endif                                                     ;SPECIAL ACT
;
widget_control,basedi,/realize,/hourglass 
;
show_status,2
img.screen_index=0  &  img.cscale=0  
get_plotformat
;wdelete,2
window,20,xsize=imgpos.screen_x,ysize=imgpos.screen_y,                $
	  title='Group Images in Time Series' 
img.loadmore=0
img.plotmore_def=0
img.spikeout=0
img.firststart=0
showmore,imagedata,epochdata   ;display the 1st group of images as def 
listone,epochdata 
one_imageindex=-1   ; a flag to prevent 
img.add_coord=0     ; starts without adding coord.
if sdata.instrument(spanel_index) eq 'uvi' then begin
      widget_control,coordtype(0),/set_button
      get_moreuvinfo,epochdata
endif
;
widget_control,basedi,set_uvalue=imagedata,/no_copy 
widget_control,label_1,set_uvalue=epochdata,/no_copy 
; 
xmanager,"display_image",basedi 
end 

function findGaps, times, gapFactor, avgDeltaT=avgDeltaT
if (n_elements(gapFactor) le 0) then gapFactor = 1.5
if (n_elements(times) lt 4) then return, -1L   ; or message,'Too few points'
deltaT = times(1:*) - times
sd = stdev(deltaT, avgDeltaT)
nogaps = where(abs(deltaT) le abs(avgDeltaT * gapFactor), wc)
if (wc gt 0) then begin
  sd = stdev(deltaT(nogaps), avgDeltaT)
  if (abs(sd/avgDeltaT) gt 0.5) then message, /info, $
	'DeltaTime inaccurate; gaps too big; ' + string(avgDeltaT, sd)
  gaps = where(abs(deltaT) gt abs(avgDeltaT * gapFactor))
endif
return, gaps
end ; findGaps

Pro Colorbar, scale, title, logZ=logZ, position=position, cCharSize=cCharSize
; This procedure creates a colorbar for the right side of a spectrogram

common deviceTypeC, deviceType,file; required for inverting grayscale Postscript
xsave = !x & ysave = !y & zsave = !z & psave = !p

if (n_elements(position) ne 0) then positiont = position else        $
  positiont=[!x.window(1)+0.01, !y.window(0), !x.window(1)+0.04, !y.window(1)]

if not keyword_set(logZ) then logZ=0
if (n_elements(title) le 0) then title = ''
nColors = !d.n_colors-2.      ; reserve black and white at ends of colorscale
colors = bindgen(nColors) + 1B
if (n_elements(deviceType) ne 0) then    $ ; invert grayscale for Postscript     
      if (deviceType eq 2) then colors = (!d.n_colors-1B) - colors     

fontsize = 1.0
if n_elements(cCharSize) le 0 then cCharSize = 0.
if cCharSize gt 0 then begin
     fontsize = cCharSize
endif else begin
     ; alternative if cCharSize is undefined or le 0
     if !p.charsize gt 0. then fontsize = !p.charsize
     if !y.charsize gt 0. then fontsize = !y.charsize * fontsize
     if (!p.multi(1)>!p.multi(2)) gt 2 then fontsize = fontsize/2.
endelse
plot, [0., 1.], [0., 1.], position = positiont,/nodata, /noerase,  $
			 xstyle = 4, ystyle = 1+4

if (abs(!x.window(1)-!x.window(0))*!d.x_size le 2) then begin
  message, 'Colorbar too narrow', /info
  !x = xsave & !y = ysave & !z = zsave & !p = psave ; restore original settings
  return
endif
colorStep = ceil(float(ncolors)/(abs(!y.window(1)-!y.window(0))*!d.y_size)) > 1L
nSteps = fix(nColors / colorStep) < nColors
if (!d.flags and 1L) then begin ; has scalable pixels (Postscript)
  colorStep = 1L
  nSteps = nColors
endif

for i = 0L, nSteps-1 do begin
  polyfill, [0.,1.,1.,0.], (i+[0.,0.,1.,1.])/nSteps, $
	color=colors(i*colorStep), noclip=0
endfor ; i

; replot so the box gets put back over the filled area
plot, [0., 1.], [0., 1.], position = positiont, $
	/nodata, /noerase, xstyle = 4, ystyle = 1+4
axis, yaxis = 1, ystyle = 1, yrange = scale, ytype=logZ, ycharsize=fontsize, $
	ytitle = title, ticklen = -0.02*0.78/0.04 ; adjust for narrow window
!x = xsave   
!y = ysave   
!z = zsave   
!p = psave ; restore original settings
return
end ; colorbar

pro spectrogram,Z,X,Y,logY=logY,logZ=logZ,colorbar=colorbar,ctitle=ctitle,$
		cCharSize=cCharSize, noSkipGaps=noSkipGaps,quick=quick
	
common deviceTypeC,deviceType,file
common spec,szlabel,sxlabel,sylabel,header,footnote
common setvalue,imagecdf,varname,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length,imagefile
doStatus=0
status = 0L

; process z var first
Z = reform(Z)        
Zsize = size(Z)

;process Xvar and Yvar

X  = reform(X )   
Vsize = size(X )   
if not (Vsize(Vsize(0)+2) eq Zsize(1)) then Xmin = X   $
	 else   Xmin = rebin(X ,Zsize(1),Zsize(2),/sample)
Y  = reform(Y )  
Vsize = size(Y )   
if not (Vsize(Vsize(0)+2) eq Zsize(2)) then Ymin = Y  else            $
   Ymin=rebin(reform(Y,1,Zsize(2),/overwrite),Zsize(1),Zsize(2),/sample)

; Scheme for aligning lower left corner of box on (X, Y) position
Xmax = shift(Xmin,-1,0)       ; shift all elements in 1st dim to the left
Xmax(Zsize(1)-1,*) = Xmin(Zsize(1)-1,*)*2 - Xmin(Zsize(1)-2,*)
Ymax = shift(Ymin,0,-1)       ; shift all elements in 2nd dim to the bottom
Ymax(*,Zsize(2)-1) = Ymin(*,Zsize(2)-1)*2 - Ymin(*,Zsize(2)-2)
if not keyword_set(noSkipGaps) then begin
      ; only uses first row of Xmin; assumes no fill data
      gaps = findGaps(Xmin(*,0), 1.5, avg=avgDeltaX)
    print,'gaps@1: ',gaps
      if (gaps(0) lt 0) then nGaps = 0 else nGaps = n_elements(gaps)
      if (nGaps gt 0) then    $
	   for k = 0L, nGaps-1 do Xmax(gaps(k),*)=Xmin(gaps(k),*)+avgDeltaX
endif ; noSkipGaps
;
;Ymax=max(Y)   this is for some type of data
; 
minZ = min(Z)
maxZ = max(Z)
fillZ = minZ - 1

isBad = (Z lt minZ) or (Z gt maxZ) or (Z eq fillZ)
wBad = where(isBad, wBadc)
if (wBadc gt 0) then begin
   wGood = where(isBad ne 1, wGoodc)
   if (wGoodc le 0) then begin ; quit here
      doStatus=-1
      msgText = 'No good values to display'
      if doStatus lt 0 then begin
	 xmargin=!x.margin
	 ymargin=!y.margin
	 if (!x.omargin(1)+!x.margin(1)) lt 14 then !x.margin(1)=14
	 Xminmax=[min([Xmin,Xmax],max=maxt),maxt]
	 if not keyword_set(logY) then logY = 0
	 plot, Xminmax, [-10,10], ytype=logY, /nodata, _Extra=extra,xstyle=1,$
	    ticklen=-0.02,title=szlabel,xtitle=sxlabel,$
	    ytitle=sylabel
	 message, msgText, /info & status = -1L & return
      endif else begin
	 message, msgText
      endelse
   endif
   if (n_elements(minValue) le 0) then minZ=min(Z(wGood))
   if (n_elements(maxValue) le 0) then maxZ=max(Z(wGood))
   if (n_elements(fillValue) le 0) then fillZ = minZ - 1
endif

if not keyword_set(logZ) then logZ = 0
flipColorBar=0
if keyword_set(colorbar) then begin
    doColorBar = 1
    cscale = [minZ, maxZ]
endif

minZ1 = minZ & maxZ1 = maxZ
Zt = Z
if (Zsize(Zsize(0)+1) ne 1) then begin ; not Byte array
  if logZ then begin
    wh = where(Z le 0, wc)
    if (wc eq 0) then begin
      Zt = alog10(Z)
    endif else begin
      Zt = Z*0 ; all 0's
      wh = where(Z gt 0, wc)
      if (wc gt 0) then Zt(wh) = alog10(Z(wh))
    endelse
    if (minZ le 0.) then minZ1 = 0. else minZ1 = alog10(minZ)
    if (maxZ le 0.) then maxZ1 = 0. else maxZ1 = alog10(maxZ)
  endif
  Zt = bytscl(Zt, min=minZ1, max=maxZ1, top=!d.n_colors-3)+1B
	; reserve black and white at ends of colorscale
endif
if (wBadc gt 0) then Zt(wBad) = 0B ; minZ1

if (n_elements(deviceType) ne 0) then if (deviceType eq 2) then $
	Zt = (!d.n_colors-1B) - Zt ; invert grayscale for Postscript
if flipColorBar then Zt = (!d.n_colors-1B) - Zt ; invert for inverted cscale

xmargin = !x.margin

if doColorBar then    $
    if (!x.omargin(1)+!x.margin(1)) lt 14 then !x.margin(1) = 14
if not keyword_set(logY) then logY = 0

Xminmax = [min([Xmin,Xmax], max=maxt), maxt]
Yminmax = [min([Ymin,Ymax], max=maxt), maxt]
plot, Xminmax, Yminmax, $ ; position = positiont, $
	 ytype=logY, /nodata, _Extra=extra,xstyle=1,ystyle=1,ticklen=-0.02,  $
	 title=header+szlabel, $
	 xtitle=sxlabel,ytitle=sylabel
	; subtitle=footnote  
	 ;'CDF: '+CDFname+'                 '+  $
	 ;  '!cKey Parameter Visualization Tool v1.6    @ '+systime()
position_c=[!x.window(0),!y.window(0),!x.window(1),!y.window(1)]
px=!x.window
py=!y.window
xWinsize=px(1)-px(0)
yWinsize=py(1)-py(0)
if keyword_set(quick) and ((!d.name eq 'X') or $
    (!d.name eq 'WIN') or (!d.name eq 'MAC') or (!d.name eq 'SUN')) then begin
  tv,congrid(Zt,xWinsize*600.,yWinsize*700.),px(0),py(0),/normal
endif else if (keyword_set(quick) and (!d.name eq 'PS')) then $
  tv,Zt, xsize=xWinsize,  $
      ysize=yWinsize,px(0),py(0),/normal
plot, Xminmax, Yminmax, $ ; position = positiont, $
	_Extra=extra, ytype=logY, /nodata, /noerase  $
	,xstyle=1,ystyle=1,position=position_c,ticklen=-0.02

if doColorBar then begin
  if (n_elements(ctitle) le 0) then ctitle = ''
  if (n_elements(cCharSize) le 0) then cCharSize = 0.
  offset = 0.01
  colorbar, cscale, ctitle, logZ=logZ, cCharSize=cCharSize, $
	position=[position_c(2)+offset,      position_c(1),$
		  position_c(2)+offset+0.03, position_c(3)]
endif ; colorbar

!x.margin = xmargin
return
end ; spectrogram

pro get_setplot
case !version.os of
 'windows': set_plot,'win'
 'Win32': set_plot,'win'
 'MacOS':set_plot,'MAC'
else: set_plot,'x'
endcase
end

pro get_pfontsize
case 1 of
((!version.os eq 'windows') or (!version.os eq 'Win32') or   $
 (!version.os eq 'MacOS')):  psflag.pfontsize=1.0
else: begin
	 case sdata.num_panel of
	 1:psflag.pfontsize=1.5
	 2:psflag.pfontsize=1.5
	 3:psflag.pfontsize=2.0
	 4:psflag.pfontsize=2.0
	 5:psflag.pfontsize=1.5
	 6:psflag.pfontsize=1.5
	 else: psflag.pfontsize=1.0
	 endcase
      end
endcase
end

pro output_plot
common hcbloc,otflag,hc_input,lpr_command,WH,off_LL,WH_val,off_LLval,$
	      psfile,psfile_name,colorflag,windex,windex_val,okflag

device,/close
cmd=lpr_command+' '+ psfile_name
spawn,cmd

end

pro hardcopy_event,eventhc
common setting,psflag,rpflag,poflag
common hcbloc,otflag,hc_input,lpr_command,WH,off_LL,WH_val,off_LLval,$
	      psfile,psfile_name,colorflag,windex,windex_val,okflag
common sysbloc,sys_def
common hlpbloc,help_file,ohtext,help_list
common defcom, def, sysdirs, syspcmd,sdata,mday ,spanel_index           

widget_control,eventhc.id,get_uvalue=uval
case uval of
1:begin  ;ok
    sys_def.printer=1
    if ((sys_def.lpr_plot eq 1) and (sys_def.lpr_text eq 0)) then begin
       set_plot,'ps'
       if otflag eq 1 then device,/portrait else device,/landscape
       if colorflag eq 1 then begin  ; color
	  erase,255
	  !p.color=0
	  device,color=1,bits_per_pixel=8
       endif else begin   ; B/W
	  if psflag.image eq 1 then begin
	     erase,255
	     !p.color=0
	     device,color=0,bits_per_pixel=8
	  endif else device,color=0
       endelse
       widget_control,windex,get_value=sel_windex
       windex_val=long(sel_windex(0))
       widget_control,hc_input,get_value=value1
       lpr_command=value1(0)
       widget_control,psfile,get_value=psfile_name
       widget_control,WH(0),get_value=newval
       WH_val(0)=float(newval)
       device,xsize=WH_val(0)
       widget_control,WH(1),get_value=newval
       WH_val(1)=float(newval)
       device,ysize=WH_val(1)

       if otflag eq 1 then begin
	  widget_control,off_LL(0),get_value=newval
	  off_LLval(0)=float(newval)
	  device,xoffset=off_LLval(0)
	  widget_control,off_LL(1),get_value=newval
	  off_LLval(1)=float(newval)
	  device,yoffset=off_LLval(1)
       endif else begin
	  widget_control,off_LL(0),get_value=newval
	  off_LLval(0)=float(newval)  ; 27.9 cm is the max length on x
	  device,yoffset=27.9-off_LLval(0)
	  widget_control,off_LL(1),get_value=newval
	  off_LLval(1)=float(newval)  ; 21.0 cm is the max length on y
	  device,xoffset=off_LLval(1)
       endelse
       
       widget_control,eventhc.top,/destroy
       psfile_name=psfile_name(0)
       device,file=psfile_name
       okflag=1
    endif else begin
       widget_control,hc_input,get_value=value1
       lpr_command=value1(0)
       widget_control,eventhc.top,/destroy
    endelse
  end
2: begin   ; cancel
      okflag=0
      widget_control,eventhc.top,/destroy
   end
3: display,'seeprint.hlp',sys_def.xsubwin(1),sys_def.ysubwin(1),$
	       font=sys_def.fontname
23: begin
       set_plot,'ps'
       device,/portrait
       otflag=1
    end
24: begin
       set_plot,'ps'
       device,/landscape
       otflag=0
    end

25: begin   ; make color ps
       set_plot,'ps'
       device,color=1
       colorflag=1
    end
26: begin  ; make b/w ps
       set_plot,'ps'
       device,color=0
       colorflag=0
    end
22: begin
      widget_control,hc_input,get_value=value1
      lpr_command = value1(0)
    end
33: widget_control,psfile,get_value=psfile_name
34: begin   ; select a window
      select_windex=eventhc.index+10
      windex_str=string(select_windex)
      widget_control,windex,set_value=windex_str
    end
41: begin
       set_plot,'ps'
       widget_control,WH(0),get_value=newval
       WH_val(0)=float(newval)
       device,xsize=WH_val(0)
    end
42: begin
       set_plot,'ps'
       widget_control,WH(1),get_value=newval
       WH_val(1)=float(newval)
       device,ysize=WH_val(1)
    end
43: begin
       set_plot,'ps'
       if otflag eq 1 then begin
	  widget_control,off_LL(0),get_value=newval
	  off_LLval(0)=float(newval)
	  device,xoffset=off_LLval(0)
       endif else begin
	  widget_control,off_LL(0),get_value=newval
	  off_LLval(0)=float(newval)  ; 27.9 cm is the max length on x
	  device,yoffset=27.9-off_LLval(0)
       endelse
    end
44: begin
       set_plot,'ps'
       if otflag eq 1 then begin
	  widget_control,off_LL(1),get_value=newval
	  off_LLval(1)=float(newval)
	  device,yoffset=off_LLval(1)
       endif else begin
	  widget_control,off_LL(1),get_value=newval
	  off_LLval(1)=float(newval)  ; 21.0 cm is the max length on y
	  device,xoffset=off_LLval(1)
       endelse
    end
else: begin
	npcmd=uval mod 101
	lpr_command=syspcmd.listval(npcmd)
	widget_control,hc_input ,set_value=lpr_command 
      end
endcase
end                                                      

pro hardcopy
common defcom, def, sysdirs, syspcmd,sdata,mday ,spanel_index              
common hcbloc,otflag,hc_input,lpr_command,WH,off_LL,WH_val,off_LLval,  $
	      psfile,psfile_name,colorflag,windex,windex_val,okflag
common sysbloc,sys_def

psfile_name='kpvt_out.ps'
colorflag=0   
if lpr_command eq '' then lpr_command=syspcmd.def

hcbase=widget_base(/row,title='Print !', xoffset=20,    $
		   yoffset=100 ,space=15)
base1=widget_base(hcbase,/column,/frame)
base11=widget_base(base1,/row)
labelhc=widget_label(base11,value='Print Command ( for printer ): ')
		    ; font=sys_def.fontname)
;hc_input=widget_text(base11,value=lpr_command,uvalue=22, /editable,    $
hc_input=widget_text(base11,value=lpr_command, /frame)
cpcmdbut=widget_button(base11,value=' Change to ... ',/menu )
num_pcmds=n_elements(syspcmd.listval)
cdpcmd=lonarr(num_pcmds)
for i=0,num_pcmds-1 do cdpcmd(i)=widget_button(cpcmdbut,   $
				  value=syspcmd.listval(i),uvalue=101+i)

labelhc2=widget_label(base1,value='')   ;,font=sys_def.fontname)
if ((sys_def.lpr_plot eq 1) and (sys_def.lpr_text eq 0)) then begin
   baseps0=widget_base(base1,/row)
   baseps01=widget_base(baseps0,/column,space=5)
   basepsfile=widget_base(baseps01,/row)
   label_psfile=widget_label(basepsfile,value='PostScript File Name : ')
			;       font=sys_def.fontname)
   psfile=widget_text(basepsfile,value=psfile_name,uvalue=33,/editable,$
			/frame)    ;,font=sys_def.fontname)
   nu=widget_label(baseps01,value='')    ; ,font=sys_def.fontname)
   baseps01_0=widget_base(baseps01,/column,/frame)
   baseps01_1=widget_base(baseps01_0,/row)
   label_windex=widget_label(baseps01_1,value='Window Index Number : ')
     
     if !version.os ne 'MacOS' then begin
	device,window_state=xx
	windex_list=strarr(5)
	windex_list(2:4)=' '
	if xx(20) eq 1 then windex_list(0)='Window Index Number : 20 ' else $
			 windex_list(0)=' '
	if xx(21) eq 1 then windex_list(1)='Window Index Number : 21 ' else $
			 windex_list(1)=' '
     endif
     windex_curr=!d.window
     windex_val=string(windex_curr)
     windex=widget_text(baseps01_1,value=windex_val,/frame) ; ,    $
		    ;  font=sys_def.fontname)
     sel_windex=widget_list(baseps01_0,value=windex_list,uvalue=34,  $
		  /frame,ysize=3) ;font=sys_def.fontname, ysize=3 )
     ;right
     baseps02=widget_base(baseps0,/column)
     base02_1=widget_base(baseps02,/exclusive,/column,/frame)
     hcbut3=widget_button(base02_1,value=' Color ',/no_release,  $
			  uvalue=25)    ;, $
     hcbut4=widget_button(base02_1,value=' Black-and-White ',/no_release, $
			uvalue=26)   ;,font=sys_def.fontname )
     nu=widget_label(baseps02,value=' ') 
     labelhc3=widget_label(baseps02,value='Orientation :  ')  ;,  $
     base3=widget_base(baseps02,/exclusive,/column,/frame)
     hcbut1=widget_button(base3,value=' Portrait ',/no_release,  $
			  uvalue=23)    ;,$
					; font=sys_def.fontname )
     hcbut2=widget_button(base3,value=' Landscape ',/no_release, $
			uvalue=24)    ;,font=sys_def.fontname )
     labelhc2=widget_label(baseps02,value='')  ;,font=sys_def.fontname)
  
     labelhc3=widget_label(base1,value='Plot Output on the Page') ;,   $
	;               font=sys_def.fontname)

     baseWH=lonarr(2)
     WH_lab1=lonarr(2)
     WH_lab2=lonarr(2)
     WH_labval=['Width  ( x_size ) : ',  'Height ( y_size ): ' ] 
     WH=lonarr(2)

     base5=widget_base(base1,/column,/frame )
     for i=0,1 do begin
	baseWH(i)=widget_base(base5,/row)
	WH_lab1(i)=widget_label(baseWH(i),value=WH_labval(i) ) ;,  $
			 ;   font=sys_def.fontname)
	WH(i)=widget_text(baseWH(i),value=string(WH_val(i)),uvalue=40+(i+1), $
		      /frame,/editable)   ;,font=sys_def.fontname)
	WH_lab2(i)=widget_label(baseWH(i),value='Centimeters')   ;,  $
			   ; font=sys_def.fontname)
     endfor

     labelhc2=widget_label(base1,value='')    ;,font=sys_def.fontname)

     off_LLcap=['X position at Lower Left Corner : ',   $
		'Y position at Lower Left Corner : '  ]
     baseLL=lonarr(2)
     lab_LL1=lonarr(2)
     lab_LL2=lonarr(2)
     off_LL=lonarr(2)

     for i=0,1 do begin
	baseLL(i)=widget_base(base5,/row)
	lab_LL1(i)=widget_label(baseLL(i),value=off_LLcap(i) )  ;,  $
			   ; font=sys_def.fontname)
	off_LL(i)=widget_text(baseLL(i),value=string(off_LLval(i)),   $
			  uvalue=40+(i+3),$
			  /frame,/editable) ;font=sys_def.fontname) 
	lab_LL2(i)=widget_label(baseLL(i),value='Centimeter(s)') ;,   $
			    ; font=sys_def.fontname)
     endfor
endif

hcbut_val=['  OK  ',' Cancel ',' Help ']
base4=widget_base(hcbase,/column,space=10)
for i=0,2 do hcbut=widget_button(base4,/frame,value=hcbut_val(i),  $
				 uvalue=i+1)  ;,font=sys_def.fontname)

widget_control,hcbase,/realize
if sys_def.lpr_plot eq 1 then begin
	if otflag eq 1 then widget_control,hcbut1,/set_button  $
		       else widget_control,hcbut2,/set_button
	if colorflag eq 1 then widget_control, hcbut3,/set_button $
			  else widget_control,hcbut4,/set_button
endif
xmanager,"hardcopy",hcbase,/MODAL   ;group_leader=sys_def.leader

end

pro find_md,yr,dy,m,d
ydays=[0,31,59,90,120,151,181,212,243,273,304,334,366]
if(((yr mod 4) eq 0) and ((yr mod 100) ne 0)) or ((yr mod 400) eq 0) then $
	ydays(2)=ydays(2:*)+1
for i=1,12 do if dy le ydays(i) then goto, next
m=-1
d=-1
return
next:m=i
     d=dy-ydays(m-1)
return
end

pro get_dim,index,dimv,dims,dimd 
common sdatacom,CDFvar,KPattr,KPattr_val,KPcount,varval,complist
      
dimv=CDFvar.dim_vary(index, 0:CDFvar.num_dims(index)-1)
n_dimv=n_elements(dimv)
if n_dimv eq 1 then dimv=dimv else dimv=reform(dimv) 
dims=CDFvar.dim_size(index, 0:CDFvar.num_dims(index)-1)
n_dims=n_elements(dims)
if n_dims eq 1 then dims=dims else dims=reform(dims)
dimd = dimv * dims  

end

pro find_charattr,i,flag_ptr,charattr,charattr_ptr,charattr_val
common defcom, def, sysdirs, syspcmd,sdata,mday,spanel_index            
common sdatacom,CDFvar,KPattr,KPattr_val,KPcount,varval,complist

if ((flag_ptr eq 0) or (flag_ptr eq 1)) then begin 
   id=cdf_open(sdata.cdf(spanel_index))
endif else id=flag_ptr
kpnum=KPcount(i)
kpnum=kpnum(0)
compidex=where(KPattr(i,0:kpnum-1) eq charattr,count1)  
if count1 ne 0 then begin
    j=  charattr
    if CDFvar.is_zvar(i) ne 1 then cdf_attget,id,j,CDFvar.name(i),attvalue  $  
		  else  cdf_attget,id,j,CDFvar.name(i),attvalue,/zvariable    
    clabel_val=string(attvalue)    
endif else begin
  if flag_ptr eq 0 then                                        $ ; if no ptr  
      if charattr eq 'LABLAXIS' then clabel_val=CDFvar.name(i) $
				else clabel_val=''             $
  else begin                                                    ; for ptr  
      complabl2=where(KPattr(i,0:kpnum-1) eq charattr_ptr,count2) 
      if count2 ne 0 then begin
	  j= charattr_ptr 
	  if CDFvar.is_zvar(i) ne 1 then                          $
		      cdf_attget,id,j,CDFvar.name(i),attvalue     $  
		else  cdf_attget,id,j,CDFvar.name(i),attvalue,/zvariable    
	  clabel=string(attvalue)  ; this will be a variable name   
	  clabel_i=where(CDFvar.name eq clabel,count3)  
	  ;check if this variable exists
	  if count3 ne 0 then begin
	    j=clabel
	    get_dim,clabel_i,dimv,dims,dimd
	    num_d=n_elements(dimd)
	    d_index=lonarr(num_d)
	    for kk=0,num_d-1 do   $
		 if dimd(kk) ne 0 then d_index(kk)=1            $
				       else d_index(kk)=dims(kk)
	    ;get data
	    if CDFvar.is_zvar(clabel_i) ne 1 then   $
		 cdf_varget,id,clabel,clabel_val,interval=d_index  else    $  
		 cdf_varget,id,clabel,clabel_val,interval=d_index,/zvariable    
	    clabel_val=string(clabel_val)
	    if n_elements(clabel_val) le 1 then clabel_val=string(clabel_val) $                         
	    else  clabel_val=reform(string(clabel_val)) ;It is an array  
	  endif else clabel_val=''
      endif else clabel_val=''
  endelse
endelse

charattr_val=clabel_val
if ((flag_ptr eq 0) or (flag_ptr eq 1)) then begin
    cdf_close,id
endif

end

pro find_numattr,i,numattr,numattr_val
common defcom, def, sysdirs, syspcmd,sdata,mday,spanel_index            
common sdatacom,CDFvar,KPattr,KPattr_val,KPcount,varval,complist

id=cdf_open(sdata.cdf(spanel_index))
kpnum=KPcount(i)
kpnum=kpnum(0)
compidex=where(KPattr(i,0:kpnum-1) eq numattr,count1)  
if count1 ne 0 then begin
    j=  numattr
    if CDFvar.is_zvar(i) ne 1 then cdf_attget,id,j,CDFvar.name(i),attvalue  $  
		  else  cdf_attget,id,j,CDFvar.name(i),attvalue,/zvariable    
    num_val=n_elements(attvalue)    
    if num_val le 1 then numattr_val=attvalue                      $
		    else  numattr_val=reform(attvalue)
endif else  if numattr eq 'SCALEMIN' then numattr_val=-55555.0     $
				     else numattr_val= 55555.0  
cdf_close,id
end

pro get_epoch       ; for image plot
common defcom, def, sysdirs, syspcmd,sdata,mday,spanel_index            
common sdatacom,CDFvar,KPattr,KPattr_val,KPcount,varval,complist

mm=sdata.varindex(spanel_index)
xi=where(CDFvar.name eq 'Epoch',countx)
if countx ne 0 then begin
   get_dim,xi,dimv,dims,dimd
   num_d=n_elements(dimd)
   xoffset = lonarr(num_d)
   xinterval = lonarr(num_d)
   nn=spanel_index
   einterval = dims
   eoffset = dimv
endif else print,'There is a problem with xvar.'  
sdata.einterval(0:num_d-1)=einterval
sdata.eoffset(0:num_d-1)=eoffset
end

pro get_x       
common defcom, def, sysdirs, syspcmd,sdata,mday,spanel_index            
common sdatacom,CDFvar,KPattr,KPattr_val,KPcount,varval,complist

mm=sdata.varindex(spanel_index)
xi=where(CDFvar.name eq CDFvar.xvar(mm),countx)
if countx ne 0 then begin
   get_dim,xi,dimv,dims,dimd
   num_d=n_elements(dimd)
   xoffset = lonarr(num_d)
   xinterval = lonarr(num_d)
   nn=spanel_index
   case 1 of
   ((sdata.ptype(nn) eq 5) or (sdata.ptype(nn) eq 6)):begin  ;** image (&bin)
     for kk=0,num_d-1 do begin
       xoffset(kk)=0
       if dimd(kk) ne 0 then xinterval(kk)=1 else xinterval(kk)=dims(kk)
     endfor
     flag_ptr=1     ;find label=label+unit  
     find_charattr,xi,flag_ptr,'LABLAXIS','LABL_PTR_1',xlabel  
     find_charattr,xi,flag_ptr,'UNITS','UNIT_PTR',xunit
     find_numattr,xi,'SCALEMIN',xmin
     find_numattr,xi,'SCALEMAX',xmax
     xw=where(dimd ne 0,countxw)
     xsize=dimd(xw)
     sdata.xlabel(nn)= xlabel + ' ( ' + xunit + ' ) '
     sdata.xsize=xsize(0)
     sdata.xoffset(nn,0:num_d-1)=xoffset
     sdata.xinterval(nn,0:num_d-1)=xinterval
     sdata.x_ndims(nn)=num_d
     sdata.xis_zvar(nn)=CDFvar.is_zvar(xi)
     sdata.xmin(nn)=xmin
     sdata.xmax(nn)=xmax
   end
   (sdata.ptype(nn) eq 2):begin                     ;** x-y(time independent)
	 for kk=0,num_d-1 do begin
	   xoffset(kk)=0
	   if dimd(kk) ne 0 then xinterval(kk)=1 else xinterval(kk)=dims(kk)
	 endfor
   end
   else:begin  ;** time series and spectrogram -- Xvar is Epoch
	    xinterval = dims
	    xoffset = dimv
	    sdata.xlabel(nn)= 'Time ( Hour )'
	    sdata.xoffset(nn,0:num_d-1)=xoffset
	    sdata.xinterval(nn,0:num_d-1)=xinterval
	    sdata.x_ndims(nn)=num_d
	    sdata.xis_zvar(nn)=CDFvar.is_zvar(xi)
	    sdata.xmin(nn)=0.0
	    sdata.xmax(nn)=24.0
	end
   endcase
endif else print,'There is a problem with xvar.'  
end

pro get_y       
common defcom, def, sysdirs, syspcmd,sdata,mday ,spanel_index           
common sdatacom,CDFvar,KPattr,KPattr_val,KPcount,varval,complist

mm=sdata.varindex(spanel_index)  
yi=where(CDFvar.name eq CDFvar.yvar(mm),county)
if county ne 0 then begin
   get_dim,yi,dimv,dims,dimd
   num_d = n_elements(dimd)
   yinterval=lonarr(num_d)
   yoffset=lonarr(num_d)
   
   nn=spanel_index
   case 1 of
     ((sdata.ptype(nn) eq 5) or (sdata.ptype(nn) eq 6) or               $   
      (sdata.ptype(nn) eq 3) or (sdata.ptype(nn) eq 4) ):begin  
       for kk=0,num_d-1 do begin     ;** image (+bin)  &  spectrogram(+bin)
	   yoffset(kk)=0
	   if dimd(kk) ne 0 then yinterval(kk)=1 else yinterval(kk)=dims(kk)
       endfor
       flag_ptr=0      ;find label=label+unit  
       find_charattr,yi,flag_ptr,'LABLAXIS','LABL_PTR_1',ylabel  
       find_charattr,yi,flag_ptr,'UNITS','UNIT_PTR',yunit
       if ((sdata.ptype(nn) eq 5) or (sdata.ptype(nn) eq 6)) then begin
	  find_numattr,yi,'SCALEMIN',ymin
	  find_numattr,yi,'SCALEMAX',ymax
	  sdata.ymin(nn)=ymin
	  sdata.ymax(nn)=ymax
       endif   
       yw=where(dimd ne 0,countyw)
       ysize=dimd(yw)   
       sdata.ylabel(nn)= ylabel + ' ( ' + yunit + ' ) '
       sdata.ysize=ysize(0)
       sdata.yoffset(nn,0:num_d-1)=yoffset
       sdata.yinterval(nn,0:num_d-1)=yinterval
       sdata.y_ndims(nn)=num_d
       sdata.yis_zvar(nn)=CDFvar.is_zvar(yi)
      end
   (sdata.ptype(nn) eq 2):begin               
	 for kk=0,num_d-1 do begin
	   yoffset(kk)=0
	   if dimd(kk) ne 0 then yinterval(kk)=1 else yinterval(kk)=dims(kk)
	 endfor
      end
   (sdata.ptype(nn) eq 1):begin             
      if sdata.yescomp(nn) gt 0 then begin
	 case sdata.compi(nn) of
	 0:begin                 
	      for kk=0,num_d-1 do begin
		  yoffset(kk)=0
		  if dimd(kk) ne 0 then yinterval(kk)=1            $
				   else yinterval(kk)=dims(kk)
	      endfor       
	      sdata.ylabel(nn)=CDFvar.yvar(mm)
	      for ii=1,sdata.yescomp(nn) do begin    
		sdata.ylabel(nn)=sdata.ylabel(nn)+':'+CDFvar.complist(mm,ii)
	      endfor
	     ;
	      find_numattr,yi,'SCALEMIN',ymin
	      find_numattr,yi,'SCALEMAX',ymax
	      ;check just in case
	      num_ymin=n_elements(ymin)
	      if num_ymin le 1 then sdata.ymin(nn)=ymin    $
			      else sdata.ymin(nn)=ymin(0)  
	      num_ymax=n_elements(ymax)
	      if num_ymax le 1 then sdata.ymax(nn)=ymax    $
			      else sdata.ymax(nn)=ymax(0)
	   end
	 else:begin                     
		  for kk=0,num_d-1 do begin
		     yinterval(kk)=dims(kk)
		     if dimd(kk) ne 0 then yoffset(kk)=sdata.compi(nn)-1    $
				      else yoffset(kk)=0
		  endfor
		  flag_ptr=1
		  find_charattr,yi,flag_ptr,'LABLAXIS','LABL_PTR_1',ylabel
		  find_charattr,yi,flag_ptr,'UNITS','UNIT_PTR',yunit
		  num_label=n_elements(ylabel)
		  if num_label le 1 then label=ylabel   $
				    else label=ylabel(sdata.compi(nn)-1)
		  num_unit=n_elements(yunit)
		  if num_unit le 1 then unit=yunit      $
				   else unit=yunit(sdata.compi(nn)-1)
		  sdata.ylabel(nn)=label + ' ( ' + unit + ' ) '
		  find_numattr,yi,'SCALEMIN',ymin
		  find_numattr,yi,'SCALEMAX',ymax
		  num_ymin=n_elements(ymin)
		  if num_ymin le 1 then sdata.ymin(nn)=ymin   $
				 else sdata.ymin(nn)=ymin(sdata.compi(nn)-1)
		  num_ymax=n_elements(ymax)
		  if num_ymax le 1 then sdata.ymax(nn)=ymax   $
				 else sdata.ymax(nn)=ymax(sdata.compi(nn)-1)
	      end
	 endcase
      endif else begin                        ;@1: no component
	for kk=0,num_d-1 do begin
	   yinterval(kk)=dims(kk)
	   yoffset(kk)=0
	endfor
	flag_ptr=1
	find_charattr,yi,flag_ptr,'LABLAXIS','LABL_PTR_1',ylabel
	find_charattr,yi,flag_ptr,'UNITS','UNIT_PTR',yunit
	num_label=n_elements(ylabel)
	if num_label le 1 then label=ylabel else label=ylabel(0)
	num_unit=n_elements(yunit)
	if num_unit le 1 then unit=yunit else unit=yunit(0)
	sdata.ylabel(nn)=label + ' ( ' + unit + ' ) '
	find_numattr,yi,'SCALEMIN',ymin
	find_numattr,yi,'SCALEMAX',ymax
	;check just in case
	num_ymin=n_elements(ymin)
	if num_ymin le 1 then sdata.ymin(nn)=ymin    $
			 else sdata.ymin(nn)=ymin(0)  
	num_ymax=n_elements(ymax)
	if num_ymax le 1 then sdata.ymax(nn)=ymax    $
			 else sdata.ymax(nn)=ymax(0)
      endelse                                 ;@1:
      
      sdata.yoffset(nn,0:num_d-1)=yoffset
      sdata.yinterval(nn,0:num_d-1)=yinterval
      sdata.y_ndims(nn)=num_d
      sdata.yis_zvar(nn)=CDFvar.is_zvar(yi)
    end
   else: print,'  This plot type is not supported. '
   endcase
endif else print,'There is something wrong with yvar.'
end

pro get_z                
common defcom, def, sysdirs, syspcmd,sdata,mday,spanel_index            
common sdatacom,CDFvar,KPattr,KPattr_val,KPcount,varval,complist

mm=sdata.varindex(spanel_index)
zi=where(CDFvar.name eq CDFvar.zvar(mm),countz)
if countz ne 0 then begin
   get_dim,zi,dimv,dims,dimd
   num_d=n_elements(dimd)
   zinterval=lonarr(num_d)
   zoffset=lonarr(num_d)

   nn=spanel_index
   case 1 of
   ((sdata.ptype(nn) eq 3) or (sdata.ptype(nn) eq 5)):begin   
	 for kk=0,num_d-1 do begin
	    zoffset(kk)=0
	    if dimd(kk) ne 0 then zinterval(kk)=1 else zinterval(kk)=dims(kk)
	 endfor
	 flag_ptr=1  ;find label=label+unit
	 find_charattr,zi,flag_ptr,'LABLAXIS','LABL_PTR_1',zlabel
	    ;  print,'@get_z,  zlabel=',zlabel,'$$'
	 find_charattr,zi,flag_ptr,'UNITS','UNIT_PTR',zunit
	    ;  print,'@get_z,  zunit=',zunit,'$$'
	 zw=where(dimd ne 0,countzw)
	 zsize=dimd(zw)
	     ; print,'zsize=',zsize
	 sdata.zlabel(nn)= zlabel + ' ( ' + zunit + ' ) '
	 sdata.zoffset(nn,0:num_d-1)=zoffset
	 sdata.zinterval(nn,0:num_d-1)=zinterval
	 sdata.z_ndims(nn)=num_d
	 sdata.zis_zvar(nn)=CDFvar.is_zvar(zi)
       end
   ((sdata.ptype(nn) eq 4) or (sdata.ptype(nn) eq 6)):begin
       bi=where(CDFvar.name eq CDFvar.bin(mm),bcount)
       if bcount ne 0 then begin
	  get_dim,bi,bdimv,bdims,bdimd
	  num_b=n_elements(bdimd)
	  for kk=0,num_b-1 do begin ;------
	    case 1 of
	      ((bdimd(kk) eq 0) and (dimd(kk) eq 0)):begin
		    zinterval(kk)=dims(kk)
		    zoffset(kk)=0
		 end 
	      ((bdimd(kk) eq 0) and (dimd(kk) ne 0)):begin
		    zinterval(kk)=1
		    zoffset(kk)=0
		 end
	      ((bdimd(kk) ne 0) and (dimd(kk) ne 0)):begin
		    zinterval(kk)= dims(kk)
		    zoffset(kk)=sdata.bini(nn)      ;bin index starts from 0
		 end
	    else:
	    endcase
	  endfor ;-------
	  flag_ptr=0                             
	  find_charattr,zi,flag_ptr,'LABLAXIS','LABL_PTR_1',zlabel
	    ;  print,'@get_z,  zlabel=',zlabel,'$$'
	  find_charattr,zi,flag_ptr,'UNITS','UNIT_PTR',zunit
	    ;  print,'@get_z,  zunit=',zunit,'$$'
	  sdata.zlabel(nn)= zlabel + ' ( ' + zunit + ' ) ' +        $
			    '@' + CDFvar.binlist(zi,sdata.bini(nn))
	  sdata.zoffset(nn,0:num_d-1)=zoffset
	  sdata.zinterval(nn,0:num_d-1)=zinterval
	  sdata.z_ndims(nn)=num_d
	  sdata.zis_zvar(nn)=CDFvar.is_zvar(zi)
       endif else print,'Something is wrong with bin var.'
     end
   else:
   endcase
endif  else print,'Something is wrong with zvar'
   ; print,'(get_z) zinterval:',zinterval
   ; print,'(get_z) zoffset  :',zoffset
end

pro find_comp,id,i,plot_type
common sdatacom,CDFvar,KPattr,KPattr_val,KPcount,varval,complist

comp_index=where(CDFvar.dim_vary(i,*) ne 0,count)           ; where ?
if count ne 0 then totnum_comp=CDFvar.dim_size(i,comp_index)   ; how many ?
flag_ptr=id
find_charattr,i,flag_ptr,'LABLAXIS','LABL_PTR_1',comp_label  ; label them
find_charattr,i,flag_ptr,'UNITS','UNIT_PTR',comp_unit
num_label = n_elements(comp_label)
num_unit = n_elements(comp_unit)
case 1 of
(num_label gt 1) and (num_unit gt 1):begin 
       if num_label lt totnum_comp then begin     ;check label
	   clabel=strarr(totnum_comp)
	   clabel(0:num_label-1)=comp_label
	   clabel(num_label:totnum_comp-1)=''
       endif else clabel=comp_label
       if num_unit lt totnum_comp then begin      ;check unit
	   cunit=strarr(totnum_comp)
	   cunit(0:num_unit-1)=comp_unit
	   cunit(num_unit:totnum_comp-1)=''
       endif else cunit=comp_unit
       
       if plot_type eq 2 then begin     ; check plot_type=2 case 
	 comp_list='All Components'
	 totnum_comp=1
       endif else begin
;        print,'totnum_comp=',totnum_comp
	 totnum_comp=totnum_comp+1    &    comp_list=strarr(totnum_comp)
	 comp_list(0)='All Components'
	 for mi=1,totnum_comp-1 do                       $
	     comp_list(mi)=clabel(mi-1) +' ( '+cunit(mi-1)+' ) '
       endelse
       CDFvar.tot_comp(i)=totnum_comp
       CDFvar.complist(i,0:totnum_comp-1)=comp_list
     end
(num_label gt 1) and (num_unit le 1):begin
      if num_label lt totnum_comp then begin     ;check label
	 clabel=strarr(totnum_comp)
	 clabel(0:num_label-1)=comp_label
	 clabel(num_label:totnum_comp-1)=''
      endif else clabel=comp_label
      
      if plot_type eq 2 then begin    ; check plot_type=2 case
	 comp_list='All Components'
	 totnum_comp=1
      endif else begin
	 totnum_comp=totnum_comp+1    &    comp_list=strarr(totnum_comp)
	 comp_list(0)='All Components'
	 for mi=1,totnum_comp-1 do                       $
	     comp_list(mi)=clabel(mi-1)+' ( '+comp_unit+' ) '
      endelse
      CDFvar.tot_comp(i)=totnum_comp
      CDFvar.complist(i,0:totnum_comp-1)=comp_list
   end
(num_label le 1) and (num_unit gt 1): begin
      if plot_type eq 2 then begin    ; check plot_type=2 case
	 comp_list='All Components'
	 totnum_comp=1
      endif else begin
	 totnum_comp=totnum_comp+1    &    comp_list=strarr(totnum_comp)
	 comp_list(0)='All Components'
	 for mi=1,totnum_comp-1 do comp_list(mi)=comp_label
      endelse
      CDFvar.tot_comp(i)=totnum_comp
      CDFvar.complist(i,0:totnum_comp-1)=comp_list
   end
(num_label le 1) and (num_unit le 1): begin
   if plot_type eq 2 then begin    ; check plot_type=2 case
      comp_list='All Components'
      totnum_comp=1
   endif else begin
      totnum_comp=totnum_comp+1    &    comp_list=strarr(totnum_comp)
      comp_list(0)='All Components'
      for mi=1,totnum_comp-1 do comp_list(mi)=comp_label+' ( '+comp_unit+' ) '
   endelse
   CDFvar.tot_comp(i)=totnum_comp
   CDFvar.complist(i,0:totnum_comp-1)=comp_list
 end
else: print,'There is something wrong with comp labeling.'
endcase
;(B)
end

pro find_pnvar,i,id,totnum_var,spacecraft,experiment,KPptype
common sdatacom,CDFvar,KPattr,KPattr_val,KPcount,varval,complist

case CDFvar.name(i) of
'Epoch':begin
	  plot_type=1
	  xvar='Epoch'  & yvar=CDFvar.name(i)
	  zvar=''      &  bin=''
	end
'Time_PB5':begin
	     plot_type=1
	     xvar='Epoch' & yvar=CDFvar.name(i)
	     zvar=''     & bin=''
	     ; need to find the components
	     find_comp,id,i,plot_type  
	   end
else:begin
       dimvary_index=where(CDFvar.dim_vary(i,0:CDFvar.num_dims(i)) ne 0,  $
			   count)
       if count ne 0 then begin
	   num_dim_vary=n_elements(dimvary_index)
	   case num_dim_vary of
	   1:begin    ;1-D
	       d0=where(KPattr(i,0:KPcount(i)-1) eq 'DEPEND_0',count_d0)
	       d1=where(KPattr(i,0:KPcount(i)-1) eq 'DEPEND_1',count_d1)
	       case 1 of
	       ((count_d0 ne 0) and (count_d1 ne 0)):begin  ; spectrogram
		  if KPptype(i) eq 1 then begin      ; check DISPLAY _TYPE
		     j='DISPLAY_TYPE'
		     if CDFvar.is_zvar(i) ne 1 then                  $  
			cdf_attget,id,j,CDFvar.name(i),attvalue      $  
		     else  cdf_attget,id,j,CDFvar.name(i),attvalue,/zvariable    
		     dtype=strlowcase(strcompress(attvalue,/remove_all)) 
		     if ((dtype eq 'spectrogram') or   $
		     (dtype eq 'spectogram'))then begin ;spectogram is a typo
			plot_type=3
			xvar=KPattr_val(i,d0) & yvar=KPattr_val(i,d1)
			zvar=CDFvar.name(i)   & bin=''
		     endif else begin   ; check kpvt_ptype_checker first
					; then use time series as default
			plot_type =1
			xvar=KPattr_val(i,d0) & yvar=CDFvar.name(i)
			zvar=''              & bin=''
			find_comp,id,i,plot_type 
		     endelse
		  endif else begin   ; without DISPLAY_TYPE then check KPVT
		     plot_type =1
		     xvar=KPattr_val(i,d0) & yvar=CDFvar.name(i)
		     zvar=''              & bin=''
		     find_comp,id,i,plot_type   
		  endelse
		end
	       ((count_d0 ne 0) and (count_d1 eq 0)):begin 
		    plot_type=1
		    xvar=KPattr_val(i,d0) & yvar=CDFvar.name(i)
		    zvar=''     &    bin=''
		    find_comp,id,i,plot_type   
		  end
	       ((count_d0 eq 0) and (count_d1 ne 0)):begin  
		     plot_type=2
		     xvar=KPattr_val(i,d1) & yvar=CDFvar.name(i)
		     zvar=''              & bin=''
		     find_comp,id,i,plot_type   
		  end
	       else:begin
		       plot_type=0
		       xvar='' & yvar='' & zvar='' & bin=''
		    end
	       endcase
	     end
	   2:begin
	       d0=where(KPattr(i,0:KPcount(i)-1) eq 'DEPEND_0',count_d0)
	       d1=where(KPattr(i,0:KPcount(i)-1) eq 'DEPEND_1',count_d1)   
	       d2=where(KPattr(i,0:KPcount(i)-1) eq 'DEPEND_2',count_d2)   
	       case 1 of
	       (count_d0 ne 0) and (count_d1 ne 0) and (count_d2 ne 0):begin
		   if ((spacecraft eq 'polar') or   $
		       (spacecraft eq 'canopus'))then begin
		      if((experiment eq 'pix') or (experiment eq 'vis') or  $
			 (experiment eq 'uvi') or (experiment eq 'hyd') or  $
			 (experiment eq 'asi') )then begin
			    plot_type=5   ;image
			    xvar=KPattr_val(i,d1) & yvar=KPattr_val(i,d2)
			    zvar=CDFvar.name(i)   & bin=''
		      endif else begin
			plot_type=4   ;-----spectrogram with bin------;
			xvar=KPattr_val(i,d0) & yvar=KPattr_val(i,d1)
			zvar=CDFvar.name(i)   & bin=KPattr_val(i,d2)
		      endelse
		   endif else begin
		      plot_type=4   ;------spectrogram with bin--------;
		      xvar=KPattr_val(i,d0) & yvar=KPattr_val(i,d1)
		      zvar=CDFvar.name(i) & bin=KPattr_val(i,d2)
		   endelse
		 end
	       else: begin
		    plot_type=0
		    xvar='' & yvar='' & zvar='' & bin=''
		 end
	       endcase
	     end
	   3:begin   
	       d0=where(KPattr(i,0:KPcount(i)-1) eq 'DEPEND_0',count_d0)
	       d1=where(KPattr(i,0:KPcount(i)-1) eq 'DEPEND_1',count_d1)   
	       d2=where(KPattr(i,0:KPcount(i)-1) eq 'DEPEND_2',count_d2)   
	       d3=where(KPattr(i,0:KPcount(i)-1) eq 'DEPEND_3',count_d3)
	       case 1 of
	       ((count_d0 ne 0) and (count_d1 ne 0) and (count_d2 ne 0) and $
		     (count_d3 ne 0) ): begin
		    plot_type=6          
		    xvar=KPattr_val(i,d1)  & yvar=KPattr_val(i,d2)
		    zvar=CDFvar.name(i)    & bin=KPattr_val(i,d3)
		  end
	       else: begin
		       print,'3-D:  This variable is not clearly defined '+$
			 'in CDF.  Please define HOW TO PLOT IT by yourself.'
		       plot_type=0
		       xvar='' & yvar='' & zvar='' & bin=''
		     end
	       endcase
	     end
	   else:begin
		   print,'How to plot this data?'
		   plot_type=0
		   xvar='' & yvar='' & zvar='' & bin=''
		end
	   endcase
       endif else begin
	   d0=where(KPattr(i,0:KPcount(i)-1) eq 'DEPEND_0',count_d0)
	   d1=where(KPattr(i,0:KPcount(i)-1) eq 'DEPEND_1',count_d1)
	   case 1 of
	   ((count_d0 ne 0) and (count_d1 eq 0)):begin  ; time series (x-y)
	       plot_type=1
	       xvar=KPattr_val(i,d0)  & yvar=CDFvar.name(i)
	       zvar=''               & bin=''
	     end
	   ((count_d0 eq 0) and (count_d1 ne 0)):begin  ; var-var (x-y)
	       plot_type=2
	       xvar=KPattr_val(i,d1)  & yvar=CDFvar.name(i)
	       zvar=''               & bin=''
	     end
	   ((count_d0 eq 0) and (count_d1 eq 0)):begin  ;  
	       ;printf,1,'This variable is not for plotting.'
	       plot_type=0
	       xvar=''  & yvar='' & zvar=''  & bin=''
	     end
	   else:begin
		  print,'0-D: It cannot be plotted.'
		  plot_type=0
		  xvar='' & yvar='' & zvar='' & bin=''
		end
	   endcase
       endelse
     end
endcase
CDFvar.plot_type(i)=plot_type
CDFvar.xvar(i)=xvar   &   CDFvar.yvar(i)=yvar   
CDFvar.zvar(i)=zvar   &   CDFvar.bin(i)=bin

end

pro KPinfo,CDFname   
common sdatacom,CDFvar,KPattr,KPattr_val,KPcount,varval,complist

id=cdf_open(CDFname)    
cdfinfo=cdf_inquire(id)    
totnum_var=cdfinfo.nzvars + cdfinfo.nvars    

case 1 of    
(cdfinfo.nvars eq totnum_var):                  cdf_type=1   ; r-var cdf    
(cdfinfo.nzvars eq totnum_var):                 cdf_type=2   ; z-var cdf    
((cdfinfo.nvars+cdfinfo.nzvars) eq totnum_var): cdf_type=3   ; r+z   cdf    
else: print,'KPVT Warning: This CDF contains non-r and -z type of variables'    
endcase 
CDF={ name:'', nvars:0L, nzvars:0L, nattrs:0L}    
CDFvar={      title:'',instrument:'',                $
	      name: strarr(totnum_var),              $    
	      is_zvar: lonarr(totnum_var),           $    
	      num_dims: lonarr(totnum_var),          $    
  ;           maxrec: lonarr(totnum_var),            $    
	      dim_size: lonarr(totnum_var,10) ,      $    
	      data_type: strarr(totnum_var),         $    
	      rec_vary: strarr(totnum_var),          $    
	      dim_vary: lonarr(totnum_var,10),       $
	      plot_type: intarr(totnum_var),         $
	      xvar: strarr(totnum_var),              $   ;
	      yvar: strarr(totnum_var),              $   ;
	      zvar: strarr(totnum_var),              $   ; 
	      bin: strarr(totnum_var),               $   ;                  
	      d0: strarr(totnum_var),                $
	      d1: strarr(totnum_var),                $
	      d2: strarr(totnum_var),                $
	      d3: strarr(totnum_var),                $
	      tot_comp: lonarr(totnum_var),          $
	      complist: strarr(totnum_var,200),      $   ;       
	      tot_bin:  lonarr(totnum_var),          $
	      binlist:  strarr(totnum_var,50)         }  ;       
CDFvar.title=''    
CDFvar.instrument=''
KPcount=0    
case cdf_type of    
3: begin     ; r+z -var ; get r first then z    
     KPvarname=strarr(totnum_var)    
     for i=0,cdfinfo.nvars -1 do begin    
	varinfo=cdf_varinq(id,i)    
	CDFvar.name(i)= varinfo.name    
	CDFvar.is_zvar(i)= varinfo.is_zvar    
	if((cdfinfo.ndims eq 0) and (n_elements(cdfinfo.dim) eq 1))then begin
	    num_dims=1
	    CDFvar.num_dims(i)=num_dims
	endif else CDFvar.num_dims(i)= cdfinfo.ndims    
	CDFvar.dim_size(i,0:CDFvar.num_dims(i)-1)= cdfinfo.dim    
	CDFvar.data_type(i)=varinfo.datatype    
	CDFvar.rec_vary(i)=varinfo.recvar    
	CDFvar.dim_vary(i,0:CDFvar.num_dims(i)-1)= varinfo.dimvar    
	    
	if varinfo.recvar eq 'VARY' then begin    
	   KPvarname(KPcount)=varinfo.name    
	   KPcount=KPcount+1    
	endif    
     endfor    
	nn=KPcount 
     for i=0,cdfinfo.nzvars -1 do begin    
	varinfo=cdf_varinq(id,i,/zvariable)    
	j=i+nn
	CDFvar.name(j)= varinfo.name    
	CDFvar.is_zvar(j)= varinfo.is_zvar    
	num_dims=n_elements(varinfo.dim)
	CDFvar.num_dims(j)= num_dims    
	CDFvar.dim_size(j,0:num_dims-1)= varinfo.dim       
	CDFvar.data_type(j)=varinfo.datatype    
	CDFvar.rec_vary(j)=varinfo.recvar    
	CDFvar.dim_vary(j,0:CDFvar.num_dims(j)-1)= varinfo.dimvar    
	    
	if varinfo.recvar eq 'VARY' then begin    
	   KPvarname(KPcount)=varinfo.name    
	   KPcount=KPcount+1    
	endif    
     endfor    
   end    
else: begin  ; all r- or all z- vars    
	 KPvarname=strarr(totnum_var)    
	 for i=0,totnum_var-1 do begin    
	     if cdf_type eq 1 then varinfo=cdf_varinq(id,i)   $    
			      else varinfo=cdf_varinq(id,i,/zvariable)    
	     CDFvar.name(i)= varinfo.name    
	     CDFvar.is_zvar(i)= varinfo.is_zvar    
  
	     if varinfo.is_zvar eq 1 then begin 
		 num_dims=n_elements(varinfo.dim)  ; 0-D has num_dims of 1 
		 CDFvar.num_dims(i)=num_dims 
		 CDFvar.dim_size(i,0:num_dims-1)=varinfo.dim                  
	     endif else begin    
		 CDFvar.num_dims(i)=cdfinfo.ndims 
		 CDFvar.dim_size(i,0:cdfinfo.ndims-1)= cdfinfo.dim    
	     endelse              
	     CDFvar.data_type(i)=varinfo.datatype    
	     CDFvar.rec_vary(i)=varinfo.recvar    
	     CDFvar.dim_vary(i,0:CDFvar.num_dims(i)-1)= varinfo.dimvar    
	     if (varinfo.recvar eq 'VARY') then begin    
		 KPvarname(KPcount) = varinfo.name    
		 KPcount = KPcount + 1    
	     endif    
	 endfor    
      end    
endcase    
	 
KPvarname=KPvarname(0:KPcount-1)    
CDFvar.tot_comp(*)=0
CDFvar.complist(*,*)=''
;(C)

num_attr=40
;
KPattr=strarr(totnum_var,num_attr)
KPattr_val=strarr(totnum_var,num_attr)  
KPcount=lonarr(totnum_var)
KPptype=intarr(totnum_var)
CDFvar.title=''

for i=0,totnum_var-1 do begin
   attrcount=0
   on_ioerror,noattr  
   KPptype(i)=0
   for j=0,cdfinfo.natts-1 do begin  
      cdf_attinq,id,j,attname,scope,maxentry,maxzentry    
      if i eq 0 then begin
	 if scope eq "GLOBAL_SCOPE" then begin
	    if CDFvar.is_zvar(i) ne 1 then                             $  
		 cdf_attget,id,j,maxentry,attvalue                     $  
	    else    cdf_attget,id,j,maxentry,attvalue,/zvariable    
	    if (strlowcase(attname) eq 'project') then begin
		xx=strpos(attvalue,'>')
		project=strmid(attvalue,0,xx)
		CDFvar.title=project+'   '
	    endif
           ; spacecraft=''
	    if (strlowcase(attname) eq 'source_name') then begin
	      xx=strpos(attvalue,'>')
	      spacecraft=strmid(attvalue,0,xx)
	      CDFvar.title=CDFvar.title + spacecraft
	      spacecraft=strlowcase(spacecraft)
	    endif
	    if (strlowcase(attname) eq 'descriptor')then begin
	      xx=strpos(attvalue,'>')
	      experiment=strmid(attvalue,0,xx)
	      zz=strlen(attvalue)
	      instrument=strmid(attvalue,xx+1,zz-1)
	       CDFvar.title=CDFvar.title+' / '+instrument 
	      experiment=strlowcase(experiment)
	       CDFvar.instrument=experiment
	      instrument=strlowcase(instrument)
	    endif
	 endif
      endif
      if scope eq 'VARIABLE_SCOPE' then begin  
	 if CDFvar.is_zvar(i) ne 1 then                                   $  
	       cdf_attget,id,j,CDFvar.name(i),attvalue                    $  
	 else    cdf_attget,id,j,CDFvar.name(i),attvalue,/zvariable    
;           ;printf,1,"    '",attname,"' = ",attvalue  
	 if attname eq 'DISPLAY_TYPE' then KPptype(i)=1
	 KPattr(i,attrcount)=attname
	   ;print,i,CDFvar.name(i)
	   ;print,attname,attrcount,attvalue
	 KPattr_val(i,attrcount)=string(attvalue(0))
	   ; be very careful with the multiple attrvalue, it bumps out.
	 attrcount=attrcount+1
      endif  
   noattr:  
   endfor  
   KPcount(i)=attrcount
endfor

for i=0,totnum_var-1 do  begin 
    find_pnvar,i,id,totnum_var,spacecraft,experiment, KPptype
    if((CDFvar.plot_type(i) eq 4) or (CDFvar.plot_type(i) eq 6))then begin
       bin_i=where(CDFvar.name eq CDFvar.bin(i),bcount)
       if bcount ne 0 then begin    
	   get_dim, bin_i, bdimv, bdims, bdimd
	   num_d=n_elements(bdimd)
	   d_index=lonarr(num_d)
	   for kk=0,num_d-1 do   $
	       if bdimd(kk) ne 0 then d_index(kk)=1 $
				 else d_index(kk)=CDFvar.dim_size(bin_i,kk)
	   if CDFvar.is_zvar(bin_i) ne 1 then   $
		      cdf_varget,id,CDFvar.bin(i),bin_val,interval=d_index  $  
		else  cdf_varget,id,CDFvar.bin(i),bin_val,interval=d_index, $
				 /zvariable    
	   bin_val=string(bin_val)
	   if n_elements(bin_val) le 1 then  bin_val=string(bin_val)       $
			 else  bin_val=reform(string(bin_val))     ; an array  
       endif else bin_val='' 
       totnum_bin=n_elements(bin_val)
       CDFvar.tot_bin(i)=totnum_bin    ;    ******
       bin_list=strarr(totnum_bin)  
       bin_list=bin_val          
       ; to label it in "binval+unit+(+label+)" 
       flag_ptr=1
       find_charattr,bin_i,flag_ptr,'LABLAXIS','LABL_PTR_1',bin_label
       find_charattr,bin_i,flag_ptr,'UNITS','UNIT_PTR',bin_unit
       num_label = n_elements(bin_label)
       num_unit = n_elements(bin_unit)
       case 1 of
       (num_label gt 1) and (num_unit gt 1):begin 
	    if num_label lt totnum_bin then begin     ;check label
		      blabel=strarr(totnum_bin)
		      blabel(0:num_label-1)=bin_label
		      blabel(num_label:totnum_bin-1)=''
	    endif else blabel=bin_label
	    if num_unit lt totnum_bin then begin      ;check unit
		      bunit=strarr(totnum_bin)
		      bunit(0:num_unit-1)=bin_unit
		      bunit(num_unit:totnum_bin-1)=''
	    endif else bunit=bin_unit
	    for mi=0,totnum_bin-1 do                       $
	       bin_list(mi)= bin_list(mi)+' '+bunit(mi)+' ( '+blabel(mi)+' ) '
	    CDFvar.binlist(i,0:totnum_bin-1)=bin_list
	 end
       (num_label gt 1) and (num_unit le 1):begin
	    if num_label lt totnum_bin then begin     ;check label
	       blabel=strarr(totnum_bin)
	       blabel(0:num_label-1)=bin_label
	       blabel(num_label:totnum_bin-1)=''
	    endif else blabel=bin_label
	    for mi=0,totnum_bin-1 do    $
	       bin_list(mi)=bin_list(mi)+' '+bin_unit+' ( '+blabel(mi)+' ) '
	    CDFvar.binlist(i,0:totnum_bin-1)=bin_list
	  end
       (num_label le 1) and (num_unit gt 1): begin
	    for mi=0,totnum_bin-1 do    $
	       bin_list(mi)=bin_list(mi)+' ( '+bin_label+' ) ' 
	    CDFvar.binlist(i,0:totnum_bin-1)=bin_list
	 end
       (num_label le 1) and (num_unit le 1): begin
	    for mi=0,totnum_bin-1 do      $
	       bin_list(mi)='Bin '+strcompress(string(mi),/remove_all)+' : '+$
			     bin_list(mi)+' '+bin_unit+' ( '+bin_label+' ) '
	    CDFvar.binlist(i,0:totnum_bin-1)=bin_list
	 end
       else: print,'There is something wrong with bin labeling.'
       endcase
    endif
endfor
;
cdf_close,id
end    

pro badnews_event,eventbadnews
widget_control,get_uvalue=uval,eventbadnews.id
case uval of 
 88: widget_control,eventbadnews.top,/destroy
 else:
endcase
end

pro badnews,news
common sysbloc,sys_def
base=widget_base(/column,/frame,space=40,xoffset=100,   $
		 yoffset=100,title='Message! ') 
new_label=widget_text(base,value=news,xsize=55,ysize=5,/frame,/wrap)
okbutton=widget_button(base,value='Acknowledged',uvalue=88)
null_label2=widget_label(base,value='   ')
widget_control,base,/realize
xmanager,"badnews",base
end

pro get_ptype0,vari,ptindex,ptype0,flag0
common sdatacom,CDFvar,KPattr,KPattr_val,KPcount,varval,complist
common skpcom,pt,skplabel,kpmes,whichvar,sel_comp,cvarbut_sub,scbut 

if flag0 eq 1 then casetype=CDFvar.plot_type(vari) else casetype=ptindex
case casetype of
       1: ptype0='Time Series             ( x-y plot )'
       2: ptype0='Y-var( X-var ) vs X-var ( x-y plot )'  
       3: ptype0='Spectrogram                         '  
       4: ptype0='Spectrogram with Bin                '   
       5: ptype0='Image                               '  
       6: ptype0='Image with Bin                      '  
       7: ptype0='Vector                              '  
       8: ptype0='Yvar(time) vs Xvar(time)            '  
else:begin
       if flag0 eq 1 then badnews,'This Variable may not be designed for'+ $ 
		   ' plotting.  However, it is possible that it can be '+ $
                   ' plotted.  It may just not clearly defined in CDF.  '+$
                   ' Please inform the author if this is the case.'
       ptype0='Invalid Plot Type for this Variable'
     end
endcase

end

pro get_idex,varvali

case idex of
  1: varval(varvali)=varval(0)
  2: varval(varvali)=varval(1)
  3: varval(varvali)=varval(2)
  4: varval(varvali)=varval(3)
else:
endcase
end

pro find_mdays,i,index,id,varname,num_rec
common defcom, def, sysdirs, syspcmd,sdata ,mday ,spanel_index          
common sdatacom,CDFvar,KPattr,KPattr_val,KPcount,varval,complist
   
case sdata.xis_zvar(index) of
1:   cdf_varget,id,varname,varval,rec_count=num_rec,/zvariable,rec_start=0, $
	interval=sdata.xinterval(index), offset=sdata.xoffset(index) 
0:   cdf_varget,id,varname,varval, rec_count=num_rec, rec_start=0,          $
	interval=sdata.xinterval(index), offset=sdata.xoffset(index)  
else:
endcase

if n_elements(varval) le 1 then epo =varval else epo =reform(varval)
dayindex=0
for jj=0,num_rec-1 do begin
   cdf_epoch,epo(jj),yr,mon,day,hr,min,sec,millisec,/break                   
   doy=find_doy(yr,mon,day)
   if jj eq 0 then begin
      old_doy=doy
      old_yr=yr
      mday.index(i,dayindex)=jj
      mday.list(i,dayindex)=strcompress(string(yr),/remove_all)+ $
		    '-'+strcompress(string(mon),/remove_all)+'-'+$
		   strcompress(string(day),/remove_all)+' ( DOY  '+  $
		   strcompress(string(doy),/remove_all)+' )'
      dayindex=dayindex+1
   endif else begin
      if ((doy ne old_doy) or (yr ne old_yr))then begin
	 mday.index(i,dayindex)=jj       ;exact record index
	 mday.list(i,dayindex)=strcompress(string(yr),/remove_all)+ $
		 '-'+strcompress(string(mon),/remove_all)+'-'+      $
		 strcompress(string(day),/remove_all)+' ( DOY  '+   $
		 strcompress(string(doy),/remove_all)+' )'
	 dayindex=dayindex+1
	 old_doy=doy
	 old_yr=yr
      endif
   endelse
endfor
mday.ndays(i)=dayindex
;
end

pro check_mdays,openfile_index,openfile_count
common defcom, def, sysdirs, syspcmd,sdata ,mday ,spanel_index          
common sdatacom,CDFvar,KPattr,KPattr_val,KPcount,varval,complist

mday={ i8day:intarr(openfile_count),    $
       i8year:intarr(openfile_count),   $
       i8_flag:intarr(openfile_count),  $     ; 0:single day  1:multiday
       byear:intarr(openfile_count),    $
       bdoy:intarr(openfile_count),     $
       bmon:intarr(openfile_count),     $
       bday:intarr(openfile_count),     $
       eyear:intarr(openfile_count),    $
       edoy:intarr(openfile_count),     $
       emon:intarr(openfile_count),     $    
       eday:intarr(openfile_count),     $           
       index:lonarr(openfile_count,15), $      ; record number for diff days 
       list: strarr(openfile_count,15), $
       ndays:intarr(openfile_count),    $
       rflag:intarr(openfile_count)       }  ; list of dates
index=openfile_index
for i=0,openfile_count-1 do begin
   index=openfile_index(i)
   id=cdf_open( sdata.cdf(index) ) 
   varname=sdata.xvar(index)
   xinterval = sdata.xinterval(index, 0:sdata.x_ndims(index)-1)
   if n_elements(xinterval) le 1 then xinterval = xinterval         $
			      else xinterval = reform(xinterval)
   xoffset = sdata.xoffset(index, 0:sdata.x_ndims(index)-1 )
   if n_elements(xoffset) le 1 then xoffset = xoffset               $
			      else xoffset = reform(xoffset)
   case sdata.xis_zvar(index) of
   1:begin    ;z
       cdf_control,id,variable=varname,/zvariable,get_var_info=vinfo
       num_rec=vinfo.maxrec+1 ;tot num of rec
       cdf_varget,id,varname,varval,rec_start=0, /zvariable,             $
		  interval=xinterval, offset=xoffset ; get 1st epoch
       if n_elements(varval) le 1 then epo_b=varval else epo_b=reform(varval)
       cdf_varget,id,varname,varval,rec_start=vinfo.maxrec, /zvariable,  $
		  interval=xinterval, offset=xoffset  ;get last epoch
       if n_elements(varval) le 1 then epo_e=varval else epo_e=reform(varval)
     end
   0:begin    ;r
       cdfinfo= cdf_inquire(id)   
       num_rec=cdfinfo.maxrec+1
       cdf_varget,id,varname,varval,rec_start=0,                         $
		  interval=xinterval, offset=xoffset ; get 1st epoch
       if n_elements(varval) le 1 then epo_b=varval else epo_b=reform(varval)
       cdf_varget,id,varname,varval,rec_start=cdfinfo.maxrec,              $
		  interval=xinterval, offset=xoffset  ;get last epoch
       if n_elements(varval) le 1 then epo_e=varval else epo_e=reform(varval)
     end
   else: print,'Something is wrong @check_mdays'
   endcase
   cdf_epoch,epo_b,yr,mon,day,hr,min,sec,millisec,/break
   doy=find_doy(yr,mon,day)
   mday.byear(i)= yr
   mday.bdoy(i) = doy
   mday.bmon(i) = mon
   mday.bday(i) = day
   cdf_epoch,epo_e,yr,mon,day,hr,min,sec,millisec,/break
   doy=find_doy(yr,mon,day)
   mday.eyear(i)= yr
   mday.edoy(i) = doy
   mday.emon(i) = mon
   mday.eday(i) = day
   case 1 of
   (mday.byear(i) eq mday.eyear(i)):begin
       case 1 of                            
       (mday.bdoy(i) eq mday.edoy(i)): mday.i8_flag(i)=0
       else:begin
	      mday.i8_flag(i)=1
	      find_mdays,i,index,id,varname,num_rec  ;get mday index & list
	    end
       endcase
     end
   else:begin
	  mday.i8_flag(i)=1
	  find_mdays,i,index,id,varname,num_rec  ;get mday index & list
	end
   endcase
endfor
cdf_close,id   

end   

pro get_varval,index,id,var,varis_zvar,varval,var_interval,var_offset, $
	       num_rec,specy_flag 
common defcom, def, sysdirs, syspcmd,sdata ,mday ,spanel_index
;
if specy_flag ne 0 then begin
    start_rec=0
    num_rec=1
endif else begin
    case mday.rflag(index) of
    101:begin
	  start_rec=0
	  case varis_zvar of
	  1:begin     ;z
	      cdf_control,id,variable= var,/zvariable,get_var_info=vinfo
	      num_rec= vinfo.maxrec+1
	    end
	  0:begin     ;r
	      cdfinfo=cdf_inquire(id)
	      num_rec= cdfinfo.maxrec+1
	    end
	  else:
	  endcase
	end
    else: begin   ; multiple day
	    bindex = mday.index(index, mday.rflag(index) )
	    if mday.rflag(index) ne mday.ndays(index)-1 then          $
		  eindex = mday.index(index, mday.rflag(index)+1 )    $
	    else  begin
		case varis_zvar of
		1:begin     ;z
		    cdf_control,id,variable= var,/zvariable,get_var_info=vinfo
		    last_rec= vinfo.maxrec
		  end
		0:begin     ;r
		    cdfinfo=cdf_inquire(id)
		    last_rec= cdfinfo.maxrec
		  end
		else:
		endcase
		eindex=last_rec
	    endelse
	    start_rec=bindex
	    num_rec = eindex - bindex
	  end
    endcase
endelse
case varis_zvar of
1: cdf_varget,id, var, varval, rec_start=start_rec, rec_count= num_rec,     $   
		  interval=var_interval,offset=var_offset, /zvariable
0: cdf_varget,id, var, varval, rec_start=start_rec, rec_count=num_rec,      $
		  interval= var_interval ,offset= var_offset
else:
endcase

if n_elements( varval) gt 1 then  varval=reform( varval) $
				   else  varval= varval
end

pro loadNplot ,id,index,bpanel,epanel
common defcom, def, sysdirs, syspcmd,sdata ,mday ,spanel_index          
common spec,szlabel,sxlabel,sylabel,header,footnote
       
;if !d.name ne 'ps' then begin
;   loadct,0
;   !p.color=!d.n_colors-1
;endif else begin
;   loadct,0
;   !p.color=0
;endelse
; read epoch first
specy_flag=0       
get_varval,index,id,sdata.xvar(index),sdata.xis_zvar(index),xvarval,   $
     sdata.xinterval(index,0:sdata.x_ndims(index)-1),           $
     sdata.xoffset(index,0:sdata.x_ndims(index)-1),num_rec,specy_flag
xval=fltarr(num_rec)
for i=0,num_rec-1 do begin
    cdf_epoch,xvarval(i),yr,mon,day,hr,min,sec,millisec,/break
    ms=float(hr)*3600000.+float(min)*60000.+float(sec)*1000.+float(millisec)
	;    print,'I am @ loadNplot'
	;    print,'hr,min,sec,millisec:',hr,min,sec,millisec
    xval(i)=float(ms)/3600000.     ; time in hour
	;    print,xval(i)
endfor
for i=bpanel,epanel do begin
     if i eq bpanel then header=sdata.title(bpanel)+' !c ' else header=''
     if i eq sdata.num_panel-1 then footnote='ISTP Key Parameter '+$
	     'Visualization Tool V2.0       @ '+systime() else footnote=''
     case 1 of
     (sdata.ptype(i) eq 1): begin  ;  time series
	specy_flag=0
	get_varval,index,id,sdata.yvar(i),sdata.yis_zvar(i),yvarval,   $
	       sdata.yinterval(i,0:sdata.y_ndims(i)-1),           $
	       sdata.yoffset(i,0:sdata.y_ndims(i)-1),num_rec,specy_flag 
	
	yval= yvarval
	spec_exist=where(sdata.ptype eq 3 or sdata.ptype eq 4,count)
	if count ne 0 then begin
	   xmargin=!x.margin
	   ymargin=!y.margin
	   if(!x.omargin(1)+!x.margin(1)) lt 14 then !x.margin(1)=14
	endif
	if sdata.xscaling(i) eq 1 then x_type=0 else x_type=1
	if sdata.yscaling(i) eq 1 then y_type=0 else y_type=1
	plot,xval,yval,title=header,xtitle=sdata.xlabel(0),   $
	     ytitle=sdata.ylabel(i),xstyle=1,ystyle=1,        $
	     subtitle=footnote,psym=3,xrange=[sdata.xmin(0),sdata.xmax(0)],$
	     yrange=[sdata.ymin(i),sdata.ymax(i)],  $
	     xtype=x_type,ytype=y_type
      end
    (sdata.ptype(i) eq 2): begin  ;  x-y (time independent)
	   end
    ((sdata.ptype(i) eq 3) or (sdata.ptype(i) eq 4)): begin  
	specy_flag=100
	get_varval,index,id,sdata.yvar(i),sdata.yis_zvar(i),yvarval,   $
	      sdata.yinterval(i,0:sdata.y_ndims(i)-1),           $
	      sdata.yoffset(i,0:sdata.y_ndims(i)-1),num_rec,specy_flag
	yval= yvarval 
	specy_flag=0    
	get_varval,index,id,sdata.zvar(i),sdata.zis_zvar(i),zvarval,   $
	      sdata.zinterval(i,0:sdata.z_ndims(i)-1),           $
	      sdata.zoffset(i,0:sdata.z_ndims(i)-1),num_rec,specy_flag 
	zval=transpose(zvarval)   ; because zvarval(var_dim,rec_dim)
				  ;to make spectrogram needs
				  ;(rec_dim(as x),var_dim(as y))
	sxlabel=sdata.xlabel(i)
	sylabel=sdata.ylabel(i)
	szlabel=sdata.zlabel(i)
	if sdata.yscaling(i) eq 1 then logY=0 else logY=1
	if sdata.zscaling(i) eq 1 then logZ=0 else logZ=1
	loadct,39
	spectrogram,zval,xval,yval,/colorbar, $
		    logY=logY,logZ=logZ,/quick
      end
    else: print,'check plot type @ loadNplot_data'
    endcase
endfor
end

pro getdata,openfile_index,openfile_count,init_plot
common defcom, def, sysdirs, syspcmd,sdata ,mday ,spanel_index          

if openfile_count eq 1 then begin    ; single CDF
   id=cdf_open(sdata.cdf(0))  
   index=0
   bpanel=0
   epanel=sdata.num_panel-1
   if mday.i8_flag(0) eq 0 then begin   
     mday.rflag(0)=101
     loadNplot ,id,index,bpanel,epanel
   endif else begin     
     if init_plot eq 1 then mday.rflag(0)=0 else mday.rflag(0)=mday.rflag(0)
     loadNplot ,id,index,bpanel,epanel
   endelse              
   cdf_close,id
endif else begin    
   for i=0,openfile_count-1 do begin
       if i ne openfile_count-1 then begin
	   bpanel=openfile_index(i)
	   epanel=openfile_index(i+1)-1
       endif else begin
	   bpanel=openfile_index(i)
	   epanel=sdata.num_panel-1
       endelse
       ;   
       id=cdf_open(sdata.cdf(openfile_index(i)))
       ;
       if mday.i8_flag(i) eq 0 then begin     
	 index=i
	 mday.rflag(i)=101
	 loadNplot ,id,index,bpanel,epanel
       endif else begin                      
	 index=i
	 if init_plot eq 1 then mday.rflag(i)=0    $
			   else mday.rflag(i)=mday.rflag(i)
	 loadNplot ,id,index,bpanel,epanel
       endelse
   endfor
endelse

end

pro get_newfiles_event,eventnf
common defcom, def, sysdirs, syspcmd,sdata ,mday ,spanel_index          
common ddcom,openfile_index,openfile_count,init_plot,newfiles
common evcom,extratop
common setvalue,imagecdf,imageKP,num_panel,foldername,$ 
       pdtitle,startpath,filterspec,cdf_selection,cdf_length,imagefile 
common flagcom,sdata_flag,file_label

widget_control,eventnf.id,get_uvalue=uval
case uval of
1: begin    ;ok and plot it
     widget_control, eventnf.top, /destroy
     sdata.cdf = newfiles
     if sdata_flag ne 100 then widget_control, extratop, /destroy
     if sdata_flag eq 100 then begin
         status=2 
         show_status,status
         display_data
         sdata_flag =101
     endif else begin
         status=2
         show_status,status
         display_data
     endelse
   end
2: widget_control,eventnf.top,/destroy    ;cancel
3:    ;help
else: begin     ;select a new cdf file 
	whichone=uval mod 31
	pdtitle=' Select Data: Select a New CDF File '
	get_filefilter,1
	file_selection=pickfile(title=pdtitle,filter=filterspec,      $ 
		file=filename,path=sdata.dir(openfile_index(whichone)) )
	yesfile=where(file_selection ne '',count)
	if count ne 0 then begin
	    cdffile=file_selection                        
	    bpanel=openfile_index(whichone)
	    if whichone ne openfile_count-1 then                   $
		       epanel=openfile_index(whichone+1)-1         $
	       else    epanel=sdata.num_panel-1
	    newfiles(bpanel:epanel) = cdffile
            widget_control,file_label(whichone),  $
                           set_value='< Current File > '+cdffile
	endif else badnews,'  ***    No New CDF/File Selected.   ***  '
      end
endcase
end

pro get_newfiles,indexd,countd            ;  if openfile_count > 1
common defcom, def, sysdirs, syspcmd,sdata ,mday ,spanel_index          
common ddcom,openfile_index,openfile_count,init_plot,newfiles
common flagcom,sdata_flag,file_label

if sdata_flag eq 100 then begin
    openfile_count=countd
    openfile_index=indexd
    bartitle=' Plot File : Select data ' 
endif else bartitle=' Select Another File to View the Same Data Selections '
newfiles=strarr(sdata.num_panel) & newfiles=sdata.cdf
basenf=widget_base(/column,title=bartitle,xoffset=20,yoffset=100)  
; top
basenf_0=widget_base(basenf,/row,space=5)
control_val=['     OK  ==>  Go Plot !!     ','    Cancel    ','    Help    ']
control=lonarr(3)
for i=0,2 do control(i)=widget_button(basenf_0,value=control_val(i),  $
				 uvalue=i+1, /frame, font=def.widfont )
if sdata_flag eq 100 then begin
   nu=widget_label(basenf,value=' ')
   label=widget_label(basenf,value='Data Type : Non-Image Data',  $
                      font=def.widfont)
endif
; bottom
if openfile_count ne 0 then begin    ; just a safe check
   basenf_1  = lonarr(openfile_count) 
   basenf_11 = lonarr(openfile_count)
   basenf_12 = lonarr(openfile_count)
   newfile_but = lonarr(openfile_count)
   file_label=lonarr(openfile_count)

   for i=0,openfile_count-1 do begin
     basenf_11(i)=widget_base(basenf,/column,/frame)
     bpanel=openfile_index(i)
     if i ne openfile_count-1 then epanel=openfile_index(i+1)-1       $
		       else epanel=sdata.num_panel-1   ;exact index
     for j=bpanel,epanel do begin          
	 if sdata.ptype(j) eq 1 or sdata.ptype(j) eq 2 then           $
	     label=sdata.ylabel(j) else label=sdata.zlabel(j)
	 kplabel=widget_label(basenf_11(i),value='< Panel '+          $
	     strcompress(string(j+1),/remove_all)+' > Key Parameter: '+$
	     sdata.var(j)+'       Label(Unit): '+label ,/align_left,  $ 
	     font=def.widfont )
     endfor
     nu=widget_label(basenf_11(i),value='  ')
     ; 
     basenf_12(i)=widget_base(basenf_11(i),/row)
     label=widget_label(basenf_12(i),value=' From:   ',font=def.widfont)
     basenf_1(i)=widget_base(basenf_12(i), /column, /frame)
     if sdata_flag eq 100 then                    $                     
        label=widget_label(basenf_1(i),     value='  Source       :  '+     $
                         sdata.title(i), font=def.widfont,/align_left )
     dir_label =widget_label(basenf_1(i),   value='  Directory    :  '+     $
	 sdata.dir( openfile_index(i) ),/align_left,font=def.widfont)
     if sdata_flag ne 100 then filenow=sdata.cdf(openfile_index(i))   $
                          else filenow='(None)'
     file_label(i)=widget_label(basenf_1(i),value='  Current File :  '+     $
	 filenow,/align_left,font=def.widfont)
     nu=widget_label(basenf_1(i),value=' ')
     newfile_but(i)=widget_button(basenf_1(i),uvalue=30+(i+1),/frame, $
	     value='   Select a New CDF File   ',font=def.widfont)
   endfor
endif else print,'there is something wrong here @ get_newfiles'
;                                                                       
widget_control,basenf,/realize
xmanager,"get_newfiles",basenf

end

pro display_data_event,eventdd
common defcom, def, sysdirs, syspcmd,sdata ,mday ,spanel_index          
common ddcom,openfile_index,openfile_count,init_plot,newfiles
common evcom,extratop
common hcbloc,otflag,hc_input,lpr_command,WH,off_LL,WH_val,off_LLval, $ 
	      psfile,psfile_name,colorflag,windex,windex_val,okflag 
common sysbloc, sys_def
common maincom, mainflag,Gimage
common fillbloc,fillpath,fillext,outfile

type=tag_names(eventdd,/structure )
widget_control,eventdd.id,get_uvalue=uval
case 1 of
(uval eq 5):badnews,'  Will be available in Version 2.1  ' ; (save)PostScript
(uval eq 6):badnews,'  Will be available in Version 2.1  ' ; (save)GIF file
(uval eq 7):badnews,'  Will be available in Version 2.1  ' ; (save)JPEG file
(uval eq 1):begin                    ; panel layout
	    end

(uval eq 2):begin                    ; panel positions
	    end

(uval eq 3):begin                    ; overall fontsize
	    end

(uval eq 100):begin                  ; overall x-axis scale range
	      end

((uval ge 101) and (uval lt 200)):begin   ; y-axis scale range
				  end

((uval ge 201) and (uval lt 300)):begin   ; z-axis scale range
				  end

((uval ge 301) and (uval lt 400)):begin   ; axis styles
				  end

((uval ge 401) and (uval lt 500)):begin   ; graphic presentation of data
				  end

((uval ge 501) and (uval lt 600)):begin   ; annotation with text
				  end

(uval eq 600): badnews,'  Will be available in the future release.    '                     
					  ; annotation with data values
((uval ge 601) and (uval lt 700)):begin   ; draw a zero line
				  end

((uval ge 701) and (uval lt 800)):begin   ; draw a vertical line
				  end

(uval eq 13): begin   ;print- make a hardcopy
		 sys_def.lpr_plot=1
		 hardcopy
		 if okflag eq 1 then begin
		    getdata,openfile_index,openfile_count,init_plot
		    output_plot
		 endif
		 get_setplot    ; set_plot
		 sys_def.lpr_plot=0
	      end
(uval eq 14): begin   
	 extratop=eventdd.top
         get_newfiles,openfile_index,openfile_count
       end
(uval eq 15): begin                        
                print,'openfile_index=',openfile_index
                print,'openfile_count=',openfile_count
                indexd=openfile_index
                countd=openfile_count
		mainflag.purpose=3    &    message_no=1 
		get_message,message_no,mymessage
		title=' Create or Update a Plot File '
		get_pfilename,outfile
		getpath,mainflag.purpose,title,mymessage
		if mainflag.yesorno eq 1 then begin
		      save,filename=outfile,sdata,indexd,countd
		endif else badnews,     $
		   '  No Plot File Has Been Created or Updated.  '
	      end

(uval eq 16): begin   ;exit
		wdelete,0
		widget_control,eventdd.top,/destroy
	      end

(uval eq 17): begin   ;help
	      end

else:begin  ;
	whichone=uval mod 31
	sel_i8doy=mday.list(whichone,eventdd.index)
	mday.rflag(whichone)=eventdd.index
	init_plot=0      &      wset,0
	getdata,openfile_index,openfile_count,init_plot
     end
else:
endcase

end
 
pro display_data  
common defcom, def, sysdirs, syspcmd,sdata ,mday ,spanel_index          
common sdatacom,CDFvar,KPattr,KPattr_val,KPcount,varval,complist
common ddcom,openfile_index,openfile_count,init_plot,newfiles
common hcbloc,otflag,hc_input,lpr_command,WH,off_LL,WH_val,off_LLval, $ 
	      psfile,psfile_name,colorflag,windex,windex_val,okflag 
;
status=2 
show_status,status
; get_pfontsize
!p.multi=[0,0,sdata.num_panel,0,0]
!x.margin=[12,8]
!y.margin=[6,3]
WH_val=[18.5,24.5]
off_LLval=[1.5,1.5]
otflag=1
;
init_plot=1
openfile_index=where(sdata.cdf_flag eq 2, openfile_count)
check_mdays,openfile_index,openfile_count
window,0,title=' ISTP Key Parameter Plot ',xsize=600,ysize=700
wset,0
getdata,openfile_index,openfile_count,init_plot
wdelete,2
;
basedd=widget_base(/column,title='Plot Control - Non-Image Data',  $
		   xoffset=10,yoffset=80, space=3 )
control_val=[' Change Plot Settings ',' Save ',' Print ',          $
	     ' View Another File ? ', ' Create/Update a Plot File ', $
	     ' Exit ', ' Help  '        ]
control=lonarr(7)
basedd_1=widget_base(basedd,/row,space=5)
control(0)=widget_button(basedd_1, value=control_val(0), /menu,      $
			 font=def.widfont )
  sub0=lonarr(10)
  sub0_val=[' Panel Layout ',' Panel Positions ',' Overall Font Size ',  $
	    ' Axis Scale Ranges ',' Axis Styles ',                       $
	    ' Graphic Presentation of Data ',' Annotation ( Text ) ',    $ 
	    ' Annotation ( Data ) ', ' Draw a Zero Line ',               $  
	    ' Draw a Vertical Line ' ]
  for i=0,2 do sub0(i)=widget_button(control(0),uvalue=i+1,              $
		     value=sub0_val(i),font=def.widfont )
  ;
  sub0(3)=widget_button(control(0),value=sub0_val(3),/menu,font=def.widfont)
    sub03=lonarr(3)
    sub03_val=[' Overall X - Axis ',' Y - Axis ',' Z - Axis ( Color Bar ) ']
    sub03(0)=widget_button(sub0(3),value=' Overall X - Axis ',uvalue=100, $
			   font=def.widfont )
    for i=1,2 do sub03(i)=widget_button(sub0(3),value=sub03_val(i),   $
					    /menu,font=def.widfont)
    sub031=lonarr(sdata.num_panel)
    sub031_val=' Panel Number '+ string(indgen(sdata.num_panel)+1)
    for i=0,sdata.num_panel-1 do sub031(i)=widget_button(sub03(1),value=  $
			       sub031_val(i),uvalue=101+i,font=def.widfont )
    sub032=lonarr(sdata.num_panel)
    sub032_val=' Panel Number '+ string(indgen(sdata.num_panel)+1)
    for i=0,sdata.num_panel-1 do sub032(i)=widget_button(sub03(2),value=  $
			       sub032_val(i),uvalue=201+i,font=def.widfont )
  
  sub0(4)=widget_button(control(0),value=sub0_val(4),/menu,font=def.widfont)
    sub04=lonarr(sdata.num_panel)
    sub04_val=' Panel Number '+ string(indgen(sdata.num_panel)+1)
    for i=0,sdata.num_panel-1 do sub04(i)=widget_button(sub0(4),value=  $
			       sub04_val(i),uvalue=301+i,font=def.widfont  )
  
  sub0(5)=widget_button(control(0),value=sub0_val(5),/menu,font=def.widfont)
    sub05=lonarr(sdata.num_panel)
    sub05_val=' Panel Number '+ string(indgen(sdata.num_panel)+1)
    for i=0,sdata.num_panel-1 do sub05(i)=widget_button(sub0(5),value=  $
			       sub05_val(i),uvalue=401+i,font=def.widfont  )
  
  sub0(6)=widget_button(control(0),value=sub0_val(6),/menu,font=def.widfont)
    sub06=lonarr(sdata.num_panel)
    sub06_val=' Panel Number '+ string(indgen(sdata.num_panel)+1)
    for i=0,sdata.num_panel-1 do sub06(i)=widget_button(sub0(6),value=     $
			       sub06_val(i),uvalue=501+i,font=def.widfont )
  sub0(7)=widget_button(control(0),value=sub0_val(7),uvalue=600,         $
			font=def.widfont)   ; annotation with data values
  sub0(8)=widget_button(control(0),value=sub0_val(8),/menu,font=def.widfont)
    sub08=lonarr(sdata.num_panel)
    sub08_val=' Panel Number '+ string(indgen(sdata.num_panel)+1)
    for i=0,sdata.num_panel-1 do sub08(i)=widget_button(sub0(8),value=     $
			       sub08_val(i),uvalue=601+i,font=def.widfont )
  sub0(9)=widget_button(control(0),value=sub0_val(9),/menu,font=def.widfont)
    sub09=lonarr(sdata.num_panel)
    sub09_val=' Panel Number '+ string(indgen(sdata.num_panel)+1)
    for i=0,sdata.num_panel-1 do sub09(i)=widget_button(sub0(9),value=     $
			       sub09_val(i),uvalue=701+i,font=def.widfont )
  
control(1)=widget_button(basedd_1,value=control_val(1),/menu,            $
			 font=def.widfont)
  sub_control1=lonarr(3)
  sub_control1_val=[' PostScript File ', ' GIF File ',' JPEG File ']
  for i=0,2 do sub_control1(i)=widget_button(control(1),uvalue=i+5,       $
			       value=sub_control1_val(i),font=def.widfont )
for i=2,6 do control(i)=widget_button(basedd_1,value=control_val(i), $
			uvalue=i+11, font=def.widfont )

if openfile_count ne 0 then begin    ; safe check
   basedd_2=lonarr(openfile_count) 
   basedd_21=lonarr(openfile_count)
   basedd_210=basedd_21  &  basedd_211=basedd_21  & base220_2=basedd_21 
   basedd_2111=basedd_21 & base220=basedd_21 & base220_1=basedd_21
   basedd_22=lonarr(openfile_count)
   base_sday=lonarr(openfile_count)
   i8doy=lonarr(openfile_count)

   for i=0,openfile_count-1 do begin
      basedd_2(i)=widget_base(basedd,/column,/frame)
      ; top 
      basedd_22(i)=widget_base(basedd_2(i),/column)
      bpanel=openfile_index(i)
      if i ne openfile_count-1 then epanel=openfile_index(i+1)-1      $
		       else epanel=sdata.num_panel-1   ;exact index
      base220(i)=widget_base(basedd_22(i),/row,space=35)
      base220_1(i)=widget_base(base220(i),/column)
      for j=bpanel,epanel do begin          
	kplabel1=widget_label(base220_1(i),value='[ Panel '+  $
	strcompress(string(j+1),/remove_all)+' ]   Key Parameter:   '+ $
	    sdata.var(j),font=def.widfont ,/align_left )
      endfor
      base220_2(i)=widget_base(base220(i),/column)
      for j=bpanel,epanel do begin          
	if sdata.ptype(j) eq 1 or sdata.ptype(j) eq 2 then  $
	     label=sdata.ylabel(j)                           $
	else label=sdata.zlabel(j)
	kplabel2=widget_label(base220_2(i),value=  $
	    'Label ( Unit ) : '+label ,/align_left,font=def.widfont ) 
      endfor
      ; bottom
      basedd_210(i)=widget_base(basedd_2(i),/row)
      nu=widget_label(basedd_210(i),value=' From: ',font=def.widfont)
      basedd_21(i)=widget_base(basedd_210(i),/column,/frame )
      file_label=widget_label(basedd_21(i),value=' File:  '+          $
		 sdata.cdf( openfile_index(i) ),/align_left,font=def.widfont )
     ; nu=widget_label(basedd_21(i),value=' ')
      basedd_211(i)=widget_base(basedd_21(i),/row )
      basedd_2111(i)=widget_base(basedd_211(i),/column)
      nu=widget_label(basedd_2111(i),value='   ')
      labelb=widget_label(basedd_2111(i),value='Date Start: '+       $
	  strcompress(string( mday.bmon(i)),/remove_all) +'-'+       $
	  strcompress(string( mday.bday(i)),/remove_all) +'-'+       $
	  strcompress(string(mday.byear(i)),/remove_all) +           $
	    ' ( DOY '+strcompress(string(mday.bdoy(i)),/remove_all)+ $
	    ' ) ',/align_left,font=def.widfont  )
      labele=widget_label(basedd_2111(i),value='Date Stop : '+       $
	    strcompress(string( mday.emon(i)),/remove_all) +'-'+     $
	    strcompress(string( mday.eday(i)),/remove_all) +'-'+     $
	    strcompress(string(mday.eyear(i)),/remove_all) +         $ 
	    ' ( DOY '+strcompress(string(mday.edoy(i)),/remove_all)+ $
	    ' ) ',/align_left,font=def.widfont  )
      base_sday(i)=widget_base(basedd_211(i),/column )
      label=widget_label(base_sday(i),value=' Select One ',font=def.widfont)
      i8doy_list=strarr(5) & i8doy_list(*)=''
      i8doy(i)=widget_list(base_sday(i),value=i8doy_list,uvalue=30+(i+1),  $
			   xsize=40,ysize=2 )
   endfor
endif else print,'there is something wrong here @ display_data'
;                                                                       
widget_control,basedd,/realize
xmanager,"display_data",basedd
for i=0,openfile_count-1 do                                              $
  if mday.i8_flag(i) eq 0 then widget_control,base_sday(i),sensitive=0   $
    else widget_control,i8doy(i),set_value=mday.list(i,0:mday.ndays(i)-1)
end

pro make_plot
common defcom, def, sysdirs, syspcmd,sdata,mday,spanel_index          
common sdatacom,CDFvar,KPattr,KPattr_val,KPcount,varval,complist

case sdata.dtype of
1:begin   ; non-image data
    display_data
  end
2:begin   ; image data
   display_image
  end
else:
endcase

end

pro print_sdata
common defcom, def, sysdirs, syspcmd,sdata,mday  ,spanel_index          
openw,1,'print_sdata.dat'
for i=0,sdata.num_panel-1 do begin 
   printf,1,'<< Panel Number >>  ',i+1
   printf,1,'sdata.title:',sdata.title(i) 
   printf,1,'sdata.dtype:',sdata.dtype
   printf,1,'sdata.varindex:',sdata.varindex(i)
   printf,1,'sdata.ptype:',sdata.ptype(i)
   printf,1,'sdata.num_panel:',sdata.num_panel
   printf,1,'sdata.dir:',sdata.dir(i)
   printf,1,'sdata.cdf:',sdata.cdf(i)
   printf,1,'sdata.xvar:',sdata.xvar(i)
   printf,1,'sdata.xis_zvar:', sdata.xis_zvar(i) 
   printf,1,'sdata.x_ndims:',  sdata.x_ndims(i) 
   printf,1,'sdata.xoffset:',sdata.xoffset(i,0:sdata.x_ndims(i)-1 ) 
   printf,1,'sdata.xinterval:', sdata.xinterval(i,0:sdata.x_ndims(i)-1 )
   printf,1,'sdata.xlabel: ', sdata.xlabel(i)
   printf,1,'sdata.xmin:', sdata.xmin(i)
   printf,1,'sdata.xmax:', sdata.xmax(i)
   printf,1,'sdata.xscaling:',sdata.xscaling(i)

   printf,1,'sdata.yvar:',sdata.yvar(i)
   printf,1,'sdata.yis_zvar:', sdata.yis_zvar(i)
   printf,1,'sdata.y_ndims:',sdata.y_ndims(i)
   printf,1,'sdata.yoffset:',sdata.yoffset(i,0:sdata.y_ndims(i)-1 ) 
   printf,1,'sdata.yinterval:', sdata.yinterval(i,0:sdata.y_ndims(i)-1 )
   printf,1,'sdata.ylabel:',  sdata.ylabel(i)
   printf,1,'sdata.ymin:', sdata.ymin(i)
   printf,1,'sdata.ymax:', sdata.ymax(i) 
   printf,1,'sdata.yscaling:',sdata.yscaling(i)
if sdata.ptype(i) eq 3 or sdata.ptype(i) eq 4 or sdata.ptype(i) eq 5    $
   or sdata.ptype(i) eq 6 then begin
   printf,1,'sdata.zvar:',sdata.zvar(i)
   printf,1,'sdata.zis_zvar:', sdata.zis_zvar(i)
   printf,1,'sdata.z_ndims:',sdata.z_ndims(i)
   printf,1,'sdata.zoffset:', sdata.zoffset(i,0:sdata.z_ndims(i)-1 )
   printf,1,'sdata.zinterval:', sdata.zinterval(i,0:sdata.z_ndims(i)-1 )
   printf,1,'sdata.zlabel:', sdata.zlabel(i)
   printf,1,'sdata.zmin:', sdata.zmin(i)
   printf,1,'sdata.zmax:', sdata.zmax(i)
   printf,1,'sdata.zscaling:',sdata.zscaling(i)
endif
   printf,1,'sdata.xsize:', sdata.xsize
   printf,1,'sdata.ysize:', sdata.ysize
   printf,1,'sdata.bin:', sdata.bin(i)
   printf,1,'sdata.yescomp:', sdata.yescomp(i)
   printf,1,'sdata.yesbin:', sdata.yesbin(i)
   printf,1,'sdata.compi:', sdata.compi(i)
   printf,1,'sdata.bini:', sdata.bini(i)
   printf,1,'sdata.binlabel:', sdata.binlabel(i)
   print,'sdata.cdf_flag=',sdata.cdf_flag
endfor
close,1

end

pro skp_event,evskp
common flagcom,sdata_flag,file_label
common defcom, def, sysdirs, syspcmd,sdata ,mday ,spanel_index          
common sdatacom,CDFvar,KPattr,KPattr_val,KPcount,varval,complist
common skpcom,pt,skplabel,kpmes,whichvar,sel_comp,cvarbut_sub,scbut 

widget_control,evskp.id,get_uvalue=uval
case 1  of
(uval eq 1):begin  ; check whether everything is valid
     ; check data type
     case sdata.dtype of
     1: begin  ; non-image data
	  if ((sdata.ptype(spanel_index) eq 1) or   $
	      (sdata.ptype(spanel_index) eq 2) )then begin
      ;        (sdata.ptype(spanel_index) eq 8)) then begin
	      get_x
	      get_y
	      widget_control,evskp.top,/destroy   
	      sdata.title(spanel_index)=CDFvar.title
	      sdata.instrument(spanel_index)=CDFvar.instrument
	      ;print_sdata     ; see values
	  endif else begin   ; spectrogram  with/without bin
	    if ((sdata.ptype(spanel_index) eq 3) or   $
		(sdata.ptype(spanel_index) eq 4) )then begin
		  get_x
		  get_y
		  get_z
		  widget_control,evskp.top,/destroy   
		  sdata.title(spanel_index) = CDFvar.title
		  sdata.instrument(spanel_index)=CDFvar.instrument
		  ;print_sdata
	    endif else     $
	    badnews,'Invalid Data Type: You have selected an image key ' + $ 
	       'parameter.  You can either re-select a non-image key ' +   $ 
	       'parameter or go back to previous window to change data type.'
	  endelse
	end
     2: begin  ; image data
	  if ((sdata.ptype(0) eq 5) or (sdata.ptype(0) eq 6))then begin
	    ; get all the information from the selection
	    get_epoch
	    get_x
	    get_y
	    get_z
	    widget_control,evskp.top,/destroy
	    sdata.title(spanel_index) = CDFvar.title
	    sdata.instrument(spanel_index)=CDFvar.instrument
	    ;print_sdata
	  endif else   $                  
	    badnews,'Invalid Data Type: You have selected a non-image ' +  $ 
	       'key parameter.  You can re-select an image key ' +  $  
	       'parameter or go back to previous window to change data type.'
	end
     else: print,'something is wrong in data type.'
     endcase
   end
(uval eq 2) : widget_control,evskp.top,/destroy  ;cancel
(uval eq 3) : badnews,' *****  To be supplied  ***** '
(uval eq 10): begin   ; select a key parameter  & set up everything
      selectKP=CDFvar.name(evskp.index)
      sdata.var(spanel_index)=CDFvar.name(evskp.index)
      widget_control,kpmes,set_value='                             '
      widget_control,kpmes,set_value= '< Key Parameter >   '+selectKP,/append
      for i=0,KPcount(evskp.index)-1 do  widget_control,kpmes,/append, $
	    set_value= KPattr(evskp.index,i)+'   :   '+                $
		       KPattr_val(evskp.index,i) 
      widget_control,kpmes,/set_text_top_line
      widget_control,skplabel,set_value= '< Key Parameter >   '+selectKP 
      ptbut_subval=['Time Series             ( x-y plot )',  $
		    'Y-var( X-var ) vs X-var ( x-y plot )',  $
		    'Spectrogram                         ',  $
		    'Spectrogram with Bin                ',  $ 
		    'Image                               ',  $
		    'Image with Bin                      ',  $
		    'Vector                              ',  $
		    'Yvar(time) vs Xvar(time)            '      ]
      flag0=1
      get_ptype0,evskp.index,ptindex,ptype0,flag0
      widget_control,pt,set_value=ptype0
      plot_type=CDFvar.plot_type(evskp.index)  
      varval=[CDFvar.xvar(evskp.index), CDFvar.yvar(evskp.index),  $
	      CDFvar.zvar(evskp.index), CDFvar.bin(evskp.index) ]
      for i=0,2 do begin
	  if i lt 2 then  widget_control,scbut(i,0),/set_button       $
	     else if ((plot_type ne 1) or (plot_type ne 2)) then      $
		  widget_control,scbut(i,0),/set_button 
	     
	  widget_control,whichvar(i),set_value=varval(i)
	  for j=0,2 do widget_control,cvarbut_sub(i,j),set_value=varval(j)
      endfor
      widget_control,whichvar(3),set_value=varval(3)        ; set for bin
      for j=0,2 do widget_control,cvarbut_sub(3,j),set_value=varval(j)
      ; check comp or bin    ;check component first then bin
      if(( plot_type eq 1) or (plot_type eq 2))then begin   ; check comp
	    if CDFvar.tot_comp(evskp.index) ne 0 then begin 
		complist=strarr(200)
		complist(*)=''
		complist(0:CDFvar.tot_comp(evskp.index)-1 )=            $
			 CDFvar.complist(evskp.index,                   $
				     0:CDFvar.tot_comp(evskp.index)-1)
	      ; print,complist
	      ; print,CDFvar.complist
		widget_control,sel_comp,set_value=complist
		sdata.yescomp(spanel_index )=CDFvar.tot_comp(evskp.index)-1
	    endif else begin
		complist=strarr(200) & complist(*)=''
		widget_control,sel_comp,set_value=complist
		sdata.yescomp(spanel_index)=0
	    endelse
	    sdata.yesbin(spanel_index) = 0    ; by default
      endif else begin ;check bin
	    if(( plot_type eq 4) or (plot_type eq 6))then begin   ; check bin
		complist=strarr(200)  &   complist(*)=''
		complist(0:CDFvar.tot_bin(evskp.index)-1 )=            $
			 CDFvar.binlist(evskp.index,                   $
				     0:CDFvar.tot_bin(evskp.index)-1)
		widget_control,sel_comp,set_value=complist
		sdata.yesbin(spanel_index )=CDFvar.tot_bin(evskp.index) 
	    endif else begin
		complist=strarr(200) & complist(*)=''
		widget_control,sel_comp,set_value=complist
		sdata.yesbin(spanel_index)=0
	    endelse
	    sdata.yescomp(spanel_index) = 0     ; by default
      endelse
      ; set up the selection and store into sdata
      ;if sdata.dtype eq 1 then panelnum=spanel_index else panelnum=0
      sdata.varindex(spanel_index) = evskp.index
      sdata.xvar(spanel_index)  = CDFvar.xvar(evskp.index)
      sdata.yvar(spanel_index)  = CDFvar.yvar(evskp.index)    
      sdata.zvar(spanel_index)  = CDFvar.zvar(evskp.index)    
      sdata.bin(spanel_index)   = CDFvar.bin(evskp.index)    
      sdata.ptype(spanel_index) = CDFvar.plot_type(evskp.index )    
      sdata.xscaling(spanel_index) = 1
      sdata.yscaling(spanel_index) = 1
      sdata.zscaling(spanel_index) = 1
    end
(uval gt 40) and (uval lt 45): begin    ; change x variable assignment
       idex=uval mod 40
       varvali=0
       get_idex,varvali
    end
(uval eq 47): sdata.xscaling(spanel_index)=1  ;linear
(uval eq 48): sdata.xscaling(spanel_index)=2  ;logarithm
(uval gt 50) and (uval lt 55): begin          ; change y variable assignment
       idex=uval mod 50
       varvali=1
       get_idex,varvali
    end
(uval eq 57): sdata.yscaling(spanel_index)=1  ;linear
(uval eq 58): sdata.yscaling(spanel_index)=2  ;logarithm 
(uval gt 60) and (uval lt 65): begin          ; change z variable assignment
       idex=uval mod 60
       varvali=2
       get_idex,varvali
    end
(uval eq 67): sdata.zscaling(spanel_index)=1  ;linear
(uval eq 68): sdata.zscaling(spanel_index)=2  ;logarithm

(uval gt 70) and (uval lt 75): begin    ; change bin assignment
       idex=uval mod 70
       varvali=3
       get_idex,varvali
    end
(uval eq 80): begin    ; select a component
      if( (sdata.ptype(spanel_index) eq 4) or   $
	   (sdata.ptype(spanel_index) eq 6) ) then begin
	      sdata.bini(spanel_index) = evskp.index
	      binorcomp=complist(evskp.index)
	      print,binorcomp
       endif else begin
	   if( (sdata.ptype(spanel_index) eq 1) or   $       
	     (sdata.ptype(spanel_index) eq 2) ) then begin 
	     sdata.compi(spanel_index) = evskp.index
	     binorcomp=complist(evskp.index)
	     print,binorcomp
	   endif else begin      
	       sdata.bini(spanel_index) = 555  
	       sdata.compi(spanel_index) = 555 
	   endelse
       endelse
    end
(uval eq 21):    ; plot actual data value
(uval eq 22):    ; compute and plot new data values
else: begin  ; change plot type
	ptindex= uval mod 90
	flag0=0
	get_ptype0,vari,ptindex,ptype0,flag0
	widget_control,pt,set_value= ptype0
     end
endcase
end

pro skp 
common flagcom,sdata_flag ,file_label 
common defcom, def, sysdirs, syspcmd,sdata,mday,spanel_index            
common sdatacom,CDFvar,KPattr,KPattr_val,KPcount,varval,complist
common skpcom,pt,skplabel,kpmes,whichvar,sel_comp,cvarbut_sub,scbut 

bartitle='Select Data : Select Key Parameter'  
base_skp=widget_base(/column,title=bartitle,xoffset=50,yoffset=150,space=10)  
skpbut=lonarr(3)   
skpbut_val=['             OK             ','           Cancel           ', $  
	    '            Help            '  ]  
base1=widget_base(base_skp,/row)  
for i=0,2 do skpbut(i)=widget_button(base1,value=skpbut_val(i),           $  
			  uvalue=i+1,/frame)  
base2=widget_base(base_skp,/row)  
base21=widget_base(base2,/column)  
labela=widget_label(base21,value='Select Key Parameter')  
kplist=widget_list(base21,value=CDFvar.name,uvalue=10,/frame,xsize=30,    $
		   ysize=9) 
base22=widget_base(base2,/column)  
label2=widget_label(base22,value='Information')  
kpmes=widget_text(base22,value='Select a Key Parameter First !  ',        $
		  xsize=70,ysize=10,/frame,/wrap,/scroll) 
;label3=widget_label(base_skp,value='   ') 
skplabel=widget_label(base_skp,value='< Selection >   Key Parameter : '+  $
		  '( None )')
base3=widget_base(base_skp,/row,/frame,space=10) 
base30=widget_base(base3,/column )
base301=widget_base(base30,/row)
ptlabel=widget_label(base301,value='[  Plot Type  ] ') 
pt=widget_text(base301,value='  ',xsize=45,uvalue=23,/frame)
ptbut=widget_button(base301,value='Change to...',/menu,/frame)
ptbut_sub=lonarr(8) 
ptbut_subval=['Time Series             ( x-y plot )',  $
	      'Y-var( X-var ) vs X-var ( x-y plot )',  $
	      'Spectrogram                         ',  $
	      'Spectrogram with Bin                ',  $ 
	      'Image                               ',  $
	      'Image with Bin                      ',  $
	      'Vector                              ',  $
	      'Yvar(time) vs Xvar(time)            '      ]
for i=0,7 do ptbut_sub(i)=widget_button(ptbut,value=ptbut_subval(i),   $
					 uvalue=91+i )
base31=widget_base(base30,/column,/frame )
base311=lonarr(4) & whichvar=lonarr(4) & whichvarlabel=lonarr(4) 
whichvar_val=['<-- X axis -->','<-- Y axis -->','<-- Z axis -->',' Bin :  ']  
cvarbut=lonarr(4) & cvarbut_sub=lonarr(4,4) & cvarbut_subval=['','','','']
cvarbut_val='Change to...'
base_scl=lonarr(3) & scbut=lonarr(3,2) & scbut_val=['linear','logarithm']
for i=0,2 do begin  
   base311(i)=widget_base(base31,/row)
     base_scl(i)=widget_base(base311(i),/row,/exclusive,/frame)
     for k=0,1 do scbut(i,k)=widget_button(base_scl(i),value=scbut_val(k),$
					    uvalue=(47+k)+(i*10)   )
   whichvarlabel(i) =widget_label(base311(i),value=whichvar_val(i) )  
   whichvar(i)=widget_text(base311(i),value='   ',xsize=20,/frame)  
   cvarbut(i)=widget_button(base311(i),value=cvarbut_val,/menu,/frame )
   for j=0,2 do cvarbut_sub(i,j)=widget_button(cvarbut(i),        $
			     value=cvarbut_subval(i),uvalue=(41+j)+(i*10) )
endfor  
base311(3)=widget_base(base30,/row)
whichvarlabel(3) =widget_label(base311(3),value=whichvar_val(3) )  
whichvar(3)=widget_text(base311(3),value='   ',xsize=30,/frame)  
cvarbut(3)=widget_button(base311(3),value=cvarbut_val,/menu,/frame )
for j=0,2 do cvarbut_sub(3,j)=widget_button(cvarbut(3),        $
			     value=cvarbut_subval(3),uvalue=(41+j)+(3*10) )

base32=widget_base(base3,/column)  
complist=[' ',' ',' ']    
label=widget_label(base32,value='Select Component/Bin ?')  
sel_comp=widget_list(base32,value=complist,uvalue=80,xsize=25,ysize=6, $
		     /frame)  
label=widget_label(base32,value='   ')
base4=widget_base(base32,/column,/frame,/exclusive )  
datahow=lonarr(2)  
datahow_val=['Plot Actual Data Values          ',   $  
	     'Compute and Plot New Data Values ']  
for i=0,1 do datahow(i)=widget_button(base4,value=datahow_val(i),   $  
				      uvalue=i+21,/frame)  
;    
widget_control,base_skp,/realize ,/hourglass 
xmanager,"skp",base_skp  
end  

pro seldata_event,evsd
common defcom, def, sysdirs, syspcmd,sdata,mday ,spanel_index              
common seldatacom,panel,pbut,pbut_val,splabel,dslabel,mbut,new_dslabel,  $
		  dpath,base3
common flagcom,sdata_flag,file_label 
common sdatacom,CDFvar,KPattr,KPattr_val,KPcount,varval,complist
common skpcom,pt,skplabel,kpmes,whichvar,sel_comp,cvarbut_sub,scbut 
common setvalue,imagecdf,imageKP,num_panel,foldername,$ 
       pdtitle,startpath,filterspec,cdf_selection,cdf_length,imagefile 

widget_control,evsd.id,get_uvalue=uval
if sdata_flag eq 1 then begin   ; new selection
   if sdata.dtype eq 1 then    $
	   splabel_val='< Selection >  Panel Number: '+pbut_val(0)        $
      else splabel_val='< Selection >'
endif

case 1 of
(uval eq 81):begin
	       widget_control,evsd.top,/destroy       ;ok
	       print_sdata 
	       make_plot
	     end
(uval eq 82):                                       ;view selection
(uval eq 83):widget_control,evsd.top,/destroy       ;cancel   
(uval eq 84):badnews,'   *****    To be implemented    *****   '                                       ;help
(uval eq 41):begin
      num_panel=1
      set_sdata,num_panel
      widget_control,base3,sensitive=1
      widget_control,pbut(0),/set_button
      spanel_index=0
      for i=1,14 do widget_control,pbut(i),sensitive=0
      sdata.dir(0)=sysdirs.def
      widget_control,dpath,set_value=sdata.dir(0)         
      sdata.dtype=1  ; non-image data  
    end
(uval eq 42):begin
	num_panel=1
	set_sdata,num_panel
	spanel_index=0
	widget_control,base3,sensitive=0
	widget_control,splabel,set_value=' <  Selection  > '
	sdata.dir(0)=sysdirs.def
	widget_control,dpath,set_value=sdata.dir(0)
	sdata.dtype=2  ; image data & reset the structure
   
   ;           if sdata_flag eq 1 then begin       ; new selection
   ;              widget_control,dslabel,set_value=dslabel_val
   ;              widget_control,mbut,sensitive=0
   ;              widget_control,new_dslabel,set_value=new_dslabel_val 
   ;              widget_control,dpath,set_value=sdata.dir
   ;           endif else begin                    ; from plotfile
   ;              widget_control,dslabel,sensitive=0
   ;              widget_control,mbut,sensitive=0
   ;              widget_control,new_dslabel,sensitive=0
   ;              widget_control,base332,sensitive=0
   ;           endelse
      end
(uval eq 50):begin   ; read directory and then select CDF file 
      ;  if sdata.num_ds ne 0 then filename=cdffile else filename=' '
	 pdtitle=' Select Data: Select a CDF File '
	 get_filefilter,1
	 if  spanel_index gt 0 then filename=sdata.cdf(spanel_index-1)
	 file_selection=pickfile(title=pdtitle,path=sdata.dir(spanel_index),$
				  filter=filterspec,file=filename)
	 yesfile=where(file_selection ne '',count)
	 if count ne 0 then begin
	     cdffile=file_selection                        
	     sdata.cdf(spanel_index)=cdffile
	     if spanel_index eq 0 then begin
		sdata.cdf_flag(spanel_index)=2
		loadct,39
		window,2,title='Processing Status'
		wset,2
		xyouts,0.5,0.5,'Analyzing File ...... ',alignment=0.5,$
			  /normal,charsize=2.0,charthick=2.0,color=200
		KPinfo,cdffile   
		wdelete,2    &   loadct,0
		skp
	     endif else begin    ; spanel_index > 0
		if ( cdffile eq sdata.cdf(spanel_index -1)) then begin
		    sdata.cdf_flag(spanel_index) = 1
		    skp
		endif else begin
		    sdata.cdf_flag(spanel_index) = 2
		    loadct,39
		    window,2,title='Processing Status'
		    wset,2
		    xyouts,0.5,0.5,'Analyzing File ...... ',alignment=0.5,$
			  /normal,charsize=2.0,charthick=2.0,color=200
		    KPinfo,cdffile   
		    wdelete,2    &   loadct,0
		    skp
		 endelse
	      endelse
	 endif else badnews,'  *****    No New CDF/File Selected.   *****  '
    end
(uval gt 0) and (uval lt 20):begin  ; select "how many panels" and 
      num_panel=uval
      widget_control,panel,set_value=string(num_panel )
      set_sdata,num_panel             
      sdata.num_panel=num_panel
      for i=0,14 do widget_control,pbut(i),sensitive=1
      for i=sdata.num_panel,14 do widget_control,pbut(i),sensitive=0
      widget_control,pbut(0),/set_button
      splabel_val='< Selection >  Panel Number: '+pbut_val(0)  
      widget_control,splabel,set_value= splabel_val 
      sdata.dir(*)=sysdirs.def
      widget_control,dpath,set_value=sdata.dir(0)  
      sdata.dtype=1

;      widget_control,dslabel,set_value= dslabel_val
;      widget_control,mbut,sensitive=0
;      widget_control,new_dslabel,set_value=new_dslabel_val
    end
(uval gt 20) and (uval lt 40): begin   ;select a panel number
      spanel_index =uval mod 21
      widget_control,splabel,set_value= '< Selection >  Panel Number: '+ $
			       pbut_val(spanel_index ) 
      widget_control,dpath,set_value=sdata.dir(spanel_index )    
   ;   widget_control,dslabel,set_value= dslabel_val
   ;   widget_control,mbut,sensitive=0
   ;   widget_control,new_dslabel,set_value=new_dslabel_val
   ;   widget_control,dpath,set_value=sdata.dir(spanel_index )
    end             
else: begin   ; the directory listing
	ndir=uval mod 101
	if sdata.dtype eq 1 then dindex=spanel_index  else dindex=0
	sdata.dir(dindex)=sysdirs.listval(ndir)
	widget_control,dpath,set_value=sdata.dir(dindex)  
      end
endcase

end

pro seldata,bartitle
common defcom, def, sysdirs, syspcmd,sdata,mday ,spanel_index           
common seldatacom,panel,pbut,pbut_val,splabel,dslabel,mbut,new_dslabel,  $
		  dpath,base3
common flagcom,sdata_flag ,file_label
;
base_sd=widget_base(/column,title='Select Data : '+bartitle,xoffset=50, $ 
		    yoffset=100 )
base0=widget_base(base_sd,/row) 
sbut=lonarr(4) 
sbut_val=['    OK  ==>  Go Plot !!    ', $        
	  '   View Data Selection Status   ', $
	  '    Cancel    ', $
	  '     Help     '    ] 
for i=0,3 do sbut(i)=widget_button(base0,value=sbut_val(i),uvalue=i+81, $
				   /frame,font=def.widfont) 
nu=widget_label(base_sd,value='   ') 
base1=widget_base(base_sd,/row) 
label=widget_label(base1,value='Data Type ?  ',font=def.widfont ) 
base2=widget_base(base1,/row,/exclusive,/frame) 
dtypebut_val=[' Non-Image Data        ' , ' Image Data            ' ] 
dtypebut=lonarr(2)
for i=0,1 do dtypebut(i)=widget_button(base2,value=dtypebut_val(i),  $
		       uvalue=41+i, /no_release,font=def.widfont )
; 
base3=widget_base(base_sd,/column,/frame) 
base31=widget_base(base3,/row) 
label=widget_label(base31,value='Total Number of Panels on the plot page: ', $
		   font=def.widfont ) 
panel=widget_text(base31,value=string(sdata.num_panel),/frame,font=def.widfont) 
cpanel=widget_button(base31,value='  Change to ... ',/menu,font=def.widfont ) 
   cpanel_but=lonarr(15)  & cpanel_butval=string(indgen(15)+1)
   for i=0,14 do cpanel_but(i)=widget_button(cpanel,value=cpanel_butval(i), $
					  uvalue=i+1,font=def.widfont )
label=widget_label(base3,value='Select a Panel Number to Select Data',  $
		   font=def.widfont ) 
base32=widget_base(base3,/row,/exclusive,/frame) 
pbut=lonarr(15) & pbut_val=strcompress(string(indgen(15)+1),/remove_all) 
for i=0,14 do pbut(i)=widget_button(base32,value=pbut_val(i),uvalue=21+i,  $
				    font=def.widfont ) 
nu=widget_label(base_sd,value='   ',font=def.widfont ) 
splabel=widget_label(base_sd,value='< Selection >  Panel Number: '+     $
		     string(sdata.num_panel) ,font=def.widfont )
;base33=widget_base(base_sd,/column,/frame) 
;base331=widget_base(base33,/row,space=25 ) 
;dslabel=widget_label(base331,value='Number of Data Selections : '+    $
;                     string(sdata.num_ds(0)) ) 
;cdsbut=widget_button(base331,value='  Change to ... ',/menu ) 
;   cdsbut_sub=lonarr(2)  & cdsbut_subval=string(indgen(2)+1)
;   for i=0,1 do cdsbut_sub(i)=widget_button(cdsbut,value=cdsbut_subval(i) ,   $
;                                          uvalue=61+i  )
;label=widget_label(base331,value='Select a Data Selection Number') 
;base332=widget_base(base331,/row,/exclusive,/frame) 
;dsbut=lonarr(2) & dsbut_val=strcompress(string(indgen(2)+1),/remove_all) 
;for i=0,1 do dsbut(i)=widget_button(base332,value=dsbut_val(i),uvalue=71+i) 
;nu=widget_label(base33,value='    ') 
;new_dslabel=widget_label(base33,value='[ New Selection ]              '+  $ 
;                        'Data Selection Number:  '+string(sdata.new_ds(0))  ) 
;base332=widget_base(base33,/column,/frame) 
base332=widget_base(base_sd,/column,/frame)  
nbase1=widget_base(base332,/row) 
label=widget_label(nbase1,value='Directory Path ',font=def.widfont) 
dpath=widget_text(nbase1,value= sdata.dir(0) ,xsize=50,/frame,font=def.widfont) 
spanel_index=0
cdpath=widget_button(nbase1,value='  Change to ... ',/menu,font=def.widfont) 
   num_dirs= n_elements(sysdirs.listval)  &  cdpath_but=lonarr( num_dirs )   
   for i=0,num_dirs-1 do cdpath_but(i)=widget_button(cdpath,font=def.widfont, $
				    value=sysdirs.listval(i),uvalue=101+i  )
nbase2=widget_base(base332,/row) 
label=widget_label(nbase2,value='     - - - - - ->>  ',font=def.widfont ) 
newdata_but=widget_button(nbase2, /frame,uvalue=50, font=def.widfont,  $ 
;                         value=' Select/Add New CDF File/Key Parameter ' ) 
			  value=' Select CDF File/Key Parameter ' ) 
label=widget_label(nbase2,value='  <<- - - - - -  ',font=def.widfont ) 
 
widget_control,base_sd,/realize ,/hourglass
; automatic setup  
if sdata_flag eq 1 then begin  ;new selection
   widget_control,dtypebut(0),/set_button
   widget_control,pbut(0),/set_button
   sdata.dtype=1    ; non-image data
;   widget_control,mbut,sensitive=0
   for i=1,14 do widget_control,pbut(i),sensitive=0
endif else begin  ;from plotfile
   if sdata.dtype eq 1 then begin   ; non-image
       widget_control,dtypebut(0),/set_button
       widget_control,pbut(0),/set_button
       for i=num_panel, 14 do widget_control,pbut(i),sensitive=0
   endif else begin   ; image 
       widget_control,dtypebut(1),/set_button
       widget_control,base3,sensitive=0
       widget_control,splabel,set_value='< Selection >'
 ;      widget_control,dslabel,sensitive=0
 ;      for i=sdata.num_ds,4 do widget_control,mbut,sensitive=0
 ;      widget_control,new_dslabel,sensitive=0
 ;      widget_control,base332,sensitive=0
   endelse
endelse

xmanager,"seldata",base_sd 

end 

pro set_sdata,num_panel
common defcom, def, sysdirs, syspcmd ,sdata,mday,spanel_index
   
sdata={ pfile:'',                        $
	dtype:0,                         $
	ptype:intarr(num_panel),         $
	varindex:intarr(num_panel),      $
	var:strarr(num_panel),           $
	num_panel:0,                     $
;         num_ds:intarr(num_panel),      $ 
;         new_ds:intarr(num_panel),      $
	dir:strarr(num_panel),           $
	cdf:strarr(num_panel),           $
	dir_flag:intarr(num_panel),      $
	cdf_flag:intarr(num_panel),      $
	xvar:strarr(num_panel),          $
	yvar:strarr(num_panel),          $ 
	zvar:strarr(num_panel),          $
	xis_zvar:intarr(num_panel),      $
	yis_zvar:intarr(num_panel),      $
	zis_zvar:intarr(num_panel),      $
	x_ndims:intarr(num_panel),       $
	y_ndims:intarr(num_panel),       $
	z_ndims:intarr(num_panel),       $
	xsize:0L,                        $    ;
	ysize:0L,                        $    ; 
	eoffset:intarr(10),              $    ; 
	einterval:intarr(10),            $    ;
	bin:strarr(num_panel),           $ 
	yescomp:intarr(num_panel),       $    ;
	yesbin:intarr(num_panel),        $    ;
	compi:intarr(num_panel),         $    ;
	bini:intarr(num_panel),          $    ;
	xoffset:intarr(num_panel,10),    $
	yoffset:intarr(num_panel,10),    $
	zoffset:intarr(num_panel,10),    $
	xinterval:intarr(num_panel,10),  $
	yinterval:intarr(num_panel,10),  $
	zinterval:intarr(num_panel,10),  $
	xlabel:strarr(num_panel),        $
	ylabel:strarr(num_panel),        $
	zlabel:strarr(num_panel),        $
	binlabel:strarr(num_panel),      $
	xmin:dblarr(num_panel),          $
	ymin:dblarr(num_panel),          $
	zmin:dblarr(num_panel),          $
	xmax:dblarr(num_panel),          $
	ymax:dblarr(num_panel),          $ 
	zmax:dblarr(num_panel),          $
	xscaling:intarr(num_panel),      $
	yscaling:intarr(num_panel),      $
	zscaling:intarr(num_panel),      $
	title:strarr(num_panel),         $ 
	instrument:strarr(num_panel)   }
end

pro  get_seldata_def,bartitle        
common defcom, def, sysdirs, syspcmd ,sdata,mday,spanel_index
common flagcom,sdata_flag ,file_label
 
if sdata_flag eq 1 then begin   ; new data selection
   num_panel=1 
   set_sdata,num_panel
   sdata.pfile='Untitled'
   bartitle=sdata.pfile
   sdata.dtype = 1
   sdata.num_panel =1 
  ; sdata.num_ds(0) = 0
  ; sdata.new_ds(0) = 1
   sdata.dir(0) = sysdirs.def   ; def dir from "system setup"
endif 

end

pro makesysfile_event,evms
common new,basems,entry,filelist,filelist_val,oldfilelist_val, $
	   selectone,selectone_index,selectone_flag,def_item,olddef_item,$
	   def_item_index
common flags, sysfile_flag
common defcom, def, sysdirs, syspcmd ,sdata,mday,spanel_index

widget_control,evms.id,get_uvalue=uval
case uval of 
22: begin    ;select one
      selectone=filelist_val(evms.index)
      selectone_index=evms.index  
      selectone_flag=1
    end
55:begin     ;set to default
     def_item=selectone
     def_item_index=selectone_index
     selectone_flag=0
   end
44:begin     ; remove one form the list
     if selectone_flag eq 0 then print,'select first' else begin 
       num_item=n_elements(filelist_val)
       if num_item eq 1 then print,'It can not be removed from the list.' $
       else begin
	    newfilelist_val=strarr(n_elements(filelist_val)-1)
	    last=n_elements(filelist_val)-1
	    case  selectone_index of
	    0:    newfilelist_val(0:last-1)=filelist_val(1:last)
	    last: newfilelist_val(0:last-1)=filelist_val(0:last-1)
	    else: begin
		     newfilelist_val(0:selectone_index-1)=   $
					  filelist_val(0:selectone_index-1)
		     newfilelist_val(selectone_index:last-1)=   $
				       filelist_val(selectone_index+1:last)
		  end
	    endcase
	    filelist_val=newfilelist_val
	    widget_control,filelist,set_value=filelist_val
	    result=where(filelist_val eq def_item,count)
	    index=result(0)
	    case 1 of
	      count eq 0: def_item_index=0
	      count eq 1: def_item_index=index
	      count gt 1: def_item_index=index
	      else:
	    endcase
	    def_item=filelist_val(def_item_index)
	    widget_control,filelist,set_list_select=def_item_index
	    selectone_flag=0
	endelse
     endelse
   end

33: begin     ; add one to the list
      widget_control,entry,get_value=entryval
      entry_val=entryval(0)
      newfilelist=strarr(n_elements(filelist_val)+1)
      newfilelist(0:n_elements(filelist_val)-1)=filelist_val
      newfilelist(n_elements(newfilelist)-1)=entry_val
      filelist_val=newfilelist
      widget_control,filelist,set_value=filelist_val
      widget_control,filelist,set_list_select=def_item_index
    end
1: begin   ; OK and save the new settings
      widget_control,/destroy,evms.top
      case sysfile_flag of
      1: begin
	   sysdirs_old=sysdirs
	   sysdirs={listval:strarr(n_elements(filelist_val)),def:'',  $
		    def_index:0L, file:''}
	   sysdirs.listval=filelist_val
	   sysdirs.def=def_item
	   sysdirs.def_index=def_item_index
	   sysdirs.file=sysdirs_old.file
	   save,sysdirs,filename=sysdirs.file     ;,/verbose   
	 end
      2: begin
	   syspcmd_old=syspcmd
	   syspcmd={listval:strarr(n_elements(filelist_val)),def:'',  $
		    def_index:0L, file:''}
	   syspcmd.listval=filelist_val
	   syspcmd.def=def_item
	   syspcmd.def_index=def_item_index
	   syspcmd.file=syspcmd_old.file 
	   save,syspcmd,filename=syspcmd.file                                                      
	 end
      else:
      endcase                              
   end
2: begin   ; cancel and save the old settings
      widget_control,/destroy,evms.top
      filelist_val=oldfilelist_val
      def_item=olddef_item
      case sysfile_flag of
	1: save,sysdirs,filename=sysdirs.file     ;,/verbose   
	2: save,syspcmd,filename=syspcmd.file                                   
	else:
      endcase                              
   end
3: begin  ;helpfile
   end
else:
endcase
end


pro makesysfile      ; ,sysfile_flag
common new,basems,entry,filelist,filelist_val,oldfilelist_val, $
	   selectone,selectone_index,selectone_flag,def_item,olddef_item,$
	   def_item_index
common flags, sysfile_flag
common defcom, def, sysdirs, syspcmd ,sdata,mday,spanel_index

case sysfile_flag of
1: begin     ;file directory
     filelist_val=sysdirs.listval
     def_item=sysdirs.def
     def_item_index=sysdirs.def_index
     sysfile=sysdirs.file
     sysbartitle='File Directory'
   end
2: begin     ;print command
     filelist_val=syspcmd.listval
     def_item=syspcmd.def
     def_item_index=syspcmd.def_index
     sysfile=syspcmd.file
     sysbartitle='Print Command'
   end
else:
endcase

oldfilelist_val=filelist_val
olddef_item=def_item
selectone_flag=0
basems=widget_base(/column,title='System Setup :  ' + sysbartitle +   $
		  '                ' + 'KPVT V2.0' )
base1=widget_base(basems,/row,space=15)
control_val=['      OK      ', '    Cancel    ', '     Help     ']
control_but=lonarr(3)
for i=0,2 do control_but(i)=widget_button(base1,value=control_val(i),  $
		       uvalue=i+1,/frame,font=def.widfont )
base2=widget_base(basems,/column,/frame,space=15)
base21=widget_base(base2,/row)
label21=widget_label(base21,value='New Entry ',font=def.widfont )
entry_val='(None)'
entry=widget_text(base21,value=entry_val,uvalue=11,/editable,/frame,  $
		  xsize=55,font=def.widfont )
addbut=widget_button(base21,value='   Add to the List   ',uvalue=33,  $
		     font=def.widfont )
base22=widget_base(base2,/row)
base221=widget_base(base22,/column)
label221=widget_label(base221,value='Select one: ',font=def.widfont )

filelist=widget_list(base221,value=filelist_val, uvalue=22, /frame,   $
		     xsize=35,  ysize=10, font=def.widfont )
base222=widget_base(base22,/column,space=15)
label222=widget_label(base222,value='to:',font=def.widfont )
removebut=widget_button(base222,value=' Remove from the List ',   $
			uvalue=44, /frame, font=def.widfont )
saveasdef=widget_button(base222,value=' Save as Default '+sysbartitle+' ', $
			uvalue=55,/frame, font=def.widfont )
widget_control,basems,/realize
widget_control,filelist,set_list_select=def_item_index
xmanager,"makesysfile",basems
end 
 
pro make_skeleton,input_file,output_file

openw,1,output_file
cdfid = cdf_open(input_file)    ; Open a CDF file
cdfinfo = cdf_inquire( cdfid )     ; Find out general info
; first check what kind of cdf is
totnum_var = cdfinfo.nzvars+cdfinfo.nvars
case 1 of
(cdfinfo.nvars eq totnum_var): begin 
				  cdfvar=1 & cdf_type=' r-Variable CDF '
			       end
(cdfinfo.nzvars eq totnum_var): begin
				  cdfvar=2 & cdf_type=' z-Variable CDF '
				end
(cdfinfo.nvars+cdfinfo.nzvars eq totnum_var): begin
			  cdfvar=3 & cdf_type=' r- and z- Variable CDF '
		   end
else: print, ' Something is wrong here. '
endcase
;
printf,1,'! Generated by   ISTP Key Parameter Visualization Tool - '+ $
	 'version 2.0 '
printf,1,'! @ '+ systime()
printf,1,'   '
printf,1,'*********************************************************************'
printf,1,'*                                                                   *'
printf,1,'*                        SKELETON TABLE                             *'
printf,1,'*                                                                   *'
printf,1,'*********************************************************************'
printf,1,'   '
printf,1,'   '
printf,1,'              CDF     : ',input_file
printf,1,'   '
printf,1,'              Type    : ',cdf_type
printf,1,'              Encoding: ',cdfinfo.encoding
printf,1,'              Majority: ',cdfinfo.majority
printf,1,'              No. of rVariables:  ', cdfinfo.nvars
printf,1,'              No. of zVariables:  ',cdfinfo.nzvars  
printf,1,'              No. of Attributes:  ',cdfinfo.natts
if cdfvar eq 1 then begin
   printf,1,'              No. of Dimension(s): ',cdfinfo.ndims
   printf,1,'              Dimension Size(s): ',cdfinfo.dim
   printf,1,'              Records : ',cdfinfo.maxrec+1
endif
printf,1,'   '
printf,1,'   '
for i=0,cdfinfo.natts-1 do begin
    cdf_attinq,cdfid,i,name,scope,maxentry,maxzentry
endfor
print_title = 1
case cdfvar of
1: varnums=cdfinfo.nvars
2: varnums=cdfinfo.nzvars
3: varnums=totnum_var
else:
endcase

for attr_num = 0,cdfinfo.natts-1 do begin
   cdf_attinq, cdfid, attr_num, attname, scope, maxentry
   if ((attname eq 'TEXT') or (attname eq 'MODS')) then begin
      On_IoError, noat
      if cdfvar eq 3 then begin
	for i=0,cdfinfo.nvars-1 do begin
	   cdf_attget,cdfid,attr_num,i,attvalue
	   if i eq 0 then printf,1,"'",attname,"' = ",attvalue else $ 
			  printf,1,attvalue
	endfor
	for i=0,cdfinfo.nzvars-1 do begin
	   cdf_attget,cdfid,attr_num,i,attvalue,/zvariable
	   if i eq 0 then printf,1,"'",attname,"' = ",attvalue else $ 
			  printf,1,attvalue
	endfor
      endif else begin
	 for i=0,varnums-1 do begin 
	     case cdfvar of
	     1: cdf_attget,cdfid,attr_num,i,attvalue
	     2: cdf_attget,cdfid,attr_num,i,attvalue,/zvariable
	     else:  
	     endcase
	     if i eq 0 then printf,1,"'",attname,"' = ",attvalue else $ 
			    printf,1,attvalue
	 endfor
      endelse
      noat:
      printf,1,'   '
   endif else begin
      if scope eq "GLOBAL_SCOPE" then begin
	On_IoError, NoGlobAttr
	case cdfvar of
	1:cdf_attget, cdfid, attr_num, maxentry, attvalue
	else: cdf_attget, cdfid, attr_num, maxentry, attvalue, /zvariable
	endcase
	if print_title then begin
	printf,1,''
	printf,1,'---------------------<<   Global Attributes   >>---------'+$
		  '-----------'
	printf,1,''
	print_title = 0
	endif
	Printf,1, "'", attname, "' = ", attvalue
	printf,1,'   '
	NoGlobAttr:
      endif
   endelse
endfor

printf,1,'   '
printf,1,'---------------------<<       Variables       >>--------------------'
printf,1,'   '
printf,1,'   '

if cdfvar eq 3 then begin
    for var_num = 0, cdfinfo.nvars-1 do begin
	varinfo=cdf_varinq(cdfid,var_num)        
	printf,1,'    '  &   printf,1,'    '
	printf,1,format='( "[ Variable ]      ",A," (",A,'+ $
			  '" )      Record Variance: ",A)',$
		 varinfo.name,varinfo.datatype,varinfo.recvar
	printf,1,'    '
	On_IoError, NoAttr
	for attr_num=0,cdfinfo.natts-1 do begin
	  cdf_attinq, cdfid, attr_num, attname, scope, maxentry
	  if scope eq 'VARIABLE_SCOPE' then begin
	    cdf_attget, cdfid, attr_num, var_num, attvalue
	    if(( varinfo.name eq 'Epoch') and ( ( attname eq 'VALIDMIN') or $
	       (attname eq 'VALIDMAX') or (attname eq 'SCALEMIN') or     $
	       (attname eq 'SCALEMAX') ) )then begin
		  cdf_epoch,attvalue,yr,mon,day,hr,min,sec,millisec,/break
		  attvalue=strcompress(string(mon),/remove_all)+'/'+ $
			   strcompress(string(day),/remove_all)+'/'+ $
			   strcompress(string(yr),/remove_all)+'   '+ $
			   strcompress(string(hr),/remove_all)+':'+  $
			   strcompress(string(min),/remove_all)+':'+ $
			   strcompress(string(sec),/remove_all)+':'+ $
			   strcompress(string(millisec),/remove_all)
		  printf,1,"'", attname, "' = ", attvalue
	    endif else printf,1,"'", attname, "' = ", attvalue
	  endif
	NoAttr:
	endfor
	printf,1,'    '
	printf,1,'    '
    endfor
    for var_num = 0, cdfinfo.nzvars-1 do begin
	varinfo=cdf_varinq(cdfid,var_num,/zvariable)  
	printf,1,'    '  &   printf,1,'    '
	printf,1,format='( "[ Variable ]      ",A," (",A,'+ $
			  '" )      Record Variance: ",A)',$
		 varinfo.name,varinfo.datatype,varinfo.recvar
	printf,1,'    '
	On_IoError, NoAttr22
	for attr_num=0,cdfinfo.natts-1 do begin
	  cdf_attinq, cdfid, attr_num, attname, scope, maxentry
	  if scope eq 'VARIABLE_SCOPE' then begin
	    cdf_attget, cdfid, attr_num, var_num, attvalue,/zvariable
	    if(( varinfo.name eq 'Epoch') and ( ( attname eq 'VALIDMIN') or $
	       (attname eq 'VALIDMAX') or (attname eq 'SCALEMIN') or     $
	       (attname eq 'SCALEMAX') ) )then begin
		  cdf_epoch,attvalue,yr,mon,day,hr,min,sec,millisec,/break
		  attvalue=strcompress(string(mon),/remove_all)+'/'+ $
			   strcompress(string(day),/remove_all)+'/'+ $
			   strcompress(string(yr),/remove_all)+'   '+ $
			   strcompress(string(hr),/remove_all)+':'+  $
			   strcompress(string(min),/remove_all)+':'+ $
			   strcompress(string(sec),/remove_all)+':'+ $
			   strcompress(string(millisec),/remove_all)
		  printf,1,"'", attname, "' = ", attvalue
	    endif else printf,1,"'", attname, "' = ", attvalue
	  endif
	NoAttr22:
	endfor
	printf,1,'    '
	printf,1,'    '
    endfor

endif else begin
    for var_num = 0, varnums-1 do begin
	if cdfvar eq 1 then varinfo=cdf_varinq(cdfid,var_num)        $
		       else varinfo = cdf_varinq(cdfid, var_num,/zvariable)
	printf,1,'    '
	printf,1,'    '
	printf,1,format='( "[ Variable ]      ",A," (",A,'+ $
			  '" )      Record Variance: ",A)',$
		 varinfo.name,varinfo.datatype,varinfo.recvar
	printf,1,'    '
	On_IoError, NoAttr11
	for attr_num=0,cdfinfo.natts-1 do begin
	  cdf_attinq, cdfid, attr_num, attname, scope, maxentry
	  if scope eq 'VARIABLE_SCOPE' then begin
	    case cdfvar of
	    1:cdf_attget, cdfid, attr_num, var_num, attvalue
	    2:cdf_attget, cdfid, attr_num, var_num, attvalue, /zvariable
	    else: 
	    endcase
	    if(( varinfo.name eq 'Epoch') and ( ( attname eq 'VALIDMIN') or $
	       (attname eq 'VALIDMAX') or (attname eq 'SCALEMIN') or     $
	       (attname eq 'SCALEMAX') ) )then begin
		  cdf_epoch,attvalue,yr,mon,day,hr,min,sec,millisec,/break
		  attvalue=strcompress(string(mon),/remove_all)+'/'+ $
			   strcompress(string(day),/remove_all)+'/'+ $
			   strcompress(string(yr),/remove_all)+'   '+ $
			   strcompress(string(hr),/remove_all)+':'+  $
			   strcompress(string(min),/remove_all)+':'+ $
			   strcompress(string(sec),/remove_all)+':'+ $
			   strcompress(string(millisec),/remove_all)
		  printf,1,"'", attname, "' = ", attvalue
	    endif else printf,1,"'", attname, "' = ", attvalue
	  endif
	NoAttr11:
	endfor
	printf,1,'    '     &    printf,1,'     '
    endfor
endelse
cdf_close,cdfid    &    close,1
end

pro checkpos,pos_entry,pos_spec,posval,posval_flag

yespos=0
cnt=0
posval_flag=0
while yespos ne -1 do begin
   yespos=strpos(pos_entry,pos_spec,yespos)
   if yespos ne -1 then begin
      cnt=cnt+1
      posval=yespos
      posval_flag=1
      yespos=yespos+1
   endif
endwhile
end

pro get_sktname,infile,outfile
common setvalue,imagecdf,varname,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length,imagefile

get_defdir,dirdiv,defdir
get_filefilter,7
cdfbb_len=strlen(infile)
sktdir=defdir & sktext=filterspec
defcdfdiv='.'

checkpos,infile,dirdiv,pos,posflag
checkpos,infile,defcdfdiv,rpos,nuflag

if !version.os eq 'vms' then begin
   if posflag ne 1 then begin
      defdirdiv=':'
      checkpos,infile,defdirdiv,leftpos,nuflag
      cdfname=strmid(infile,leftpos+1,rpos-leftpos-1) 
   endif else cdfname=strmid(infile,pos+1,rpos-pos-1)
endif else cdfname=strmid(infile,pos+1,rpos-pos-1)
outfile=sktdir+cdfname+sktext

end

pro display_event, eventdp
common sysbloc,sys_def
common hcbloc,otflag,hc_input,lpr_command,WH,off_LL,WH_val,off_LLval,$
	      psfile,psfile_name,colorflag,windex,windex_val,okflag

widget_control,eventdp.top, get_uvalue=filename,/no_copy
widget_control, eventdp.id, get_uvalue = uval
case uval of
1: widget_control,eventdp.top,/destroy
2: begin  ; hardcopy
     sys_def.lpr_text=1 & sys_def.lpr_plot=0
     hardcopy
     ;show_status,3     ; too fast!
     cmd=lpr_command+' '+filename
     spawn,cmd(0)
     sys_def.lpr_text=0
     ;wdelete,3
   end
3:        ; help
else:
endcase
if widget_info(eventdp.top,/valid) then widget_control,eventdp.top,   $
					   set_uvalue=filename,/no_copy
end

pro display, filename, xoff,yoff, title = title, group = group,  $
	 width=width,   height = height, text = text, font = font

if(not(keyword_set(title))) then title = 'Display File :  '+filename
if(not(keyword_set(height))) then height = 24   
if(not(keyword_set(width))) then width = 80

if(not(keyword_set(text)))then begin
 if !version.os eq 'vms' then begin
      yessfdu=0
      cnt=0
      sfdupos=-1
      while yessfdu ne -1 do begin
	 yessfdu=strpos(filename,'SFDU',yessfdu)
	 if yessfdu ne -1 then begin
	    cnt=cnt+1
	    sfdupos=yessfdu
	    yessfdu=yessfdu+1
	 endif
      endwhile
      if sfdupos eq -1 then begin
	 yessfdu=0
	 cnt=0
	 while yessfdu ne -1 do begin
	    yessfdu=strpos(filename,'SFD',yessfdu)
	    if yessfdu ne -1 then begin
	       cnt=cnt+1
	       sfdupos=yessfdu
	       yessfdu=yessfdu+1
	    endif
	 endwhile
	 if sfdupos eq -1 then openr,unit,filename,/get_lun,error=i   $
	 else openr,unit,filename,/get_lun,error=i,/stream
      endif else openr,unit,filename,/get_lun,error=i,/stream
 endif else openr, unit, filename, /get_lun, error=i    


  if i lt 0 then begin
	a = [ !err_string, ' Can not display ' + filename] 
  endif else begin
	  array_size=5000
	  a = strarr(array_size)                      
	  i = 0
	  c = ''
	  while ( (not eof(unit)) and (i lt array_size)) do begin
		readf,unit,c
		a(i) = c
		i = i + 1
	  endwhile
	  a = a(0:(i-1)>0) 
	  free_lun, unit                        
  endelse
endif else a = text

filebase = widget_base(title = title,/column,space=20,xpad=20,ypad=20, $
		       xoffset=xoff,yoffset=yoff,/frame)
base1=widget_base(filebase,/row,space=15)
but1=lonarr(3) 
but1val=['      Quit      ','     Hardcopy ?     ','      Help      ']
for i=0,2 do but1(i)=widget_button(base1,value=but1val(i),uvalue=i+1,/frame)

if n_elements(font) gt 0 then $
 filetext=widget_text(filebase, xsize=width,ysize=height,/scroll, $
			 font = font,value=a,/frame,/wrap) else                   $
 filetext=widget_text(filebase,xsize=width,ysize=height,/scroll,/frame,  $
		      /wrap,value=a)

widget_control, filebase, /realize      
widget_control,filebase,set_uvalue=filename,/no_copy
xmanager, "display",filebase                    
end

pro show_GIForJPEG_event,eventshow
common sysbloc,sys_def
common hcbloc,otflag,hc_input,lpr_command,WH,off_LL,WH_val,off_LLval,$
	      psfile,psfile_name,colorflag,windex,windex_val,okflag
common maincom, mainflag,Gimage
common setting,psflag,rpflag,poflag

widget_control,eventshow.id, get_uvalue=uval
case uval of
1: widget_control,eventshow.top,/destroy
2: begin                 ; hardcopy
     set_plot,'z'
     device,/z_buffering,set_resolution=[Gimage.size(1),Gimage.size(2)] 
     case Gimage.type of 
     4:begin  ;gif 
	 read_gif,Gimage.file,Gimage0,r,g,b
	 tvlct,r,g,b      &     tv,Gimage0
       end
     5:begin  ;jpeg
	 read_jpeg,Gimage.file,Gimage0,ctable,colors=!d.n_colors-1
	 tv,Gimage0    &     tvlct,ctable
       end
     else:
     endcase                   
     b=tvrd()
     sys_def.lpr_text=0 & sys_def.lpr_plot=1
     WH_val=[18.5,24.5]
     off_LLval=[1.5,1.5]   & otflag=1  & psflag.image=1
     get_setplot
     hardcopy
     tv,b
     output_plot
     get_setplot
   end
3:                 ; end
else:
endcase
end

pro show_GIForJPEG,type,Gimage_file,Gtitle   
common maincom, mainflag,Gimage
case type of
4: read_gif,Gimage_file,Gimage0,r,g,b 
5: read_jpeg,Gimage_file,Gimage0,ctable,colors=!d.n_colors-1
else:
endcase
imagesize=size(Gimage0)

showbase=widget_base(/column,title='Browser : '+Gtitle,space=20,   $
		     xoffset=20,yoffset=100)
bases1=widget_base(showbase,/row,space=15)
buts1=lonarr(3) 
buts1val=['      Quit      ','     Hardcopy ?     ','      Help      ']
for i=0,2 do buts1(i)=widget_button(bases1,value=buts1val(i), $
				     uvalue=i+1,/frame )
showimage=widget_draw(showbase,xsize=imagesize(1),ysize=imagesize(2), $
		      /frame, retain=2)
widget_control, showbase, /realize,/hourglass      
widget_control, showimage, get_value= show_screen
wset,show_screen
case type of 
4:begin  ;gif 
   tvlct,r,g,b      &     tv,Gimage0
  end
5:begin  ;jpeg
    tv,Gimage0    &     tvlct,ctable
  end
else:
endcase                   
Gimage={file:'',type:0,size:intarr(n_elements(imagesize)) }
Gimage.file=Gimage_file & Gimage.type=type
Gimage.size=imagesize
xmanager, "show_GIForJPEG", showbase                    
end

pro main_event,ev
common flags, sysfile_flag
common defcom, def, sysdirs, syspcmd ,sdata,mday,spanel_index
common flagcom,sdata_flag,file_label 
common hcbloc,otflag,hc_input,lpr_command,WH,off_LL,WH_val,off_LLval,$
	      psfile,psfile_name,colorflag,windex,windex_val,okflag
common sysbloc,sys_def
common maincom, mainflag,Gimage
common setvalue,imagecdf,varname,num_panel,foldername,  $
       pdtitle,startpath,filterspec,cdf_selection,cdf_length,imagefile
common fillbloc,fillpath,fillext,outfile


widget_control,ev.id,get_uvalue=uval  
sys_def.leader=ev.top
case 1 of   
(uval gt 0) and  (uval lt 10):begin
      uval2=uval mod 10
      case uval2 of
      1: begin         ; 
           sdata_flag = 100
	   mainflag.purpose=0
	   mymessage=' '
	   title=' Select a Directory Path and File Filter to Start With ! '
	   startpath=sysdirs.def  
	   get_filefilter,4
	   getpath,mainflag.purpose,title,mymessage
	   if mainflag.gonext eq 1 then begin
		gotfile=pickfile(title=' Open a Plot File ',path=startpath,$
				 filter=filterspec)
		gotit=where(gotfile ne '',count)
		if count ne 0 then begin 
		   restore,filename=gotfile
		   case sdata.dtype of
		   1: get_newfiles,indexd,countd      
		   2: get_newimgfile                
		   else:
		   endcase
		endif else badnews,'  No Plot File has been selected.  '
	     endif else badnews,'  No Plot File has been selected.   '
	 end
      2: widget_control,ev.top,/destroy
      else:
      endcase
   end
(uval gt 10) and (uval lt 20):begin
	   uval2=uval mod 10
	   case uval2 of 
	   1: begin   ; file directory
		restore,'filedirs.sys'
		sysfile_flag=1  
		makesysfile     
	      end
	   2: begin   ; print command
		restore,'printcmd.sys'
		sysfile_flag=2 
		makesysfile  
	      end
	   3: begin   ; windows
		badnews,'      To be available in Version 2.1      '
	      end
	   4: begin   ; color table
		badnews,'      To be available in Version 2.1      '            
	      end
	   5: begin   ; graphic default settings/ determination factors
		badnews,'      To be available in Version 2.1      '
	      end 
	   else:
	   endcase
	end
(uval gt 20) and (uval lt 30):begin 
	uval2=uval mod 20
	case uval2 of 
	1: begin ; new data selection
	     sdata_flag = 1
	     get_seldata_def,bartitle
	     seldata,bartitle
	   end 
	else: begin  ; old seldata setup
		sdata_flag = 0   
		get_seldata_def,bartitle
		seldata,bartitle
	      end
	endcase
     end
(uval gt 40) and (uval lt 50):begin        ; tools
	uval2=uval mod 40
	case uval2 of 
	1: begin          ; make skeletontable
	     message_no=0    &   get_message,message_no,mymessage
	     startpath = sysdirs.def  & mainflag.purpose=1  
	     get_filefilter,1
	     gp_title='Select a Directory Path and File Filter to Start With !'
	     getpath,mainflag.purpose,gp_title,mymessage
	     if mainflag.gonext eq 1 then begin
		gotfile=pickfile(title=' Make Skeleton Table : Select a '+$ 
			'File!',path=startpath,filter=filterspec)
		gotit=where(gotfile ne '',count)
		if count ne 0 then begin 
		   infile=gotfile & mainflag.purpose=2  &  mymessage=' '
		   gp_title='Where to Write Your Skeleton Table ?'
		   get_sktname,infile,outfile
		   print,'outfile@main: ',outfile
		   getpath,mainflag.purpose,gp_title,mymessage
		   if mainflag.yesorno eq 1 then begin
		      show_status,1
		      make_skeleton,infile,outfile
		      wdelete,1
		      display,outfile,20,100
		   endif else badnews,' No skeleton table is generated. '
		endif else badnews,'  No CDF is selected.  And no skeleton '+$
				   'table is generated.  '
	     endif else badnews,'  No skeleton table is generated.   '
	   end
	2: badnews,'   Will be available in Version 2.1    ' 
                                                  ; make data look-up table
	else:
	endcase
      end
(uval gt 50) and (uval lt 60):begin        ;browser - a text/graphic viewer
	 uval2=uval mod 50
	 browser_type=['View SFDU File','View Skeleton Table',         $
	     'View Text/ASCII File', 'Display GIF File','Display JPEG File']  
	 mainflag.purpose=0     &   mymessage=''
	 get_filefilter,uval2+1
	 get_defdir,dirdiv,defdir   & startpath=defdir
	 gp_title='Browser: '+ browser_type(uval2-1)
	 getpath,mainflag.purpose,gp_title,mymessage
	 if mainflag.gonext eq 1 then begin
	    gotfile=pickfile(title=' Browser : Select a '+$ 
			'File!',path=startpath,filter=filterspec)
	    gotit=where(gotfile ne '',count)
	    if count ne 0 then begin 
	       case 1 of
	       ((uval2 ge 1)  and (uval2 le 3) ): display,gotfile,20,100
	       ((uval2 ge 4) and (uval2 le 5)):  show_GIForJPEG,uval2,gotfile,$
						   gp_title
	       else:
	       endcase
	    endif else badnews,'  No File is selected for Viewing. '
	 endif else badnews,'  The action is canceled.   '
      end
(uval gt 60) and (uval lt 70): begin       ; help
	uval2 =uval mod 60
	case uval2 of 
	1:
	2:
	else:
	endcase
      end
uval eq 88:
uval eq 99:
else:
endcase
  
end  

pro main  
common defcom, def, sysdirs, syspcmd ,sdata,mday,spanel_index
common hcbloc,otflag,hc_input,lpr_command,WH,off_LL,WH_val,off_LLval,$
	      psfile,psfile_name,colorflag,windex,windex_val,okflag
common sysbloc,sys_def
common setting,psflag,rpflag,poflag
common maincom, mainflag,Gimage

;setup def structure
sys_def={leader:0L, printer:0L,lpr_plot:0L,lpr_text:0L}
sys_def.printer=0
sys_def.lpr_plot=0
sys_def.lpr_text=0
psflag={image:0L}
psflag.image=0

def={ widfont:' ' }
mainflag={gonext:0  ,yesorno:0,purpose:0 }
mainflag.gonext=0
mainflag.yesorno=0
lpr_command=''

;
case !version.os of  
'windows': def.widfont='Arial*18'  
'MacOS': def.widfont='*'
else:  $  
def.widfont='-adobe-helvetica-bold-r-normal--14-140-75-75-p-82-iso8859-1'  
endcase  
  
; menu  
case !version.os of  
'windows': mainval=['Plot File', 'System Setup', 'Select Data',       $  
		    'Tools', 'Browser'  , 'Help' ]  
;                   'Plot Setup',  'Tools', 'Browser'  , 'Help' ]  
else:  mainval=[' Plot File ', ' System Setup ', ' Select Data ',     $  
		' Tools ', ' Browser '  ,' Help '  ]  
;               ' Plot Setup ', ' Tools ', ' Browser '  ,' Help '  ]  
endcase  
mainbut=lonarr(6)  
maintitle='ISTP'+'           '+'Key Parameter Visualization Tool ( KPVT )'+$  
	  '           '+'Version 2.0'  

if float(!version.release) lt 4.0 then begin  
   base=widget_base(title=maintitle,/column)  
   base1=widget_base(base,/row)  
   butbase=base1  
endif else begin  
   base=widget_base(title=maintitle,mbar=wmb,tlb_frame_attr=1)   
   butbase=wmb  
endelse  

for i=0,5 do mainbut(i)=widget_button(butbase,value=mainval(i),/menu, $  
				      font=def.widfont)  
; sub menu 0 - plot file  
but0=lonarr(2)  
but0val=['  Open ...    ', '   Exit   '  ]  ;   Save ...    ', '  Exit   ' ]  
for i=0,1 do but0(i)=widget_button(mainbut(0),value=but0val(i),uvalue=1+i, $  
				font=def.widfont)  
; sub menu 1 - system setup  
but1=lonarr(5)  
but1val=['  File Directory ...   ','  Print Command ...   ',   $
	 '  Windows ...   ', '  Color Table ...   ',           $
	 '  Graphic Settings ......   '             ]  
for i=0,4 do but1(i)=widget_button(mainbut(1),value=but1val(i),uvalue=11+i, $  
				   font=def.widfont)  
; sub menu 2 - select data  
but2val='  New ...           ' 
but2=widget_button(mainbut(2),value=but2val,uvalue=21, font=def.widfont)  

; sub menu 3 - custom plot setup  
;but3val='  New ...           '  
;but3 = widget_button(mainbut(3),value=but3val,uvalue=31, font=def.widfont )  

; sub menu 4 - tools  
but4=lonarr(2)  
but4val=['  Make Skeleton Table ...  ','  Make Data Look-Up Table ...  ' ]  
for i=0,1 do but4(i)=widget_button(mainbut(3),value=but4val(i),uvalue=41+i, $  
				   font=def.widfont)  
; sub menu 5 - viewer 
but5=lonarr(5)
but5val=['  View SFDU File ...  ',       '  View Skeleton Table ...  ',   $
	 '  View Text/ASCII File ...   ', '  Display GIF File ...  ',     $
	 '  Display JPEG File ...  '  ]  
for i=0,4 do but5(i)=widget_button(mainbut(4),value=but5val(i),uvalue=51+i, $  
			   font=def.widfont)  
; sub menu 5 - help
but6=lonarr(2)
but6val=['  On-Line Help      ', '  Comments or Questions?   ']
for i=0,1 do but6(i)=widget_button(mainbut(5),value=but6val(i),uvalue=61+i,$
			   font=def.widfont )
;  istp info base
base20=widget_base(base,/column,/frame)
base2= widget_base(base20,/row)
istplistval=sindgen(15) & istplistval(*)='   '
if !version.os eq 'windows' then begin  
   istplist=widget_list(base2,value=istplistval,xsize=50,ysize=3,/frame, $
		      uvalue=99, font=def.widfont )
   base21=widget_base(base20,/column)  
   text=widget_text(base21,value=istplistval,uvalue=500,/frame,/wrap,   $
		      font=def.widfont, xsize=110, ysize=10, /scroll) 
endif else begin
   istplist=widget_list(base2,value=istplistval,xsize=25,ysize=3,/frame, $
		      uvalue=99, font=def.widfont )
   base21=widget_base(base20,/column)  
   text=widget_text(base21,value=istplistval,uvalue=500,font=def.widfont,$
		      xsize=70, ysize=15, /scroll, /wrap ,/frame )
endelse
istpbut=widget_button(base2,value='     ISTP  Key  Parameters     ',/frame,  $
		      uvalue=88,font=def.widfont )
;
widget_control,base,/realize
;
restore,'filedirs.sys'  &  sysfile_flag=1             ; 1:file directory
restore,'printcmd.sys'  &  sysfile_flag=2             ; 2:print command
;
xmanager,"main",base  
end  

pro phase1_event,ev

common sysbloc,sys_def
common keepwindow,phase1_window,ymargin,xmargin,pcharsize,baselog

widget_control,ev.id,get_uvalue=uval   
case uval of 
11:begin
     widget_control,ev.top,/destroy
     loadct,0,/silent
     main
   end
22: widget_control,ev.top,/destroy
33: display,'Macintosh HD:readme.doc',sys_def.xsubwin(1),sys_def.ysubwin(1),   $
	    font=sys_def.fontname
endcase
end

pro phase1

common keepwindow,phase1_window,ymargin,xmargin,pcharsize,baselog
common sysbloc,sys_def

; sys def
sys_def={xdraw_phase1:0L,ydraw_phase1:0L,xdraw_phase3:0L,ydraw_phase3:0L, $
	 xsubwin:lonarr(3),ysubwin:lonarr(3),xoffset_phase1:0L,fontname:'', $
	 leader:0L,yoffset_phase1:0L ,printer:0L, lpr_plot:0L, lpr_text:0L }
sys_def.printer=0
sys_def.lpr_plot=0
sys_def.lpr_text=0

get_setplot      ; set_plot
device,get_screen_size=screensize
case !version.os of
'windows': begin
	    if ((screensize(0) ge 800) and (screensize(1) ge 600)) then begin
	       sys_def.fontname='Times New Roman*18'  
	       sys_def.xoffset_phase1=100
	       sys_def.yoffset_phase1=20
	       sys_def.xdraw_phase1=480
	       sys_def.ydraw_phase1=450
	       sys_def.xdraw_phase3=640
	       sys_def.ydraw_phase3=560
	       xoff=[50,100,150]
	       sys_def.xsubwin(*)=xoff
	       sys_def.ysubwin(*)=xoff
	    endif else begin
	       sys_def.fontname='Times New Roman*14'
	       sys_def.xoffset_phase1=20
	       sys_def.yoffset_phase1=10
	       sys_def.xdraw_phase1=450
	       sys_def.ydraw_phase1=400
	       sys_def.xdraw_phase3=510
	       sys_def.ydraw_phase3=440
	       xoff=[25,75,100]
	       sys_def.xsubwin(*)=xoff
	       sys_def.ysubwin(*)=xoff
	    endelse
	   end
'MacOS': begin
	    if ((screensize(0) ge 800) and (screensize(1) ge 600)) then begin
	       sys_def.fontname='Times New Roman*18'  
	       sys_def.xoffset_phase1=100
	       sys_def.yoffset_phase1=20
	       sys_def.xdraw_phase1=480
	       sys_def.ydraw_phase1=450
	       sys_def.xdraw_phase3=640
	       sys_def.ydraw_phase3=560
	       xoff=[50,100,150]
	       sys_def.xsubwin(*)=xoff
	       sys_def.ysubwin(*)=xoff
	    endif else begin
	       sys_def.fontname='Times New Roman*14'
	       sys_def.xoffset_phase1=20
	       sys_def.yoffset_phase1=10
	       sys_def.xdraw_phase1=450
	       sys_def.ydraw_phase1=400
	       sys_def.xdraw_phase3=510
	       sys_def.ydraw_phase3=440
	       xoff=[25,75,100]
	       sys_def.xsubwin(*)=xoff
	       sys_def.ysubwin(*)=xoff
	    endelse
	   end
else:begin
       sys_def.fontname=''
       sys_def.xoffset_phase1=200
       sys_def.yoffset_phase1=100
       sys_def.xdraw_phase1= 600
       sys_def.ydraw_phase1= 600
       sys_def.xdraw_phase3=650
       if screensize(1) gt 880 then sys_def.ydraw_phase3=850 else $
				    sys_def.ydraw_phase3=725
       xoff=[100,150,200]
       sys_def.xsubwin(*)=xoff
       sys_def.ysubwin(*)=xoff
       
     end
endcase

fontname0='-adobe-helvetica-bold-r-normal--24-240-75-75-p-138-iso8859-1'
fontname='-adobe-helvetica-medium-r-normal--18-180-75-75-p-98-iso8859-1'
baselog=widget_base(/column,space=15,xoffset=sys_def.xoffset_phase1,  $
   yoffset=sys_def.yoffset_phase1,title='ISTP - KPVT 2.0') 
trow=widget_base(baselog,/row,space=15)

istplogo=widget_draw(trow,xsize=433,ysize=207,/frame)
top1=widget_base(trow,/column,space=25)
ws=widget_button(top1,value='  Start  ',uvalue=11,/frame,font=fontname) 
wq=widget_button(top1,value='  Quit  ',uvalue=22,/frame,font=fontname)
wnu=widget_label(top1,value='')
wr=widget_button(top1,value='  Read Me  ',uvalue=33,/frame,font=fontname)
brow=widget_base(baselog,/column,space=5,/frame)
nu=widget_label(brow,value=' ')
titlea=widget_label(brow,value='  Key Parameter Visualization Tool  ',$
    font=fontname0 )
nu=widget_label(brow,value=' ')
titleb=widget_label(brow,value=' Version 2.0 ',font=fontname)
nu=widget_label(brow,value=' ')
nu=widget_label(brow,value=' ')
titlec=widget_label(brow,value=' Syau-Yun W. Hsieh ',font=fontname)
titled=widget_label(brow, font=fontname, value=       $
 '        ISTP - Science Planning and Operations Facility (SPOF)        ')
titlee=widget_label(brow,value=' NASA - GSFC ',font=fontname)

widget_control,/realize,baselog,/hourglass
read_gif,'istp-logo.GIF',image,r,g,b
tvlct,r,g,b
tv,image
xmanager,'phase1',baselog

end
