pro maspace_to_nifspace, masurf, nifsurf

; Ma input surface must have either 2 (scalar) or 3 (vector) dimensions

if (size(masurf))(0) eq 3 then begin ; Vector quantity
; Vector quantities assumed to have dimension sizes [nx,ny,3]
    if (n_elements(masurf(0,0,*)) ne 3) then $
      message, 'Ma surface has wrong dimension sizes;  Must be [nx,ny,3]'

    nxma = n_elements(masurf(*,0,0))
    nyma = n_elements(masurf(0,*,0))    
    nn = nxma*nyma
    mavec = fltarr(nn,3)
    mavec(*,0) = masurf(*,*,0)
    mavec(*,1) = masurf(*,*,1)
    mavec(*,2) = masurf(*,*,2)
    
; Define the rotation matrix from Ma coordinates to Hydra's NIF coordinates
    ma2nif = fltarr(3,3)
    ma2nif(*,0) = [0.,0.,1.]
    ma2nif(*,1) = [-1.,0.,0.]
    ma2nif(*,2) = [0.,-1.,0.]
    
    nifvec = hd_mvmult( ma2nif, mavec )
    surfx=fltarr(nxma,nyma) & surfy=fltarr(nxma,nyma) & surfz=fltarr(nxma,nyma)
    surfx(*,*) = nifvec(*,0)
    surfy(*,*) = nifvec(*,1)
    surfz(*,*) = nifvec(*,2)
    
; The surf arrays are indexed according to Ma's simulation grid.
; Since the simulation grid (X_Ma - Y_Ma plane) has a different
; orientation in the X_NIF - Z_NIF plane (X_Ma = Z_NIF, Y_Ma = -X_NIF)
; we must map the Ma surface indicies to NIF surface indicies so
; that the surface arrays we send to hydra_plotcolor have the
; correct orientation.  We do this by:
;                    1) NIF_surf = transpose(Ma_surf)
;                    2) For all iy, 
;                         NIF_surf(*,iy) = reverse(NIF_surf(*,iy)) 
; Then NIF_surf can be plotted with the 'x'-axis as X_NIF and the
; 'y'-axis as Z_NIF.
    
    newsizex = nyma
    newsizey = nxma
    nifx = fltarr(newsizex,newsizey)
    nifx(*,*) = transpose( surfx )
    nifx(*,*) = reverse(nifx(*,*),1) ; PPQ fix, 9/16/99
    
    nify = fltarr(newsizex,newsizey)
    nify(*,*) = transpose( surfy )
    nify(*,*) = reverse(nify(*,*),1) ; PPQ fix, 9/16/99
    
    nifz = fltarr(newsizex,newsizey)
    nifz(*,*) = transpose( surfz )
    nifz(*,*) = reverse(nifz(*,*),1) ; PPQ fix, 9/16/99

    nifsurf = fltarr(newsizex,newsizey,3)
    nifsurf(*,*,0) = nifx
    nifsurf(*,*,1) = nify
    nifsurf(*,*,2) = nifz

endif else if (size(masurf))(0) eq 2 then begin ; Scalar quantity
    
    nifsurf = transpose( masurf )
    nifsurf(*,*) = reverse(nifsurf(*,*),1) ; PPQ fix, 9/16/99
    
endif else begin

    message, 'Ma data input must have either 2 or 3 dimensions', /cont
    message, '2 dimension sizes must be [nx,ny] (scalar surface)', /cont
    message, '3 dimension sizes must be [nx,ny,3] (vector surface)', /cont
    return

endelse
    
return
end
