PRO SORTEVAL,EVAL,EVECT
;PURPOSE: SORT EIGENVALUES FROM MIN TO MAX AND MAKE SURE EIGENVECTERS ARE
;         CONSISTENT WITH A RHS.
;------------------------------------------------------------------------------
INDEX = SORT(EVAL)
EVAL = EVAL(INDEX)
EVECT1 = EVECT(*,INDEX(0))
EVECT2 = EVECT(*,INDEX(1))
EVECT3 = EVECT(*,INDEX(2))
EVECT = EVECT(*,INDEX)

; Make sure that the x-component of evect(*,0) is positive
; (convention).  evect(*,0) is the 'normal' vector.
if (EVECT1(0) lt 0) then begin
    EVECT(*,0) = -EVECT(*,0)
    evect1 = evect(*,0)         ; <---This line wasn't in the original code!!!
                                ; PPQ, 6/21/00
endif

; Make sure a right-handed system is returned
; (i.e. (evect1 cross evect2) dot evect3 must be > 0)
IF (TOTAL(CROSSP(EVECT1,EVECT2)*EVECT3) LT 0.0) THEN EVECT(*,1) = -EVECT(*,1)

END;======================================================================

PRO NORM_MINVAR,BX,BY,BZ,EVAL,EVECT
;PURPOSE:  CONSTRUCT THE COVARIANCE MATRIX AND DETERMINE THE EIGENVALUES
;          AND EIGENVECTORS.  THE SHOCK NORMAL CORRESPONDS TO THE EIGENVECTOR
;          ASSOCIATED WITH THE SMALLEST EIGENVALUE.
;          EIGENVALUES ARE STORED IN EVAL AND CORRESPONDING EIGENVECTORS
;          ARE STORED IN THE COLLUMNS OF EVECT.
;------------------------------------------------------------------------------
MOMBX = MOMENT(BX)
MOMBY = MOMENT(BY)
MOMBZ = MOMENT(BZ)
MOMBXBY = MOMENT(BX*BY)
MOMBXBZ = MOMENT(BX*BZ)
MOMBYBZ = MOMENT(BY*BZ)
MOMBXBX = MOMENT(BX*BX)
MOMBYBY = MOMENT(BY*BY)
MOMBZBZ = MOMENT(BZ*BZ)

EVECT = DBLARR(3,3)
EVAL = DBLARR(3)
E = DBLARR(3)

EVECT(0,0) = MOMBXBX(0) - MOMBX(0)^2
EVECT(0,1) = MOMBXBY(0) - MOMBX(0)*MOMBY(0)
EVECT(0,2) = MOMBXBZ(0) - MOMBX(0)*MOMBZ(0)
EVECT(1,0) = EVECT(0,1)
EVECT(1,1) = MOMBYBY(0) - MOMBY(0)^2
EVECT(1,2) = MOMBYBZ(0) - MOMBY(0)*MOMBZ(0)
EVECT(2,0) = EVECT(0,2)
EVECT(2,1) = EVECT(1,2)
EVECT(2,2) = MOMBZBZ(0) - MOMBZ(0)^2

TRIRED,EVECT,EVAL,E,/DOUBLE
TRIQL,EVAL,E,EVECT,/DOUBLE

SORTEVAL,EVAL,EVECT

END


