PRO SET_GIF_PAM, FILE = filename, ORIENTATION = orient, $
                 LANDSCAPE=landscape, $
                 FULL_SCREEN=full_screen, $
                 half_screen = half_screen, $
                 quarter_screen=quarter_screen, $
                 WHITE_BACKGROUND=white, BLACK_BACKGROUND=black, $
                 SWITCH_FOREGROUND_BACKGROUND=switch, $
                 SET_CHARACTER_SIZE=charsize

   COMMON print_file, file_name, prev_device, present_device
   COMMON gif_colors, fore_color, back_color
   COMMON device_char, xsize_c, ysize_c, aspect_ratio
;
;	No required Keywords.
;
; Handles printing to postscript devices
;
;	Parameters:
;		FILENAME = name of file
;		ORIENTATION = 'L' for Landscape, Portrait otherwise
;               /LANDSCAPE to landscape printing
;               /FULL_SCREEN means full screen size (72 dpi)
;               /HALF_SCREEN means half screen size (72 dpi)
;               /QUARTER_SCREEN means quarter screen size (72 dpi)
;               /WHITE_BACKGROUND  means reverse normal color settings
;               /BLACK_BACKGROUND  means normal settings
;               /SWITCH_FOREGROUND_BACKGROUND  means reverse normal colors
;               SET_CHARACTER_SIZE=[width, line_separation]
;
;       N.B. This does not work with color yet!!!!
;
;
   PREV_DEVICE0 = !D.NAME
   if (PREV_DEVICE0 NE 'Z') then begin
      SET_PLOT, 'Z'
      present_device = 'gif'
      DEVICE, z_buffering=0
      IF KEYWORD_SET(FILENAME) THEN file_name = filename $
      ELSE file_name = 'idl.gif'
      PREV_DEVICE = PREV_DEVICE0
   ENDIF
   
   IF KEYWORD_SET(FULL_SCREEN) THEN BEGIN
      dpi = 72
      s1 = 11.0
      s2 = 14.0
      charsize0 = [8,12]
   ENDIF ELSE IF KEYWORD_SET(HALF_SCREEN) THEN BEGIN
      dpi = 72
      s1 = 11.0
      s2 = 7.0
      charsize0 = [8,12]
   ENDIF ELSE IF KEYWORD_SET(quarter_screen) THEN BEGIN
      dpi = 72
      s1 = 5.5
      s2 = 7.0
      charsize0 = [8,12]
   ENDIF ELSE BEGIN 
      dpi = 72
      s1 = 11.0
      s2 = 14.0
      charsize0 = [8,12]
   ENDELSE 
   
   size1 = dpi*s1
   size2 = dpi*s2
   
   IF (keyword_set(charsize)) THEN BEGIN
      device, set_character_size=charsize
   ENDIF ELSE BEGIN 
      device, set_character_size=charsize0
   ENDELSE 
   
   back_color = !p.background
   fore_color = !p.color
   IF ((keyword_set(white)) OR (keyword_set(switch))) THEN BEGIN
      !p.background = fore_color
      !p.color = back_color
   ENDIF 
   
   IF KEYWORD_SET(ORIENT) THEN BEGIN
      IF (strlowcase(STRMID(ORIENT,0,1)) EQ 'l') THEN BEGIN
         orient = 'L'
         xsiz = size1
         ysiz = size2
      ENDIF ELSE BEGIN
         orient = 'P'
         xsiz = size2
         ysiz = size1
      ENDELSE
   ENDIF ELSE BEGIN
      orient = 'P'
      xsiz = size2
      ysiz = size1
   ENDELSE
   IF KEYWORD_SET(LANDSCAPE) THEN BEGIN
      orient = 'L'
      xsiz = size1
      ysiz = size2
   ENDIF 

   device, set_resolution=[xsiz,ysiz]

   xsize_c = xsiz
   ysize_c = ysiz
   aspect_ratio = float(xsize_c)/float(ysize_c)

END



